/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.rescu.impl;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.poshjosh.ratelimiter.store.BandwidthsStore;
import jakarta.ws.rs.HeaderParam;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.ArrayUtils;
import org.oxerr.rescu.ext.singleton.RestProxyFactorySingletonImpl;
import org.oxerr.vividseats.client.VividSeatsClient;
import org.oxerr.vividseats.client.inventory.ListingService;
import org.oxerr.vividseats.client.rescu.impl.RateLimiterInterceptor;
import org.oxerr.vividseats.client.rescu.impl.inventory.ListingServiceImpl;
import org.oxerr.vividseats.client.rescu.resource.v1.inventory.ListingResource;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.IRestProxyFactory;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactoryImpl;
import si.mazi.rescu.serialization.jackson.DefaultJacksonObjectMapperFactory;
import si.mazi.rescu.serialization.jackson.JacksonObjectMapperFactory;

public class ResCUVividSeatsClient
implements VividSeatsClient {
    private static final String DEFAULT_BASE_URL = "https://brokers.vividseats.com/webservices";
    private final String baseUrl;
    private final IRestProxyFactory restProxyFactory;
    private final ListingService listingService;

    public ResCUVividSeatsClient(CharSequence token, Interceptor ... interceptors) {
        this(DEFAULT_BASE_URL, token, interceptors);
    }

    public ResCUVividSeatsClient(CharSequence token, BandwidthsStore<?> bandwidthsStore, Interceptor ... interceptors) {
        this(DEFAULT_BASE_URL, token, bandwidthsStore, interceptors);
    }

    public ResCUVividSeatsClient(Supplier<CharSequence> tokenSupplier, Interceptor ... interceptors) {
        this(DEFAULT_BASE_URL, tokenSupplier, interceptors);
    }

    public ResCUVividSeatsClient(Supplier<CharSequence> tokenSupplier, BandwidthsStore<?> bandwidthsStore, Interceptor ... interceptors) {
        this(DEFAULT_BASE_URL, tokenSupplier, bandwidthsStore, interceptors);
    }

    public ResCUVividSeatsClient(String baseUrl, CharSequence token, Interceptor ... interceptors) {
        this(baseUrl, () -> token, interceptors);
    }

    public ResCUVividSeatsClient(String baseUrl, Supplier<CharSequence> tokenSupplier, Interceptor ... interceptors) {
        this(baseUrl, tokenSupplier, BandwidthsStore.ofDefaults(), interceptors);
    }

    public ResCUVividSeatsClient(String baseUrl, CharSequence token, BandwidthsStore<?> bandwidthsStore, Interceptor ... interceptors) {
        this(baseUrl, () -> token, bandwidthsStore, interceptors);
    }

    public ResCUVividSeatsClient(String baseUrl, Supplier<CharSequence> tokenSupplier, BandwidthsStore<?> bandwidthsStore, Interceptor ... interceptors) {
        this.baseUrl = baseUrl;
        JacksonObjectMapperFactory jacksonObjectMapperFactory = this.createJacksonObjectMapperFactory();
        ClientConfig clientConfigV1 = this.createClientConfigV1(jacksonObjectMapperFactory);
        ClientConfig clientConfig = this.createClientConfig(jacksonObjectMapperFactory, tokenSupplier);
        this.restProxyFactory = new RestProxyFactorySingletonImpl((IRestProxyFactory)new RestProxyFactoryImpl());
        Interceptor[] allInterceptors = Optional.ofNullable(bandwidthsStore).map(RateLimiterInterceptor::new).map(t -> (Interceptor[])ArrayUtils.addFirst((Object[])interceptors, (Object)t)).orElse(interceptors);
        this.listingService = new ListingServiceImpl(tokenSupplier, (ListingResource)this.restProxyFactory.createProxy(ListingResource.class, baseUrl, clientConfigV1, interceptors), this.createProxy(org.oxerr.vividseats.client.rescu.resource.inventory.ListingResource.class, clientConfig, allInterceptors));
    }

    public ListingService getListingService() {
        return this.listingService;
    }

    protected <I> I createProxy(Class<I> restInterface, ClientConfig clientConfig, Interceptor ... interceptors) {
        return (I)this.restProxyFactory.createProxy(restInterface, this.baseUrl, clientConfig, interceptors);
    }

    protected ClientConfig createClientConfigV1(JacksonObjectMapperFactory jacksonObjectMapperFactory) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setJacksonObjectMapperFactory(jacksonObjectMapperFactory);
        return clientConfig;
    }

    protected ClientConfig createClientConfig(JacksonObjectMapperFactory jacksonObjectMapperFactory, final Supplier<CharSequence> tokenSupplier) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addDefaultParam(HeaderParam.class, "Api-token", new Object(){

            public String toString() {
                return ((CharSequence)tokenSupplier.get()).toString();
            }
        });
        clientConfig.setJacksonObjectMapperFactory(jacksonObjectMapperFactory);
        return clientConfig;
    }

    protected JacksonObjectMapperFactory createJacksonObjectMapperFactory() {
        return new DefaultJacksonObjectMapperFactory(){

            public void configureObjectMapper(ObjectMapper objectMapper) {
                super.configureObjectMapper(objectMapper);
                objectMapper.registerModule((Module)new JavaTimeModule());
                objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
                objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                objectMapper.configure(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS, false);
                objectMapper.configure(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, false);
            }
        };
    }
}

