/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.rescu.impl;

import io.github.poshjosh.ratelimiter.RateLimiter;
import io.github.poshjosh.ratelimiter.RateLimiterContext;
import io.github.poshjosh.ratelimiter.RateLimiterRegistries;
import io.github.poshjosh.ratelimiter.store.BandwidthsStore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.Interceptor;

public class RateLimiterInterceptor
implements Interceptor {
    private final Logger log = LoggerFactory.getLogger(RateLimiterInterceptor.class);
    private final BandwidthsStore<String> store;

    public RateLimiterInterceptor(BandwidthsStore<String> store) {
        this.store = store;
    }

    public Object aroundInvoke(InvocationHandler invocationHandler, Object proxy, Method method, Object[] args) throws Throwable {
        RateLimiter limiter = this.getRateLimiter(method);
        this.log.trace("Acquiring permit for {}...", (Object)method);
        double timeSpent = limiter.acquire();
        this.log.trace("Acquired permit for {} in {} seconds.", (Object)method, (Object)timeSpent);
        return invocationHandler.invoke(proxy, method, args);
    }

    public RateLimiter getRateLimiter(Method method) {
        RateLimiterContext context = RateLimiterContext.builder().classes(new Class[]{method.getDeclaringClass()}).store(this.store).build();
        return RateLimiterRegistries.of((RateLimiterContext)context).getMethodRateLimiter(method);
    }
}

