/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.vividseats.client.rescu.impl.inventory;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.oxerr.vividseats.client.inventory.BrokerListingQuery;
import org.oxerr.vividseats.client.inventory.ListingService;
import org.oxerr.vividseats.client.model.inventory.BrokerListing;
import org.oxerr.vividseats.client.model.v1.inventory.Update;
import org.oxerr.vividseats.client.rescu.resource.VividSeatsException;
import org.oxerr.vividseats.client.rescu.resource.v1.inventory.ListingResource;

public class ListingServiceImpl
implements ListingService {
    private final Supplier<CharSequence> tokenSupplier;
    private final ListingResource listingResourceV1;
    private final org.oxerr.vividseats.client.rescu.resource.inventory.ListingResource listingResource;

    public ListingServiceImpl(Supplier<CharSequence> tokenSupplier, ListingResource listingResourceV1, org.oxerr.vividseats.client.rescu.resource.inventory.ListingResource listingResource) {
        this.tokenSupplier = tokenSupplier;
        this.listingResourceV1 = listingResourceV1;
        this.listingResource = listingResource;
    }

    public List<BrokerListing> get(BrokerListingQuery brokerListingQuery) throws IOException {
        return this.listingResource.get(brokerListingQuery.getListingId(), brokerListingQuery.getInternalTicketId(), brokerListingQuery.getProductionId(), brokerListingQuery.getHeadlinerId(), brokerListingQuery.getFromEventDate(), brokerListingQuery.getToEventDate(), brokerListingQuery.getIncludeFiles()).getListings();
    }

    public BrokerListing create(BrokerListing brokerListing) throws IOException {
        return this.listingResource.create(brokerListing).getListing();
    }

    public void updateListing(Update update) throws IOException {
        this.listingResourceV1.updateListing(this.tokenSupplier.get(), update.getTicketId(), update.getQuantity(), update.getSection(), update.getRow(), update.getSeatFrom(), update.getSeatThru(), update.getNotes(), update.getPrice(), update.getElectronic(), update.getInHandDate(), update.getSplitType(), update.getSplitValue(), update.getBarcode(), update.getFaceValue(), update.getUnitTaxedCost());
    }

    public void update(BrokerListing brokerListing) throws IOException {
        this.listingResource.update(brokerListing);
    }

    public void deleteListing(String ticketId) throws IOException {
        block2: {
            try {
                this.listingResourceV1.deleteListing((CharSequence)this.tokenSupplier.get().toString(), ticketId);
            }
            catch (VividSeatsException e) {
                if (Objects.equals(e.getMessage(), "Listing not found.")) break block2;
                throw e;
            }
        }
    }

    public void delete(Long listingId, String internalTicketId) throws IOException {
        this.listingResource.delete(listingId, internalTicketId);
    }
}

