/*
 * Copyright 2009 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.*;

/**
 * Compiler pass that removes useless ruleset nodes from the AST.
 *
 * @author oana@google.com (Oana Florescu)
 */
public class EliminateUselessRulesetNodes extends DefaultTreeVisitor
        implements CssCompilerPass {

    private final CssTree tree;
    private final MutatingVisitController visitController;

    public EliminateUselessRulesetNodes(CssTree tree) {
        this.tree = tree;
        this.visitController = tree.getMutatingVisitController();
    }

    @Override
    public boolean enterRuleset(CssRulesetNode node) {
        if (tree.getRulesetNodesToRemove().getRulesetNodes().contains(node)) {
            visitController.removeCurrentNode();
            return false;
        }
        return true;
    }

    @Override
    public void runPass() {
        visitController.startVisit(this);

        // Now that we've removed everything we can clear this.
        tree.resetRulesetNodesToRemove();
    }
}
