/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.css.GssFunctionMapProvider;
import com.google.common.css.JobDescription;
import com.google.common.css.OutputRenamingMapFormat;
import com.google.common.css.SourceCode;
import com.google.common.css.SubstitutionMapProvider;
import com.google.common.css.Vendor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JobDescriptionBuilder {
    List<SourceCode> inputs = Lists.newArrayList();
    String copyrightNotice = null;
    JobDescription.OutputFormat outputFormat = JobDescription.OutputFormat.COMPRESSED;
    JobDescription.InputOrientation inputOrientation = JobDescription.InputOrientation.LTR;
    JobDescription.OutputOrientation outputOrientation = JobDescription.OutputOrientation.LTR;
    JobDescription.OptimizeStrategy optimize = JobDescription.OptimizeStrategy.SAFE;
    List<String> trueConditionNames = Lists.newArrayList();
    boolean useInternalBidiFlipper = false;
    boolean swapLtrRtlInUrl = false;
    boolean swapLeftRightInUrl = false;
    boolean simplifyCss = false;
    boolean eliminateDeadStyles = false;
    boolean allowDefPropagation = false;
    boolean allowUnrecognizedFunctions = false;
    Set<String> allowedNonStandardFunctions = Sets.newHashSet();
    boolean allowUnrecognizedProperties = false;
    Set<String> allowedUnrecognizedProperties = Sets.newHashSet();
    boolean allowUndefinedConstants = false;
    boolean allowMozDocument = false;
    Vendor vendor = null;
    boolean allowKeyframes = true;
    boolean allowWebkitKeyframes = true;
    boolean processDependencies = false;
    String cssRenamingPrefix = "";
    List<String> excludedClassesFromRenaming = Lists.newArrayList();
    GssFunctionMapProvider gssFunctionMapProvider = null;
    SubstitutionMapProvider cssSubstitutionMapProvider = null;
    OutputRenamingMapFormat outputRenamingMapFormat = OutputRenamingMapFormat.JSCOMP_VARIABLE_MAP;
    Map<String, String> inputRenamingMap = ImmutableMap.of();
    boolean preserveComments = false;
    boolean suppressDependencyCheck = false;
    Map<String, Integer> compileConstants = new HashMap<String, Integer>();
    boolean preserveImportantComments = false;
    JobDescription job = null;
    boolean createSourceMap = false;
    JobDescription.SourceMapDetailLevel sourceMapLevel = JobDescription.SourceMapDetailLevel.DEFAULT;

    public JobDescriptionBuilder copyFrom(JobDescription jobToCopy) {
        this.setInputs(Lists.newArrayList(jobToCopy.inputs));
        this.copyrightNotice = jobToCopy.copyrightNotice;
        this.setOutputFormat(jobToCopy.outputFormat);
        this.setInputOrientation(jobToCopy.inputOrientation);
        this.setOutputOrientation(jobToCopy.outputOrientation);
        this.optimize = jobToCopy.optimize;
        this.setTrueConditionNames(jobToCopy.trueConditionNames);
        this.useInternalBidiFlipper = jobToCopy.useInternalBidiFlipper;
        this.swapLtrRtlInUrl = jobToCopy.swapLtrRtlInUrl;
        this.swapLeftRightInUrl = jobToCopy.swapLeftRightInUrl;
        this.simplifyCss = jobToCopy.simplifyCss;
        this.eliminateDeadStyles = jobToCopy.eliminateDeadStyles;
        this.allowDefPropagation = jobToCopy.allowDefPropagation;
        this.allowUnrecognizedFunctions = jobToCopy.allowUnrecognizedFunctions;
        this.allowedNonStandardFunctions = ImmutableSet.copyOf(jobToCopy.allowedNonStandardFunctions);
        this.allowUnrecognizedProperties = jobToCopy.allowUnrecognizedProperties;
        this.allowedUnrecognizedProperties = ImmutableSet.copyOf(jobToCopy.allowedUnrecognizedProperties);
        this.allowUndefinedConstants = jobToCopy.allowUndefinedConstants;
        this.allowMozDocument = jobToCopy.allowMozDocument;
        this.vendor = jobToCopy.vendor;
        this.allowKeyframes = jobToCopy.allowKeyframes;
        this.allowWebkitKeyframes = jobToCopy.allowWebkitKeyframes;
        this.cssRenamingPrefix = jobToCopy.cssRenamingPrefix;
        this.setExcludedClassesFromRenaming((List<String>)ImmutableList.copyOf(jobToCopy.excludedClassesFromRenaming));
        this.gssFunctionMapProvider = jobToCopy.gssFunctionMapProvider;
        this.cssSubstitutionMapProvider = jobToCopy.cssSubstitutionMapProvider;
        this.outputRenamingMapFormat = jobToCopy.outputRenamingMapFormat;
        this.inputRenamingMap = jobToCopy.inputRenamingMap;
        this.preserveComments = jobToCopy.preserveComments;
        this.suppressDependencyCheck = jobToCopy.suppressDependencyCheck;
        this.setCompileConstants(jobToCopy.compileConstants);
        this.createSourceMap = jobToCopy.createSourceMap;
        this.sourceMapLevel = jobToCopy.sourceMapLevel;
        this.preserveImportantComments = jobToCopy.preserveImportantComments;
        return this;
    }

    void checkJobIsNotAlreadyCreated() {
        Preconditions.checkState((this.job == null ? 1 : 0) != 0, (Object)"You cannot set job properties after the message was created.");
    }

    public JobDescriptionBuilder clearInputs() {
        this.checkJobIsNotAlreadyCreated();
        this.inputs.clear();
        return this;
    }

    public JobDescriptionBuilder setInputs(List<SourceCode> newInputs) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.inputs.isEmpty());
        Preconditions.checkArgument((!newInputs.contains(null) ? 1 : 0) != 0);
        this.inputs = Lists.newArrayList(newInputs);
        return this;
    }

    public JobDescriptionBuilder addInput(SourceCode sourceCode) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)sourceCode);
        this.inputs.add(sourceCode);
        return this;
    }

    public JobDescriptionBuilder setOptimizeStrategy(JobDescription.OptimizeStrategy optimize) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)optimize));
        this.optimize = optimize;
        return this;
    }

    public JobDescriptionBuilder clearTrueConditionNames() {
        this.checkJobIsNotAlreadyCreated();
        this.trueConditionNames.clear();
        return this;
    }

    public JobDescriptionBuilder setTrueConditionNames(List<String> newTrueConditionNames) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.trueConditionNames.isEmpty());
        Preconditions.checkArgument((!newTrueConditionNames.contains(null) ? 1 : 0) != 0);
        this.trueConditionNames = Lists.newArrayList(newTrueConditionNames);
        return this;
    }

    public JobDescriptionBuilder addTrueConditionName(String conditionName) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)conditionName);
        this.trueConditionNames.add(conditionName);
        return this;
    }

    public JobDescriptionBuilder setExcludedClassesFromRenaming(List<String> excludedClassesFromRenaming) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.excludedClassesFromRenaming.isEmpty());
        Preconditions.checkArgument((!excludedClassesFromRenaming.contains(null) ? 1 : 0) != 0);
        this.excludedClassesFromRenaming = Lists.newArrayList(excludedClassesFromRenaming);
        return this;
    }

    public JobDescriptionBuilder setCssRenamingPrefix(String cssRenamingPrefix) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)cssRenamingPrefix);
        this.cssRenamingPrefix = cssRenamingPrefix;
        return this;
    }

    public JobDescriptionBuilder setCopyrightNotice(String copyrightNotice) {
        this.checkJobIsNotAlreadyCreated();
        this.copyrightNotice = copyrightNotice;
        return this;
    }

    public JobDescriptionBuilder setUseInternalBidiFlipper(boolean use) {
        this.checkJobIsNotAlreadyCreated();
        this.useInternalBidiFlipper = use;
        return this;
    }

    public JobDescriptionBuilder useInternalBidiFlipper() {
        return this.setUseInternalBidiFlipper(true);
    }

    public JobDescriptionBuilder setSwapLtrRtlInUrl(boolean swap) {
        this.checkJobIsNotAlreadyCreated();
        if (this.useInternalBidiFlipper) {
            this.swapLtrRtlInUrl = swap;
        }
        return this;
    }

    public JobDescriptionBuilder swapLtrRtlInUrl() {
        return this.setSwapLtrRtlInUrl(true);
    }

    public JobDescriptionBuilder setSwapLeftRightInUrl(boolean swap) {
        this.checkJobIsNotAlreadyCreated();
        if (this.useInternalBidiFlipper) {
            this.swapLeftRightInUrl = swap;
        }
        return this;
    }

    public JobDescriptionBuilder swapLeftRightInUrl() {
        return this.setSwapLeftRightInUrl(true);
    }

    public JobDescriptionBuilder setInputOrientation(JobDescription.InputOrientation newInputOrientation) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newInputOrientation));
        this.inputOrientation = newInputOrientation;
        return this;
    }

    public JobDescriptionBuilder setOutputOrientation(JobDescription.OutputOrientation newOutputOrientation) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newOutputOrientation));
        this.outputOrientation = newOutputOrientation;
        return this;
    }

    public JobDescriptionBuilder setOutputFormat(JobDescription.OutputFormat newOutputFormat) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull((Object)((Object)newOutputFormat));
        this.outputFormat = newOutputFormat;
        return this;
    }

    public JobDescriptionBuilder setSimplifyCss(boolean simplify) {
        this.checkJobIsNotAlreadyCreated();
        this.simplifyCss = simplify;
        return this;
    }

    public JobDescriptionBuilder simplifyCss() {
        return this.setSimplifyCss(true);
    }

    public JobDescriptionBuilder setEliminateDeadStyles(boolean eliminate) {
        this.checkJobIsNotAlreadyCreated();
        this.eliminateDeadStyles = eliminate;
        return this;
    }

    public JobDescriptionBuilder eliminateDeadStyles() {
        return this.setEliminateDeadStyles(true);
    }

    public JobDescriptionBuilder setGssFunctionMapProvider(GssFunctionMapProvider gssFunctionMapProvider) {
        this.checkJobIsNotAlreadyCreated();
        this.gssFunctionMapProvider = gssFunctionMapProvider;
        return this;
    }

    public JobDescriptionBuilder setCssSubstitutionMapProvider(SubstitutionMapProvider cssSubstitutionMapProvider) {
        this.checkJobIsNotAlreadyCreated();
        this.cssSubstitutionMapProvider = cssSubstitutionMapProvider;
        return this;
    }

    public JobDescriptionBuilder setAllowUnrecognizedFunctions(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowUnrecognizedFunctions = allow;
        return this;
    }

    public JobDescriptionBuilder allowUnrecognizedFunctions() {
        return this.setAllowUnrecognizedFunctions(true);
    }

    public JobDescriptionBuilder setAllowedNonStandardFunctions(List<String> functionNames) {
        this.checkJobIsNotAlreadyCreated();
        this.allowedNonStandardFunctions.addAll(functionNames);
        return this;
    }

    public JobDescriptionBuilder setAllowUnrecognizedProperties(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowUnrecognizedProperties = allow;
        return this;
    }

    public JobDescriptionBuilder allowUnrecognizedProperties() {
        return this.setAllowUnrecognizedProperties(true);
    }

    public JobDescriptionBuilder setAllowedUnrecognizedProperties(List<String> propertyNames) {
        this.checkJobIsNotAlreadyCreated();
        this.allowedUnrecognizedProperties.addAll(propertyNames);
        return this;
    }

    public JobDescriptionBuilder setVendor(Vendor vendor) {
        this.checkJobIsNotAlreadyCreated();
        this.vendor = vendor;
        return this;
    }

    public JobDescriptionBuilder setAllowKeyframes(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowKeyframes = allow;
        return this;
    }

    public JobDescriptionBuilder allowKeyframes() {
        return this.setAllowKeyframes(true);
    }

    public JobDescriptionBuilder setAllowWebkitKeyframes(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowWebkitKeyframes = allow;
        return this;
    }

    public JobDescriptionBuilder allowWebkitKeyframes() {
        return this.setAllowWebkitKeyframes(true);
    }

    public JobDescriptionBuilder setProcessDependencies(boolean process) {
        this.checkJobIsNotAlreadyCreated();
        this.processDependencies = process;
        return this;
    }

    public JobDescriptionBuilder setOutputRenamingMapFormat(OutputRenamingMapFormat outputFormat) {
        this.checkJobIsNotAlreadyCreated();
        this.outputRenamingMapFormat = outputFormat;
        return this;
    }

    public JobDescriptionBuilder setInputRenamingMap(Map<String, String> inputRenamingMap) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkNotNull(inputRenamingMap);
        this.inputRenamingMap = ImmutableMap.copyOf(inputRenamingMap);
        return this;
    }

    public JobDescriptionBuilder setAllowMozDocument(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowMozDocument = allow;
        return this;
    }

    public JobDescriptionBuilder allowMozDocument() {
        return this.setAllowMozDocument(true);
    }

    public JobDescriptionBuilder setAllowDefPropagation(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowDefPropagation = allow;
        return this;
    }

    public JobDescriptionBuilder allowDefPropagation() {
        return this.setAllowDefPropagation(true);
    }

    public JobDescriptionBuilder setAllowUndefinedConstants(boolean allow) {
        this.checkJobIsNotAlreadyCreated();
        this.allowUndefinedConstants = allow;
        return this;
    }

    public JobDescriptionBuilder setSuppressDependencyCheck(boolean suppress) {
        this.checkJobIsNotAlreadyCreated();
        this.suppressDependencyCheck = suppress;
        return this;
    }

    public JobDescriptionBuilder setPreserveComments(boolean preserve) {
        this.checkJobIsNotAlreadyCreated();
        this.preserveComments = preserve;
        return this;
    }

    public JobDescriptionBuilder preserveComments() {
        return this.setPreserveComments(true);
    }

    public JobDescriptionBuilder setCompileConstants(Map<String, Integer> newCompileConstants) {
        this.checkJobIsNotAlreadyCreated();
        Preconditions.checkState((boolean)this.compileConstants.isEmpty());
        Preconditions.checkArgument((!newCompileConstants.containsKey(null) ? 1 : 0) != 0);
        this.compileConstants = new HashMap<String, Integer>(newCompileConstants);
        return this;
    }

    public JobDescriptionBuilder setPreserveImportantComments(boolean preserve) {
        this.checkJobIsNotAlreadyCreated();
        this.preserveImportantComments = preserve;
        return this;
    }

    public JobDescriptionBuilder preserveImportantComments() {
        return this.setPreserveImportantComments(true);
    }

    public JobDescription getJobDescription() {
        if (this.job != null) {
            return this.job;
        }
        HashSet allowedAtRules = Sets.newHashSet();
        if (this.allowKeyframes || this.allowWebkitKeyframes) {
            allowedAtRules.add("keyframes");
            allowedAtRules.add("-moz-keyframes");
            allowedAtRules.add("-ms-keyframes");
            allowedAtRules.add("-o-keyframes");
            allowedAtRules.add("-webkit-keyframes");
        }
        if (this.allowMozDocument) {
            allowedAtRules.add("-moz-document");
        }
        this.job = new JobDescription(this.inputs, this.copyrightNotice, this.outputFormat, this.inputOrientation, this.outputOrientation, this.optimize, this.trueConditionNames, this.useInternalBidiFlipper, this.swapLtrRtlInUrl, this.swapLeftRightInUrl, this.simplifyCss, this.eliminateDeadStyles, this.allowDefPropagation, this.allowUnrecognizedFunctions, this.allowedNonStandardFunctions, this.allowUnrecognizedProperties, this.allowedUnrecognizedProperties, this.allowUndefinedConstants, this.allowMozDocument, this.vendor, this.allowKeyframes, this.allowWebkitKeyframes, this.processDependencies, allowedAtRules, this.cssRenamingPrefix, this.excludedClassesFromRenaming, this.gssFunctionMapProvider, this.cssSubstitutionMapProvider, this.outputRenamingMapFormat, this.inputRenamingMap, this.preserveComments, this.suppressDependencyCheck, this.compileConstants, this.createSourceMap, this.sourceMapLevel, this.preserveImportantComments);
        return this.job;
    }

    public JobDescriptionBuilder setSourceMapLevel(JobDescription.SourceMapDetailLevel sourceMapLevel) {
        this.sourceMapLevel = sourceMapLevel;
        return this;
    }

    public JobDescriptionBuilder setCreateSourceMap(boolean createSourceMap) {
        this.createSourceMap = createSourceMap;
        return this;
    }
}

