/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import javax.annotation.Nullable;

public enum Vendor {
    WEBKIT("-webkit-"),
    MOZILLA("-moz-"),
    MICROSOFT("-ms-"),
    OPERA("-o-"),
    KONQUEROR("-khtml-");

    private final String prefix;

    private Vendor(String prefix) {
        this.prefix = prefix;
    }

    @Nullable
    public static Vendor parseProperty(String propertyName) {
        for (Vendor vendor : Vendor.values()) {
            if (!propertyName.startsWith(vendor.prefix)) continue;
            return vendor;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

