/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssSelectorNode;

public class CssCombinatorNode
extends CssNode {
    private CssSelectorNode selector;
    private final Combinator type;

    public CssCombinatorNode(CssSelectorNode selector, Combinator type, SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.selector = selector;
        this.becomeParentForNode(this.selector);
        this.type = type;
    }

    public CssCombinatorNode(Combinator type, SourceCodeLocation sourceCodeLocation) {
        this(null, type, sourceCodeLocation);
    }

    public CssCombinatorNode(CssCombinatorNode node) {
        this(node.getSelector().deepCopy(), node.getCombinatorType(), node.getSourceCodeLocation());
    }

    @Override
    public CssCombinatorNode deepCopy() {
        return new CssCombinatorNode(this);
    }

    public CssSelectorNode getSelector() {
        return this.selector;
    }

    public void setSelector(CssSelectorNode selector) {
        if (this.selector != null) {
            this.removeAsParentOfNode(this.selector);
        }
        this.selector = selector;
        this.becomeParentForNode(this.selector);
    }

    public Combinator getCombinatorType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.type.getCanonicalName() + this.selector;
    }

    public static enum Combinator {
        DESCENDANT(" "),
        DEEP("/deep/"),
        CHILD(">"),
        ADJACENT_SIBLING("+"),
        GENERAL_SIBLING("~");

        private final String symbol;

        private Combinator(String symbol) {
            this.symbol = symbol;
        }

        public String getCanonicalName() {
            return this.symbol;
        }
    }
}

