/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.ChunkAware;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.List;

public class CssDefinitionNode
extends CssAtRuleNode
implements ChunkAware {
    private Object chunk;

    public CssDefinitionNode(CssLiteralNode name, List<CssCommentNode> comments) {
        super(CssAtRuleNode.Type.DEF, name, comments);
    }

    public CssDefinitionNode(CssLiteralNode name) {
        super(CssAtRuleNode.Type.DEF, name);
    }

    public CssDefinitionNode(List<CssValueNode> parameters, CssLiteralNode name) {
        super(CssAtRuleNode.Type.DEF, name);
        this.setParameters(parameters);
    }

    public CssDefinitionNode(List<CssValueNode> parameters, CssLiteralNode name, SourceCodeLocation sourceCodeLocation) {
        super(CssAtRuleNode.Type.DEF, name);
        this.setParameters(parameters);
        this.setSourceCodeLocation(sourceCodeLocation);
    }

    public CssDefinitionNode(List<CssValueNode> parameters, CssLiteralNode name, List<CssCommentNode> comments) {
        super(CssAtRuleNode.Type.DEF, name, comments);
        this.setParameters(parameters);
    }

    public CssDefinitionNode(List<CssValueNode> parameters, CssLiteralNode name, List<CssCommentNode> comments, SourceCodeLocation sourceCodeLocation) {
        this(parameters, name, comments);
        this.setSourceCodeLocation(sourceCodeLocation);
    }

    public CssDefinitionNode(CssDefinitionNode node) {
        super(node);
        this.chunk = node.getChunk();
    }

    @Override
    public CssDefinitionNode deepCopy() {
        return new CssDefinitionNode(this);
    }

    @Override
    public String toString() {
        return this.getType().toString() + " " + this.getName().toString() + " " + this.getParameters().toString();
    }

    @Override
    public Object getChunk() {
        return this.chunk;
    }

    @Override
    public void setChunk(Object chunk) {
        this.chunk = chunk;
    }
}

