/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.List;

public final class CssMathNode
extends CssCompositeValueNode {
    private CssMathNode(CssValueNode operand1, CssCompositeValueNode.Operator operator, CssValueNode operand2, boolean hasParenthesis) {
        super((List<CssValueNode>)ImmutableList.of((Object)operand1, (Object)operand2), operator, hasParenthesis, null);
    }

    public static CssValueNode createFromOperandsAndOperators(List<CssValueNode> operands, List<CssCompositeValueNode.Operator> operators, boolean hasParenthesis) {
        Preconditions.checkArgument((operands.size() == operators.size() + 1 ? 1 : 0) != 0, (Object)"There should be one more operands than operators");
        if (operators.isEmpty()) {
            return operands.get(0);
        }
        if (operators.size() == 1) {
            return new CssMathNode(operands.get(0), operators.get(0), operands.get(1), hasParenthesis);
        }
        return new CssMathNode(operands.get(0), operators.get(0), CssMathNode.createFromOperandsAndOperators(operands.subList(1, operands.size()), operators.subList(1, operators.size()), false), hasParenthesis);
    }

    @Override
    public CssMathNode deepCopy() {
        CssValueNode operand1 = this.getValues().get(0);
        CssValueNode operand2 = this.getValues().get(1);
        return new CssMathNode(operand1, this.getOperator(), operand2, this.hasParenthesis());
    }
}

