/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CssNodesListNode<T extends CssNode>
extends CssNode {
    protected List<T> children = Lists.newArrayList();
    private final boolean isEnclosedWithBraces;

    protected CssNodesListNode(boolean isEnclosedWithBraces) {
        this(isEnclosedWithBraces, null);
    }

    protected CssNodesListNode(boolean isEnclosedWithBraces, @Nullable List<CssCommentNode> comments) {
        super(null, comments, null);
        this.isEnclosedWithBraces = isEnclosedWithBraces;
    }

    protected CssNodesListNode(boolean isEnclosedWithBraces, List<T> childrenList, @Nullable List<CssCommentNode> comments) {
        super(null, comments, null);
        for (CssNode child : childrenList) {
            CssNode childCopy = child.deepCopy();
            this.addChildToBack(childCopy);
        }
        this.isEnclosedWithBraces = isEnclosedWithBraces;
    }

    protected CssNodesListNode(CssNodesListNode<? extends CssNode> node) {
        super(node.getParent(), node.getComments(), node.getSourceCodeLocation());
        this.isEnclosedWithBraces = node.isEnclosedWithBraces;
        for (CssNode cssNode : node.childIterable()) {
            CssNode childCopy = cssNode.deepCopy();
            this.addChildToBack(childCopy);
        }
    }

    public List<T> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Iterator<T> getChildIterator() {
        return this.children.iterator();
    }

    public Iterable<T> childIterable() {
        return Iterables.unmodifiableIterable(this.children);
    }

    void setChildren(List<T> children) {
        Preconditions.checkArgument((!children.contains(null) ? 1 : 0) != 0);
        this.removeAsParentOfNodes(this.children);
        this.children = this.copyToList(children);
        this.becomeParentForNodes(this.children);
    }

    T removeChildAt(int index) {
        Preconditions.checkState((index >= 0 && index < this.children.size() ? 1 : 0) != 0);
        CssNode child = (CssNode)this.children.get(index);
        this.removeAsParentOfNode(child);
        this.children.remove(index);
        return (T)child;
    }

    public void replaceChildAt(int index, List<? extends T> newChildren) {
        Preconditions.checkState((index >= 0 && index < this.children.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((!newChildren.contains(null) ? 1 : 0) != 0);
        this.removeChildAt(index);
        this.children.addAll(index, newChildren);
        this.becomeParentForNodes(newChildren);
    }

    public T getChildAt(int index) {
        Preconditions.checkState((index >= 0 && index < this.children.size() ? 1 : 0) != 0);
        return (T)((CssNode)this.children.get(index));
    }

    public int numChildren() {
        return this.children.size();
    }

    T removeLastChild() {
        return this.removeChildAt(this.children.size() - 1);
    }

    public T getLastChild() {
        return (T)((CssNode)this.children.get(this.children.size() - 1));
    }

    public void addChildToBack(T child) {
        Preconditions.checkNotNull(child);
        this.children.add(child);
        this.becomeParentForNode((CssNode)child);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public boolean isEnclosedWithBraces() {
        return this.isEnclosedWithBraces;
    }

    @Override
    public String toString() {
        StringBuilder output = new StringBuilder();
        if (!this.getComments().isEmpty()) {
            output.append("[");
            output.append(this.getComments().toString());
            output.append(this.children.toString());
            output.append("]");
        } else {
            output.append(this.children.toString());
        }
        return output.toString();
    }

    @Override
    public SourceCodeLocation getSourceCodeLocation() {
        SourceCodeLocation location = super.getSourceCodeLocation();
        if (location == null) {
            location = SourceCodeLocation.merge(this.children);
        }
        return location;
    }
}

