/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.Property;
import javax.annotation.Nullable;

public class CssPropertyNode
extends CssValueNode {
    private final Property property;

    public CssPropertyNode(String value) {
        this(value, null);
    }

    public CssPropertyNode(String value, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(value, sourceCodeLocation);
        this.property = Property.byName(value);
    }

    public CssPropertyNode(CssPropertyNode node) {
        super(node);
        this.property = node.property;
    }

    @Override
    public CssPropertyNode deepCopy() {
        return new CssPropertyNode(this);
    }

    public Property getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.property.getName();
    }

    public boolean isCustom() {
        return this.property.isCustom();
    }

    public String getPartition() {
        return this.property.getPartition();
    }

    @Override
    public String toString() {
        return this.property.getName();
    }
}

