/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssSelectorNode;

public abstract class CssRefinerNode
extends CssNode {
    protected final Refiner refinerType;
    protected final String refinerName;

    protected CssRefinerNode(Refiner refinerType, String refinerName, SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.refinerType = refinerType;
        this.refinerName = refinerName;
    }

    public String getRefinerName() {
        return this.refinerName;
    }

    public Refiner getRefinerType() {
        return this.refinerType;
    }

    public String getPrefix() {
        return this.refinerType.getPrefix();
    }

    public String getSuffix() {
        return this.refinerType.getSuffix();
    }

    public abstract CssSelectorNode.Specificity getSpecificity();

    @Override
    public String toString() {
        return this.refinerType.getPrefix() + this.refinerName + this.refinerType.getSuffix();
    }

    public static enum Refiner {
        CLASS(".", ""),
        ID("#", ""),
        PSEUDO_CLASS(":", ""),
        PSEUDO_ELEMENT("::", ""),
        ATTRIBUTE("[", "]");

        private final String prefix;
        private final String suffix;

        private Refiner(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String toString() {
            return this.prefix + this.suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

