/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssImportBlockNode;
import com.google.common.css.compiler.ast.CssNode;
import javax.annotation.Nullable;

public class CssRootNode
extends CssNode {
    private CssAtRuleNode charsetRule = null;
    private CssImportBlockNode importRules;
    private final CssBlockNode body;

    public CssRootNode(CssBlockNode body) {
        Preconditions.checkNotNull((Object)body);
        Preconditions.checkArgument((!body.isEnclosedWithBraces() ? 1 : 0) != 0);
        this.body = body;
        this.importRules = new CssImportBlockNode();
        this.becomeParentForNode(this.body);
        this.becomeParentForNode(this.importRules);
    }

    public CssRootNode() {
        this(new CssBlockNode(false));
    }

    public CssRootNode(CssRootNode node) {
        this(node.getBody().deepCopy());
        this.setParent(node.getParent());
        this.importRules = node.getImportRules().deepCopy();
    }

    @Override
    public CssRootNode deepCopy() {
        return new CssRootNode(this);
    }

    @Override
    void removeParent() {
        Preconditions.checkState((boolean)false, (Object)"You cannot remove the parent node of a tree root.");
    }

    @Override
    void setParent(CssNode parent) {
        Preconditions.checkState((parent == null ? 1 : 0) != 0, (Object)"You cannot set a non-null parent node of a tree root.");
    }

    public CssAtRuleNode getCharsetRule() {
        return this.charsetRule;
    }

    void setCharsetRule(@Nullable CssAtRuleNode charsetRule) {
        this.removeAsParentOfNode(this.charsetRule);
        this.charsetRule = charsetRule;
        this.becomeParentForNode(this.charsetRule);
    }

    public CssImportBlockNode getImportRules() {
        return this.importRules;
    }

    void setImportRules(@Nullable CssImportBlockNode importRules) {
        this.removeAsParentOfNode(this.importRules);
        this.importRules = importRules;
        this.becomeParentForNode(this.importRules);
    }

    public CssBlockNode getBody() {
        return this.body;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getCharsetRule() != null) {
            sb.append(this.getCharsetRule().toString());
        }
        if (!this.getImportRules().isEmpty()) {
            sb.append(this.getImportRules().toString());
        }
        sb.append(this.getBody().toString());
        return sb.toString();
    }
}

