/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import java.util.List;
import javax.annotation.Nullable;

public class CssRulesetNode
extends CssNode {
    private CssSelectorListNode selectors;
    private final CssDeclarationBlockNode declarations;

    public CssRulesetNode(CssDeclarationBlockNode declarations, @Nullable List<CssCommentNode> comments) {
        super(null, comments, null);
        Preconditions.checkNotNull((Object)declarations);
        this.declarations = declarations;
        this.becomeParentForNode(this.declarations);
        this.selectors = new CssSelectorListNode();
        this.becomeParentForNode(this.selectors);
    }

    public CssRulesetNode(CssDeclarationBlockNode declarations) {
        this(declarations, null);
    }

    public CssRulesetNode() {
        this(new CssDeclarationBlockNode());
    }

    public CssRulesetNode(List<CssCommentNode> comments) {
        this(new CssDeclarationBlockNode(), comments);
    }

    public CssRulesetNode(CssRulesetNode node) {
        this(node.getDeclarations().deepCopy());
        this.setSourceCodeLocation(node.getSourceCodeLocation());
        this.setComments(node.getComments());
        this.selectors = node.getSelectors().deepCopy();
    }

    @Override
    public CssRulesetNode deepCopy() {
        return new CssRulesetNode(this);
    }

    public CssSelectorListNode getSelectors() {
        return this.selectors;
    }

    public void setSelectors(CssSelectorListNode selectors) {
        Preconditions.checkNotNull((Object)selectors);
        this.removeAsParentOfNode(this.selectors);
        this.selectors = selectors;
        this.becomeParentForNode(this.selectors);
    }

    public CssDeclarationBlockNode getDeclarations() {
        return this.declarations;
    }

    public void addDeclaration(CssNode declaration) {
        this.declarations.addChildToBack(declaration);
    }

    public void addSelector(CssSelectorNode selector) {
        this.selectors.addChildToBack(selector);
    }

    @Override
    public String toString() {
        String output = "";
        if (!this.getComments().isEmpty()) {
            output = this.getComments().toString();
        }
        output = output + this.selectors.toString() + "{" + this.declarations.toString() + "}";
        return output;
    }
}

