/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.CharMatcher;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssValueNode;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CssStringNode
extends CssValueNode {
    private static final String LINE_BREAK_PATTERN_STRING = "\\n|\\r\\n|\\r|\\f";
    private static final CharMatcher CONSUMABLE_WHITESPACE = CharMatcher.anyOf((CharSequence)"\n\t ");
    private static final Pattern ESCAPE_CHAR_STRING_CONTINUATION_PATTERN = Pattern.compile("\\\\\\n|\\r\\n|\\r|\\f");
    private static final Pattern ESCAPE_CHAR_NOT_SPECIAL = Pattern.compile("\\\\([^0-9a-fA-F\\n\\r\\f])");
    private static final Pattern ESCAPE_CHAR_HARD_TO_TYPE = Pattern.compile("\\\\([0-9a-fA-F]{1,6})(\\r\\n|[ \\t\\r\\n\\f])?");
    private static final Pattern HTML_PATTERN = Pattern.compile("[<>\"&']");
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\n|\\r\\n|\\r|\\f");
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]+");
    private static final Pattern WIDE_NONASCII_PATTERN = Pattern.compile("\\P{ASCII}");
    private final Type type;
    private String concreteValue;
    public static final UnaryOperator<String> HTML_ESCAPER = input -> CssStringNode.paranoidEscapeChars(WIDE_NONASCII_PATTERN, CssStringNode.paranoidEscapeChars(HTML_PATTERN, input));
    public static final Function<String, String> SHORT_ESCAPER = input -> {
        StringBuffer sb = new StringBuffer();
        Matcher m = WIDE_NONASCII_PATTERN.matcher((CharSequence)input);
        while (m.find()) {
            String match = m.group(0);
            assert (match.length() > 0 && match.length() == match.offsetByCodePoints(0, 1));
            String hexDigits = String.format("%x", match.codePointAt(0));
            String trailer = input.length() <= m.end() ? "" : (hexDigits.length() < 6 && HEX_PATTERN.matcher(input.subSequence(m.end(), m.end() + 1)).matches() ? " " : (CONSUMABLE_WHITESPACE.matches(input.charAt(m.end())) ? " " : ""));
            m.appendReplacement(sb, String.format("\\\\%s%s", hexDigits, trailer));
        }
        m.appendTail(sb);
        return sb.toString();
    };

    public CssStringNode(Type type, SourceCodeLocation location) {
        super("", location);
        this.setConcreteValue(location.getSourceCode().getFileContents().substring(location.getBeginCharacterIndex() + 1, location.getEndCharacterIndex() - 1));
        this.type = type;
    }

    public CssStringNode(Type type, String value) {
        super(value, null);
        this.type = type;
        this.setValue(value);
    }

    public CssStringNode(CssStringNode node) {
        super(node);
        this.type = node.type;
        this.concreteValue = node.getConcreteValue();
    }

    public Type getType() {
        return this.type;
    }

    public String setConcreteValue(String concreteValue) {
        this.concreteValue = concreteValue;
        super.setValue(CssStringNode.unescape(concreteValue));
        return concreteValue;
    }

    public String getConcreteValue() {
        return this.concreteValue;
    }

    @Override
    public void setValue(String value) {
        this.setConcreteValue(CssStringNode.escape(this.type, HTML_ESCAPER, value));
    }

    @Override
    public CssStringNode deepCopy() {
        return new CssStringNode(this);
    }

    @Override
    public String toString() {
        return this.type.toString(this.getValue(), SHORT_ESCAPER);
    }

    public static String unescape(String escaped) {
        String result = ESCAPE_CHAR_STRING_CONTINUATION_PATTERN.matcher(escaped).replaceAll("");
        result = ESCAPE_CHAR_NOT_SPECIAL.matcher(result).replaceAll("$1");
        Matcher unicode = ESCAPE_CHAR_HARD_TO_TYPE.matcher(result);
        StringBuffer sb = new StringBuffer();
        while (unicode.find()) {
            int codepoint = Integer.parseInt(unicode.group(1), 16);
            if (codepoint > 0x10FFFF && codepoint > 0x10FFFF) {
                codepoint = 65533;
            }
            String replacement = codepoint == 0 ? "" : new String(Character.toChars(codepoint));
            unicode.appendReplacement(sb, replacement);
        }
        unicode.appendTail(sb);
        result = sb.toString();
        return result;
    }

    private static String escapeLineBreaks(String input) {
        Matcher linebreak = LINE_BREAK_PATTERN.matcher(input);
        StringBuilder sb = new StringBuilder(input.length());
        int left = 0;
        while (linebreak.find()) {
            char c;
            if (linebreak.start() > left) {
                sb.append(input.subSequence(left, linebreak.start()));
            }
            sb.append("\\00000a");
            int right = linebreak.end();
            if (right < input.length() && CONSUMABLE_WHITESPACE.matches(c = input.charAt(right))) {
                sb.append(" ");
            }
            left = right;
        }
        if (left < input.length()) {
            sb.append(input.subSequence(left, input.length()));
        }
        return sb.toString();
    }

    public static String escape(Type type, Function<? super String, String> discretionaryEscaper, String raw) {
        String result = raw.replaceAll("\\\\", "\\\\\\\\");
        result = CssStringNode.escapeLineBreaks(result);
        result = discretionaryEscaper.apply(result);
        result = type.escapeForDelimiters(result);
        return result;
    }

    private static String paranoidEscapeChars(Pattern banned, String context) {
        StringBuffer sb = new StringBuffer();
        Matcher markup = banned.matcher(context);
        while (markup.find()) {
            String match = markup.group(0);
            assert (match.length() > 0 && match.length() == match.offsetByCodePoints(0, 1));
            markup.appendReplacement(sb, String.format("\\\\%06x", markup.group(0).codePointAt(0)));
            if (markup.end() >= context.length() || !CONSUMABLE_WHITESPACE.matches(context.charAt(markup.end()))) continue;
            sb.append(" ");
        }
        markup.appendTail(sb);
        return sb.toString();
    }

    public String toString(Function<? super String, String> discretionaryEscaper) {
        return this.type.toString(this.getValue(), discretionaryEscaper);
    }

    public static enum Type {
        DOUBLE_QUOTED_STRING("\""),
        SINGLE_QUOTED_STRING("'");

        public final String delimiter;
        public final String format;

        private Type(String delimiter) {
            this.delimiter = delimiter;
            this.format = String.format("%s%%s%s", delimiter, delimiter);
        }

        public String toString(String value, Function<? super String, String> discretionaryEscaper) {
            return String.format(this.format, CssStringNode.escape(this, discretionaryEscaper, value));
        }

        public String escapeForDelimiters(String input) {
            return input.replaceAll(this.delimiter, "\\\\" + this.delimiter);
        }
    }
}

