/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssNode;
import javax.annotation.Nullable;

public abstract class CssValueNode
extends CssNode {
    private String value;
    private boolean isDefault;

    protected CssValueNode(@Nullable String value, @Nullable SourceCodeLocation sourceCodeLocation) {
        super(sourceCodeLocation);
        this.value = value;
        this.isDefault = false;
    }

    protected CssValueNode(String value) {
        this(value, null);
    }

    protected CssValueNode(CssValueNode node) {
        this(node.getValue(), node.getSourceCodeLocation());
        this.isDefault = node.getIsDefault();
    }

    @Override
    public abstract CssValueNode deepCopy();

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        Preconditions.checkNotNull((Object)value);
        this.value = value;
    }

    public void setIsDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean getIsDefault() {
        return this.isDefault;
    }

    @Override
    public String toString() {
        return this.getValue();
    }
}

