/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.css.compiler.ast.CssAbstractBlockNode;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssCharSetNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssComponentNode;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssForLoopRuleNode;
import com.google.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssIdSelectorNode;
import com.google.common.css.compiler.ast.CssImportBlockNode;
import com.google.common.css.compiler.ast.CssImportRuleNode;
import com.google.common.css.compiler.ast.CssKeyListNode;
import com.google.common.css.compiler.ast.CssKeyNode;
import com.google.common.css.compiler.ast.CssKeyframeRulesetNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.common.css.compiler.ast.CssMixinNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNodesListNode;
import com.google.common.css.compiler.ast.CssPageRuleNode;
import com.google.common.css.compiler.ast.CssPageSelectorNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssProvideNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerListNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssRequireNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Deque;
import java.util.List;

class DefaultVisitController
implements MutatingVisitController {
    private final CssNode subtree;
    private final boolean allowMutating;
    @VisibleForTesting
    CssTreeVisitor visitor;
    private final StateStack stateStack = new StateStack();

    public DefaultVisitController(CssNode subtree, boolean allowMutating) {
        Preconditions.checkNotNull((Object)subtree);
        this.subtree = subtree;
        this.allowMutating = allowMutating;
    }

    public DefaultVisitController(CssTree tree, boolean allowMutating) {
        this(tree.getRoot(), allowMutating);
    }

    public StateStack getStateStack() {
        return this.stateStack;
    }

    @Override
    public void removeCurrentNode() {
        Preconditions.checkState((boolean)this.allowMutating);
        this.stateStack.getTop().removeCurrentNodeCalled();
    }

    @Override
    public <T extends CssNode> void replaceCurrentBlockChildWith(List<T> replacementNodes, boolean visitTheReplacementNodes) {
        Preconditions.checkState((boolean)this.allowMutating);
        VisitState<? extends CssNode> stackTop = this.stateStack.getTop();
        stackTop.replaceCurrentBlockChildWithCalled(replacementNodes, visitTheReplacementNodes);
    }

    @Override
    public void startVisit(CssTreeVisitor treeVisitor) {
        Preconditions.checkNotNull((Object)treeVisitor);
        this.visitor = treeVisitor;
        this.stateStack.push(this.createVisitStateInternal(this.subtree));
        while (!this.stateStack.isEmpty()) {
            try {
                this.stateStack.getTop().doVisit();
                this.stateStack.getTop().transitionToNextState();
            }
            catch (StopVisitRequestedException e) {
                break;
            }
        }
    }

    @Override
    public void stopVisit() {
        this.stateStack.getTop().stopVisitCalled();
        throw new StopVisitRequestedException();
    }

    private <T extends CssNode> VisitState<? extends CssNode> createVisitState(T child, BaseVisitState<T> fallbackStateSource) {
        VisitState<? extends CssNode> state = this.createVisitStateInternal(child);
        return state == null ? fallbackStateSource.createFallbackState(child) : state;
    }

    private VisitState<? extends CssNode> createVisitStateInternal(CssNode child) {
        if (child instanceof CssProvideNode) {
            return new VisitProvideState((CssProvideNode)child);
        }
        if (child instanceof CssRequireNode) {
            return new VisitRequireState((CssRequireNode)child);
        }
        if (child instanceof CssMediaRuleNode) {
            return new VisitMediaRuleState((CssMediaRuleNode)child);
        }
        if (child instanceof CssPageRuleNode) {
            return new VisitPageRuleState((CssPageRuleNode)child);
        }
        if (child instanceof CssPageSelectorNode) {
            return new VisitPageSelectorState((CssPageSelectorNode)child);
        }
        if (child instanceof CssFontFaceNode) {
            return new VisitFontFaceState((CssFontFaceNode)child);
        }
        if (child instanceof CssCharSetNode) {
            return new VisitCharSetState((CssCharSetNode)child);
        }
        if (child instanceof CssImportRuleNode) {
            return new VisitImportRuleState((CssImportRuleNode)child);
        }
        if (child instanceof CssComponentNode) {
            return new VisitComponentState((CssComponentNode)child);
        }
        if (child instanceof CssRefinerNode) {
            return new VisitRefinerNodeState((CssRefinerNode)child);
        }
        if (child instanceof CssDeclarationNode) {
            return new VisitDeclarationState((CssDeclarationNode)child);
        }
        if (child instanceof CssMixinNode) {
            return new VisitMixinState((CssMixinNode)child);
        }
        if (child instanceof CssForLoopRuleNode) {
            return new VisitForLoopRuleState((CssForLoopRuleNode)child);
        }
        if (child instanceof CssUnknownAtRuleNode) {
            return new VisitUnknownAtRuleState((CssUnknownAtRuleNode)child);
        }
        if (child instanceof CssKeyframesNode) {
            return new VisitWebkitKeyframesState((CssKeyframesNode)child);
        }
        if (child instanceof CssKeyframeRulesetNode) {
            return new VisitKeyframeRulesetState((CssKeyframeRulesetNode)child);
        }
        if (child instanceof CssConditionalBlockNode) {
            return new VisitConditionalBlockState((CssConditionalBlockNode)child);
        }
        if (child instanceof CssRulesetNode) {
            return new VisitRulesetState((CssRulesetNode)child);
        }
        if (child instanceof CssDefinitionNode) {
            return new VisitDefinitionState((CssDefinitionNode)child);
        }
        if (child instanceof CssFunctionNode) {
            return new VisitFunctionNodeState((CssFunctionNode)child);
        }
        if (child instanceof CssMixinDefinitionNode) {
            return new VisitMixinDefinitionState((CssMixinDefinitionNode)child);
        }
        if (child instanceof CssCompositeValueNode) {
            return new VisitCompositeValueState((CssCompositeValueNode)child);
        }
        if (child instanceof CssPropertyValueNode) {
            return new VisitPropertyValueState((CssPropertyValueNode)child);
        }
        if (child instanceof CssRootNode) {
            return new RootVisitBeforeChildrenState((CssRootNode)child);
        }
        return null;
    }

    static class StateStack {
        final Deque<VisitState<? extends CssNode>> stack = Queues.newArrayDeque();

        StateStack() {
        }

        VisitState<? extends CssNode> getTop() {
            return this.stack.peek();
        }

        void push(VisitState<? extends CssNode> state) {
            Preconditions.checkNotNull(state);
            this.stack.addFirst(state);
        }

        void pop() {
            this.stack.removeFirst();
        }

        void transitionTo(VisitState<? extends CssNode> state) {
            this.pop();
            this.push(state);
        }

        int size() {
            return this.stack.size();
        }

        boolean isEmpty() {
            return this.stack.isEmpty();
        }
    }

    @VisibleForTesting
    class VisitMixinDefinitionState
    extends BaseVisitState<CssNode> {
        private final CssMixinDefinitionNode node;
        private boolean visitedChildren;

        VisitMixinDefinitionState(CssMixinDefinitionNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterMixinDefinition(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveMixinDefinition(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitDeclarationBlockState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitWebkitKeyframesState
    extends VisitChildrenOptionalState {
        private final CssKeyframesNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitWebkitKeyframesState(CssKeyframesNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterKeyframesRule(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveKeyframesRule(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                if (this.node.getType().hasBlock()) {
                    DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.node.getBlock()));
                }
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitUnknownAtRuleBlockState
    extends VisitChildrenOptionalState {
        private final CssAbstractBlockNode body;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitUnknownAtRuleBlockState(CssAbstractBlockNode body) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.body = body;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                if (this.body instanceof CssBlockNode) {
                    this.shouldVisitChildren = DefaultVisitController.this.visitor.enterBlock((CssBlockNode)this.body);
                }
            } else if (this.body instanceof CssBlockNode) {
                DefaultVisitController.this.visitor.leaveBlock((CssBlockNode)this.body);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                if (this.body instanceof CssBlockNode) {
                    DefaultVisitController.this.stateStack.push(new VisitBlockChildrenState((CssBlockNode)this.body));
                } else if (this.body instanceof CssDeclarationBlockNode) {
                    DefaultVisitController.this.stateStack.push(new VisitDeclarationBlockState((CssDeclarationBlockNode)this.body));
                }
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitUnknownAtRuleState
    extends VisitChildrenOptionalState {
        private final CssUnknownAtRuleNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;
        private int currentIndex;

        VisitUnknownAtRuleState(CssUnknownAtRuleNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.currentIndex = -1;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren && this.currentIndex == -1) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterUnknownAtRule(this.node);
            } else if (this.visitedChildren) {
                DefaultVisitController.this.visitor.leaveUnknownAtRule(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (this.visitedChildren || !this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            ++this.currentIndex;
            int parametersCount = this.node.getParameters().size();
            if (this.currentIndex < parametersCount) {
                if (this.currentIndex < parametersCount - 1) {
                    DefaultVisitController.this.stateStack.push(new VisitMediaTypeListDelimiterState(this.node));
                }
                DefaultVisitController.this.stateStack.push(this.getVisitState(this.node.getParameters().get(this.currentIndex)));
            } else {
                if (this.node.getType().hasBlock()) {
                    DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.node.getBlock()));
                }
                this.visitedChildren = true;
            }
        }

        public VisitState<? extends CssNode> getVisitState(CssValueNode node) {
            if (node instanceof CssCompositeValueNode) {
                return new VisitCompositeValueState((CssCompositeValueNode)node);
            }
            return new VisitValueNodeState(node);
        }
    }

    @VisibleForTesting
    class VisitForLoopRuleState
    extends BaseVisitState<CssNode> {
        private final CssForLoopRuleNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitForLoopRuleState(CssForLoopRuleNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterForLoop(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveForLoop(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitBlockChildrenState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitComponentChildrenState
    extends VisitReplaceChildrenState<CssNode> {
        VisitComponentChildrenState(CssBlockNode block) {
            super(block);
        }
    }

    @VisibleForTesting
    class VisitComponentState
    extends VisitChildrenOptionalState {
        private final CssComponentNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitComponentState(CssComponentNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterComponent(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveComponent(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitComponentChildrenState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitFunctionArgumentNodeState
    extends BaseVisitState<CssNode> {
        private final CssValueNode node;

        VisitFunctionArgumentNodeState(CssValueNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterArgumentNode(this.node);
            DefaultVisitController.this.visitor.leaveArgumentNode(this.node);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitFunctionArgumentsNodeState
    extends VisitReplaceChildrenState<CssValueNode> {
        VisitFunctionArgumentsNodeState(CssFunctionArgumentsNode node) {
            super(node);
        }

        @Override
        public void replaceCurrentBlockChildWith(List<CssValueNode> replacementNodes, boolean visitTheReplacementNodes) {
            CssCompositeValueNode compositeValueNode;
            if (replacementNodes.size() == 1 && replacementNodes.get(0) instanceof CssCompositeValueNode && (compositeValueNode = (CssCompositeValueNode)replacementNodes.get(0)).getOperator() == CssCompositeValueNode.Operator.SPACE) {
                replacementNodes = compositeValueNode.getValues();
            }
            super.replaceCurrentBlockChildWith(replacementNodes, visitTheReplacementNodes);
        }

        @Override
        public VisitState<CssNode> createFallbackState(CssValueNode child) {
            return new VisitFunctionArgumentNodeState(child);
        }
    }

    @VisibleForTesting
    class VisitFunctionNodeState
    extends BaseVisitState<CssNode> {
        private final CssFunctionNode node;
        private boolean shouldVisitChildren;
        private boolean visitedChildren;

        VisitFunctionNodeState(CssFunctionNode node) {
            this.shouldVisitChildren = true;
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterFunctionNode(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveFunctionNode(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                if (this.shouldVisitChildren) {
                    DefaultVisitController.this.stateStack.push(new VisitFunctionArgumentsNodeState(this.node.getArguments()));
                }
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }

        @Override
        public void removeCurrentChild() {
            this.node.setArguments(new CssFunctionArgumentsNode());
        }

        @Override
        public void removeCurrentNodeCalled() {
            this.popToNonDegenerateState();
            DefaultVisitController.this.stateStack.getTop().removeCurrentChild();
        }

        private void popToNonDegenerateState() {
            CssNode child = this.node;
            while (true) {
                boolean otherSiblingsExist;
                if (child instanceof CssDeclarationNode) {
                    otherSiblingsExist = true;
                } else if (child instanceof CssNodesListNode) {
                    otherSiblingsExist = ((CssNodesListNode)child).numChildren() > 1;
                } else if (child instanceof CssCompositeValueNode) {
                    otherSiblingsExist = ((CssCompositeValueNode)child).getValues().size() > 1;
                } else {
                    if (!(child instanceof CssFunctionNode)) break;
                    otherSiblingsExist = false;
                }
                if (otherSiblingsExist) break;
                DefaultVisitController.this.stateStack.pop();
                child = child.getParent();
            }
        }
    }

    class IntervalueState
    extends BaseVisitState<CssNode> {
        private final CssCompositeValueNode parent;

        IntervalueState(CssCompositeValueNode parent) {
            this.parent = parent;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterCompositeValueNodeOperator(this.parent);
            DefaultVisitController.this.visitor.leaveCompositeValueNodeOperator(this.parent);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitCompositeValueState
    extends BaseVisitState<CssValueNode> {
        private final CssCompositeValueNode node;
        private final List<CssValueNode> children;
        private int currentIndex;
        private boolean doNotIncreaseIndex;
        private boolean visitChildren;
        private boolean intervalueStateIsNext;

        VisitCompositeValueState(CssCompositeValueNode node) {
            this.currentIndex = -1;
            this.doNotIncreaseIndex = false;
            this.visitChildren = true;
            this.intervalueStateIsNext = false;
            this.node = node;
            this.children = node.getValues();
        }

        @Override
        public void transitionToNextState() {
            if (this.currentIndex == this.children.size() - 1) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            if (!this.visitChildren) {
                this.currentIndex = this.children.size() - 1;
                return;
            }
            if (this.intervalueStateIsNext) {
                DefaultVisitController.this.stateStack.push(new IntervalueState(this.node));
                this.intervalueStateIsNext = false;
                return;
            }
            if (!this.doNotIncreaseIndex) {
                ++this.currentIndex;
            } else {
                this.doNotIncreaseIndex = false;
            }
            DefaultVisitController.this.stateStack.push(DefaultVisitController.this.createVisitState(this.children.get(this.currentIndex), this));
            this.intervalueStateIsNext = true;
        }

        @Override
        public void removeCurrentChild() {
            this.children.remove(this.currentIndex);
            this.intervalueStateIsNext = false;
            this.doNotIncreaseIndex = true;
            if (this.currentIndex == this.children.size()) {
                DefaultVisitController.this.stateStack.pop();
            }
        }

        @Override
        public VisitState<CssValueNode> createFallbackState(CssValueNode child) {
            return new VisitValueNodeState(child);
        }

        @Override
        public void doVisit() {
            if (this.currentIndex < 0) {
                this.visitChildren = DefaultVisitController.this.visitor.enterCompositeValueNode(this.node);
            } else if (this.currentIndex == this.children.size() - 1) {
                DefaultVisitController.this.visitor.leaveCompositeValueNode(this.node);
            }
        }

        @Override
        public void replaceCurrentBlockChildWith(List<CssValueNode> replacementNodes, boolean visitTheReplacementNodes) {
            CssCompositeValueNode compositeValueNode;
            this.children.remove(this.currentIndex);
            if (replacementNodes.size() == 1 && replacementNodes.get(0) instanceof CssCompositeValueNode && (compositeValueNode = (CssCompositeValueNode)replacementNodes.get(0)).getOperator() == this.node.getOperator()) {
                replacementNodes = compositeValueNode.getValues();
            }
            this.children.addAll(this.currentIndex, replacementNodes);
            this.node.becomeParentForNodes(replacementNodes);
            if (!visitTheReplacementNodes) {
                this.currentIndex += replacementNodes.size() - 1;
            } else {
                this.doNotIncreaseIndex = true;
            }
        }
    }

    @VisibleForTesting
    class VisitValueNodeState
    extends BaseVisitState<CssValueNode> {
        private final CssValueNode node;

        VisitValueNodeState(CssValueNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterValueNode(this.node);
            DefaultVisitController.this.visitor.leaveValueNode(this.node);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitPropertyValueState
    extends BaseVisitState<CssValueNode> {
        private final CssPropertyValueNode node;
        private boolean visitedChildren;
        private boolean visitingChildren;
        private int currentIndex;
        private boolean doNotIncreaseIndex;

        VisitPropertyValueState(CssPropertyValueNode node) {
            this.visitedChildren = false;
            this.visitingChildren = false;
            this.currentIndex = -1;
            this.doNotIncreaseIndex = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitingChildren) {
                if (!this.visitedChildren) {
                    DefaultVisitController.this.visitor.enterPropertyValue(this.node);
                } else {
                    DefaultVisitController.this.visitor.leavePropertyValue(this.node);
                }
            }
        }

        @Override
        public void removeCurrentChild() {
            this.node.removeChildAt(this.currentIndex);
            this.doNotIncreaseIndex = true;
        }

        @Override
        public void replaceCurrentBlockChildWith(List<CssValueNode> replacementNodes, boolean visitTheReplacementNodes) {
            CssCompositeValueNode compositeValueNode;
            if (replacementNodes.size() == 1 && replacementNodes.get(0) instanceof CssCompositeValueNode && (compositeValueNode = (CssCompositeValueNode)replacementNodes.get(0)).getOperator() == CssCompositeValueNode.Operator.SPACE) {
                replacementNodes = compositeValueNode.getValues();
            }
            this.node.replaceChildAt(this.currentIndex, replacementNodes);
            if (visitTheReplacementNodes) {
                this.doNotIncreaseIndex = true;
            } else {
                this.currentIndex += replacementNodes.size() - 1;
            }
        }

        @Override
        public void transitionToNextState() {
            if (this.currentIndex == this.node.numChildren() - 1 && !this.doNotIncreaseIndex || this.currentIndex == this.node.numChildren()) {
                if (this.visitedChildren) {
                    DefaultVisitController.this.stateStack.pop();
                } else {
                    this.visitingChildren = false;
                    this.visitedChildren = true;
                }
                return;
            }
            this.visitingChildren = true;
            if (!this.doNotIncreaseIndex) {
                ++this.currentIndex;
            } else {
                this.doNotIncreaseIndex = false;
            }
            VisitState state = DefaultVisitController.this.createVisitState((CssValueNode)this.node.getChildAt(this.currentIndex), this);
            if (state != null) {
                DefaultVisitController.this.stateStack.push(state);
            }
        }

        @Override
        public VisitState<? extends CssNode> createFallbackState(CssValueNode child) {
            return new VisitValueNodeState(child);
        }
    }

    @VisibleForTesting
    class VisitMixinState
    extends BaseVisitState<CssNode> {
        private final CssMixinNode node;
        private boolean visitedChildren;

        VisitMixinState(CssMixinNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterMixin(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveMixin(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitFunctionArgumentsNodeState(this.node.getArguments()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitDeclarationState
    extends BaseVisitState<CssNode> {
        private final CssDeclarationNode node;
        private boolean visitedChildren;

        VisitDeclarationState(CssDeclarationNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterDeclaration(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveDeclaration(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitPropertyValueState(this.node.getPropertyValue()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }

        @Override
        public void removeCurrentChild() {
            DefaultVisitController.this.stateStack.pop();
            DefaultVisitController.this.stateStack.getTop().removeCurrentChild();
        }
    }

    @VisibleForTesting
    class VisitDeclarationBlockState
    extends BaseVisitState<CssNode> {
        private final CssDeclarationBlockNode node;
        private boolean startedVisitingChildren;
        private boolean finishedVisitingChildren;
        @VisibleForTesting
        int currentIndex;
        private boolean doNotIncreaseIndex;

        VisitDeclarationBlockState(CssDeclarationBlockNode block) {
            this.startedVisitingChildren = false;
            this.finishedVisitingChildren = false;
            this.currentIndex = -1;
            this.doNotIncreaseIndex = false;
            this.node = block;
        }

        @Override
        public void doVisit() {
            if (!this.startedVisitingChildren) {
                DefaultVisitController.this.visitor.enterDeclarationBlock(this.node);
                this.startedVisitingChildren = true;
            } else if (this.finishedVisitingChildren) {
                DefaultVisitController.this.visitor.leaveDeclarationBlock(this.node);
            }
        }

        @Override
        public void removeCurrentChild() {
            this.node.removeChildAt(this.currentIndex);
            this.doNotIncreaseIndex = true;
        }

        @Override
        public void replaceCurrentBlockChildWith(List<CssNode> replacementNodes, boolean visitTheReplacementNodes) {
            this.node.replaceChildAt(this.currentIndex, (List<? extends CssNode>)replacementNodes);
            if (visitTheReplacementNodes) {
                this.doNotIncreaseIndex = true;
            } else {
                this.currentIndex += replacementNodes.size() - 1;
            }
        }

        @Override
        public void transitionToNextState() {
            if (this.finishedVisitingChildren) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            if (this.currentIndex == this.node.numChildren() - 1 && !this.doNotIncreaseIndex || this.currentIndex == this.node.numChildren()) {
                this.finishedVisitingChildren = true;
                return;
            }
            if (!this.doNotIncreaseIndex) {
                ++this.currentIndex;
            } else {
                this.doNotIncreaseIndex = false;
            }
            VisitState state = DefaultVisitController.this.createVisitState(this.node.getChildAt(this.currentIndex), this);
            if (state != null) {
                DefaultVisitController.this.stateStack.push(state);
            }
        }
    }

    @VisibleForTesting
    class VisitCombinatorState
    extends BaseVisitState<CssNode> {
        private final CssCombinatorNode node;
        private boolean visitedChildren;

        VisitCombinatorState(CssCombinatorNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterCombinator(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveCombinator(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitSelectorState(this.node.getSelector()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitRefinerNodeState
    extends BaseVisitState<CssNode> {
        private final CssRefinerNode node;
        private boolean visitedChildren;

        VisitRefinerNodeState(CssRefinerNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                if (this.node instanceof CssClassSelectorNode) {
                    DefaultVisitController.this.visitor.enterClassSelector((CssClassSelectorNode)this.node);
                } else if (this.node instanceof CssIdSelectorNode) {
                    DefaultVisitController.this.visitor.enterIdSelector((CssIdSelectorNode)this.node);
                } else if (this.node instanceof CssPseudoClassNode) {
                    DefaultVisitController.this.visitor.enterPseudoClass((CssPseudoClassNode)this.node);
                } else if (this.node instanceof CssPseudoElementNode) {
                    DefaultVisitController.this.visitor.enterPseudoElement((CssPseudoElementNode)this.node);
                } else if (this.node instanceof CssAttributeSelectorNode) {
                    DefaultVisitController.this.visitor.enterAttributeSelector((CssAttributeSelectorNode)this.node);
                }
            } else if (this.node instanceof CssClassSelectorNode) {
                DefaultVisitController.this.visitor.leaveClassSelector((CssClassSelectorNode)this.node);
            } else if (this.node instanceof CssIdSelectorNode) {
                DefaultVisitController.this.visitor.leaveIdSelector((CssIdSelectorNode)this.node);
            } else if (this.node instanceof CssPseudoClassNode) {
                DefaultVisitController.this.visitor.leavePseudoClass((CssPseudoClassNode)this.node);
            } else if (this.node instanceof CssPseudoElementNode) {
                DefaultVisitController.this.visitor.leavePseudoElement((CssPseudoElementNode)this.node);
            } else if (this.node instanceof CssAttributeSelectorNode) {
                DefaultVisitController.this.visitor.leaveAttributeSelector((CssAttributeSelectorNode)this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                CssPseudoClassNode pseudoClass;
                if (this.node instanceof CssPseudoClassNode && (pseudoClass = (CssPseudoClassNode)this.node).getNotSelector() != null) {
                    DefaultVisitController.this.stateStack.push(new VisitSelectorState(pseudoClass.getNotSelector()));
                }
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitRefinerListState
    extends VisitReplaceChildrenState<CssRefinerNode> {
        VisitRefinerListState(CssRefinerListNode node) {
            super(node);
        }
    }

    @VisibleForTesting
    class VisitKeyState
    extends BaseVisitState<CssNode> {
        private final CssKeyNode node;
        private boolean visitedChildren;

        VisitKeyState(CssKeyNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterKey(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveKey(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitSelectorState
    extends BaseVisitState<CssNode> {
        private final CssSelectorNode node;
        private boolean visitedChildren;

        VisitSelectorState(CssSelectorNode node) {
            this.visitedChildren = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterSelector(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveSelector(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                if (this.node.getCombinator() != null) {
                    DefaultVisitController.this.stateStack.push(new VisitCombinatorState(this.node.getCombinator()));
                }
                DefaultVisitController.this.stateStack.push(new VisitRefinerListState(this.node.getRefiners()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitKeyBlockChildrenState
    extends VisitChildrenState<CssKeyNode> {
        VisitKeyBlockChildrenState(CssKeyListNode block) {
            super(block);
        }

        @Override
        VisitState<CssNode> getVisitState(CssKeyNode node) {
            return new VisitKeyState(node);
        }
    }

    @VisibleForTesting
    class VisitKeyBlockState
    extends BaseVisitState<CssNode> {
        private final CssKeyListNode block;
        private final CssKeyframeRulesetNode ruleset;
        private boolean visitedChildren;

        VisitKeyBlockState(CssKeyframeRulesetNode ruleset, CssKeyListNode block) {
            this.visitedChildren = false;
            this.ruleset = ruleset;
            this.block = block;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterKeyBlock(this.block);
            } else {
                DefaultVisitController.this.visitor.leaveKeyBlock(this.block);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitKeyBlockChildrenState(this.block));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.transitionTo(new VisitDeclarationBlockState(this.ruleset.getDeclarations()));
            }
        }
    }

    @VisibleForTesting
    class VisitSelectorBlockChildrenState
    extends VisitChildrenState<CssSelectorNode> {
        VisitSelectorBlockChildrenState(CssSelectorListNode block) {
            super(block);
        }

        @Override
        VisitState<CssNode> getVisitState(CssSelectorNode node) {
            return new VisitSelectorState(node);
        }
    }

    @VisibleForTesting
    class VisitSelectorBlockState
    extends BaseVisitState<CssNode> {
        private final CssSelectorListNode block;
        private final CssRulesetNode ruleset;
        private boolean visitedChildren;

        VisitSelectorBlockState(CssRulesetNode ruleset, CssSelectorListNode block) {
            this.visitedChildren = false;
            this.ruleset = ruleset;
            this.block = block;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterSelectorBlock(this.block);
            } else {
                DefaultVisitController.this.visitor.leaveSelectorBlock(this.block);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitSelectorBlockChildrenState(this.block));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.transitionTo(new VisitDeclarationBlockState(this.ruleset.getDeclarations()));
            }
        }
    }

    @VisibleForTesting
    class VisitKeyframeRulesetState
    extends VisitChildrenOptionalState {
        private final CssKeyframeRulesetNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitKeyframeRulesetState(CssKeyframeRulesetNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterKeyframeRuleset(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveKeyframeRuleset(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitKeyBlockState(this.node, this.node.getKeys()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitRulesetState
    extends VisitChildrenOptionalState {
        private final CssRulesetNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitRulesetState(CssRulesetNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterRuleset(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveRuleset(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitSelectorBlockState(this.node, this.node.getSelectors()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitConditionalRuleChildrenState
    extends VisitReplaceChildrenState<CssNode> {
        VisitConditionalRuleChildrenState(CssAbstractBlockNode block) {
            super(block);
        }
    }

    @VisibleForTesting
    class VisitConditionalRuleState
    extends VisitChildrenOptionalState {
        private final CssConditionalRuleNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitConditionalRuleState(CssConditionalRuleNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterConditionalRule(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveConditionalRule(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitConditionalRuleChildrenState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitConditionalBlockChildrenState
    extends VisitChildrenState<CssConditionalRuleNode> {
        VisitConditionalBlockChildrenState(CssConditionalBlockNode block) {
            super(block);
        }

        @Override
        VisitState<CssNode> getVisitState(CssConditionalRuleNode node) {
            return new VisitConditionalRuleState(node);
        }
    }

    @VisibleForTesting
    class VisitConditionalBlockState
    extends BaseVisitState<CssNode> {
        private final CssConditionalBlockNode block;
        private boolean visitedChildren;

        VisitConditionalBlockState(CssConditionalBlockNode block) {
            this.visitedChildren = false;
            this.block = block;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.visitor.enterConditionalBlock(this.block);
            } else {
                DefaultVisitController.this.visitor.leaveConditionalBlock(this.block);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren) {
                DefaultVisitController.this.stateStack.push(new VisitConditionalBlockChildrenState(this.block));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitCharSetState
    extends VisitChildrenOptionalState {
        private final CssCharSetNode node;

        VisitCharSetState(CssCharSetNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (DefaultVisitController.this.visitor.enterCharSet(this.node)) {
                DefaultVisitController.this.visitor.leaveCharSet(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitFontFaceState
    extends VisitChildrenOptionalState {
        private final CssFontFaceNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitFontFaceState(CssFontFaceNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterFontFace(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveFontFace(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitPageSelectorState
    extends VisitChildrenOptionalState {
        private final CssPageSelectorNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitPageSelectorState(CssPageSelectorNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterPageSelector(this.node);
            } else {
                DefaultVisitController.this.visitor.leavePageSelector(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitPageRuleState
    extends VisitChildrenOptionalState {
        private final CssPageRuleNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitPageRuleState(CssPageRuleNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterPageRule(this.node);
            } else {
                DefaultVisitController.this.visitor.leavePageRule(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.node.getBlock()));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    private class VisitMediaTypeListDelimiterState
    extends BaseVisitState<CssNode> {
        private final CssNodesListNode<? extends CssNode> node;

        public VisitMediaTypeListDelimiterState(CssNodesListNode<? extends CssNode> node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterMediaTypeListDelimiter(this.node);
            DefaultVisitController.this.visitor.leaveMediaTypeListDelimiter(this.node);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitMediaRuleState
    extends VisitReplaceChildrenState<CssValueNode> {
        private final CssMediaRuleNode mediaRuleNode;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitMediaRuleState(CssMediaRuleNode mediaRuleNode) {
            super(mediaRuleNode);
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.mediaRuleNode = mediaRuleNode;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren && this.currentIndex == -1) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterMediaRule(this.mediaRuleNode);
            } else if (this.visitedChildren) {
                DefaultVisitController.this.visitor.leaveMediaRule(this.mediaRuleNode);
            }
        }

        @Override
        public void replaceCurrentBlockChildWith(List<CssValueNode> replacementNodes, boolean visitTheReplacementNodes) {
            CssCompositeValueNode compositeValueNode;
            if (replacementNodes.size() == 1 && replacementNodes.get(0) instanceof CssCompositeValueNode && (compositeValueNode = (CssCompositeValueNode)replacementNodes.get(0)).getOperator() == CssCompositeValueNode.Operator.SPACE) {
                replacementNodes = compositeValueNode.getValues();
            }
            super.replaceCurrentBlockChildWith(replacementNodes, visitTheReplacementNodes);
        }

        @Override
        public void transitionToNextState() {
            if (this.visitedChildren || !this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            if (!this.doNotIncreaseIndex) {
                ++this.currentIndex;
            } else {
                this.doNotIncreaseIndex = false;
            }
            int parametersCount = this.mediaRuleNode.getParameters().size();
            if (this.currentIndex < parametersCount) {
                if (this.currentIndex < parametersCount - 1) {
                    DefaultVisitController.this.stateStack.push(new VisitMediaTypeListDelimiterState(this.mediaRuleNode));
                }
                DefaultVisitController.this.stateStack.push(this.getVisitState(this.mediaRuleNode.getParameters().get(this.currentIndex)));
            } else {
                if (this.mediaRuleNode.getType().hasBlock()) {
                    DefaultVisitController.this.stateStack.push(new VisitUnknownAtRuleBlockState(this.mediaRuleNode.getBlock()));
                }
                this.visitedChildren = true;
            }
        }

        public VisitState<? extends CssNode> getVisitState(CssValueNode node) {
            if (node instanceof CssCompositeValueNode) {
                return new VisitCompositeValueState((CssCompositeValueNode)node);
            }
            return new VisitValueNodeState(node);
        }
    }

    @VisibleForTesting
    class VisitDefinitionParametersState
    extends VisitReplaceChildrenState<CssValueNode> {
        VisitDefinitionParametersState(CssDefinitionNode def) {
            super(def);
        }

        @Override
        public VisitState<CssValueNode> createFallbackState(CssValueNode child) {
            return new VisitValueNodeState(child);
        }
    }

    @VisibleForTesting
    class VisitDefinitionState
    extends VisitChildrenOptionalState {
        private final CssDefinitionNode node;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        VisitDefinitionState(CssDefinitionNode node) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterDefinition(this.node);
            } else {
                DefaultVisitController.this.visitor.leaveDefinition(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitDefinitionParametersState(this.node));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.pop();
            }
        }
    }

    @VisibleForTesting
    class VisitBlockChildrenState
    extends VisitReplaceChildrenState<CssNode> {
        VisitBlockChildrenState(CssBlockNode block) {
            super(block);
        }
    }

    @VisibleForTesting
    class RootVisitBodyState
    extends VisitChildrenOptionalState {
        private final CssRootNode root;
        private final CssBlockNode body;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        RootVisitBodyState(CssRootNode root, CssBlockNode body) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.root = root;
            this.body = body;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterBlock(this.body);
            } else {
                DefaultVisitController.this.visitor.leaveBlock(this.body);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitBlockChildrenState(this.body));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.transitionTo(new RootVisitAfterChildrenState(this.root));
            }
        }
    }

    @VisibleForTesting
    class VisitRequireState
    extends BaseVisitState<CssNode> {
        private final CssRequireNode node;

        VisitRequireState(CssRequireNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterRequireNode(this.node);
            DefaultVisitController.this.visitor.leaveRequireNode(this.node);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitProvideState
    extends BaseVisitState<CssNode> {
        private final CssProvideNode node;

        VisitProvideState(CssProvideNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterProvideNode(this.node);
            DefaultVisitController.this.visitor.leaveProvideNode(this.node);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitImportRuleState
    extends BaseVisitState<CssNode> {
        private final CssImportRuleNode node;

        VisitImportRuleState(CssImportRuleNode node) {
            this.node = node;
        }

        @Override
        public void doVisit() {
            if (DefaultVisitController.this.visitor.enterImportRule(this.node)) {
                DefaultVisitController.this.visitor.leaveImportRule(this.node);
            }
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class VisitImportBlockChildrenState
    extends VisitChildrenState<CssImportRuleNode> {
        VisitImportBlockChildrenState(CssImportBlockNode block) {
            super(block);
        }

        @Override
        VisitState<CssNode> getVisitState(CssImportRuleNode node) {
            return new VisitImportRuleState(node);
        }
    }

    @VisibleForTesting
    class RootVisitImportBlockState
    extends BaseVisitState<CssNode> {
        private final CssRootNode root;
        private final CssImportBlockNode block;
        private boolean visitedChildren;
        private boolean shouldVisitChildren;

        RootVisitImportBlockState(CssRootNode root, CssImportBlockNode block) {
            this.visitedChildren = false;
            this.shouldVisitChildren = true;
            this.root = root;
            this.block = block;
        }

        @Override
        public void doVisit() {
            if (!this.visitedChildren) {
                this.shouldVisitChildren = DefaultVisitController.this.visitor.enterImportBlock(this.block);
            } else {
                DefaultVisitController.this.visitor.leaveImportBlock(this.block);
            }
        }

        @Override
        public void transitionToNextState() {
            if (!this.visitedChildren && this.shouldVisitChildren) {
                DefaultVisitController.this.stateStack.push(new VisitImportBlockChildrenState(this.block));
                this.visitedChildren = true;
            } else {
                DefaultVisitController.this.stateStack.transitionTo(new RootVisitBodyState(this.root, this.root.getBody()));
            }
        }
    }

    @VisibleForTesting
    class RootVisitCharsetState
    extends BaseVisitState<CssNode> {
        private final CssRootNode root;
        private final CssAtRuleNode charsetRule;

        RootVisitCharsetState(CssRootNode root, CssAtRuleNode charsetRule) {
            this.root = root;
            this.charsetRule = charsetRule;
        }

        @Override
        public void doVisit() {
            if (this.charsetRule == null) {
                // empty if block
            }
        }

        @Override
        public void removeCurrentNodeCalled() {
            this.root.setCharsetRule(null);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.transitionTo(new RootVisitImportBlockState(this.root, this.root.getImportRules()));
        }
    }

    @VisibleForTesting
    class RootVisitAfterChildrenState
    extends BaseVisitState<CssNode> {
        private final CssRootNode root;

        RootVisitAfterChildrenState(CssRootNode root) {
            Preconditions.checkNotNull((Object)root);
            this.root = root;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.leaveTree(this.root);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.pop();
        }
    }

    @VisibleForTesting
    class RootVisitBeforeChildrenState
    extends BaseVisitState<CssNode> {
        private final CssRootNode root;

        RootVisitBeforeChildrenState(CssRootNode root) {
            Preconditions.checkNotNull((Object)root);
            this.root = root;
        }

        @Override
        public void doVisit() {
            DefaultVisitController.this.visitor.enterTree(this.root);
        }

        @Override
        public void transitionToNextState() {
            DefaultVisitController.this.stateStack.transitionTo(new RootVisitCharsetState(this.root, this.root.getCharsetRule()));
        }
    }

    abstract class VisitChildrenOptionalState
    extends BaseVisitState<CssNode> {
        VisitChildrenOptionalState() {
        }
    }

    abstract class VisitReplaceChildrenState<T extends CssNode>
    extends BaseVisitState<T> {
        protected int currentIndex;
        protected boolean doNotIncreaseIndex;
        protected final CssNodesListNode<T> node;

        VisitReplaceChildrenState(CssNodesListNode<T> node) {
            this.currentIndex = -1;
            this.doNotIncreaseIndex = false;
            this.node = node;
        }

        @Override
        public void doVisit() {
        }

        @Override
        public void removeCurrentChild() {
            this.node.removeChildAt(this.currentIndex);
            this.doNotIncreaseIndex = true;
        }

        @Override
        public void replaceCurrentBlockChildWith(List<T> replacementNodes, boolean visitTheReplacementNodes) {
            this.node.replaceChildAt(this.currentIndex, replacementNodes);
            if (visitTheReplacementNodes) {
                this.doNotIncreaseIndex = true;
            } else {
                this.currentIndex += replacementNodes.size() - 1;
            }
        }

        @Override
        public void transitionToNextState() {
            if (this.currentIndex == this.node.numChildren() - 1 && !this.doNotIncreaseIndex || this.currentIndex == this.node.numChildren()) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            if (!this.doNotIncreaseIndex) {
                ++this.currentIndex;
            } else {
                this.doNotIncreaseIndex = false;
            }
            VisitState state = DefaultVisitController.this.createVisitState(this.node.getChildAt(this.currentIndex), this);
            if (state != null) {
                DefaultVisitController.this.stateStack.push(state);
            }
        }
    }

    abstract class VisitChildrenState<T extends CssNode>
    extends BaseVisitState<CssNode> {
        private final CssNodesListNode<T> block;
        private int currentIndex;

        VisitChildrenState(CssNodesListNode<T> block) {
            this.currentIndex = -1;
            this.block = block;
        }

        @Override
        public void transitionToNextState() {
            if (this.currentIndex == this.block.numChildren() - 1) {
                DefaultVisitController.this.stateStack.pop();
                return;
            }
            ++this.currentIndex;
            DefaultVisitController.this.stateStack.push(this.getVisitState(this.block.getChildAt(this.currentIndex)));
        }

        abstract VisitState<CssNode> getVisitState(T var1);

        @Override
        public void doVisit() {
        }
    }

    @VisibleForTesting
    abstract class BaseVisitState<N extends CssNode>
    implements VisitState<N> {
        BaseVisitState() {
        }

        @Override
        public void stopVisitCalled() {
        }

        @Override
        public void removeCurrentChild() {
            throw new AssertionError((Object)("Current child removal is not supported by " + this.getClass().getName() + " VisitState class."));
        }

        @Override
        public void removeCurrentNodeCalled() {
            DefaultVisitController.this.stateStack.pop();
            DefaultVisitController.this.stateStack.getTop().removeCurrentChild();
        }

        @Override
        public <S extends CssNode> void replaceCurrentBlockChildWithCalled(List<S> replacementNodes, boolean visitTheReplacementNodes) {
            DefaultVisitController.this.stateStack.pop();
            VisitState<? extends CssNode> topState = DefaultVisitController.this.stateStack.getTop();
            topState.replaceCurrentBlockChildWith(replacementNodes, visitTheReplacementNodes);
        }

        @Override
        public void replaceCurrentBlockChildWith(List<N> replacementNodes, boolean visitTheReplacementNodes) {
        }

        public VisitState<? extends CssNode> createFallbackState(N child) {
            return null;
        }
    }

    @VisibleForTesting
    static interface VisitState<T extends CssNode> {
        public void doVisit();

        public void transitionToNextState();

        public void stopVisitCalled();

        public void removeCurrentNodeCalled();

        public void removeCurrentChild();

        public <S extends CssNode> void replaceCurrentBlockChildWithCalled(List<S> var1, boolean var2);

        public void replaceCurrentBlockChildWith(List<T> var1, boolean var2);
    }

    private static class StopVisitRequestedException
    extends RuntimeException {
        private StopVisitRequestedException() {
        }
    }
}

