/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.css.SourceCodeLocation;
import java.io.Serializable;
import java.text.MessageFormat;

public class GssError
implements Comparable<GssError>,
Serializable {
    private final String message;
    private final SourceCodeLocation location;
    private String line = null;
    private String format = null;

    public GssError(String message, SourceCodeLocation location) {
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkNotNull((Object)location);
        this.message = message;
        this.location = location;
    }

    public SourceCodeLocation getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLine() {
        if (this.line == null) {
            String source = this.location.getSourceCode().getFileContents();
            int beginLineIndex = this.location.getBeginCharacterIndex() - this.location.getBeginIndexInLine() + 1;
            int endLineIndex = source.indexOf(10, this.location.getBeginCharacterIndex());
            if (endLineIndex == -1) {
                endLineIndex = source.length();
            }
            this.line = source.substring(beginLineIndex, endLineIndex);
        }
        return this.line;
    }

    public String format() {
        if (this.format == null) {
            this.format = this.messageFormat().apply();
        }
        return this.format;
    }

    public MessageFormatArgs messageFormat() {
        if (this.location.isUnknown()) {
            return new MessageFormatArgs("{0} at unknown location", this.message);
        }
        if (this.location.getSourceCode().getFileName() == null) {
            return new MessageFormatArgs("{0} at line {1} column {2}:\n{3}\n{4}^\n", this.message, this.location.getBeginLineNumber(), this.location.getBeginIndexInLine(), this.getLine(), Strings.repeat((String)" ", (int)(this.location.getBeginIndexInLine() - 1)));
        }
        return new MessageFormatArgs("{0} in {1} at line {2} column {3}:\n{4}\n{5}^\n", this.message, this.location.getSourceCode().getFileName(), this.location.getBeginLineNumber(), this.location.getBeginIndexInLine(), this.getLine(), Strings.repeat((String)" ", (int)(this.location.getBeginIndexInLine() - 1)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GssError)) {
            return false;
        }
        GssError gssError = (GssError)o;
        if (!this.location.equals(gssError.location)) {
            return false;
        }
        return this.message.equals(gssError.message);
    }

    public int hashCode() {
        return 31 * this.message.hashCode() + this.location.hashCode();
    }

    @Override
    public int compareTo(GssError o) {
        int locationCompare;
        String source1 = this.location.getSourceCode().getFileName();
        String source2 = o.location.getSourceCode().getFileName();
        if (source1 != null && source2 != null) {
            int sourceCompare = source1.compareTo(source2);
            if (sourceCompare != 0) {
                return sourceCompare;
            }
        } else {
            if (source1 == null && source2 != null) {
                return -1;
            }
            if (source1 != null) {
                return 1;
            }
        }
        if ((locationCompare = this.location.compareTo(o.location)) != 0) {
            return locationCompare;
        }
        return this.message.compareTo(o.message);
    }

    public static class MessageFormatArgs {
        public final String pattern;
        public final Object[] arguments;

        public MessageFormatArgs(String pattern, Object ... arguments) {
            this.pattern = pattern;
            this.arguments = arguments;
        }

        public String apply() {
            return MessageFormat.format(this.pattern, this.arguments);
        }
    }
}

