/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.css.SourceCode;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CharStream;
import com.google.common.css.compiler.ast.CssAbstractBlockNode;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssCustomFunctionNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFunctionArgumentsNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssHexColorNode;
import com.google.common.css.compiler.ast.CssIdSelectorNode;
import com.google.common.css.compiler.ast.CssKeyListNode;
import com.google.common.css.compiler.ast.CssKeyNode;
import com.google.common.css.compiler.ast.CssKeyframeRulesetNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssLoopVariableNode;
import com.google.common.css.compiler.ast.CssMathNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerListNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssUnicodeRangeNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.GssParserCCConstants;
import com.google.common.css.compiler.ast.GssParserCCTokenManager;
import com.google.common.css.compiler.ast.GssParserException;
import com.google.common.css.compiler.ast.ParseException;
import com.google.common.css.compiler.ast.StringCharStream;
import com.google.common.css.compiler.ast.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class GssParserCC
extends GssParserCCConstants {
    private static final Pattern FUNCTIONSWITHSPACESEPOK = Pattern.compile("(?:-(?:O|MOZ|WEBKIT|MS)-)?(?:REPEATING-)?(?:LINEAR|RADIAL)-GRADIENT|(?:-(?:O|MOZ|WEBKIT|MS)-)?IMAGE-SET|RECT|INSET|CIRCLE|ELLIPSE|POLYGON|-KHTML-GRADIENT|-WEBKIT-GRADIENT|(?:-WEBKIT-)?DROP-SHADOW|(?:-WEBKIT-)?CUSTOM|LOCAL", 2);
    private static final ImmutableSet<String> URLFUNCTIONS = ImmutableSet.of((Object)"domain", (Object)"url", (Object)"url-prefix");
    private static final CharMatcher CSSWHITESPACE = CharMatcher.anyOf((CharSequence)" \t\r\n\f");
    private static final Pattern VALIDBLOCKCOMMENTPATTERN = Pattern.compile(".*/\\*.*\\*/.*", 32);
    public static final String CRAZY_CONTENT = "{[()]}";
    private CssBlockNode globalBlock;
    private SourceCode sourceCode;
    private final CssNodeBuilder nodeBuilder = new CssNodeBuilder();
    private StringCharStream charStream;
    private boolean enableErrorRecovery;
    private final List<GssParserException> handledErrors = Lists.newArrayList();
    private final GssParserCCTokenManager tokenSource;
    private Token token;
    private int jjNtk;
    private Token jjScanpos;
    private Token jjLastpos;
    private int jjLa;
    private boolean jjLookingAhead = false;
    private boolean jjSemLA;
    private int jjGen;
    private final int[] jjLa1 = new int[160];
    private static int[] jjLa10;
    private static int[] jjLa11;
    private static int[] jjLa12;
    private final JJCalls[] jj2Rtns = new JJCalls[20];
    private boolean jjRescan = false;
    private int jjGc = 0;
    private final LookaheadSuccess jjLs = new LookaheadSuccess();
    private final List<int[]> jjExpentries = new ArrayList<int[]>();
    private int[] jjExpentry;
    private int jjKind = -1;
    private final int[] jjLasttokens = new int[100];
    private int jjEndpos;

    private SourceCodeLocation getLocation() {
        return this.getLocation(this.token);
    }

    private SourceCodeLocation getLocation(Token t) {
        int lineNumber1 = t.beginLine;
        int indexInLine1 = t.beginColumn;
        int charIndex1 = this.charStream.convertToCharacterIndex(lineNumber1, indexInLine1);
        int lineNumber2 = t.endLine;
        int indexInLine2 = t.endColumn + 1;
        int charIndex2 = this.charStream.convertToCharacterIndex(lineNumber2, indexInLine2);
        return new SourceCodeLocation(this.sourceCode, charIndex1, lineNumber1, indexInLine1, charIndex2, lineNumber2, indexInLine2);
    }

    private SourceCodeLocation mergeLocations(SourceCodeLocation beginLocation, SourceCodeLocation endLocation) {
        return SourceCodeLocation.merge(beginLocation, endLocation);
    }

    private SourceCodeLocation mergeLocations(Iterable<? extends CssNode> locations) {
        return SourceCodeLocation.merge(locations);
    }

    private CssFunctionNode createUrlFunction(Token t) {
        SourceCodeLocation loc = this.getLocation(t);
        int pi = t.image.indexOf(40);
        String funName = t.image.substring(0, pi);
        Preconditions.checkState((boolean)URLFUNCTIONS.contains((Object)funName));
        CssFunctionNode.Function funType = CssFunctionNode.Function.byName(funName);
        CssFunctionNode fun = new CssFunctionNode(funType, loc);
        String parenContents = GssParserCC.trim(t.image.substring(pi + 1, t.image.length() - 1));
        CssLiteralNode arg = new CssLiteralNode(parenContents, loc);
        fun.setArguments(new CssFunctionArgumentsNode((List<CssValueNode>)ImmutableList.of((Object)arg)));
        return fun;
    }

    private void addArgumentsWithSeparator(CssFunctionArgumentsNode node, Iterable<CssValueNode> args, int numArgs, String sep) {
        int current = 0;
        for (CssValueNode arg : args) {
            if (arg instanceof CssCompositeValueNode && ((CssCompositeValueNode)arg).getOperator() == CssCompositeValueNode.Operator.COMMA) {
                CssCompositeValueNode composite = (CssCompositeValueNode)arg;
                this.addArgumentsWithSeparator(node, composite.getValues(), composite.getValues().size(), ",");
            } else {
                node.addChildToBack(arg);
            }
            if (++current >= numArgs) continue;
            node.addChildToBack(new CssLiteralNode(sep, arg.getSourceCodeLocation()));
        }
    }

    private static String trim(String input) {
        return CSSWHITESPACE.trimFrom((CharSequence)input);
    }

    public void parse() throws GssParserException {
        try {
            this.start();
        }
        catch (ParseException e) {
            Token tokenWithError = this.token.next == null ? this.token : this.token.next;
            throw new GssParserException(this.getLocation(tokenWithError), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(CssBlockNode globalBlock, SourceCode sourceCode, boolean errorHandling, ImmutableList.Builder<GssParserException> parsingErrors) throws GssParserException {
        try {
            this.initialize(globalBlock, sourceCode, errorHandling);
            this.parse();
        }
        finally {
            parsingErrors.addAll(this.handledErrors);
            this.clearState();
        }
    }

    private void initialize(CssBlockNode globalBlock, SourceCode sourceCode, boolean errorHandling) {
        StringCharStream charStream;
        this.enableErrorRecovery = errorHandling;
        this.sourceCode = sourceCode;
        this.globalBlock = globalBlock;
        this.handledErrors.clear();
        this.charStream = charStream = new StringCharStream(sourceCode.getFileContents());
        this.reInit(charStream);
    }

    private void clearState() {
        this.sourceCode = null;
        this.globalBlock = null;
        this.handledErrors.clear();
        this.charStream = null;
    }

    public final CssStringNode string() throws ParseException {
        CssStringNode.Type type;
        Token t;
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 61: {
                t = this.jjConsumeToken(61);
                type = CssStringNode.Type.DOUBLE_QUOTED_STRING;
                break;
            }
            case 62: {
                t = this.jjConsumeToken(62);
                type = CssStringNode.Type.SINGLE_QUOTED_STRING;
                break;
            }
            default: {
                this.jjLa1[0] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        SourceCodeLocation endLocation = this.getLocation();
        return this.nodeBuilder.buildStringNode(type, t.image, this.mergeLocations(beginLocation, endLocation), t);
    }

    public final CssRulesetNode ruleSet() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        try {
            Token t;
            CssSelectorListNode selectors;
            try {
                selectors = this.selectorList();
                t = this.jjConsumeToken(13);
                tokens.add(t);
            }
            catch (ParseException e) {
                if (!this.enableErrorRecovery || e.currentToken == null) {
                    throw e;
                }
                this.skipComponentValuesToAfter(13);
                throw e;
            }
            CssDeclarationBlockNode declarations = this.styleDeclaration();
            t = this.jjConsumeToken(14);
            tokens.add(t);
            CssRulesetNode ruleSet = this.nodeBuilder.buildRulesetNode(declarations, selectors, this.mergeLocations(selectors.getSourceCodeLocation(), this.getLocation()), tokens);
            return ruleSet;
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToAfter(14);
            throw e;
        }
    }

    public final CssSelectorListNode selectorList() throws ParseException {
        CssSelectorListNode list = new CssSelectorListNode();
        CssSelectorNode selector = this.selector();
        list.addChildToBack(selector);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 15) break;
            Token t = this.jjConsumeToken(15);
            this.nodeBuilder.attachComment(t, selector);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[2] = this.jjGen;
            selector = this.selector();
            list.addChildToBack(selector);
        }
        this.jjLa1[1] = this.jjGen;
        return list;
    }

    public final CssSelectorNode selector() throws ParseException {
        CssSelectorNode first;
        ArrayList tokens = Lists.newArrayList();
        CssSelectorNode prev = first = this.simpleSelector();
        while (this.jj21(2)) {
            CssCombinatorNode c = this.combinator();
            CssSelectorNode next = this.simpleSelector();
            c.setSelector(next);
            prev.setCombinator(c);
            prev = next;
        }
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            Token t = this.jjConsumeToken(45);
            tokens.add(t);
        }
        this.jjLa1[3] = this.jjGen;
        this.nodeBuilder.attachComments(tokens, first);
        return first;
    }

    public final CssClassSelectorNode className() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        CssClassSelectorNode.ComponentScoping scoping = CssClassSelectorNode.ComponentScoping.DEFAULT;
        Token t = this.jjConsumeToken(4);
        tokens.add(t);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 17: 
            case 27: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 17: {
                        this.jjConsumeToken(17);
                        scoping = CssClassSelectorNode.ComponentScoping.FORCE_SCOPED;
                        break block0;
                    }
                    case 27: {
                        this.jjConsumeToken(27);
                        scoping = CssClassSelectorNode.ComponentScoping.FORCE_UNSCOPED;
                        break block0;
                    }
                }
                this.jjLa1[4] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            default: {
                this.jjLa1[5] = this.jjGen;
            }
        }
        t = this.jjConsumeToken(66);
        tokens.add(t);
        return this.nodeBuilder.buildClassSelectorNode(t.image, this.getLocation(), scoping, tokens);
    }

    public final CssRefinerNode id() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(59);
        tokens.add(t);
        String name = t.image.substring(1);
        return this.nodeBuilder.buildIdSelectorNode(name, this.getLocation(), tokens);
    }

    public final CssRefinerNode pseudo() throws ParseException {
        String pseudo = null;
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(3);
        SourceCodeLocation beginLocation = this.getLocation();
        tokens.add(t);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 3: 
            case 66: 
            case 68: 
            case 69: 
            case 74: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 66: {
                        t = this.jjConsumeToken(66);
                        pseudo = t.image;
                        tokens.add(t);
                        break block0;
                    }
                    case 3: {
                        t = this.jjConsumeToken(3);
                        tokens.add(t);
                        t = this.jjConsumeToken(66);
                        pseudo = t.image;
                        tokens.add(t);
                        SourceCodeLocation endLocation = this.getLocation();
                        return this.nodeBuilder.buildPseudoElementNode(pseudo, this.mergeLocations(beginLocation, endLocation), tokens);
                    }
                    case 68: {
                        t = this.jjConsumeToken(68);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[6] = this.jjGen;
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        CssSelectorNode notSelector = this.simpleSelector();
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[7] = this.jjGen;
                        t = this.jjConsumeToken(12);
                        tokens.add(t);
                        SourceCodeLocation endLocation = this.getLocation();
                        return this.nodeBuilder.buildPseudoClassNode(pseudo, notSelector, this.mergeLocations(beginLocation, endLocation), tokens);
                    }
                    case 69: {
                        t = this.jjConsumeToken(69);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[8] = this.jjGen;
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        t = this.jjConsumeToken(66);
                        String argument = t.image;
                        tokens.add(t);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[9] = this.jjGen;
                        t = this.jjConsumeToken(12);
                        tokens.add(t);
                        SourceCodeLocation endLocation = this.getLocation();
                        return this.nodeBuilder.buildPseudoClassNode(CssPseudoClassNode.FunctionType.LANG, pseudo, argument, this.mergeLocations(beginLocation, endLocation), tokens);
                    }
                    case 74: {
                        t = this.jjConsumeToken(74);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[10] = this.jjGen;
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        String argument = this.nth();
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[11] = this.jjGen;
                        t = this.jjConsumeToken(12);
                        tokens.add(t);
                        SourceCodeLocation endLocation = this.getLocation();
                        return this.nodeBuilder.buildPseudoClassNode(CssPseudoClassNode.FunctionType.NTH, pseudo, argument, this.mergeLocations(beginLocation, endLocation), tokens);
                    }
                }
                this.jjLa1[12] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            default: {
                this.jjLa1[13] = this.jjGen;
            }
        }
        SourceCodeLocation endLocation = this.getLocation();
        return this.nodeBuilder.buildPseudoClassNode(pseudo, this.mergeLocations(beginLocation, endLocation), tokens);
    }

    public final String nth() throws ParseException {
        int i;
        StringBuilder argument = new StringBuilder();
        do {
            switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                case 49: {
                    Token t = this.jjConsumeToken(49);
                    argument.append(t.image);
                    break;
                }
                case 7: {
                    Token t = this.jjConsumeToken(7);
                    argument.append(t.image);
                    break;
                }
                case 48: {
                    Token t = this.jjConsumeToken(48);
                    argument.append(GssParserCC.trim(t.image));
                    break;
                }
                case 58: {
                    Token t = this.jjConsumeToken(58);
                    argument.append(t.image);
                    break;
                }
                case 66: {
                    Token t = this.jjConsumeToken(66);
                    argument.append(t.image);
                    break;
                }
                case 65: {
                    Token t = this.jjConsumeToken(65);
                    argument.append(t.image);
                    break;
                }
                default: {
                    this.jjLa1[14] = this.jjGen;
                    this.jjConsumeToken(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[15] = this.jjGen;
        } while ((i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 7 || i == 48 || i == 49 || i == 58 || i == 65 || i == 66);
        this.jjLa1[16] = this.jjGen;
        return argument.toString();
    }

    public final CssAttributeSelectorNode attribute() throws ParseException {
        String attribute;
        CssValueNode stringNode = null;
        CssLiteralNode idNode = null;
        ArrayList tokens = Lists.newArrayList();
        CssAttributeSelectorNode.MatchType matchType = CssAttributeSelectorNode.MatchType.ANY;
        Token t = this.jjConsumeToken(9);
        SourceCodeLocation beginLocation = this.getLocation();
        tokens.add(t);
        try {
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[17] = this.jjGen;
            t = this.jjConsumeToken(66);
            attribute = t.image;
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[18] = this.jjGen;
            block1 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                case 8: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 8: {
                            t = this.jjConsumeToken(8);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.EXACT;
                            break;
                        }
                        case 32: {
                            t = this.jjConsumeToken(32);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.ONE_WORD;
                            break;
                        }
                        case 33: {
                            t = this.jjConsumeToken(33);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.PREFIX;
                            break;
                        }
                        case 34: {
                            t = this.jjConsumeToken(34);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.SUFFIX;
                            break;
                        }
                        case 35: {
                            t = this.jjConsumeToken(35);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.CONTAINS;
                            break;
                        }
                        case 36: {
                            t = this.jjConsumeToken(36);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.EXACT_OR_DASH;
                            break;
                        }
                        default: {
                            this.jjLa1[19] = this.jjGen;
                            this.jjConsumeToken(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[20] = this.jjGen;
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 66: {
                            t = this.jjConsumeToken(66);
                            idNode = new CssLiteralNode(t.image, this.getLocation());
                            tokens.add(t);
                            break;
                        }
                        case 61: 
                        case 62: {
                            stringNode = this.string();
                            break;
                        }
                        default: {
                            this.jjLa1[21] = this.jjGen;
                            this.jjConsumeToken(-1);
                            throw new ParseException();
                        }
                    }
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                            this.jjLa1[22] = this.jjGen;
                            break block1;
                        }
                        this.jjConsumeToken(45);
                    }
                }
                default: {
                    this.jjLa1[23] = this.jjGen;
                }
            }
            t = this.jjConsumeToken(10);
            tokens.add(t);
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToAfter(10);
            throw e;
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssValueNode v = stringNode != null ? stringNode : (idNode != null ? idNode : new CssLiteralNode(""));
        return this.nodeBuilder.buildAttributeSelectorNode(matchType, attribute, v, this.mergeLocations(beginLocation, endLocation), tokens);
    }

    public final CssSelectorNode simpleSelector() throws ParseException {
        Token selectorName = null;
        CssRefinerListNode refiners = new CssRefinerListNode();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 5: 
            case 66: {
                int i;
                selectorName = this.elementName();
                while (true) {
                    CssRefinerNode n;
                    int n2 = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
                    if (i != 3 && i != 4 && i != 9 && i != 59) {
                        this.jjLa1[24] = this.jjGen;
                        break block0;
                    }
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 59: {
                            n = this.id();
                            break;
                        }
                        case 4: {
                            n = this.className();
                            break;
                        }
                        case 9: {
                            n = this.attribute();
                            break;
                        }
                        case 3: {
                            n = this.pseudo();
                            break;
                        }
                        default: {
                            this.jjLa1[25] = this.jjGen;
                            this.jjConsumeToken(-1);
                            throw new ParseException();
                        }
                    }
                    refiners.addChildToBack(n);
                }
            }
            case 3: 
            case 4: 
            case 9: 
            case 59: {
                int i;
                do {
                    CssRefinerNode n;
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 59: {
                            n = this.id();
                            break;
                        }
                        case 4: {
                            n = this.className();
                            break;
                        }
                        case 9: {
                            n = this.attribute();
                            break;
                        }
                        case 3: {
                            n = this.pseudo();
                            break;
                        }
                        default: {
                            this.jjLa1[26] = this.jjGen;
                            this.jjConsumeToken(-1);
                            throw new ParseException();
                        }
                    }
                    refiners.addChildToBack(n);
                } while ((i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 3 || i == 4 || i == 9 || i == 59);
                this.jjLa1[27] = this.jjGen;
                break;
            }
            default: {
                this.jjLa1[28] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssSelectorNode selectorNode = this.nodeBuilder.buildSelectorNode(selectorName, this.mergeLocations(beginLocation, endLocation), refiners);
        return selectorNode;
    }

    public final Token elementName() throws ParseException {
        Token t;
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 66: {
                t = this.jjConsumeToken(66);
                break;
            }
            case 5: {
                t = this.jjConsumeToken(5);
                break;
            }
            default: {
                this.jjLa1[29] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final CssCombinatorNode combinator() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 49: {
                Token t = this.jjConsumeToken(49);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[30] = this.jjGen;
                tokens.add(t);
                return this.nodeBuilder.buildCombinatorNode(CssCombinatorNode.Combinator.ADJACENT_SIBLING, this.getLocation(), tokens);
            }
            case 50: {
                Token t = this.jjConsumeToken(50);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[31] = this.jjGen;
                tokens.add(t);
                return this.nodeBuilder.buildCombinatorNode(CssCombinatorNode.Combinator.CHILD, this.getLocation(), tokens);
            }
            case 51: {
                Token t = this.jjConsumeToken(51);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[32] = this.jjGen;
                tokens.add(t);
                return this.nodeBuilder.buildCombinatorNode(CssCombinatorNode.Combinator.GENERAL_SIBLING, this.getLocation(), tokens);
            }
            case 52: {
                Token t = this.jjConsumeToken(52);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[33] = this.jjGen;
                tokens.add(t);
                return this.nodeBuilder.buildCombinatorNode(CssCombinatorNode.Combinator.DEEP, this.getLocation(), tokens);
            }
            case 45: {
                do {
                    Token t = this.jjConsumeToken(45);
                    tokens.add(t);
                } while ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 45);
                this.jjLa1[34] = this.jjGen;
                return this.nodeBuilder.buildCombinatorNode(CssCombinatorNode.Combinator.DESCENDANT, this.getLocation(), tokens);
            }
        }
        this.jjLa1[35] = this.jjGen;
        this.jjConsumeToken(-1);
        throw new ParseException();
    }

    public final CssDeclarationBlockNode styleDeclaration() throws ParseException {
        CssNode decl;
        CssDeclarationBlockNode block = new CssDeclarationBlockNode();
        try {
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[36] = this.jjGen;
            switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                case 5: 
                case 66: 
                case 67: {
                    decl = this.declaration();
                    block.addChildToBack(decl);
                    break;
                }
                default: {
                    this.jjLa1[37] = this.jjGen;
                }
            }
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[38] = this.jjGen;
                    break;
                }
                this.jjConsumeToken(45);
            }
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.handledErrors.add(new GssParserException(this.getLocation(e.currentToken.next), (Throwable)e));
        }
        while (true) {
            int i;
            int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
            if (i != 2 && i != 78) break;
            try {
                block6 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 78: {
                        try {
                            decl = this.innerAtRule();
                            block.addChildToBack(decl);
                        }
                        catch (ParseException e) {
                            if (!this.enableErrorRecovery || e.currentToken == null) {
                                throw e;
                            }
                            this.handledErrors.add(new GssParserException(this.getLocation(e.currentToken.next), (Throwable)e));
                        }
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[40] = this.jjGen;
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 5: 
                            case 66: 
                            case 67: {
                                decl = this.declaration();
                                block.addChildToBack(decl);
                                break block6;
                            }
                        }
                        this.jjLa1[41] = this.jjGen;
                        break;
                    }
                    case 2: {
                        this.jjConsumeToken(2);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[42] = this.jjGen;
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 5: 
                            case 66: 
                            case 67: {
                                decl = this.declaration();
                                block.addChildToBack(decl);
                                break block6;
                            }
                        }
                        this.jjLa1[43] = this.jjGen;
                        break;
                    }
                    default: {
                        this.jjLa1[44] = this.jjGen;
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                }
            }
            catch (ParseException e) {
                if (!this.enableErrorRecovery || e.currentToken == null) {
                    throw e;
                }
                this.handledErrors.add(new GssParserException(this.getLocation(e.currentToken.next), (Throwable)e));
            }
        }
        this.jjLa1[39] = this.jjGen;
        return block;
    }

    public final CssNode declaration() throws ParseException {
        CssDeclarationNode decl;
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 5: 
            case 66: {
                decl = this.standardDeclaration();
                break;
            }
            case 67: {
                decl = this.customDeclaration();
                break;
            }
            default: {
                this.jjLa1[45] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        return decl;
    }

    public final CssDeclarationNode customDeclaration() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        try {
            Token t = this.jjConsumeToken(67);
            CssPropertyNode property = new CssPropertyNode(t.image, this.getLocation());
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[46] = this.jjGen;
            t = this.jjConsumeToken(3);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[47] = this.jjGen;
            CssPropertyValueNode valueNode = this.customDeclarationValue();
            return this.nodeBuilder.buildDeclarationNode(property, valueNode, tokens);
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToBefore(14, 2);
            throw e;
        }
    }

    public final CssPropertyValueNode customDeclarationValue() throws ParseException {
        CssPropertyValueNode value = this.expr();
        return value;
    }

    public final CssDeclarationNode standardDeclaration() throws ParseException {
        CssPriorityNode priority = null;
        ArrayList tokens = Lists.newArrayList();
        String propertyName = "";
        try {
            Token t;
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 5) {
                t = this.jjConsumeToken(5);
                tokens.add(t);
                propertyName = "*";
            } else {
                this.jjLa1[48] = this.jjGen;
            }
            t = this.jjConsumeToken(66);
            propertyName = propertyName + t.image;
            CssPropertyNode property = new CssPropertyNode(propertyName, this.getLocation());
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[49] = this.jjGen;
            t = this.jjConsumeToken(3);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[50] = this.jjGen;
            CssPropertyValueNode valueNode = this.expr();
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[51] = this.jjGen;
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 60) {
                priority = this.important();
            } else {
                this.jjLa1[52] = this.jjGen;
            }
            if (priority != null) {
                valueNode.addChildToBack(priority);
            }
            CssDeclarationNode node = this.nodeBuilder.buildDeclarationNode(property, valueNode, tokens);
            return node;
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToBefore(14, 2);
            throw e;
        }
    }

    public final CssPropertyValueNode expr() throws ParseException {
        ArrayList lst = Lists.newArrayList();
        CssValueNode value = this.compositeTerm();
        lst.add(value);
        while (this.jj22(1)) {
            value = this.compositeTerm();
            lst.add(value);
        }
        CssPropertyValueNode result = new CssPropertyValueNode(lst);
        result.setSourceCodeLocation(this.mergeLocations(lst));
        return result;
    }

    public final CssValueNode compositeTerm() throws ParseException {
        ArrayList lst = Lists.newArrayList();
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        CssValueNode value = this.assignTerm();
        lst.add(value);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 15) break;
            Token t = this.jjConsumeToken(15);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[54] = this.jjGen;
            value = this.assignTerm();
            lst.add(value);
        }
        this.jjLa1[53] = this.jjGen;
        if (lst.size() == 1) {
            return (CssValueNode)lst.get(0);
        }
        return this.nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.COMMA, this.mergeLocations(beginLocation, this.getLocation()), tokens);
    }

    public final CssValueNode assignTerm() throws ParseException {
        ArrayList lst = Lists.newArrayList();
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        CssValueNode value = this.slashTerm();
        lst.add(value);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 8) break;
            Token t = this.jjConsumeToken(8);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[56] = this.jjGen;
            value = this.slashTerm();
            lst.add(value);
        }
        this.jjLa1[55] = this.jjGen;
        if (lst.size() == 1) {
            return (CssValueNode)lst.get(0);
        }
        return this.nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.EQUALS, this.mergeLocations(beginLocation, this.getLocation()), tokens);
    }

    public final CssValueNode slashTerm() throws ParseException {
        ArrayList lst = Lists.newArrayList();
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        CssValueNode value = this.term();
        lst.add(value);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 6) break;
            Token t = this.jjConsumeToken(6);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[58] = this.jjGen;
            value = this.term();
            lst.add(value);
        }
        this.jjLa1[57] = this.jjGen;
        if (lst.size() == 1) {
            return (CssValueNode)lst.get(0);
        }
        return this.nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.SLASH, this.mergeLocations(beginLocation, this.getLocation()), tokens);
    }

    public final CssValueNode term() throws ParseException {
        Token t = null;
        Token dim = null;
        String unit = null;
        String unop = "";
        CssFunctionNode function = null;
        CssStringNode stringNode = null;
        ArrayList tokens = Lists.newArrayList();
        boolean hexcolor = false;
        boolean loopVariable = false;
        boolean unicodeRange = false;
        block1 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 7: 
            case 49: 
            case 58: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 7: 
                    case 49: {
                        t = this.unaryOperator();
                        unop = GssParserCC.trim(t.image);
                        tokens.add(t);
                        break;
                    }
                    default: {
                        this.jjLa1[59] = this.jjGen;
                    }
                }
                t = this.jjConsumeToken(58);
                unit = "";
                tokens.add(t);
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 17: 
                    case 66: {
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 17: {
                                dim = this.jjConsumeToken(17);
                                break;
                            }
                            case 66: {
                                dim = this.jjConsumeToken(66);
                                break;
                            }
                            default: {
                                this.jjLa1[60] = this.jjGen;
                                this.jjConsumeToken(-1);
                                throw new ParseException();
                            }
                        }
                        unit = dim.image.toLowerCase();
                        tokens.add(dim);
                        break block1;
                    }
                }
                this.jjLa1[61] = this.jjGen;
                break;
            }
            case 73: {
                t = this.jjConsumeToken(73);
                unicodeRange = true;
                tokens.add(t);
                break;
            }
            case 61: 
            case 62: {
                stringNode = this.string();
                break;
            }
            default: {
                this.jjLa1[70] = this.jjGen;
                if (this.jj23(1)) {
                    if (this.getToken((int)2).kind == 4 || this.getToken((int)2).kind == 3) {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    t = this.jjConsumeToken(66);
                    tokens.add(t);
                    break;
                }
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 65) {
                    t = this.jjConsumeToken(65);
                    loopVariable = true;
                    tokens.add(t);
                    break;
                }
                this.jjLa1[71] = this.jjGen;
                if (this.jj24(1)) {
                    if (this.getToken((int)1).kind != 11 || this.getToken((int)3).kind != 3 && this.getToken((int)4).kind != 3) {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    t = this.jjConsumeToken(11);
                    tokens.add(t);
                    try {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 45) {
                            this.jjConsumeToken(45);
                        } else {
                            this.jjLa1[62] = this.jjGen;
                        }
                        t = this.jjConsumeToken(66);
                        tokens.add(t);
                        t = this.jjConsumeToken(3);
                        tokens.add(t);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[63] = this.jjGen;
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 58: {
                                t = this.jjConsumeToken(58);
                                tokens.add(t);
                                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                                    case 6: 
                                    case 45: {
                                        while (true) {
                                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                                            this.jjConsumeToken(45);
                                        }
                                        this.jjLa1[64] = this.jjGen;
                                        t = this.jjConsumeToken(6);
                                        tokens.add(t);
                                        while (true) {
                                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                                            this.jjConsumeToken(45);
                                        }
                                        this.jjLa1[65] = this.jjGen;
                                        t = this.jjConsumeToken(58);
                                        tokens.add(t);
                                        break;
                                    }
                                    default: {
                                        this.jjLa1[66] = this.jjGen;
                                    }
                                }
                                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 66) {
                                    dim = this.jjConsumeToken(66);
                                    tokens.add(dim);
                                    break;
                                }
                                this.jjLa1[67] = this.jjGen;
                                break;
                            }
                            case 66: {
                                t = this.jjConsumeToken(66);
                                tokens.add(t);
                                break;
                            }
                            default: {
                                this.jjLa1[68] = this.jjGen;
                                this.jjConsumeToken(-1);
                                throw new ParseException();
                            }
                        }
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[69] = this.jjGen;
                        t = this.jjConsumeToken(12);
                        tokens.add(t);
                        break;
                    }
                    catch (ParseException e) {
                        if (!this.enableErrorRecovery || e.currentToken == null) {
                            throw e;
                        }
                        this.skipComponentValuesToAfter(12);
                        throw e;
                    }
                }
                if (this.getToken((int)1).kind == 63) {
                    function = this.uri();
                    break;
                }
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 59: {
                        t = this.hexcolor();
                        tokens.add(t);
                        hexcolor = true;
                        break block1;
                    }
                    case 70: {
                        function = this.calc();
                        break block1;
                    }
                    case 71: {
                        function = this.varNode();
                        break block1;
                    }
                    case 66: 
                    case 74: {
                        function = this.function();
                        break block1;
                    }
                }
                this.jjLa1[72] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[73] = this.jjGen;
        if (unit != null) {
            SourceCodeLocation location = dim != null ? this.mergeLocations(this.getLocation(t), this.getLocation(dim)) : this.getLocation(t);
            return this.nodeBuilder.buildNumericNode(unop + t.image, unit, location, tokens);
        }
        if (function != null) {
            return function;
        }
        if (hexcolor) {
            return this.nodeBuilder.buildHexColorNode(t.image, this.getLocation(t), tokens);
        }
        if (stringNode != null) {
            return stringNode;
        }
        StringBuilder sb = new StringBuilder();
        for (Token token : tokens) {
            sb.append(token.image);
        }
        if (loopVariable) {
            return this.nodeBuilder.buildLoopVariableNode(sb.toString(), this.getLocation(t), tokens);
        }
        if (unicodeRange) {
            return this.nodeBuilder.buildUnicodeRangeNode(sb.toString(), this.getLocation(t), tokens);
        }
        return this.nodeBuilder.buildLiteralNode(sb.toString(), this.getLocation(t), tokens);
    }

    public final CssBooleanExpressionNode extendedTerm() throws ParseException {
        String value = "";
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        CssBooleanExpressionNode left = this.booleanAndTerm();
        value = value + left.toString();
        while (true) {
            CssBooleanExpressionNode newNode;
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 31) break;
            Token t = this.jjConsumeToken(31);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[75] = this.jjGen;
            CssBooleanExpressionNode right = this.booleanAndTerm();
            value = value + right.toString();
            SourceCodeLocation endLocation = this.getLocation();
            left = newNode = this.nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.OR, value, left, right, this.mergeLocations(beginLocation, endLocation), tokens);
        }
        this.jjLa1[74] = this.jjGen;
        return left;
    }

    public final CssBooleanExpressionNode booleanAndTerm() throws ParseException {
        CssBooleanExpressionNode left;
        String value = "";
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 16) {
            left = this.booleanNegatedTerm();
        } else {
            this.jjLa1[76] = this.jjGen;
            if (this.jj25(1)) {
                left = this.basicTerm();
            } else {
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        value = value + left.toString();
        while (true) {
            CssBooleanExpressionNode newNode;
            CssBooleanExpressionNode right;
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 30) break;
            Token t = this.jjConsumeToken(30);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[78] = this.jjGen;
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 16) {
                right = this.booleanNegatedTerm();
            } else {
                this.jjLa1[79] = this.jjGen;
                if (this.jj26(1)) {
                    right = this.basicTerm();
                } else {
                    this.jjConsumeToken(-1);
                    throw new ParseException();
                }
            }
            value = value + right.toString();
            SourceCodeLocation endLocation = this.getLocation();
            left = newNode = this.nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.AND, value, left, right, this.mergeLocations(beginLocation, endLocation), tokens);
        }
        this.jjLa1[77] = this.jjGen;
        return left;
    }

    public final CssBooleanExpressionNode booleanNegatedTerm() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(16);
        String value = "!";
        SourceCodeLocation beginLocation = this.getLocation();
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[80] = this.jjGen;
        CssBooleanExpressionNode boolNode = this.basicTerm();
        SourceCodeLocation endLocation = this.getLocation();
        return this.nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.NOT, value, boolNode, null, this.mergeLocations(beginLocation, endLocation), tokens);
    }

    public final CssBooleanExpressionNode basicTerm() throws ParseException {
        String value;
        CssBooleanExpressionNode node = null;
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        if (this.jj27(1)) {
            CssValueNode termNode = this.term();
            value = termNode.toString();
        } else if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 11) {
            node = this.parenthesizedTerm();
            value = node.toString();
        } else {
            this.jjLa1[81] = this.jjGen;
            this.jjConsumeToken(-1);
            throw new ParseException();
        }
        SourceCodeLocation endLocation = this.getLocation();
        if (node == null) {
            return this.nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.CONSTANT, value, null, null, this.mergeLocations(beginLocation, endLocation), tokens);
        }
        return node;
    }

    public final CssBooleanExpressionNode parenthesizedTerm() throws ParseException {
        CssBooleanExpressionNode node;
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(11);
        tokens.add(t);
        try {
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[82] = this.jjGen;
            node = this.extendedTerm();
            t = this.jjConsumeToken(12);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[83] = this.jjGen;
                    break;
                }
                this.jjConsumeToken(45);
            }
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToAfter(12);
            throw e;
        }
        this.nodeBuilder.attachComments(tokens, node);
        return node;
    }

    public final Token unaryOperator() throws ParseException {
        Token t;
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 7: {
                t = this.jjConsumeToken(7);
                break;
            }
            case 49: {
                t = this.jjConsumeToken(49);
                break;
            }
            default: {
                this.jjLa1[84] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        return t;
    }

    public final Token hexcolor() throws ParseException {
        Token t = this.jjConsumeToken(59);
        return t;
    }

    public final CssFunctionNode varNode() throws ParseException {
        StringBuilder functionName = new StringBuilder();
        ArrayList tokens = Lists.newArrayList();
        ArrayList arguments = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        Token t = this.jjConsumeToken(71);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[85] = this.jjGen;
        t = this.jjConsumeToken(67);
        arguments.add(new CssPropertyNode(t.image, this.getLocation()));
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[86] = this.jjGen;
        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 15) {
            t = this.jjConsumeToken(15);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[87] = this.jjGen;
            CssPropertyValueNode defaultValueNode = this.customDeclarationValue();
            arguments.add((CssValueNode)defaultValueNode.getChildAt(0));
        } else {
            this.jjLa1[88] = this.jjGen;
        }
        t = this.jjConsumeToken(12);
        tokens.add(t);
        SourceCodeLocation endLocation = this.getLocation(t);
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        this.addArgumentsWithSeparator(args, arguments, arguments.size(), ",");
        return this.nodeBuilder.buildFunctionNode(functionName.toString(), this.mergeLocations(beginLocation, endLocation), args, tokens);
    }

    public final CssFunctionNode uri() throws ParseException {
        this.getLocation(this.token.next);
        Token t = this.jjConsumeToken(63);
        return this.createUrlFunction(t);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final CssFunctionNode function() throws ParseException {
        CssFunctionArgumentsNode args;
        SourceCodeLocation endLocation;
        CssPropertyValueNode expr;
        SourceCodeLocation beginLocation;
        ArrayList tokens;
        StringBuilder functionName;
        block19: {
            Token t;
            block18: {
                functionName = new StringBuilder();
                tokens = Lists.newArrayList();
                beginLocation = this.getLocation(this.token.next);
                block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 74: {
                        t = this.jjConsumeToken(74);
                        functionName.append(t.image);
                        functionName.setLength(functionName.length() - 1);
                        tokens.add(t);
                        break block18;
                    }
                    case 66: {
                        t = this.jjConsumeToken(66);
                        functionName.append(t.image);
                        tokens.add(t);
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 4: {
                                this.jjConsumeToken(4);
                                functionName.append(".");
                                break block0;
                            }
                            case 3: {
                                this.jjConsumeToken(3);
                                functionName.append(":");
                                break block0;
                            }
                        }
                        this.jjLa1[89] = this.jjGen;
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jjLa1[92] = this.jjGen;
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                }
                block12: while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 66) {
                        this.jjLa1[90] = this.jjGen;
                        t = this.jjConsumeToken(74);
                        functionName.append(t.image);
                        functionName.setLength(functionName.length() - 1);
                        break block18;
                    }
                    t = this.jjConsumeToken(66);
                    functionName.append(t.image);
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 4: {
                            this.jjConsumeToken(4);
                            functionName.append(".");
                            continue block12;
                        }
                        case 3: {
                            this.jjConsumeToken(3);
                            functionName.append(":");
                            continue block12;
                        }
                    }
                    break;
                }
                this.jjLa1[91] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[93] = this.jjGen;
                    expr = this.expr();
                    t = this.jjConsumeToken(12);
                    tokens.add(t);
                    endLocation = this.getLocation();
                    args = new CssFunctionArgumentsNode();
                    if (expr.numChildren() == 1) {
                        break;
                    }
                    break block19;
                }
                this.jjConsumeToken(45);
            }
            CssValueNode child = (CssValueNode)expr.getChildAt(0);
            this.addArgumentsWithSeparator(args, (Iterable<CssValueNode>)ImmutableList.of((Object)child), 1, " ");
            return this.nodeBuilder.buildFunctionNode(functionName.toString(), this.mergeLocations(beginLocation, endLocation), args, tokens);
        }
        if (!FUNCTIONSWITHSPACESEPOK.matcher(functionName).matches()) {
            throw this.generateParseException();
        }
        this.addArgumentsWithSeparator(args, expr.childIterable(), expr.numChildren(), " ");
        return this.nodeBuilder.buildFunctionNode(functionName.toString(), this.mergeLocations(beginLocation, endLocation), args, tokens);
    }

    public final CssFunctionNode calc() throws ParseException {
        StringBuilder functionName = new StringBuilder();
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        Token t = this.jjConsumeToken(70);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[94] = this.jjGen;
        CssValueNode math = this.sum(false);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[95] = this.jjGen;
        t = this.jjConsumeToken(12);
        tokens.add(t);
        SourceCodeLocation endLocation = this.getLocation(t);
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        this.addArgumentsWithSeparator(args, (Iterable<CssValueNode>)ImmutableList.of((Object)math), 1, "");
        return this.nodeBuilder.buildFunctionNode(functionName.toString(), this.mergeLocations(beginLocation, endLocation), args, tokens);
    }

    public final CssValueNode sum(boolean hasParenthesis) throws ParseException {
        ArrayList<CssValueNode> operands = new ArrayList<CssValueNode>();
        ArrayList<CssCompositeValueNode.Operator> operators = new ArrayList<CssCompositeValueNode.Operator>();
        CssValueNode operand = this.product(hasParenthesis);
        operands.add(operand);
        while (true) {
            int i;
            int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
            if (i != 48 && i != 49) break;
            switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                case 49: {
                    this.jjConsumeToken(49);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[97] = this.jjGen;
                    operators.add(CssCompositeValueNode.Operator.ADD);
                    break;
                }
                case 48: {
                    this.jjConsumeToken(48);
                    operators.add(CssCompositeValueNode.Operator.SUB);
                    break;
                }
                default: {
                    this.jjLa1[98] = this.jjGen;
                    this.jjConsumeToken(-1);
                    throw new ParseException();
                }
            }
            operand = this.product(false);
            operands.add(operand);
        }
        this.jjLa1[96] = this.jjGen;
        return CssMathNode.createFromOperandsAndOperators(operands, operators, hasParenthesis);
    }

    public final CssValueNode product(boolean hasParenthesis) throws ParseException {
        ArrayList<CssCompositeValueNode.Operator> operators;
        ArrayList<CssValueNode> operands;
        block8: {
            operands = new ArrayList<CssValueNode>();
            operators = new ArrayList<CssCompositeValueNode.Operator>();
            CssValueNode operand = this.unit();
            operands.add(operand);
            block4: while (true) {
                int i;
                int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
                if (i != 5 && i != 6 && i != 45) break block8;
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[100] = this.jjGen;
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 5: {
                        this.jjConsumeToken(5);
                        operators.add(CssCompositeValueNode.Operator.MULT);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[101] = this.jjGen;
                        operand = this.unit();
                        operands.add(operand);
                        continue block4;
                    }
                    case 6: {
                        this.jjConsumeToken(6);
                        operators.add(CssCompositeValueNode.Operator.DIV);
                        while (true) {
                            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                            this.jjConsumeToken(45);
                        }
                        this.jjLa1[102] = this.jjGen;
                        Token t = this.jjConsumeToken(58);
                        operands.add(new CssNumericNode(t.image, ""));
                        continue block4;
                    }
                }
                break;
            }
            this.jjLa1[103] = this.jjGen;
            this.jjConsumeToken(-1);
            throw new ParseException();
        }
        this.jjLa1[99] = this.jjGen;
        return CssMathNode.createFromOperandsAndOperators(operands, operators, hasParenthesis);
    }

    public final CssValueNode unit() throws ParseException {
        String sign = "";
        Token dim = null;
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 7: 
            case 49: 
            case 58: 
            case 66: 
            case 71: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 71: {
                        CssFunctionNode node = this.varNode();
                        return node;
                    }
                    case 66: {
                        Token t = this.jjConsumeToken(66);
                        return new CssLiteralNode(t.image, this.getLocation(t));
                    }
                    case 7: 
                    case 49: 
                    case 58: {
                        Token t;
                        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 7: 
                            case 49: {
                                t = this.unaryOperator();
                                sign = t.image;
                                break;
                            }
                            default: {
                                this.jjLa1[104] = this.jjGen;
                            }
                        }
                        t = this.jjConsumeToken(58);
                        block13 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                            case 17: 
                            case 66: {
                                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                                    case 17: {
                                        dim = this.jjConsumeToken(17);
                                        break block13;
                                    }
                                    case 66: {
                                        dim = this.jjConsumeToken(66);
                                        break block13;
                                    }
                                }
                                this.jjLa1[105] = this.jjGen;
                                this.jjConsumeToken(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jjLa1[106] = this.jjGen;
                            }
                        }
                        return new CssNumericNode(sign + t.image, dim != null ? dim.image.toLowerCase() : "", this.getLocation(t));
                    }
                }
                this.jjLa1[107] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            case 11: {
                this.jjConsumeToken(11);
                try {
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[108] = this.jjGen;
                    CssValueNode node = this.sum(true);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[109] = this.jjGen;
                    this.jjConsumeToken(12);
                    return node;
                }
                catch (ParseException e) {
                    if (!this.enableErrorRecovery || e.currentToken == null) {
                        throw e;
                    }
                    this.skipComponentValuesToAfter(12);
                    throw e;
                }
            }
        }
        this.jjLa1[110] = this.jjGen;
        this.jjConsumeToken(-1);
        throw new ParseException();
    }

    public final CssFunctionNode atFunction() throws ParseException {
        CssPropertyValueNode expr = null;
        StringBuilder functionName = new StringBuilder();
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        Token t = this.jjConsumeToken(74);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[111] = this.jjGen;
        if (this.jj28(1)) {
            expr = this.expr();
        }
        t = this.jjConsumeToken(12);
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[112] = this.jjGen;
        SourceCodeLocation endLocation = this.getLocation();
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        if (expr != null && expr.numChildren() == 1) {
            CssValueNode child = (CssValueNode)expr.getChildAt(0);
            this.addArgumentsWithSeparator(args, (Iterable<CssValueNode>)ImmutableList.of((Object)child), 1, " ");
        } else if (expr != null) {
            this.addArgumentsWithSeparator(args, expr.childIterable(), expr.numChildren(), " ");
        }
        CssFunctionNode functionNode = this.nodeBuilder.buildFunctionNode(functionName.toString(), this.mergeLocations(beginLocation, endLocation), args, tokens);
        return functionNode;
    }

    public final CssPriorityNode important() throws ParseException {
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(60);
        SourceCodeLocation beginLocation = this.getLocation();
        SourceCodeLocation endLocation = this.getLocation();
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[113] = this.jjGen;
        return this.nodeBuilder.buildPriorityNode(this.mergeLocations(beginLocation, endLocation), tokens);
    }

    public final CssAtRuleNode atRule() throws ParseException {
        CssLiteralNode name;
        SourceCodeLocation beginLocation;
        Token t;
        CssBlockNode block = null;
        ArrayList parameters = Lists.newArrayList();
        ArrayList tokens = Lists.newArrayList();
        try {
            t = this.jjConsumeToken(78);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[114] = this.jjGen;
                    break;
                }
                this.jjConsumeToken(45);
            }
            block9: while (this.jj29(1)) {
                CssValueNode v;
                if (this.jj210(1)) {
                    v = this.compositeTerm();
                } else if (this.jj211(1)) {
                    v = this.extendedTerm();
                } else {
                    this.jjConsumeToken(-1);
                    throw new ParseException();
                }
                parameters.add(v);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                        this.jjLa1[115] = this.jjGen;
                        continue block9;
                    }
                    this.jjConsumeToken(45);
                }
            }
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            if (this.skipComponentValuesToAfter(2, 13) == 13) {
                this.skipComponentValuesToAfter(14);
            }
            throw e;
        }
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 13: {
                t = this.jjConsumeToken(13);
                tokens.add(t);
                try {
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[116] = this.jjGen;
                    block = this.block(true);
                    t = this.jjConsumeToken(14);
                    tokens.add(t);
                    break;
                }
                catch (ParseException e) {
                    if (!this.enableErrorRecovery || e.currentToken == null) {
                        throw e;
                    }
                    this.skipComponentValuesToAfter(14);
                    throw e;
                }
            }
            case 2: {
                t = this.jjConsumeToken(2);
                tokens.add(t);
                break;
            }
            default: {
                this.jjLa1[117] = this.jjGen;
                e = this.generateParseException();
                if (this.enableErrorRecovery && e.currentToken != null && this.skipComponentValuesToAfter(2, 13) == 13) {
                    this.skipComponentValuesToAfter(14);
                }
                throw e;
            }
        }
        SourceCodeLocation endLocation = this.getLocation(t);
        CssUnknownAtRuleNode at = this.nodeBuilder.buildUnknownAtRuleNode(name, block, this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        return at;
    }

    public final CssAtRuleNode atRuleWithDeclBlock() throws ParseException {
        CssLiteralNode name;
        SourceCodeLocation beginLocation;
        Token t;
        ArrayList tokens;
        ArrayList parameters;
        CssDeclarationBlockNode block;
        block28: {
            block = null;
            parameters = Lists.newArrayList();
            tokens = Lists.newArrayList();
            ArrayList pseudoPageTokens = Lists.newArrayList();
            try {
                CssValueNode v;
                t = this.jjConsumeToken(77);
                beginLocation = this.getLocation(t);
                name = new CssLiteralNode(t.image.substring(1), beginLocation);
                tokens.add(t);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[118] = this.jjGen;
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 74) {
                    v = this.atFunction();
                    parameters.add(v);
                    break block28;
                }
                this.jjLa1[122] = this.jjGen;
                if (this.jj215(1)) {
                    if (this.getToken((int)1).kind != 3 && this.getToken((int)2).kind != 3) {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 66) {
                        t = this.jjConsumeToken(66);
                        pseudoPageTokens.add(t);
                        v = this.nodeBuilder.buildLiteralNode(t.image, this.getLocation(t), pseudoPageTokens);
                        parameters.add(v);
                        pseudoPageTokens.clear();
                    } else {
                        this.jjLa1[119] = this.jjGen;
                    }
                    t = this.jjConsumeToken(3);
                    pseudoPageTokens.add(t);
                    t = this.jjConsumeToken(66);
                    pseudoPageTokens.add(t);
                    v = this.nodeBuilder.buildLiteralNode(":" + t.image, this.getLocation(t), pseudoPageTokens);
                    parameters.add(v);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                            this.jjLa1[120] = this.jjGen;
                            break block28;
                        }
                        this.jjConsumeToken(45);
                    }
                }
                block10: while (this.jj212(1)) {
                    if (this.jj213(1)) {
                        v = this.compositeTerm();
                    } else if (this.jj214(1)) {
                        v = this.extendedTerm();
                    } else {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    parameters.add(v);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                            this.jjLa1[121] = this.jjGen;
                            continue block10;
                        }
                        this.jjConsumeToken(45);
                    }
                }
            }
            catch (ParseException e) {
                if (!this.enableErrorRecovery || e.currentToken == null) {
                    throw e;
                }
                if (this.skipComponentValuesToAfter(2, 13) == 13) {
                    this.skipComponentValuesToAfter(14);
                }
                throw e;
            }
        }
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 13: {
                t = this.jjConsumeToken(13);
                tokens.add(t);
                try {
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[123] = this.jjGen;
                    block = this.styleDeclaration();
                    t = this.jjConsumeToken(14);
                    tokens.add(t);
                    break;
                }
                catch (ParseException e) {
                    if (!this.enableErrorRecovery || e.currentToken == null) {
                        throw e;
                    }
                    this.skipComponentValuesToAfter(14);
                    throw e;
                }
            }
            case 2: {
                t = this.jjConsumeToken(2);
                tokens.add(t);
                break;
            }
            default: {
                this.jjLa1[124] = this.jjGen;
                ParseException e = this.generateParseException();
                if (this.enableErrorRecovery && e.currentToken != null && this.skipComponentValuesToAfter(2, 13) == 13) {
                    this.skipComponentValuesToAfter(14);
                }
                throw e;
            }
        }
        SourceCodeLocation endLocation = this.getLocation(t);
        CssUnknownAtRuleNode at = this.nodeBuilder.buildUnknownAtRuleNode(name, block, this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        return at;
    }

    public final CssAtRuleNode innerAtRule() throws ParseException {
        CssLiteralNode name;
        SourceCodeLocation beginLocation;
        Token t;
        ArrayList tokens;
        ArrayList parameters;
        CssDeclarationBlockNode block;
        block28: {
            block = null;
            parameters = Lists.newArrayList();
            tokens = Lists.newArrayList();
            ArrayList pseudoPageTokens = Lists.newArrayList();
            try {
                CssValueNode v;
                t = this.jjConsumeToken(78);
                beginLocation = this.getLocation(t);
                name = new CssLiteralNode(t.image.substring(1), beginLocation);
                tokens.add(t);
                while (true) {
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                    this.jjConsumeToken(45);
                }
                this.jjLa1[125] = this.jjGen;
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 74) {
                    v = this.atFunction();
                    parameters.add(v);
                    break block28;
                }
                this.jjLa1[129] = this.jjGen;
                if (this.jj219(1)) {
                    if (this.getToken((int)1).kind != 3 && this.getToken((int)2).kind != 3) {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 66) {
                        t = this.jjConsumeToken(66);
                        pseudoPageTokens.add(t);
                        v = this.nodeBuilder.buildLiteralNode(t.image, this.getLocation(t), pseudoPageTokens);
                        parameters.add(v);
                        pseudoPageTokens.clear();
                    } else {
                        this.jjLa1[126] = this.jjGen;
                    }
                    t = this.jjConsumeToken(3);
                    pseudoPageTokens.add(t);
                    t = this.jjConsumeToken(66);
                    pseudoPageTokens.add(t);
                    v = this.nodeBuilder.buildLiteralNode(":" + t.image, this.getLocation(t), pseudoPageTokens);
                    parameters.add(v);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                            this.jjLa1[127] = this.jjGen;
                            break block28;
                        }
                        this.jjConsumeToken(45);
                    }
                }
                block10: while (this.jj216(1)) {
                    if (this.jj217(1)) {
                        v = this.compositeTerm();
                    } else if (this.jj218(1)) {
                        v = this.extendedTerm();
                    } else {
                        this.jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    parameters.add(v);
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                            this.jjLa1[128] = this.jjGen;
                            continue block10;
                        }
                        this.jjConsumeToken(45);
                    }
                }
            }
            catch (ParseException e) {
                if (!this.enableErrorRecovery || e.currentToken == null) {
                    throw e;
                }
                if (this.skipComponentValuesToAfter(2, 13) == 13) {
                    this.skipComponentValuesToAfter(14);
                }
                throw e;
            }
        }
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 13: {
                t = this.jjConsumeToken(13);
                tokens.add(t);
                try {
                    while (true) {
                        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                        this.jjConsumeToken(45);
                    }
                    this.jjLa1[130] = this.jjGen;
                    block = this.styleDeclaration();
                    t = this.jjConsumeToken(14);
                    tokens.add(t);
                    break;
                }
                catch (ParseException e) {
                    if (!this.enableErrorRecovery || e.currentToken == null) {
                        throw e;
                    }
                    this.skipComponentValuesToAfter(14);
                    throw e;
                }
            }
            case 2: {
                t = this.jjConsumeToken(2);
                tokens.add(t);
                break;
            }
            default: {
                this.jjLa1[131] = this.jjGen;
                ParseException e = this.generateParseException();
                if (this.enableErrorRecovery && e.currentToken != null && this.skipComponentValuesToAfter(2, 13) == 13) {
                    this.skipComponentValuesToAfter(14);
                }
                throw e;
            }
        }
        SourceCodeLocation endLocation = this.getLocation(t);
        CssUnknownAtRuleNode at = this.nodeBuilder.buildUnknownAtRuleNode(name, block, this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        return at;
    }

    public final CssAtRuleNode webkitKeyframesRule() throws ParseException {
        CssBlockNode block;
        CssLiteralNode name;
        SourceCodeLocation beginLocation;
        Token t;
        ArrayList parameters = Lists.newArrayList();
        ArrayList tokens = Lists.newArrayList();
        try {
            t = this.jjConsumeToken(76);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[132] = this.jjGen;
            t = this.jjConsumeToken(66);
            ArrayList identifierTokens = Lists.newArrayList();
            identifierTokens.add(t);
            CssLiteralNode l = this.nodeBuilder.buildLiteralNode(t.image, this.getLocation(t), identifierTokens);
            parameters.add(l);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[133] = this.jjGen;
                    break;
                }
                this.jjConsumeToken(45);
            }
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            if (this.skipComponentValuesToAfter(2, 13) == 13) {
                this.skipComponentValuesToAfter(14);
            }
            throw e;
        }
        t = this.jjConsumeToken(13);
        tokens.add(t);
        try {
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[134] = this.jjGen;
            block = this.webkitKeyframesBlock();
            t = this.jjConsumeToken(14);
            tokens.add(t);
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToAfter(14);
            throw e;
        }
        SourceCodeLocation endLocation = this.getLocation(t);
        CssKeyframesNode at = this.nodeBuilder.buildWebkitKeyframesNode(name, block, this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        return at;
    }

    public final CssBlockNode webkitKeyframesBlock() throws ParseException {
        CssBlockNode block = new CssBlockNode(true);
        block0: while (true) {
            int i;
            int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
            if (i != 58 && i != 66) break;
            CssKeyframeRulesetNode n2 = this.webkitKeyframeRuleSet();
            block.addChildToBack(n2);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) {
                    this.jjLa1[136] = this.jjGen;
                    continue block0;
                }
                this.jjConsumeToken(45);
            }
            break;
        }
        this.jjLa1[135] = this.jjGen;
        return block;
    }

    public final CssKeyframeRulesetNode webkitKeyframeRuleSet() throws ParseException {
        CssDeclarationBlockNode declarations;
        Token t;
        CssKeyListNode keys;
        ArrayList tokens = Lists.newArrayList();
        try {
            keys = this.keyList();
            t = this.jjConsumeToken(13);
            tokens.add(t);
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            if (this.skipComponentValuesToAfter(2, 13) == 13) {
                this.skipComponentValuesToAfter(14);
            }
            throw e;
        }
        try {
            declarations = this.styleDeclaration();
            t = this.jjConsumeToken(14);
            tokens.add(t);
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery || e.currentToken == null) {
                throw e;
            }
            this.skipComponentValuesToAfter(14);
            throw e;
        }
        CssKeyframeRulesetNode ruleSet = this.nodeBuilder.buildKeyframeRulesetNode(declarations, keys, tokens);
        return ruleSet;
    }

    public final CssKeyListNode keyList() throws ParseException {
        CssKeyListNode list = new CssKeyListNode();
        CssKeyNode key = this.key();
        list.addChildToBack(key);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 15) break;
            Token t = this.jjConsumeToken(15);
            this.nodeBuilder.attachComment(t, key);
            while (true) {
                if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
                this.jjConsumeToken(45);
            }
            this.jjLa1[138] = this.jjGen;
            key = this.key();
            list.addChildToBack(key);
        }
        this.jjLa1[137] = this.jjGen;
        return list;
    }

    public final CssKeyNode key() throws ParseException {
        String value;
        Token key;
        ArrayList tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation = this.getLocation(this.token.next);
        switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 58: {
                key = this.jjConsumeToken(58);
                tokens.add(key);
                Token dim = this.jjConsumeToken(17);
                tokens.add(dim);
                value = key.image + dim.image;
                break;
            }
            case 66: {
                key = this.jjConsumeToken(66);
                tokens.add(key);
                value = key.image;
                break;
            }
            default: {
                this.jjLa1[139] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            Token t = this.jjConsumeToken(45);
            tokens.add(t);
        }
        this.jjLa1[140] = this.jjGen;
        SourceCodeLocation endLocation = this.getLocation();
        CssKeyNode keyNode = this.nodeBuilder.buildKeyNode(key, value, this.mergeLocations(beginLocation, endLocation));
        this.nodeBuilder.attachComments(tokens, keyNode);
        return keyNode;
    }

    public final CssBlockNode block(boolean isEnclosedWithBraces) throws ParseException {
        CssBlockNode block;
        block20: {
            block = isEnclosedWithBraces ? new CssBlockNode(isEnclosedWithBraces) : this.globalBlock;
            block15: while (true) {
                int i;
                int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
                if (i != 3 && i != 4 && i != 5 && i != 9 && i != 59 && i != 66 && i != 75 && i != 76 && i != 77 && i != 78) break block20;
                try {
                    CssNode n2;
                    block1 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 9: 
                        case 59: 
                        case 66: {
                            n2 = this.ruleSet();
                            break;
                        }
                        default: {
                            this.jjLa1[142] = this.jjGen;
                            if (this.jj220(Integer.MAX_VALUE)) {
                                n2 = this.atRuleWithCrazySyntax();
                                break;
                            }
                            switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                                case 78: {
                                    n2 = this.atRule();
                                    break block1;
                                }
                                case 76: {
                                    n2 = this.webkitKeyframesRule();
                                    break block1;
                                }
                                case 77: {
                                    n2 = this.atRuleWithDeclBlock();
                                    break block1;
                                }
                            }
                            this.jjLa1[143] = this.jjGen;
                            this.jjConsumeToken(-1);
                            throw new ParseException();
                        }
                    }
                    block.addChildToBack(n2);
                }
                catch (ParseException e) {
                    if (!this.enableErrorRecovery || e.currentToken == null) {
                        throw e;
                    }
                    this.handledErrors.add(new GssParserException(this.getLocation(e.currentToken.next), (Throwable)e));
                }
                block16: while (true) {
                    int j;
                    int n3 = j = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
                    if (j != 37 && j != 38 && j != 45) {
                        this.jjLa1[144] = this.jjGen;
                        continue block15;
                    }
                    switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                        case 45: {
                            this.jjConsumeToken(45);
                            continue block16;
                        }
                        case 37: {
                            this.jjConsumeToken(37);
                            continue block16;
                        }
                        case 38: {
                            this.jjConsumeToken(38);
                            continue block16;
                        }
                    }
                    break;
                }
                break;
            }
            this.jjLa1[145] = this.jjGen;
            this.jjConsumeToken(-1);
            throw new ParseException();
        }
        this.jjLa1[141] = this.jjGen;
        return block;
    }

    public final void start() throws ParseException {
        block9: {
            block7: while (true) {
                int i;
                int n = i = this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk;
                if (i != 37 && i != 38 && i != 45) break block9;
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 45: {
                        this.jjConsumeToken(45);
                        continue block7;
                    }
                    case 37: {
                        this.jjConsumeToken(37);
                        continue block7;
                    }
                    case 38: {
                        this.jjConsumeToken(38);
                        continue block7;
                    }
                }
                break;
            }
            this.jjLa1[147] = this.jjGen;
            this.jjConsumeToken(-1);
            throw new ParseException();
        }
        this.jjLa1[146] = this.jjGen;
        this.block(false);
        this.jjConsumeToken(0);
        try {
            this.validateFinalBlockCommentIfPresent();
        }
        catch (ParseException e) {
            if (!this.enableErrorRecovery) {
                throw e;
            }
            this.handledErrors.add(new GssParserException(this.getLocation(), (Throwable)e));
        }
    }

    public final CssAtRuleNode atRuleWithCrazySyntax() throws ParseException {
        CssLiteralNode blockishContent = null;
        ArrayList tokens = Lists.newArrayList();
        Token t = this.jjConsumeToken(75);
        SourceCodeLocation beginLocation = this.getLocation(t);
        CssLiteralNode name = new CssLiteralNode(t.image.substring(1), beginLocation);
        tokens.add(t);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[148] = this.jjGen;
        String s = this.scanCrazyContent(";{");
        CssLiteralNode nonBlockContent = new CssLiteralNode(s);
        tokens.add(t);
        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 13) {
            blockishContent = this.crazyBlockBrace();
        } else {
            this.jjLa1[149] = this.jjGen;
        }
        if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) == 2) {
            t = this.jjConsumeToken(2);
            tokens.add(t);
        } else {
            this.jjLa1[150] = this.jjGen;
        }
        SourceCodeLocation endLocation = this.getLocation((Token)tokens.get(tokens.size() - 1));
        ArrayList parameters = Lists.newArrayList();
        parameters.add(nonBlockContent);
        if (blockishContent != null) {
            parameters.add(blockishContent);
        }
        return this.nodeBuilder.buildUnknownAtRuleNode(name, null, this.mergeLocations(beginLocation, endLocation), parameters, tokens);
    }

    public final CssLiteralNode crazyBlockBrace() throws ParseException {
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        this.jjConsumeToken(13);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[151] = this.jjGen;
        String s = this.scanCrazyContent(CRAZY_CONTENT);
        CssLiteralNode childContent = new CssLiteralNode(s);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 9: 
            case 11: 
            case 13: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 13: {
                        childCrazy = this.crazyBlockBrace();
                        break block0;
                    }
                    case 9: {
                        childCrazy = this.crazyBlockBracket();
                        break block0;
                    }
                    case 11: {
                        childCrazy = this.crazyBlockParen();
                        break block0;
                    }
                }
                this.jjLa1[152] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            default: {
                this.jjLa1[153] = this.jjGen;
            }
        }
        Token t = this.jjConsumeToken(14);
        this.getLocation(t);
        result.append("{");
        result.append(childContent.getValue());
        if (childCrazy != null) {
            result.append(" ");
        }
        if (childCrazy != null) {
            result.append(childCrazy.getValue());
        }
        result.append("}");
        return new CssLiteralNode(result.toString());
    }

    public final CssLiteralNode crazyBlockBracket() throws ParseException {
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        this.jjConsumeToken(9);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[154] = this.jjGen;
        String s = this.scanCrazyContent(CRAZY_CONTENT);
        CssLiteralNode childContent = new CssLiteralNode(s);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 9: 
            case 11: 
            case 13: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 13: {
                        childCrazy = this.crazyBlockBrace();
                        break block0;
                    }
                    case 9: {
                        childCrazy = this.crazyBlockBracket();
                        break block0;
                    }
                    case 11: {
                        childCrazy = this.crazyBlockParen();
                        break block0;
                    }
                }
                this.jjLa1[155] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            default: {
                this.jjLa1[156] = this.jjGen;
            }
        }
        Token t = this.jjConsumeToken(10);
        this.getLocation(t);
        result.append("[");
        result.append(childContent.getValue());
        if (childCrazy != null) {
            result.append(" ");
        }
        if (childCrazy != null) {
            result.append(childCrazy.getValue());
        }
        result.append("]");
        return new CssLiteralNode(result.toString());
    }

    public final CssLiteralNode crazyBlockParen() throws ParseException {
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        this.jjConsumeToken(11);
        while (true) {
            if ((this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) != 45) break;
            this.jjConsumeToken(45);
        }
        this.jjLa1[157] = this.jjGen;
        String s = this.scanCrazyContent(CRAZY_CONTENT);
        CssLiteralNode childContent = new CssLiteralNode(s);
        block0 : switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
            case 9: 
            case 11: 
            case 13: {
                switch (this.jjNtk == -1 ? this.jjNtkF() : this.jjNtk) {
                    case 13: {
                        childCrazy = this.crazyBlockBrace();
                        break block0;
                    }
                    case 9: {
                        childCrazy = this.crazyBlockBracket();
                        break block0;
                    }
                    case 11: {
                        childCrazy = this.crazyBlockParen();
                        break block0;
                    }
                }
                this.jjLa1[158] = this.jjGen;
                this.jjConsumeToken(-1);
                throw new ParseException();
            }
            default: {
                this.jjLa1[159] = this.jjGen;
            }
        }
        Token t = this.jjConsumeToken(12);
        this.getLocation(t);
        result.append("(");
        result.append(childContent.getValue());
        if (childCrazy != null) {
            result.append(" ");
        }
        if (childCrazy != null) {
            result.append(childCrazy.getValue());
        }
        result.append(")");
        return new CssLiteralNode(result.toString());
    }

    String scanCrazyContent(String endChars) throws ParseException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            Token t = this.getToken(1);
            if (t.kind == 0 || t.image.length() == 1 && endChars.contains(t.image)) break;
            sb.append(t.image);
            this.getNextToken();
        }
        if (sb.length() < 1) {
            throw this.generateParseException();
        }
        return sb.toString();
    }

    int skipComponentValuesToBefore(Integer ... kinds) throws ParseException {
        Token t;
        ImmutableSet kindset = ImmutableSet.builder().add((Object)0).add((Object[])kinds).build();
        do {
            t = this.getToken(1);
            if (kindset.contains(t.kind)) {
                return t.kind;
            }
            this.getNextToken();
        } while (!(t.kind == 13 && this.skipComponentValuesToAfter(14) == 0 || t.kind == 11 && this.skipComponentValuesToAfter(12) == 0) && (t.kind != 9 || this.skipComponentValuesToAfter(10) != 0));
        return 0;
    }

    int skipComponentValuesToAfter(Integer ... kinds) throws ParseException {
        int kind = this.skipComponentValuesToBefore(kinds);
        if (kind != 0) {
            this.getNextToken();
        }
        return kind;
    }

    void validateFinalBlockCommentIfPresent() throws ParseException {
        if (this.token.specialToken != null && !VALIDBLOCKCOMMENTPATTERN.matcher(this.token.specialToken.image).matches()) {
            throw new ParseException("unterminated block comment at EOF");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj21(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj22(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj23(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj24(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj25(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj26(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj27(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj28(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj29(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj210(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj310();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj211(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj311();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj212(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj312();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj213(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj313();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj214(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj314();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj215(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj315();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj216(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj316();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj217(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj317();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj218(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj318();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj219(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj319();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj220(int xla) {
        this.jjLa = xla;
        this.jjLastpos = this.jjScanpos = this.token;
        try {
            boolean bl = !this.jj320();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jjSave(19, xla);
        }
    }

    private boolean jj3R130() {
        return this.jj3R143();
    }

    private boolean jj3R129() {
        return this.jj3R142();
    }

    private boolean jj3R128() {
        return this.jj3R141();
    }

    private boolean jj3R127() {
        return this.jj3R140();
    }

    private boolean jj311() {
        return this.jj3R108();
    }

    private boolean jj3R126() {
        return this.jj3R139();
    }

    private boolean jj318() {
        return this.jj3R108();
    }

    private boolean jj3R113() {
        Token xsp;
        if (this.jjScanToken(49)) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jjScanToken(45));
        this.jjScanpos = xsp;
        return false;
    }

    private boolean jj3R100() {
        Token xsp = this.jjScanpos;
        if (this.jj3R113()) {
            this.jjScanpos = xsp;
            if (this.jj3R114()) {
                this.jjScanpos = xsp;
                if (this.jj3R115()) {
                    this.jjScanpos = xsp;
                    if (this.jj3R116()) {
                        this.jjScanpos = xsp;
                        return this.jj3R117();
                    }
                }
            }
        }
        return false;
    }

    private boolean jj3R136() {
        return this.jjScanToken(11);
    }

    private boolean jj3R133() {
        Token xsp = this.jjScanpos;
        if (this.jjScanToken(66)) {
            this.jjScanpos = xsp;
            return this.jjScanToken(5);
        }
        return false;
    }

    private boolean jj310() {
        return this.jj3R102();
    }

    private boolean jj39() {
        Token xsp = this.jjScanpos;
        if (this.jj310()) {
            this.jjScanpos = xsp;
            return this.jj311();
        }
        return false;
    }

    private boolean jj317() {
        return this.jj3R102();
    }

    private boolean jj3R158() {
        return this.jjScanToken(3);
    }

    private boolean jj316() {
        Token xsp = this.jjScanpos;
        if (this.jj317()) {
            this.jjScanpos = xsp;
            return this.jj318();
        }
        return false;
    }

    private boolean jj34() {
        this.jjLookingAhead = true;
        this.jjSemLA = this.getToken((int)1).kind == 11 && (this.getToken((int)3).kind == 3 || this.getToken((int)4).kind == 3);
        this.jjLookingAhead = false;
        if (!this.jjSemLA) {
            return true;
        }
        return this.jjScanToken(11);
    }

    private boolean jj3R148() {
        return this.jj3R158();
    }

    private boolean jj3R147() {
        return this.jj3R157();
    }

    private boolean jj3R121() {
        return this.jj3R136();
    }

    private boolean jj3R146() {
        return this.jj3R156();
    }

    private boolean jj37() {
        return this.jj3R106();
    }

    private boolean jj3R145() {
        return this.jj3R155();
    }

    private boolean jj3R125() {
        return this.jjScanToken(65);
    }

    private boolean jj3R134() {
        Token xsp = this.jjScanpos;
        if (this.jj3R145()) {
            this.jjScanpos = xsp;
            if (this.jj3R146()) {
                this.jjScanpos = xsp;
                if (this.jj3R147()) {
                    this.jjScanpos = xsp;
                    return this.jj3R148();
                }
            }
        }
        return false;
    }

    private boolean jj3R141() {
        return this.jjScanToken(70);
    }

    private boolean jj3R119() {
        Token xsp;
        if (this.jj3R134()) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jj3R134());
        this.jjScanpos = xsp;
        return false;
    }

    private boolean jj33() {
        this.jjLookingAhead = true;
        this.jjSemLA = this.getToken((int)2).kind != 4 && this.getToken((int)2).kind != 3;
        this.jjLookingAhead = false;
        if (!this.jjSemLA) {
            return true;
        }
        return this.jjScanToken(66);
    }

    private boolean jj3R105() {
        Token xsp = this.jjScanpos;
        if (this.jj37()) {
            this.jjScanpos = xsp;
            return this.jj3R121();
        }
        return false;
    }

    private boolean jj3R124() {
        return this.jj3R138();
    }

    private boolean jj3R112() {
        return this.jjScanToken(66);
    }

    private boolean jj3R123() {
        return this.jjScanToken(73);
    }

    private boolean jj3R118() {
        return this.jj3R133();
    }

    private boolean jj3R137() {
        return this.jj3R149();
    }

    private boolean jj319() {
        this.jjLookingAhead = true;
        this.jjSemLA = this.getToken((int)1).kind == 3 || this.getToken((int)2).kind == 3;
        this.jjLookingAhead = false;
        if (!this.jjSemLA) {
            return true;
        }
        Token xsp = this.jjScanpos;
        if (this.jj3R112()) {
            this.jjScanpos = xsp;
        }
        return this.jjScanToken(3);
    }

    private boolean jj3R155() {
        return this.jjScanToken(59);
    }

    private boolean jj3R122() {
        Token xsp = this.jjScanpos;
        if (this.jj3R137()) {
            this.jjScanpos = xsp;
        }
        return this.jjScanToken(58);
    }

    private boolean jj3R101() {
        Token xsp = this.jjScanpos;
        if (this.jj3R118()) {
            this.jjScanpos = xsp;
            return this.jj3R119();
        }
        return false;
    }

    private boolean jj3R106() {
        Token xsp = this.jjScanpos;
        if (this.jj3R122()) {
            this.jjScanpos = xsp;
            if (this.jj3R123()) {
                this.jjScanpos = xsp;
                if (this.jj3R124()) {
                    this.jjScanpos = xsp;
                    if (this.jj33()) {
                        this.jjScanpos = xsp;
                        if (this.jj3R125()) {
                            this.jjScanpos = xsp;
                            if (this.jj34()) {
                                this.jjScanpos = xsp;
                                this.jjLookingAhead = true;
                                this.jjSemLA = this.getToken((int)1).kind == 63;
                                this.jjLookingAhead = false;
                                if (!this.jjSemLA || this.jj3R126()) {
                                    this.jjScanpos = xsp;
                                    if (this.jj3R127()) {
                                        this.jjScanpos = xsp;
                                        if (this.jj3R128()) {
                                            this.jjScanpos = xsp;
                                            if (this.jj3R129()) {
                                                this.jjScanpos = xsp;
                                                return this.jj3R130();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj3R154() {
        return this.jjScanToken(16);
    }

    private boolean jj3R156() {
        return this.jjScanToken(4);
    }

    private boolean jj3R153() {
        return this.jjScanToken(66);
    }

    private boolean jj3R152() {
        return this.jjScanToken(74);
    }

    private boolean jj3R143() {
        Token xsp = this.jjScanpos;
        if (this.jj3R152()) {
            this.jjScanpos = xsp;
            return this.jj3R153();
        }
        return false;
    }

    private boolean jj3R135() {
        return this.jj3R106();
    }

    private boolean jj36() {
        return this.jj3R105();
    }

    private boolean jj38() {
        return this.jj3R107();
    }

    private boolean jj314() {
        return this.jj3R108();
    }

    private boolean jj31() {
        if (this.jj3R100()) {
            return true;
        }
        return this.jj3R101();
    }

    private boolean jj35() {
        return this.jj3R105();
    }

    private boolean jj3R144() {
        return this.jj3R154();
    }

    private boolean jj3R139() {
        return this.jjScanToken(63);
    }

    private boolean jj3R131() {
        Token xsp = this.jjScanpos;
        if (this.jj3R144()) {
            this.jjScanpos = xsp;
            return this.jj35();
        }
        return false;
    }

    private boolean jj3R120() {
        return this.jj3R135();
    }

    private boolean jj3R157() {
        return this.jjScanToken(9);
    }

    private boolean jj313() {
        return this.jj3R102();
    }

    private boolean jj312() {
        Token xsp = this.jjScanpos;
        if (this.jj313()) {
            this.jjScanpos = xsp;
            return this.jj314();
        }
        return false;
    }

    private boolean jj3R110() {
        return this.jjScanToken(66);
    }

    private boolean jj3R102() {
        return this.jj3R120();
    }

    private boolean jj315() {
        this.jjLookingAhead = true;
        this.jjSemLA = this.getToken((int)1).kind == 3 || this.getToken((int)2).kind == 3;
        this.jjLookingAhead = false;
        if (!this.jjSemLA) {
            return true;
        }
        Token xsp = this.jjScanpos;
        if (this.jj3R110()) {
            this.jjScanpos = xsp;
        }
        return this.jjScanToken(3);
    }

    private boolean jj3R108() {
        return this.jj3R131();
    }

    private boolean jj3R142() {
        return this.jjScanToken(71);
    }

    private boolean jj3R132() {
        return this.jjScanToken(45);
    }

    private boolean jj32() {
        return this.jj3R102();
    }

    private boolean jj3R107() {
        return this.jj3R102();
    }

    private boolean jj3R117() {
        Token xsp;
        if (this.jj3R132()) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jj3R132());
        this.jjScanpos = xsp;
        return false;
    }

    private boolean jj3R140() {
        return this.jjScanToken(59);
    }

    private boolean jj3R116() {
        Token xsp;
        if (this.jjScanToken(52)) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jjScanToken(45));
        this.jjScanpos = xsp;
        return false;
    }

    private boolean jj3R151() {
        return this.jjScanToken(62);
    }

    private boolean jj3R150() {
        return this.jjScanToken(61);
    }

    private boolean jj320() {
        return this.jjScanToken(75);
    }

    private boolean jj3R138() {
        Token xsp = this.jjScanpos;
        if (this.jj3R150()) {
            this.jjScanpos = xsp;
            return this.jj3R151();
        }
        return false;
    }

    private boolean jj3R115() {
        Token xsp;
        if (this.jjScanToken(51)) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jjScanToken(45));
        this.jjScanpos = xsp;
        return false;
    }

    private boolean jj3R149() {
        Token xsp = this.jjScanpos;
        if (this.jjScanToken(7)) {
            this.jjScanpos = xsp;
            return this.jjScanToken(49);
        }
        return false;
    }

    private boolean jj3R114() {
        Token xsp;
        if (this.jjScanToken(50)) {
            return true;
        }
        do {
            xsp = this.jjScanpos;
        } while (!this.jjScanToken(45));
        this.jjScanpos = xsp;
        return false;
    }

    private static void jjLa1Init0() {
        jjLa10 = new int[]{0, 32768, 0, 0, 0x8020000, 0x8020000, 0, 0, 0, 0, 0, 0, 8, 8, 128, 0, 128, 0, 0, 256, 0, 0, 0, 256, 536, 536, 536, 536, 568, 32, 0, 0, 0, 0, 0, 0, 0, 32, 0, 4, 0, 32, 0, 32, 4, 32, 0, 0, 32, 0, 0, 0, 0, 32768, 0, 256, 0, 64, 0, 128, 131072, 131072, 0, 0, 0, 0, 64, 0, 0, 0, 128, 0, 0, 0, Integer.MIN_VALUE, 0, 65536, 0x40000000, 0, 65536, 0, 2048, 0, 0, 128, 0, 0, 0, 32768, 24, 0, 24, 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 0, 96, 128, 131072, 131072, 128, 0, 0, 2176, 0, 0, 0, 0, 0, 0, 8196, 0, 0, 0, 0, 0, 0, 8196, 0, 0, 0, 0, 0, 0, 8196, 0, 0, 0, 0, 0, 32768, 0, 0, 0, 568, 568, 0, 0, 0, 0, 0, 0, 8192, 4, 0, 10752, 10752, 0, 10752, 10752, 0, 10752, 10752};
    }

    private static void jjLa1Init1() {
        jjLa11 = new int[]{0x60000000, 0, 8192, 8192, 0, 0, 8192, 8192, 8192, 8192, 8192, 8192, 0, 0, 0x4030000, 8192, 0x4030000, 8192, 8192, 31, 8192, 0x60000000, 8192, 31, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0, 8192, 8192, 8192, 8192, 8192, 1974272, 8192, 0, 8192, 0, 8192, 0, 8192, 0, 0, 0, 8192, 8192, 0, 8192, 8192, 8192, 0x10000000, 0, 8192, 0, 8192, 0, 8192, 131072, 0, 0, 8192, 8192, 8192, 8192, 8192, 0, 0x4000000, 8192, 1677852672, 0, 0x8000000, 8192, 0, 8192, 0, 0, 8192, 0, 8192, 0, 8192, 8192, 131072, 8192, 8192, 8192, 0, 0, 0, 0, 0, 8192, 8192, 8192, 196608, 8192, 196608, 8192, 8192, 8192, 8192, 0, 131072, 0, 0, 0x4020000, 8192, 8192, 0x4020000, 8192, 8192, 8192, 8192, 8192, 8192, 0, 8192, 0, 8192, 8192, 0, 8192, 0, 8192, 0, 8192, 8192, 0, 8192, 0, 8192, 8192, 8192, 0x4000000, 8192, 0, 8192, 0x4000000, 8192, 0x8000000, 0x8000000, 0, 8288, 8288, 8288, 8288, 8192, 0, 0, 8192, 0, 0, 8192, 0, 0, 8192, 0, 0};
    }

    private static void jjLa1Init2() {
        jjLa12 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1076, 1076, 6, 0, 6, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 0, 0, 12, 0, 16384, 0, 12, 0, 12, 16384, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 0, 0, 0, 0, 0, 4, 4, 0, 512, 2, 1220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 1028, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4, 132, 0, 0, 132, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 1024, 0, 0, 0, 4, 0, 0, 1024, 0, 0, 0, 0, 0, 4, 0, 0, 0, 4, 0, 30724, 4, 28672, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public GssParserCC(CharStream stream) {
        int i;
        this.tokenSource = new GssParserCCTokenManager(stream);
        this.token = new Token();
        this.jjNtk = -1;
        this.jjGen = 0;
        for (i = 0; i < 160; ++i) {
            this.jjLa1[i] = -1;
        }
        for (i = 0; i < this.jj2Rtns.length; ++i) {
            this.jj2Rtns[i] = new JJCalls();
        }
    }

    public void reInit(CharStream stream) {
        int i;
        this.tokenSource.reInit(stream);
        this.token = new Token();
        this.jjNtk = -1;
        this.jjLookingAhead = false;
        this.jjGen = 0;
        for (i = 0; i < 160; ++i) {
            this.jjLa1[i] = -1;
        }
        for (i = 0; i < this.jj2Rtns.length; ++i) {
            this.jj2Rtns[i] = new JJCalls();
        }
    }

    private Token jjConsumeToken(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.jjNtk = -1;
        if (this.token.kind == kind) {
            ++this.jjGen;
            if (++this.jjGc > 100) {
                this.jjGc = 0;
                JJCalls[] jJCallsArray = this.jj2Rtns;
                int n = jJCallsArray.length;
                for (int i = 0; i < n; ++i) {
                    JJCalls jj2Rtn;
                    JJCalls c = jj2Rtn = jJCallsArray[i];
                    while (c != null) {
                        if (c.gen < this.jjGen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jjKind = kind;
        throw this.generateParseException();
    }

    private boolean jjScanToken(int kind) {
        if (this.jjScanpos == this.jjLastpos) {
            --this.jjLa;
            if (this.jjScanpos.next == null) {
                this.jjScanpos = this.jjScanpos.next = this.tokenSource.getNextToken();
                this.jjLastpos = this.jjScanpos.next;
            } else {
                this.jjLastpos = this.jjScanpos = this.jjScanpos.next;
            }
        } else {
            this.jjScanpos = this.jjScanpos.next;
        }
        if (this.jjRescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jjScanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jjAddErrorToken(kind, i);
            }
        }
        if (this.jjScanpos.kind != kind) {
            return true;
        }
        if (this.jjLa == 0 && this.jjScanpos == this.jjLastpos) {
            throw this.jjLs;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.jjNtk = -1;
        ++this.jjGen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jjLookingAhead ? this.jjScanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.tokenSource.getNextToken());
        }
        return t;
    }

    private int jjNtkF() {
        Token jjNt = this.token.next;
        if (jjNt == null) {
            this.token.next = this.tokenSource.getNextToken();
            this.jjNtk = this.token.next.kind;
        } else {
            this.jjNtk = jjNt.kind;
        }
        return this.jjNtk;
    }

    private void jjAddErrorToken(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jjEndpos + 1) {
            this.jjLasttokens[this.jjEndpos++] = kind;
        } else if (this.jjEndpos != 0) {
            this.jjExpentry = new int[this.jjEndpos];
            System.arraycopy(this.jjLasttokens, 0, this.jjExpentry, 0, this.jjEndpos);
            for (int[] oldentry : this.jjExpentries) {
                if (oldentry.length != this.jjExpentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jjExpentry.length; ++i) {
                    if (oldentry[i] == this.jjExpentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jjExpentries.add(this.jjExpentry);
                break;
            }
            if (pos != 0) {
                this.jjEndpos = pos;
                this.jjLasttokens[this.jjEndpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jjExpentries.clear();
        boolean[] la1tokens = new boolean[80];
        if (this.jjKind >= 0) {
            la1tokens[this.jjKind] = true;
            this.jjKind = -1;
        }
        for (i = 0; i < 160; ++i) {
            if (this.jjLa1[i] != this.jjGen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jjLa10[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jjLa11[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jjLa12[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 80; ++i) {
            if (!la1tokens[i]) continue;
            this.jjExpentry = new int[1];
            this.jjExpentry[0] = i;
            this.jjExpentries.add(this.jjExpentry);
        }
        this.jjEndpos = 0;
        this.jjRescanToken();
        this.jjAddErrorToken(0, 0);
        int[][] exptokseq = new int[this.jjExpentries.size()][];
        for (int i2 = 0; i2 < this.jjExpentries.size(); ++i2) {
            exptokseq[i2] = this.jjExpentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    private void jjRescanToken() {
        this.jjRescan = true;
        for (int i = 0; i < 20; ++i) {
            try {
                JJCalls p = this.jj2Rtns[i];
                do {
                    if (p.gen <= this.jjGen) continue;
                    this.jjLa = p.arg;
                    this.jjLastpos = this.jjScanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj31();
                            break;
                        }
                        case 1: {
                            this.jj32();
                            break;
                        }
                        case 2: {
                            this.jj33();
                            break;
                        }
                        case 3: {
                            this.jj34();
                            break;
                        }
                        case 4: {
                            this.jj35();
                            break;
                        }
                        case 5: {
                            this.jj36();
                            break;
                        }
                        case 6: {
                            this.jj37();
                            break;
                        }
                        case 7: {
                            this.jj38();
                            break;
                        }
                        case 8: {
                            this.jj39();
                            break;
                        }
                        case 9: {
                            this.jj310();
                            break;
                        }
                        case 10: {
                            this.jj311();
                            break;
                        }
                        case 11: {
                            this.jj312();
                            break;
                        }
                        case 12: {
                            this.jj313();
                            break;
                        }
                        case 13: {
                            this.jj314();
                            break;
                        }
                        case 14: {
                            this.jj315();
                            break;
                        }
                        case 15: {
                            this.jj316();
                            break;
                        }
                        case 16: {
                            this.jj317();
                            break;
                        }
                        case 17: {
                            this.jj318();
                            break;
                        }
                        case 18: {
                            this.jj319();
                            break;
                        }
                        case 19: {
                            this.jj320();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jjRescan = false;
    }

    private void jjSave(int index, int xla) {
        JJCalls p = this.jj2Rtns[index];
        while (p.gen > this.jjGen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jjGen + xla - this.jjLa;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        GssParserCC.jjLa1Init0();
        GssParserCC.jjLa1Init1();
        GssParserCC.jjLa1Init2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class CssNodeBuilder {
        private CssNodeBuilder() {
        }

        protected CssNode attachComments(List<Token> tokens, CssNode node) {
            for (Token t : tokens) {
                node = this.attachComment(t, node);
            }
            return node;
        }

        public CssNode attachComment(Token t, CssNode node) {
            if (t.specialToken == null) {
                return node;
            }
            Token special = t.specialToken;
            while (special.specialToken != null) {
                special = special.specialToken;
            }
            while (special != null) {
                node.appendComment(new CssCommentNode(GssParserCC.trim(special.image), GssParserCC.this.getLocation(special)));
                special = special.next;
            }
            return node;
        }

        public CssStringNode buildStringNode(CssStringNode.Type type, String image, SourceCodeLocation location, Token token) {
            Preconditions.checkNotNull((Object)image, (Object)"image should be non-null");
            Preconditions.checkArgument((image.length() > 1 ? 1 : 0) != 0, (String)"the image argument must be quoted", (Object)image);
            CssStringNode node = new CssStringNode(type, location);
            this.attachComments(Lists.newArrayList((Object[])new Token[]{token}), node);
            return node;
        }

        public CssHexColorNode buildHexColorNode(String image, SourceCodeLocation location, List<Token> tokens) {
            CssHexColorNode node = new CssHexColorNode(image, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssRulesetNode buildRulesetNode(CssDeclarationBlockNode declarations, CssSelectorListNode selectors, SourceCodeLocation location, List<Token> tokens) {
            CssRulesetNode node = new CssRulesetNode(declarations);
            node.setSelectors(selectors);
            node.setSourceCodeLocation(location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssKeyframeRulesetNode buildKeyframeRulesetNode(CssDeclarationBlockNode declarations, CssKeyListNode keys, List<Token> tokens) {
            CssKeyframeRulesetNode node = new CssKeyframeRulesetNode(declarations);
            node.setKeys(keys);
            this.attachComments(tokens, node);
            return node;
        }

        public CssKeyNode buildKeyNode(Token token, String value, SourceCodeLocation location) {
            CssKeyNode node = new CssKeyNode(value, location);
            if (token != null) {
                this.attachComment(token, node);
            }
            return node;
        }

        public CssClassSelectorNode buildClassSelectorNode(String name, SourceCodeLocation location, CssClassSelectorNode.ComponentScoping scoping, List<Token> tokens) {
            CssClassSelectorNode node = new CssClassSelectorNode(name, scoping, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssIdSelectorNode buildIdSelectorNode(String id, SourceCodeLocation location, List<Token> tokens) {
            CssIdSelectorNode node = new CssIdSelectorNode(id, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(String name, SourceCodeLocation location, List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(name, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(CssPseudoClassNode.FunctionType functionType, String name, String argument, SourceCodeLocation location, List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(functionType, name, argument, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(String name, CssSelectorNode notSelector, SourceCodeLocation location, List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(name, notSelector, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssPseudoElementNode buildPseudoElementNode(String name, SourceCodeLocation location, List<Token> tokens) {
            CssPseudoElementNode node = new CssPseudoElementNode(name, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssAttributeSelectorNode buildAttributeSelectorNode(CssAttributeSelectorNode.MatchType matchType, String attribute, CssValueNode value, SourceCodeLocation location, List<Token> tokens) {
            CssAttributeSelectorNode node = new CssAttributeSelectorNode(matchType, attribute, value, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssSelectorNode buildSelectorNode(Token token, SourceCodeLocation location, CssRefinerListNode refiners) {
            String name = "";
            if (token != null) {
                name = token.image;
            }
            CssSelectorNode node = new CssSelectorNode(name, location);
            if (token != null) {
                this.attachComment(token, node);
            }
            node.setRefiners(refiners);
            return node;
        }

        public CssCombinatorNode buildCombinatorNode(CssCombinatorNode.Combinator combinator, SourceCodeLocation location, List<Token> tokens) {
            CssCombinatorNode node = new CssCombinatorNode(combinator, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssDeclarationNode buildDeclarationNode(CssPropertyNode property, CssPropertyValueNode value, List<Token> tokens) {
            try {
                CssDeclarationNode node = new CssDeclarationNode(property, value, GssParserCC.this.mergeLocations(property.getSourceCodeLocation(), value.getSourceCodeLocation()));
                this.attachComments(tokens, node);
                return node;
            }
            catch (NullPointerException e) {
                StringBuilder valueValue = new StringBuilder();
                for (CssValueNode n : value.getChildren()) {
                    valueValue.append(n.getValue());
                    valueValue.append("<");
                    valueValue.append(n.getSourceCodeLocation());
                    valueValue.append("> ");
                }
                throw new RuntimeException("property: " + property.toString() + ", " + valueValue, e);
            }
        }

        public CssCompositeValueNode buildCompositeValueNode(List<CssValueNode> list, CssCompositeValueNode.Operator op, SourceCodeLocation location, List<Token> tokens) {
            CssCompositeValueNode node = new CssCompositeValueNode(list, op, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssBooleanExpressionNode buildBoolExpressionNode(CssBooleanExpressionNode.Type type, String value, CssBooleanExpressionNode left, CssBooleanExpressionNode right, SourceCodeLocation loc, List<Token> tokens) {
            CssBooleanExpressionNode node = new CssBooleanExpressionNode(type, value, left, right, loc);
            this.attachComments(tokens, node);
            return node;
        }

        public CssLiteralNode buildLiteralNode(String value, SourceCodeLocation location, List<Token> tokens) {
            CssLiteralNode node = new CssLiteralNode(value, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssUnicodeRangeNode buildUnicodeRangeNode(String value, SourceCodeLocation location, List<Token> tokens) {
            CssUnicodeRangeNode node = new CssUnicodeRangeNode(value, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssNumericNode buildNumericNode(String num, String unit, SourceCodeLocation location, List<Token> tokens) {
            CssNumericNode node = new CssNumericNode(num, unit, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssLiteralNode buildLoopVariableNode(String value, SourceCodeLocation location, List<Token> tokens) {
            CssLoopVariableNode node = new CssLoopVariableNode(value, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssFunctionNode buildFunctionNode(String name, SourceCodeLocation location, CssFunctionArgumentsNode args, List<Token> tokens) {
            CssFunctionNode.Function functionType = CssFunctionNode.Function.byName(name);
            if (functionType == null) {
                functionType = CssFunctionNode.Function.CUSTOM;
            }
            CssFunctionNode functionNode = functionType != CssFunctionNode.Function.CUSTOM ? new CssFunctionNode(functionType, location) : new CssCustomFunctionNode(name, location);
            functionNode.setArguments(args);
            this.attachComments(tokens, functionNode);
            return functionNode;
        }

        public CssPriorityNode buildPriorityNode(SourceCodeLocation location, List<Token> tokens) {
            CssPriorityNode node = new CssPriorityNode(CssPriorityNode.PriorityType.IMPORTANT, location);
            this.attachComments(tokens, node);
            return node;
        }

        public CssUnknownAtRuleNode buildUnknownAtRuleNode(CssLiteralNode name, CssAbstractBlockNode block, SourceCodeLocation location, List<CssValueNode> parameters, List<Token> tokens) {
            boolean hasBlock = block != null;
            CssUnknownAtRuleNode at = new CssUnknownAtRuleNode(name, hasBlock);
            at.setSourceCodeLocation(location);
            if (hasBlock) {
                at.setBlock(block);
            }
            at.setParameters(parameters);
            this.attachComments(tokens, at);
            return at;
        }

        public CssKeyframesNode buildWebkitKeyframesNode(CssLiteralNode name, CssBlockNode block, SourceCodeLocation location, List<CssValueNode> parameters, List<Token> tokens) {
            CssKeyframesNode at = new CssKeyframesNode(name);
            at.setSourceCodeLocation(location);
            at.setBlock(block);
            at.setParameters(parameters);
            this.attachComments(tokens, at);
            return at;
        }
    }
}

