/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.collect.ImmutableSet;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import java.util.Set;

public class SkippingTreeVisitor
extends DefaultTreeVisitor {
    private boolean skipping = false;
    final Set<String> propertyNamesToSkip = ImmutableSet.of((Object)"display");

    public SkippingTreeVisitor(boolean skip) {
        this.skipping = skip;
    }

    public boolean canModifyRuleset(CssRulesetNode ruleset) {
        if (this.skipping) {
            for (String propNameToSkip : this.propertyNamesToSkip) {
                for (CssNode child : ruleset.getDeclarations().childIterable()) {
                    CssDeclarationNode decl;
                    if (!(child instanceof CssDeclarationNode) || !(decl = (CssDeclarationNode)child).getPropertyName().getPropertyName().equals(propNameToSkip)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isSkipping() {
        return this.skipping;
    }
}

