/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CharStream;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class StringCharStream
implements CharStream {
    private static final IOException END_OF_STREAM = new IOException();
    private final String input;
    private final int length;
    private int charPos;
    private int line;
    private int column;
    private char lastChar;
    private int tokenStart;
    private int beginLine;
    private int beginColumn;
    private final int tabSize = 1;
    private boolean trackLineColumn;
    private int[] lineToCharIndex;

    public StringCharStream(String inputString) {
        this.input = inputString;
        this.length = this.input.length();
        this.lastChar = '\u0000';
        this.charPos = -1;
        this.column = 0;
        this.line = 1;
        this.tokenStart = this.charPos;
        this.beginLine = this.line;
        this.beginColumn = this.column;
        this.initCharIndex(this.input);
    }

    private void initCharIndex(String source) {
        ArrayList lineToCharIndexList = Lists.newArrayList();
        int charIndex = -1;
        lineToCharIndexList.add(charIndex);
        do {
            lineToCharIndexList.add(++charIndex);
        } while ((charIndex = source.indexOf(10, charIndex)) >= 0);
        this.lineToCharIndex = Ints.toArray((Collection)lineToCharIndexList);
    }

    public int convertToCharacterIndex(int lineNumber, int indexInLine) {
        return this.lineToCharIndex[lineNumber] + indexInLine - 1;
    }

    public int getCharIndex() {
        return this.charPos;
    }

    @VisibleForTesting
    int getTokenStart() {
        return this.tokenStart;
    }

    @Override
    public char readChar() throws IOException {
        if (this.charPos + 1 == this.length) {
            throw END_OF_STREAM;
        }
        if (this.lastChar == '\n') {
            ++this.line;
            this.column = 0;
        }
        this.column = this.lastChar == '\t' ? (this.column += 1 - this.column % 1) : ++this.column;
        this.lastChar = this.input.charAt(++this.charPos);
        return this.lastChar;
    }

    @Override
    public int getEndColumn() {
        return this.column;
    }

    @Override
    public int getEndLine() {
        return this.line;
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getBeginLine() {
        return this.beginLine;
    }

    @Override
    public void backup(int amount) {
        this.charPos -= amount;
        while (this.line > 1 && this.lineToCharIndex[this.line] > this.charPos) {
            --this.line;
        }
        this.column = this.charPos - this.lineToCharIndex[this.line] + 1;
        this.lastChar = this.charPos < 0 ? (char)'\u0000' : this.input.charAt(this.charPos);
    }

    @Override
    public char beginToken() throws IOException {
        this.readChar();
        this.tokenStart = this.charPos;
        this.beginLine = this.line;
        this.beginColumn = this.column;
        return this.lastChar;
    }

    @Override
    public String getImage() {
        return this.input.substring(this.tokenStart, this.charPos + 1);
    }

    @Override
    public char[] getSuffix(int len) {
        int end = this.charPos + 1;
        int start = end - len;
        char[] chars = new char[end - start];
        this.input.getChars(start, end, chars, 0);
        return chars;
    }

    @Override
    public void done() {
    }

    @Override
    public void setTabSize(int tabSize) {
        throw new UnsupportedOperationException("setTabSize() is not supported.");
    }

    @Override
    public int getTabSize() {
        return 1;
    }

    @Override
    public boolean getTrackLineColumn() {
        return this.trackLineColumn;
    }

    @Override
    public void setTrackLineColumn(boolean trackLineColumn) {
        this.trackLineColumn = trackLineColumn;
    }
}

