/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.ast;

import com.google.common.css.compiler.ast.EscapeUtil;

public class TokenMgrError
extends Error {
    private static final long serialVersionUID = 1L;
    public static final int LEXICAL_ERROR = 0;
    public static final int STATIC_LEXER_ERROR = 1;
    public static final int INVALID_LEXICAL_STATE = 2;
    public static final int LOOP_DETECTED = 3;
    private int errorCode;

    protected static String lexicalErr(boolean eofseen, int lexState, int errorLine, int errorColumn, String errorAfter, int curChar) {
        char curChar1 = (char)curChar;
        return "Lexical error at line " + errorLine + ", column " + errorColumn + ".  Encountered: " + (eofseen ? "<EOF> " : "\"" + EscapeUtil.addEscapes(String.valueOf(curChar1)) + "\"" + " (" + curChar + "), ") + "after : \"" + EscapeUtil.addEscapes(errorAfter) + "\"";
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public TokenMgrError() {
    }

    public TokenMgrError(String message, int reason) {
        super(message);
        this.errorCode = reason;
    }

    public TokenMgrError(boolean eofseen, int lexState, int errorLine, int errorColumn, String errorAfter, int curChar, int reason) {
        this(TokenMgrError.lexicalErr(eofseen, lexState, errorLine, errorColumn, errorAfter, curChar), reason);
    }
}

