/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.commandline;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.css.AbstractCommandLineCompiler;
import com.google.common.css.ExitCodeHandler;
import com.google.common.css.JobDescription;
import com.google.common.css.RecordingSubstitutionMap;
import com.google.common.css.SourceCode;
import com.google.common.css.compiler.ast.BasicErrorManager;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.GssParser;
import com.google.common.css.compiler.ast.GssParserException;
import com.google.common.css.compiler.passes.CompactPrinter;
import com.google.common.css.compiler.passes.DefaultGssSourceMapGenerator;
import com.google.common.css.compiler.passes.GssSourceMapGenerator;
import com.google.common.css.compiler.passes.NullGssSourceMapGenerator;
import com.google.common.css.compiler.passes.PassRunner;
import com.google.common.css.compiler.passes.PrettyPrinter;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nullable;

public class DefaultCommandLineCompiler
extends AbstractCommandLineCompiler<JobDescription> {
    protected static final int MAXIMUM_ERRORS_TO_OUTPUT = 100;
    private final ErrorManager errorManager;
    private final PassRunner passRunner;
    private final GssSourceMapGenerator gssSourceMapGenerator;

    protected DefaultCommandLineCompiler(JobDescription job, ExitCodeHandler exitCodeHandler, ErrorManager errorManager) {
        super(job, exitCodeHandler);
        this.errorManager = errorManager;
        this.passRunner = new PassRunner(job, errorManager);
        this.gssSourceMapGenerator = this.createSourceMapGenerator(job);
    }

    private GssSourceMapGenerator createSourceMapGenerator(JobDescription job) {
        if (!job.createSourceMap) {
            return new NullGssSourceMapGenerator();
        }
        return new DefaultGssSourceMapGenerator(job.sourceMapLevel);
    }

    public String compile() throws GssParserException {
        Preconditions.checkState((!this.compilerWasUsed ? 1 : 0) != 0);
        this.compilerWasUsed = true;
        int copyrightNoticeSize = this.job.copyrightNotice != null ? this.job.copyrightNotice.length() : 0;
        StringBuilder result = new StringBuilder(this.job.getAllInputsLength() + copyrightNoticeSize);
        if (this.job.copyrightNotice != null) {
            result.append(this.job.copyrightNotice);
        }
        if (this.job.allowDefPropagation) {
            GssParser parser = new GssParser(this.job.inputs);
            this.parseAndPrint(result, parser);
        } else {
            for (SourceCode source : this.job.inputs) {
                GssParser parser = new GssParser(source);
                this.parseAndPrint(result, parser);
            }
        }
        return result.toString();
    }

    private void parseAndPrint(StringBuilder result, GssParser parser) throws GssParserException {
        CssTree cssTree = parser.parse();
        if (this.job.outputFormat != JobDescription.OutputFormat.DEBUG) {
            this.passRunner.runPasses(cssTree);
        }
        if (this.job.outputFormat == JobDescription.OutputFormat.COMPRESSED) {
            CompactPrinter compactPrinterPass = new CompactPrinter(cssTree, this.gssSourceMapGenerator);
            compactPrinterPass.setPreserveMarkedComments(this.job.preserveImportantComments);
            compactPrinterPass.runPass();
            result.append(compactPrinterPass.getCompactPrintedString());
        } else {
            PrettyPrinter prettyPrinterPass = new PrettyPrinter(cssTree.getVisitController(), null, this.gssSourceMapGenerator);
            prettyPrinterPass.setPreserveComments(this.job.preserveComments).runPass();
            result.append(prettyPrinterPass.getPrettyPrintedString());
        }
    }

    protected String execute(@Nullable File renameFile, @Nullable File sourcemapFile) {
        try {
            RecordingSubstitutionMap recordingSubstitutionMap;
            String compilerOutput = this.compile();
            this.errorManager.generateReport();
            if (this.errorManager.hasErrors()) {
                this.exitCodeHandler.processExitCode(1);
            }
            if ((recordingSubstitutionMap = this.passRunner.getRecordingSubstitutionMap()) != null && renameFile != null) {
                try (PrintWriter renamingMapWriter = new PrintWriter(Files.newWriter((File)renameFile, (Charset)StandardCharsets.UTF_8));){
                    Map<String, String> renamingMap = recordingSubstitutionMap.getMappings();
                    this.writeRenamingMap(renamingMap, renamingMapWriter);
                }
            }
            if (this.job.createSourceMap && sourcemapFile != null && !Strings.isNullOrEmpty((String)sourcemapFile.getName())) {
                try (PrintWriter sourceMapWriter = new PrintWriter(Files.newWriter((File)sourcemapFile, (Charset)StandardCharsets.UTF_8));){
                    this.gssSourceMapGenerator.appendOutputTo(sourceMapWriter, sourcemapFile.getName());
                }
            }
            return compilerOutput;
        }
        catch (IOException e) {
            AbstractCommandLineCompiler.exitOnUnhandledException(e, this.exitCodeHandler);
        }
        catch (GssParserException e) {
            System.err.println("Compiler parsing error: " + e.getMessage());
            e.printStackTrace();
            this.exitCodeHandler.processExitCode(1);
        }
        catch (RuntimeException e) {
            System.err.println("Compiler internal error: " + e.getMessage());
            e.printStackTrace();
            this.exitCodeHandler.processExitCode(3);
        }
        return null;
    }

    protected void writeRenamingMap(Map<String, String> renamingMap, PrintWriter renamingMapWriter) {
        this.job.outputRenamingMapFormat.writeRenamingMap(renamingMap, renamingMapWriter);
    }

    protected static final class CompilerErrorManager
    extends BasicErrorManager {
        private boolean warningsAsErrors = false;

        protected CompilerErrorManager() {
        }

        @Override
        public void print(String msg) {
            System.err.println(msg);
        }

        @Override
        public void reportWarning(GssError warning) {
            if (this.warningsAsErrors) {
                this.report(warning);
            } else {
                super.reportWarning(warning);
            }
        }

        public void setWarningsAsErrors(boolean state) {
            this.warningsAsErrors = state;
        }
    }
}

