/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.gssfunctions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ColorParser {
    private static final Pattern HEX6_PATTERN = ColorParser.formatHexadecimalPattern(6);
    private static final Pattern HEX8_PATTERN = ColorParser.formatHexadecimalPattern(8);
    private static final Pattern HEX4_PATTERN = ColorParser.formatHexadecimalPattern(4);
    private static final Pattern CSS_RGB_PATTERN;
    private static final Pattern CSS_PERCENT_PATTERN;
    private static final Pattern CSS_RGBA_PATTERN;
    private static final Pattern CSS_RGBA_PERCENT_PATTERN;
    private static final ImmutableMap<String, Color> HTML_COLOR_MAP;
    private static final ImmutableMap<String, Color> CSS_COLOR_MAP;
    private static final ImmutableMap<String, Color> SVG_COLOR_MAP;
    private final Set<Format> formats;
    private static final ColorParser ANY_COLOR_PARSER;

    public static Color parseAny(String value) {
        return ANY_COLOR_PARSER.parse(value);
    }

    public ColorParser(Format ... formats) {
        Preconditions.checkArgument((formats.length > 0 ? 1 : 0) != 0, (Object)"At least one format is required");
        this.formats = EnumSet.copyOf(Arrays.asList(formats));
    }

    public Color parse(String value) {
        value = value.trim();
        for (Format format : this.formats) {
            Color result = format.parse(value);
            if (result == null) continue;
            return result;
        }
        throw new IllegalArgumentException("Illegal color value, does not match any of " + this.formats + ": " + value);
    }

    @VisibleForTesting
    static Pattern formatHexadecimalPattern(int numberOfDigits) {
        return Pattern.compile(String.format("^#[0-9a-fA-F]{%d}$", numberOfDigits));
    }

    static {
        String integerPattern = "([+-]?[0-9]+)";
        String numberPattern = "([+-]?[0-9]+|[+-]?[0-9]*\\.[0-9]+)";
        String rgbTemplate = "^rgb\\(\\s*%1$s\\s*,\\s*%1$s\\s*,\\s*%1$s\\s*\\)$";
        CSS_RGB_PATTERN = Pattern.compile(String.format(rgbTemplate, integerPattern));
        CSS_PERCENT_PATTERN = Pattern.compile(String.format(rgbTemplate, numberPattern + "%"));
        String rgbaTemplate = "^rgba\\(\\s*%1$s\\s*,\\s*%1$s\\s*,\\s*%1$s\\s*\\,\\s*%2$s\\s*\\)$";
        CSS_RGBA_PATTERN = Pattern.compile(String.format(rgbaTemplate, integerPattern, numberPattern));
        CSS_RGBA_PERCENT_PATTERN = Pattern.compile(String.format(rgbaTemplate, numberPattern + "%", numberPattern));
        HTML_COLOR_MAP = new ImmutableMap.Builder().put((Object)"aqua", (Object)new Color(65535)).put((Object)"black", (Object)new Color(0)).put((Object)"blue", (Object)new Color(255)).put((Object)"fuchsia", (Object)new Color(0xFF00FF)).put((Object)"gray", (Object)new Color(0x808080)).put((Object)"green", (Object)new Color(32768)).put((Object)"lime", (Object)new Color(65280)).put((Object)"maroon", (Object)new Color(0x800000)).put((Object)"navy", (Object)new Color(128)).put((Object)"olive", (Object)new Color(0x808000)).put((Object)"purple", (Object)new Color(0x800080)).put((Object)"red", (Object)new Color(0xFF0000)).put((Object)"silver", (Object)new Color(0xC0C0C0)).put((Object)"teal", (Object)new Color(32896)).put((Object)"white", (Object)new Color(0xFFFFFF)).put((Object)"yellow", (Object)new Color(0xFFFF00)).build();
        CSS_COLOR_MAP = new ImmutableMap.Builder().putAll(HTML_COLOR_MAP).put((Object)"orange", (Object)new Color(16753920)).build();
        SVG_COLOR_MAP = new ImmutableMap.Builder().putAll(CSS_COLOR_MAP).put((Object)"aliceblue", (Object)new Color(0xF0F8FF)).put((Object)"antiquewhite", (Object)new Color(16444375)).put((Object)"aquamarine", (Object)new Color(8388564)).put((Object)"azure", (Object)new Color(0xF0FFFF)).put((Object)"beige", (Object)new Color(16119260)).put((Object)"bisque", (Object)new Color(16770244)).put((Object)"blanchedalmond", (Object)new Color(16772045)).put((Object)"blueviolet", (Object)new Color(9055202)).put((Object)"brown", (Object)new Color(0xA52A2A)).put((Object)"burlywood", (Object)new Color(14596231)).put((Object)"cadetblue", (Object)new Color(6266528)).put((Object)"chartreuse", (Object)new Color(0x7FFF00)).put((Object)"chocolate", (Object)new Color(13789470)).put((Object)"coral", (Object)new Color(16744272)).put((Object)"cornflowerblue", (Object)new Color(6591981)).put((Object)"cornsilk", (Object)new Color(16775388)).put((Object)"crimson", (Object)new Color(14423100)).put((Object)"cyan", (Object)new Color(65535)).put((Object)"darkblue", (Object)new Color(139)).put((Object)"darkcyan", (Object)new Color(35723)).put((Object)"darkgoldenrod", (Object)new Color(12092939)).put((Object)"darkgray", (Object)new Color(0xA9A9A9)).put((Object)"darkgreen", (Object)new Color(25600)).put((Object)"darkgrey", (Object)new Color(0xA9A9A9)).put((Object)"darkkhaki", (Object)new Color(12433259)).put((Object)"darkmagenta", (Object)new Color(0x8B008B)).put((Object)"darkolivegreen", (Object)new Color(5597999)).put((Object)"darkorange", (Object)new Color(16747520)).put((Object)"darkorchid", (Object)new Color(10040012)).put((Object)"darkred", (Object)new Color(0x8B0000)).put((Object)"darksalmon", (Object)new Color(15308410)).put((Object)"darkseagreen", (Object)new Color(9419919)).put((Object)"darkslateblue", (Object)new Color(4734347)).put((Object)"darkslategray", (Object)new Color(0x2F4F4F)).put((Object)"darkslategrey", (Object)new Color(0x2F4F4F)).put((Object)"darkturquoise", (Object)new Color(52945)).put((Object)"darkviolet", (Object)new Color(9699539)).put((Object)"deeppink", (Object)new Color(16716947)).put((Object)"deepskyblue", (Object)new Color(49151)).put((Object)"dimgray", (Object)new Color(0x696969)).put((Object)"dimgrey", (Object)new Color(0x696969)).put((Object)"dodgerblue", (Object)new Color(2003199)).put((Object)"firebrick", (Object)new Color(0xB22222)).put((Object)"floralwhite", (Object)new Color(0xFFFAF0)).put((Object)"forestgreen", (Object)new Color(0x228B22)).put((Object)"gainsboro", (Object)new Color(0xDCDCDC)).put((Object)"ghostwhite", (Object)new Color(0xF8F8FF)).put((Object)"gold", (Object)new Color(16766720)).put((Object)"goldenrod", (Object)new Color(14329120)).put((Object)"greenyellow", (Object)new Color(11403055)).put((Object)"grey", (Object)new Color(0x808080)).put((Object)"honeydew", (Object)new Color(0xF0FFF0)).put((Object)"hotpink", (Object)new Color(16738740)).put((Object)"indianred", (Object)new Color(0xCD5C5C)).put((Object)"indigo", (Object)new Color(4915330)).put((Object)"ivory", (Object)new Color(0xFFFFF0)).put((Object)"khaki", (Object)new Color(15787660)).put((Object)"lavender", (Object)new Color(15132410)).put((Object)"lavenderblush", (Object)new Color(0xFFF0F5)).put((Object)"lawngreen", (Object)new Color(8190976)).put((Object)"lemonchiffon", (Object)new Color(16775885)).put((Object)"lightblue", (Object)new Color(11393254)).put((Object)"lightcoral", (Object)new Color(0xF08080)).put((Object)"lightcyan", (Object)new Color(0xE0FFFF)).put((Object)"lightgoldenrodyellow", (Object)new Color(16448210)).put((Object)"lightgray", (Object)new Color(0xD3D3D3)).put((Object)"lightgreen", (Object)new Color(0x90EE90)).put((Object)"lightgrey", (Object)new Color(0xD3D3D3)).put((Object)"lightpink", (Object)new Color(16758465)).put((Object)"lightsalmon", (Object)new Color(16752762)).put((Object)"lightseagreen", (Object)new Color(2142890)).put((Object)"lightskyblue", (Object)new Color(8900346)).put((Object)"lightslategray", (Object)new Color(0x778899)).put((Object)"lightslategrey", (Object)new Color(0x778899)).put((Object)"lightsteelblue", (Object)new Color(11584734)).put((Object)"lightyellow", (Object)new Color(0xFFFFE0)).put((Object)"limegreen", (Object)new Color(3329330)).put((Object)"linen", (Object)new Color(16445670)).put((Object)"magenta", (Object)new Color(0xFF00FF)).put((Object)"mediumaquamarine", (Object)new Color(6737322)).put((Object)"mediumblue", (Object)new Color(205)).put((Object)"mediumorchid", (Object)new Color(12211667)).put((Object)"mediumpurple", (Object)new Color(9662683)).put((Object)"mediumseagreen", (Object)new Color(3978097)).put((Object)"mediumslateblue", (Object)new Color(8087790)).put((Object)"mediumspringgreen", (Object)new Color(64154)).put((Object)"mediumturquoise", (Object)new Color(4772300)).put((Object)"mediumvioletred", (Object)new Color(13047173)).put((Object)"midnightblue", (Object)new Color(1644912)).put((Object)"mintcream", (Object)new Color(0xF5FFFA)).put((Object)"mistyrose", (Object)new Color(16770273)).put((Object)"moccasin", (Object)new Color(16770229)).put((Object)"navajowhite", (Object)new Color(16768685)).put((Object)"oldlace", (Object)new Color(16643558)).put((Object)"olivedrab", (Object)new Color(7048739)).put((Object)"orangered", (Object)new Color(16729344)).put((Object)"orchid", (Object)new Color(14315734)).put((Object)"palegoldenrod", (Object)new Color(0xEEE8AA)).put((Object)"palegreen", (Object)new Color(10025880)).put((Object)"paleturquoise", (Object)new Color(0xAFEEEE)).put((Object)"palevioletred", (Object)new Color(14381203)).put((Object)"papayawhip", (Object)new Color(16773077)).put((Object)"peachpuff", (Object)new Color(16767673)).put((Object)"peru", (Object)new Color(13468991)).put((Object)"pink", (Object)new Color(16761035)).put((Object)"plum", (Object)new Color(0xDDA0DD)).put((Object)"powderblue", (Object)new Color(11591910)).put((Object)"rosybrown", (Object)new Color(12357519)).put((Object)"royalblue", (Object)new Color(4286945)).put((Object)"saddlebrown", (Object)new Color(9127187)).put((Object)"salmon", (Object)new Color(16416882)).put((Object)"sandybrown", (Object)new Color(16032864)).put((Object)"seagreen", (Object)new Color(3050327)).put((Object)"seashell", (Object)new Color(0xFFF5EE)).put((Object)"sienna", (Object)new Color(10506797)).put((Object)"skyblue", (Object)new Color(8900331)).put((Object)"slateblue", (Object)new Color(6970061)).put((Object)"slategray", (Object)new Color(7372944)).put((Object)"slategrey", (Object)new Color(7372944)).put((Object)"snow", (Object)new Color(0xFFFAFA)).put((Object)"springgreen", (Object)new Color(65407)).put((Object)"steelblue", (Object)new Color(4620980)).put((Object)"tan", (Object)new Color(13808780)).put((Object)"thistle", (Object)new Color(14204888)).put((Object)"tomato", (Object)new Color(16737095)).put((Object)"turquoise", (Object)new Color(4251856)).put((Object)"violet", (Object)new Color(0xEE82EE)).put((Object)"wheat", (Object)new Color(16113331)).put((Object)"whitesmoke", (Object)new Color(0xF5F5F5)).put((Object)"yellowgreen", (Object)new Color(10145074)).build();
        ANY_COLOR_PARSER = new ColorParser(Format.HEX3, Format.HEX6, Format.CSS_RGB, Format.CSS_RGBA, Format.SVG_KEYWORDS);
    }

    public static enum Format {
        HEX6{

            @Override
            Color parse(String value) {
                return HEX6_PATTERN.matcher(value).matches() ? new Color(Integer.parseInt(value.substring(1), 16)) : null;
            }
        }
        ,
        HEX3{

            @Override
            Color parse(String value) {
                return HEX4.parse(value + "F");
            }
        }
        ,
        HEX4{

            @Override
            Color parse(String value) {
                if (HEX4_PATTERN.matcher(value).matches()) {
                    int r = Integer.parseInt(value.substring(1, 2), 16);
                    int g = Integer.parseInt(value.substring(2, 3), 16);
                    int b = Integer.parseInt(value.substring(3, 4), 16);
                    int a = Integer.parseInt(value.substring(4, 5), 16);
                    return new Color(r << 4 | r, g << 4 | g, b << 4 | b, a << 4 | a);
                }
                return null;
            }
        }
        ,
        HEX8{

            @Override
            Color parse(String value) {
                if (HEX8_PATTERN.matcher(value).matches()) {
                    int rgb = Integer.parseInt(value.substring(1, 7), 16);
                    int a = Integer.parseInt(value.substring(7, 9), 16);
                    return new Color(a << 24 | rgb, true);
                }
                return null;
            }
        }
        ,
        CSS_RGB{

            @Override
            Color parse(String value) {
                Matcher matcher = CSS_RGB_PATTERN.matcher(value);
                if (matcher.matches()) {
                    return this.newColor(matcher, 255.0f);
                }
                matcher = CSS_PERCENT_PATTERN.matcher(value);
                return matcher.matches() ? this.newColor(matcher, 100.0f) : null;
            }

            private Color newColor(Matcher matcher, float max) {
                return new Color(Format.clipRangeAndNormalize(matcher.group(1), max), Format.clipRangeAndNormalize(matcher.group(2), max), Format.clipRangeAndNormalize(matcher.group(3), max));
            }
        }
        ,
        CSS_RGBA{

            @Override
            Color parse(String value) {
                Matcher matcher = CSS_RGBA_PATTERN.matcher(value);
                if (matcher.matches()) {
                    return this.newColor(matcher, 255.0f);
                }
                matcher = CSS_RGBA_PERCENT_PATTERN.matcher(value);
                return matcher.matches() ? this.newColor(matcher, 100.0f) : null;
            }

            private Color newColor(Matcher matcher, float max) {
                return new Color(Format.clipRangeAndNormalize(matcher.group(1), max), Format.clipRangeAndNormalize(matcher.group(2), max), Format.clipRangeAndNormalize(matcher.group(3), max), Format.clipRangeAndNormalize(matcher.group(4), 1.0f));
            }
        }
        ,
        HTML_KEYWORDS{

            @Override
            Color parse(String value) {
                return (Color)HTML_COLOR_MAP.get((Object)value.toLowerCase());
            }
        }
        ,
        CSS_KEYWORDS{

            @Override
            Color parse(String value) {
                return (Color)CSS_COLOR_MAP.get((Object)value.toLowerCase());
            }
        }
        ,
        SVG_KEYWORDS{

            @Override
            Color parse(String value) {
                return (Color)SVG_COLOR_MAP.get((Object)value.toLowerCase());
            }
        };


        abstract Color parse(String var1);

        private static float clipRangeAndNormalize(String value, float max) {
            return Math.max(0.0f, Math.min(max, Float.parseFloat(value))) / max;
        }
    }
}

