/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import java.util.Set;

public class BooleanExpressionEvaluator {
    final CssBooleanExpressionNode expression;
    final Set<String> trueConditions;
    final Set<String> falseConditions;
    final boolean theRestAreUnknown;

    public BooleanExpressionEvaluator(CssBooleanExpressionNode expression, Set<String> trueConditions) {
        this(expression, trueConditions, (Set<String>)ImmutableSet.of(), false);
        Preconditions.checkArgument((!trueConditions.contains(null) ? 1 : 0) != 0);
    }

    public BooleanExpressionEvaluator(CssBooleanExpressionNode expression, Set<String> trueConditions, Set<String> falseConditions) {
        this(expression, trueConditions, falseConditions, true);
        Preconditions.checkArgument((!trueConditions.contains(null) ? 1 : 0) != 0);
        Preconditions.checkArgument((!falseConditions.contains(null) ? 1 : 0) != 0);
    }

    private BooleanExpressionEvaluator(CssBooleanExpressionNode expression, Set<String> trueConditions, Set<String> falseConditions, boolean theRestAreUnknown) {
        Preconditions.checkArgument((falseConditions.isEmpty() || !theRestAreUnknown ? 1 : 0) != 0);
        Preconditions.checkArgument((!trueConditions.contains("TRUE") && !trueConditions.contains("FALSE") && !falseConditions.contains("TRUE") && !falseConditions.contains("FALSE") ? 1 : 0) != 0);
        this.expression = expression;
        this.trueConditions = Sets.union(trueConditions, (Set)ImmutableSet.of((Object)"TRUE"));
        this.falseConditions = Sets.union(falseConditions, (Set)ImmutableSet.of((Object)"FALSE"));
        this.theRestAreUnknown = theRestAreUnknown;
    }

    public CssBooleanExpressionNode evaluate() {
        Object result = this.evaluateTree(this.expression);
        if (result instanceof Boolean) {
            return new CssBooleanExpressionNode(CssBooleanExpressionNode.Type.CONSTANT, (Boolean)result != false ? "TRUE" : "FALSE");
        }
        return (CssBooleanExpressionNode)result;
    }

    private Object evaluateTree(CssBooleanExpressionNode node) {
        if (node.getType().isConstant()) {
            String constantName = node.getValue();
            if (this.trueConditions.contains(constantName)) {
                return Boolean.TRUE;
            }
            if (this.falseConditions.contains(constantName)) {
                return Boolean.FALSE;
            }
            if (this.theRestAreUnknown) {
                return new CssBooleanExpressionNode(node.getType(), node.getValue(), node.getSourceCodeLocation());
            }
            return Boolean.FALSE;
        }
        if (node.getType().isUnaryOperator()) {
            return this.evaluateTreeWithUnaryOperator(node);
        }
        return this.evaluateTreeWithBinaryOperator(node);
    }

    private Object evaluateTreeWithUnaryOperator(CssBooleanExpressionNode node) {
        Object operand = this.evaluateTree(node.getLeft());
        if (operand instanceof Boolean) {
            Boolean boolResult = (Boolean)operand;
            return boolResult == false;
        }
        CssBooleanExpressionNode operandResult = (CssBooleanExpressionNode)operand;
        return new CssBooleanExpressionNode(node.getType(), node.getValue(), operandResult, node.getSourceCodeLocation());
    }

    private Object evaluateTreeWithBinaryOperator(CssBooleanExpressionNode node) {
        Object rightOperand;
        Object leftOperand = this.evaluateTree(node.getLeft());
        if (leftOperand instanceof Boolean) {
            boolean leftBoolResult = (Boolean)leftOperand;
            if (leftBoolResult && node.getType() == CssBooleanExpressionNode.Type.OR) {
                return Boolean.TRUE;
            }
            if (!leftBoolResult && node.getType() == CssBooleanExpressionNode.Type.AND) {
                return Boolean.FALSE;
            }
        }
        if ((rightOperand = this.evaluateTree(node.getRight())) instanceof Boolean) {
            boolean rightBoolResult = (Boolean)rightOperand;
            if (leftOperand instanceof Boolean) {
                if (node.getType() == CssBooleanExpressionNode.Type.AND) {
                    return (Boolean)leftOperand != false && (Boolean)rightOperand != false;
                }
                return (Boolean)leftOperand != false || (Boolean)rightOperand != false;
            }
            if (rightBoolResult && node.getType() == CssBooleanExpressionNode.Type.OR) {
                return Boolean.TRUE;
            }
            if (!rightBoolResult && node.getType() == CssBooleanExpressionNode.Type.AND) {
                return Boolean.FALSE;
            }
            return leftOperand;
        }
        if (leftOperand instanceof Boolean) {
            return rightOperand;
        }
        CssBooleanExpressionNode leftResult = (CssBooleanExpressionNode)leftOperand;
        CssBooleanExpressionNode rightResult = (CssBooleanExpressionNode)rightOperand;
        return new CssBooleanExpressionNode(node.getType(), node.getValue(), leftResult, rightResult, node.getSourceCodeLocation());
    }
}

