/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.CodePrinter;
import com.google.common.css.compiler.passes.CompactPrintingVisitor;
import com.google.common.css.compiler.passes.GssSourceMapGenerator;
import javax.annotation.Nullable;

public class CompactPrinter
extends CodePrinter {
    private String compactedPrintedString = null;

    public CompactPrinter(CssNode subtree, @Nullable CodeBuffer buffer, @Nullable GssSourceMapGenerator generator) {
        super(subtree.getVisitController(), buffer, generator);
    }

    public CompactPrinter(CssNode subtree, @Nullable CodeBuffer buffer) {
        this(subtree, buffer, null);
    }

    public CompactPrinter(CssNode subtree) {
        this(subtree, null);
    }

    public CompactPrinter(CssTree tree, @Nullable CodeBuffer buffer, @Nullable GssSourceMapGenerator generator) {
        super(tree.getVisitController(), buffer, generator);
    }

    public CompactPrinter(CssTree tree, CodeBuffer buffer) {
        this(tree, buffer, null);
    }

    public CompactPrinter(CssTree tree, GssSourceMapGenerator generator) {
        this(tree, null, generator);
    }

    public CompactPrinter(CssTree tree) {
        this(tree, null, null);
    }

    @Override
    protected CssTreeVisitor createVisitor(VisitController visitController, CodeBuffer buffer) {
        return new CompactPrintingVisitor(visitController, buffer);
    }

    public String getCompactPrintedString() {
        return this.compactedPrintedString;
    }

    @Override
    public void runPass() {
        this.resetBuffer();
        this.visit();
        this.compactedPrintedString = this.getOutputBuffer();
    }

    public static String printCompactly(CssNode n) {
        CompactPrinter p = new CompactPrinter(n);
        p.runPass();
        return p.getCompactPrintedString().trim();
    }

    public static String printCompactly(CssTree t) {
        return CompactPrinter.printCompactly(t.getRoot());
    }
}

