/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.common.css.compiler.ast.CssCharSetNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssImportBlockNode;
import com.google.common.css.compiler.ast.CssImportRuleNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssPageRuleNode;
import com.google.common.css.compiler.ast.CssPageSelectorNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.UniformVisitor;
import java.util.ArrayList;
import java.util.List;

public class CreateStandardAtRuleNodes
implements UniformVisitor,
CssCompilerPass {
    @VisibleForTesting
    static final String NO_BLOCK_ERROR_MESSAGE = "This @-rule has to have a block";
    @VisibleForTesting
    static final String BLOCK_ERROR_MESSAGE = "This @-rule is not allowed to have a block";
    @VisibleForTesting
    static final String ONLY_DECLARATION_BLOCK_ERROR_MESSAGE = "Only declaration blocks are allowed for this @-rule";
    @VisibleForTesting
    static final String INVALID_PARAMETERS_ERROR_MESSAGE = "This @-rule has invalid parameters";
    @VisibleForTesting
    static final String MEDIA_INVALID_CHILD_ERROR_MESSAGE = "This is not valid inside an @media block";
    @VisibleForTesting
    static final String MEDIA_WITHOUT_PARAMETERS_ERROR_MESSAGE = "@media without parameters";
    @VisibleForTesting
    static final String PAGE_SELECTOR_PARAMETERS_ERROR_MESSAGE = "Page selectors are not allowed to have parameters";
    @VisibleForTesting
    static final String FONT_FACE_PARAMETERS_ERROR_MESSAGE = "@font-face is not allowed to have parameters";
    @VisibleForTesting
    static final String CHARSET_SPACES_MESSAGE = "There may only be a single space between @charset and the quote";
    @VisibleForTesting
    static final String CHARSET_ERROR_CHAR_BEFORE_MESSAGE = "There must not be characters before @charset";
    @VisibleForTesting
    static final String CHARSET_ERROR_NO_PARAMETER_MESSAGE = "Missing charset definition for @charset rule";
    @VisibleForTesting
    static final String IGNORED_IMPORT_WARNING_MESSAGE = "@import rules should occur outside blocks and can only be preceded by @charset and other @import rules.";
    @VisibleForTesting
    static final String IGNORE_IMPORT_WARNING_MESSAGE = "A node after which all @import rule nodes are ignored is here.";
    @VisibleForTesting
    static final String IGNORED_CHARSET_WARNING_MESSAGE = "Only the first @charset rule is used. This node is superfluous.";
    private static final ImmutableList<CssAtRuleNode.Type> PAGE_SELECTORS = ImmutableList.of((Object)((Object)CssAtRuleNode.Type.TOP_LEFT_CORNER), (Object)((Object)CssAtRuleNode.Type.TOP_LEFT), (Object)((Object)CssAtRuleNode.Type.TOP_CENTER), (Object)((Object)CssAtRuleNode.Type.TOP_RIGHT), (Object)((Object)CssAtRuleNode.Type.TOP_RIGHT_CORNER), (Object)((Object)CssAtRuleNode.Type.LEFT_TOP), (Object)((Object)CssAtRuleNode.Type.LEFT_MIDDLE), (Object)((Object)CssAtRuleNode.Type.LEFT_BOTTOM), (Object)((Object)CssAtRuleNode.Type.RIGHT_TOP), (Object)((Object)CssAtRuleNode.Type.RIGHT_MIDDLE), (Object)((Object)CssAtRuleNode.Type.RIGHT_BOTTOM), (Object)((Object)CssAtRuleNode.Type.BOTTOM_LEFT_CORNER), (Object[])new CssAtRuleNode.Type[]{CssAtRuleNode.Type.BOTTOM_LEFT, CssAtRuleNode.Type.BOTTOM_CENTER, CssAtRuleNode.Type.BOTTOM_RIGHT, CssAtRuleNode.Type.BOTTOM_RIGHT_CORNER});
    private static final ImmutableSet<String> PSEUDO_PAGES = ImmutableSet.of((Object)":left", (Object)":right", (Object)":first");
    private static final ImmutableSet<String> ALLOWED_AT_RULES_IN_MEDIA = ImmutableSet.of((Object)"page", (Object)"if", (Object)"elseif", (Object)"else", (Object)"for", (Object)"media", (Object[])new String[]{"keyframes", "supports", "font-face"});
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final List<CssImportRuleNode> nonIgnoredImportRules = Lists.newArrayList();
    private CssRootNode root;
    private CssNode noMoreImportRules;
    private CssNode noMoreCharsetRules;

    public CreateStandardAtRuleNodes(MutatingVisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    private void enterTree(CssRootNode root) {
        this.root = root;
        this.noMoreImportRules = null;
        this.noMoreCharsetRules = null;
    }

    @Override
    public void leave(CssNode node) {
        if (!(node instanceof CssImportRuleNode) && !(node instanceof CssImportBlockNode) && node != this.root.getCharsetRule()) {
            this.noMoreImportRules = node;
        }
        if (node instanceof CssRootNode) {
            this.leaveTree((CssRootNode)node);
        }
    }

    @Override
    public void enter(CssNode cssNode) {
        if (cssNode instanceof CssRootNode) {
            this.enterTree((CssRootNode)cssNode);
        }
        if (!(cssNode instanceof CssUnknownAtRuleNode)) {
            return;
        }
        CssUnknownAtRuleNode node = (CssUnknownAtRuleNode)cssNode;
        String charsetName = CssAtRuleNode.Type.CHARSET.getCanonicalName();
        String importName = CssAtRuleNode.Type.IMPORT.getCanonicalName();
        String mediaName = CssAtRuleNode.Type.MEDIA.getCanonicalName();
        String pageName = CssAtRuleNode.Type.PAGE.getCanonicalName();
        String fontFaceName = CssAtRuleNode.Type.FONT_FACE.getCanonicalName();
        List<CssValueNode> params = node.getParameters();
        if (node.getName().getValue().equals(charsetName)) {
            this.createCharsetRule(node);
        } else if (node.getName().getValue().equals(importName)) {
            if (params.isEmpty()) {
                this.reportError("@" + importName + " without a following string or uri", node);
                return;
            }
            if (params.size() > 2) {
                this.reportError("@" + importName + " with too many parameters", node);
                return;
            }
            CssValueNode param = params.get(0);
            if (!(param instanceof CssStringNode) && !this.checkIfUri(param)) {
                this.reportError("@" + importName + "'s first parameter has to be a string or an url", node);
                return;
            }
            ArrayList paramlist = Lists.newArrayList((Object[])new CssValueNode[]{param});
            if (params.size() == 2) {
                CssValueNode param2 = params.get(1);
                if (param2 instanceof CssCompositeValueNode || param2 instanceof CssLiteralNode) {
                    paramlist.add(param2);
                } else {
                    this.reportError("@" + importName + " has illegal parameter", node);
                    return;
                }
            }
            CssImportRuleNode importRule = new CssImportRuleNode(node.getComments());
            importRule.setParameters(paramlist);
            importRule.setSourceCodeLocation(node.getSourceCodeLocation());
            if (this.noMoreImportRules != null) {
                this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssNode[]{importRule}), false);
                this.reportWarning(IGNORED_IMPORT_WARNING_MESSAGE, node);
                this.reportWarning(IGNORE_IMPORT_WARNING_MESSAGE, this.noMoreImportRules);
            } else {
                this.visitController.removeCurrentNode();
                this.nonIgnoredImportRules.add(importRule);
            }
        } else if (node.getName().getValue().equals(mediaName)) {
            this.createMediaRule(node);
        } else if (node.getName().getValue().equals(pageName)) {
            this.createPageRule(node);
        } else if (node.getName().getValue().equals(fontFaceName)) {
            this.createFontFaceRule(node);
        } else {
            for (CssAtRuleNode.Type type : PAGE_SELECTORS) {
                if (!node.getName().getValue().equals(type.getCanonicalName())) continue;
                this.createPageSelector(type, node);
                break;
            }
        }
    }

    private void leaveTree(CssRootNode root) {
        for (CssImportRuleNode importRule : this.nonIgnoredImportRules) {
            root.getImportRules().addChildToBack(importRule);
        }
    }

    private void createMediaRule(CssUnknownAtRuleNode node) {
        if (node.getBlock() == null) {
            this.reportError(NO_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!(node.getBlock() instanceof CssBlockNode)) {
            this.reportError(ONLY_DECLARATION_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        CssBlockNode block = (CssBlockNode)node.getBlock();
        for (CssNode part : block.childIterable()) {
            if (this.isValidInMediaRule(part)) continue;
            this.reportError(MEDIA_INVALID_CHILD_ERROR_MESSAGE, part);
            return;
        }
        List<CssValueNode> params = node.getParameters();
        if (params.isEmpty()) {
            this.reportError(MEDIA_WITHOUT_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        if (!this.checkMediaParameter(params)) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssMediaRuleNode mediaRule = new CssMediaRuleNode(node.getComments(), block);
        mediaRule.setParameters(params);
        mediaRule.setSourceCodeLocation(node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssMediaRuleNode[]{mediaRule}), true);
    }

    private boolean checkMediaParameter(List<CssValueNode> params) {
        if (params.get(0) instanceof CssCompositeValueNode) {
            return this.checkMediaCompositeExpression(params, 0);
        }
        if (params.get(0) instanceof CssBooleanExpressionNode) {
            return this.checkMediaExpression(params, 0);
        }
        if (!(params.get(0) instanceof CssLiteralNode)) {
            CssValueNode node = params.get(0);
            this.reportWarning(String.format("Expected CssLiteralNode but found %s", node.getClass().getName()), node);
            return false;
        }
        int numberOfStartingLiterals = 1;
        String firstValue = params.get(0).getValue();
        if (firstValue.equals("only") || firstValue.equals("not")) {
            numberOfStartingLiterals = 2;
        }
        if (params.size() < numberOfStartingLiterals) {
            this.reportWarning("Expected CssLiteralNode after 'only' or 'not'.", params.get(params.size() - 1));
            return false;
        }
        if (params.size() - numberOfStartingLiterals > 0) {
            return this.checkAndMediaExpression(params, numberOfStartingLiterals);
        }
        return true;
    }

    private boolean checkAndMediaExpression(List<CssValueNode> params, int start) {
        if (params.size() - start < 2) {
            return false;
        }
        if (!params.get(start).getValue().equals("and")) {
            return false;
        }
        return this.checkMediaExpression(params, start + 1);
    }

    private boolean checkMediaExpression(List<CssValueNode> params, int start) {
        if (params.size() - start < 1) {
            return false;
        }
        if (params.get(start) instanceof CssCompositeValueNode) {
            return this.checkMediaCompositeExpression(params, start);
        }
        if (params.size() > start + 1) {
            return this.checkAndMediaExpression(params, start + 1);
        }
        return true;
    }

    private boolean checkMediaCompositeExpression(List<CssValueNode> params, int start) {
        CssValueNode startValue;
        CssCompositeValueNode comp = (CssCompositeValueNode)params.get(start);
        if (comp.getValues().size() == 2) {
            startValue = comp.getValues().get(1);
        } else {
            ArrayList newChildren = Lists.newArrayList(comp.getValues());
            newChildren.remove(0);
            startValue = new CssCompositeValueNode(newChildren, comp.getOperator(), comp.getSourceCodeLocation());
        }
        ArrayList newParams = Lists.newArrayList((Object[])new CssValueNode[]{startValue});
        for (int i = 0; i < params.size(); ++i) {
            if (i <= start) continue;
            newParams.add(params.get(i));
        }
        return this.checkMediaParameter(newParams);
    }

    private boolean isValidInMediaRule(CssNode node) {
        if (node instanceof CssRulesetNode) {
            return true;
        }
        if (node instanceof CssAtRuleNode && ALLOWED_AT_RULES_IN_MEDIA.contains((Object)((CssAtRuleNode)node).getName().getValue())) {
            return true;
        }
        return node instanceof CssConditionalBlockNode;
    }

    private void createPageRule(CssUnknownAtRuleNode node) {
        if (node.getBlock() == null) {
            this.reportError(NO_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
            this.reportError(ONLY_DECLARATION_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        List<CssValueNode> params = node.getParameters();
        int numParams = params.size();
        if (numParams > 2) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        if (numParams == 2 && !PSEUDO_PAGES.contains((Object)params.get(1).getValue())) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        if (numParams == 1 && params.get(0).getValue().startsWith(":") && !PSEUDO_PAGES.contains((Object)params.get(0).getValue())) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssDeclarationBlockNode block = (CssDeclarationBlockNode)node.getBlock();
        CssPageRuleNode pageRule = new CssPageRuleNode(node.getComments(), block);
        pageRule.setParameters(params);
        pageRule.setSourceCodeLocation(node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssPageRuleNode[]{pageRule}), true);
    }

    private void createPageSelector(CssAtRuleNode.Type type, CssUnknownAtRuleNode node) {
        if (node.getBlock() == null) {
            this.reportError(NO_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
            this.reportError(ONLY_DECLARATION_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!node.getParameters().isEmpty()) {
            this.reportError(PAGE_SELECTOR_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssDeclarationBlockNode block = (CssDeclarationBlockNode)node.getBlock();
        CssPageSelectorNode pageSelector = new CssPageSelectorNode(type, node.getComments(), block);
        pageSelector.setSourceCodeLocation(node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssPageSelectorNode[]{pageSelector}), true);
    }

    private void createCharsetRule(CssUnknownAtRuleNode node) {
        if (this.noMoreCharsetRules == null) {
            this.charsetRuleValidation(node);
            CssCharSetNode charSet = new CssCharSetNode(node.getComments());
            charSet.setParameters(node.getChildren());
            charSet.setSourceCodeLocation(node.getSourceCodeLocation());
            this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssCharSetNode[]{charSet}), true);
            this.noMoreCharsetRules = node;
        } else {
            this.visitController.removeCurrentNode();
            this.reportWarning(IGNORED_CHARSET_WARNING_MESSAGE, node);
        }
    }

    private void charsetRuleValidation(CssUnknownAtRuleNode node) {
        List children;
        if (!this.root.toString().startsWith("[" + node.toString())) {
            this.reportError(CHARSET_ERROR_CHAR_BEFORE_MESSAGE, node);
        }
        if ((children = node.getChildren()).isEmpty()) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssValueNode charsetParamNode = (CssValueNode)children.get(0);
        String charsetParam = charsetParamNode.toString();
        if (!charsetParam.startsWith("\"") || !charsetParam.endsWith("\"")) {
            this.reportError(INVALID_PARAMETERS_ERROR_MESSAGE, node);
        }
    }

    private void createFontFaceRule(CssUnknownAtRuleNode node) {
        if (node.getBlock() == null) {
            this.reportError(NO_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
            this.reportError(ONLY_DECLARATION_BLOCK_ERROR_MESSAGE, node);
            return;
        }
        if (!node.getParameters().isEmpty()) {
            this.reportError(FONT_FACE_PARAMETERS_ERROR_MESSAGE, node);
            return;
        }
        CssDeclarationBlockNode block = (CssDeclarationBlockNode)node.getBlock();
        CssFontFaceNode fontFace = new CssFontFaceNode(node.getComments(), block);
        fontFace.setSourceCodeLocation(node.getSourceCodeLocation());
        this.visitController.replaceCurrentBlockChildWith(Lists.newArrayList((Object[])new CssFontFaceNode[]{fontFace}), true);
    }

    private boolean checkIfUri(CssValueNode node) {
        if (!(node instanceof CssFunctionNode)) {
            return false;
        }
        CssFunctionNode function = (CssFunctionNode)node;
        return function.getFunctionName().equalsIgnoreCase("url");
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    private void reportWarning(String message, CssNode node) {
        this.errorManager.reportWarning(new GssError(message, node.getSourceCodeLocation()));
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(UniformVisitor.Adapters.asVisitor(this));
    }
}

