/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.reflect.Reflection;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class DelegatingVisitor {
    private DelegatingVisitor() {
    }

    public static CssTreeVisitor from(List<CssTreeVisitor> originalVisitors) {
        Preconditions.checkArgument((!originalVisitors.isEmpty() ? 1 : 0) != 0);
        if (originalVisitors.size() == 1) {
            return originalVisitors.get(0);
        }
        ImmutableList visitors = ImmutableList.copyOf(originalVisitors);
        ImmutableList reverseVisitors = visitors.reverse();
        return (CssTreeVisitor)Reflection.newProxy(CssTreeVisitor.class, (proxy, method, args) -> {
            try {
                Object returnValue = null;
                ImmutableList visitorsInOrderForMethod = method.getName().startsWith("enter") ? visitors : reverseVisitors;
                for (CssTreeVisitor visitor : visitorsInOrderForMethod) {
                    returnValue = method.invoke((Object)visitor, args);
                }
                return returnValue;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
    }

    public static CssTreeVisitor from(CssTreeVisitor ... visitors) {
        return DelegatingVisitor.from((List<CssTreeVisitor>)ImmutableList.copyOf((Object[])visitors));
    }
}

