/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.BooleanExpressionEvaluator;
import java.util.Set;

public class EliminateConditionalNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final Set<String> trueConditions;

    public EliminateConditionalNodes(MutatingVisitController visitController, Set<String> trueConditions) {
        this.visitController = visitController;
        this.trueConditions = trueConditions;
    }

    @Override
    public boolean enterConditionalBlock(CssConditionalBlockNode block) {
        for (CssConditionalRuleNode currentCondtional : block.childIterable()) {
            if (currentCondtional.getType() == CssAtRuleNode.Type.ELSE) {
                this.visitController.replaceCurrentBlockChildWith(currentCondtional.getBlock().getChildren(), true);
                return true;
            }
            BooleanExpressionEvaluator evaluator = new BooleanExpressionEvaluator(currentCondtional.getCondition(), this.trueConditions);
            CssBooleanExpressionNode result = evaluator.evaluate();
            if (!"TRUE".equals(result.getValue())) continue;
            this.visitController.replaceCurrentBlockChildWith(currentCondtional.getBlock().getChildren(), true);
            return true;
        }
        this.visitController.removeCurrentNode();
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

