/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssForLoopRuleNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Map;
import javax.annotation.Nullable;

public class EvaluateCompileConstants
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    private final Map<String, Integer> compileConstants;

    public EvaluateCompileConstants(MutatingVisitController visitController, Map<String, Integer> compileConstants) {
        this.visitController = visitController;
        this.compileConstants = compileConstants;
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        CssNumericNode newNode = this.updateValueNode(node);
        if (newNode != null) {
            this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), false);
        }
        return true;
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        return this.enterValueNode(node);
    }

    @Override
    public boolean enterForLoop(CssForLoopRuleNode node) {
        CssNumericNode step;
        CssNumericNode to;
        CssNumericNode from = this.updateValueNode(node.getFrom());
        if (from != null) {
            node.setFrom(from);
        }
        if ((to = this.updateValueNode(node.getTo())) != null) {
            node.setTo(to);
        }
        if ((step = this.updateValueNode(node.getStep())) != null) {
            node.setStep(step);
        }
        return true;
    }

    @Nullable
    private CssNumericNode updateValueNode(CssValueNode node) {
        Integer value = this.compileConstants.get(node.getValue());
        if (value != null) {
            return new CssNumericNode(String.valueOf(value), "", node.getSourceCodeLocation());
        }
        return null;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

