/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.css.SourceCode;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.EnumeratingVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class FixupFontDeclarations
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String FONT = "font";
    private static final String FONT_FAMILY = "font-family";
    private static final String NORMAL = "normal";
    private static final String INHERIT = "inherit";
    private static final ImmutableSet<String> SYSTEM_FONTS = ImmutableSet.of((Object)"caption", (Object)"icon", (Object)"menu", (Object)"message-box", (Object)"small-caption", (Object)"status-bar", (Object[])new String[0]);
    private static final ImmutableSet<String> FONT_ABSOLUTE_SIZES = ImmutableSet.of((Object)"xx-small", (Object)"x-small", (Object)"small", (Object)"medium", (Object)"large", (Object)"x-large", (Object[])new String[]{"xx-large"});
    private static final ImmutableSet<String> FONT_RELATIVE_SIZES = ImmutableSet.of((Object)"larger", (Object)"smaller");
    private static final ImmutableSet<String> DEFINITELY_STYLE = ImmutableSet.of((Object)"italic", (Object)"oblique");
    private static final ImmutableSet<String> DEFINITELY_VARIANT = ImmutableSet.of((Object)"small-caps");
    private static final ImmutableSet<String> DEFINITELY_WEIGHT = ImmutableSet.of((Object)"bold", (Object)"bolder", (Object)"lighter");
    private static final ImmutableSet<String> NUMERIC_WEIGHTS = ImmutableSet.of((Object)"100", (Object)"200", (Object)"300", (Object)"400", (Object)"500", (Object)"600", (Object[])new String[]{"700", "800", "900"});
    private static final int PRE_FAMILY_LIMIT = 6;
    private static final Predicate<CssValueNode> IS_PLAIN_SIZE = n -> n instanceof CssNumericNode && !"".equals(((CssNumericNode)n).getUnit()) || FONT_ABSOLUTE_SIZES.contains((Object)n.getValue()) || FONT_RELATIVE_SIZES.contains((Object)n.getValue());
    private static final Function<CssCompositeValueNode, CssValueNode> EXTRACT_SIZE = n -> n.getValues().get(0);
    @VisibleForTesting
    static final String SIZE_AND_FAMILY_REQUIRED = "Size and family are required in the absence of a system font or a simple inherit";
    @VisibleForTesting
    static final ImmutableMap<FontProperty, String> TOO_MANY = ImmutableMap.builder().put((Object)FontProperty.LINE_HEIGHT, (Object)"The '/' can occur at most once in a font shorthand value").put((Object)FontProperty.SIZE, (Object)"Font size can occur at most once in a font shorthand value").put((Object)FontProperty.STYLE, (Object)"Font style can occur at most once in a font shorthand value").put((Object)FontProperty.VARIANT, (Object)"Font variant can occur at most once in a font shorthand value").put((Object)FontProperty.WEIGHT, (Object)"Font weight can occur at most once in a font shorthand value").build();
    private static final ImmutableSortedSet<FontProperty> SLOTTABLE_PROPERTIES = ImmutableSortedSet.of((Comparable)((Object)FontProperty.STYLE), (Comparable)((Object)FontProperty.VARIANT), (Comparable)((Object)FontProperty.WEIGHT));
    @VisibleForTesting
    static final String TOO_MANY_NORMALS = "The keyword normal can occur at most thrice in a font shorthand value";
    @VisibleForTesting
    static final String NORMAL_TOO_LATE = "The keyword normal is only allowed in the first three tokens of a font shorthand";
    @VisibleForTesting
    static final String SIZE_AFTER_HEIGHT = "Font size must be specified before line-height";
    @VisibleForTesting
    static final String TOO_MANY_PRE_SIZE = "Too many font shorthand tokens before size";
    @VisibleForTesting
    static final String PRE_SIZE_INTERLOPER_SIZE = "Unrecognized tokens immediately preceding size";
    private final InputMode mode;
    private final ErrorManager errorManager;
    private final MutatingVisitController visitController;
    private final CssTree tree;

    private static WithOperator withOperator(CssCompositeValueNode.Operator op) {
        return new WithOperator(op);
    }

    public FixupFontDeclarations(InputMode mode, ErrorManager errorManager, CssTree tree) {
        this.mode = mode;
        this.errorManager = errorManager;
        this.tree = tree;
        this.visitController = tree.getMutatingVisitController();
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode decl) {
        String propertyName = decl.getPropertyName().getProperty().getName();
        if (!FONT.equals(propertyName) && !FONT_FAMILY.equals(propertyName)) {
            return false;
        }
        CssDeclarationNode d = decl.deepCopy();
        ImmutableList replacement = ImmutableList.of((Object)d);
        if (FONT.equals(propertyName)) {
            d.setPropertyValue(this.reparseFont(decl.getPropertyValue()));
        } else if (FONT_FAMILY.equals(propertyName)) {
            d.setPropertyValue(this.reparseFontFamily(decl.getPropertyValue()));
        }
        this.visitController.replaceCurrentBlockChildWith(replacement, false);
        return false;
    }

    private CssPropertyValueNode reparseFont(CssPropertyValueNode n) {
        if (n.numChildren() == 0) {
            return n.deepCopy();
        }
        if (n.numChildren() == 1 && SYSTEM_FONTS.contains((Object)((CssValueNode)n.getChildAt(0)).getValue()) || INHERIT.equals(((CssValueNode)n.getChildAt(0)).getValue())) {
            return n.deepCopy();
        }
        if (n.numChildren() < 2) {
            if (this.mode == InputMode.CSS) {
                this.errorManager.report(new GssError(SIZE_AND_FAMILY_REQUIRED, FixupFontDeclarations.getSourceCodeLocation(n)));
            }
            return n.deepCopy();
        }
        Iterable preFamilyCandidates = Iterables.limit(n.childIterable(), (int)6);
        Iterable sizeLineHeights = Iterables.filter(this.extractByType(CssCompositeValueNode.class, preFamilyCandidates), (Predicate)FixupFontDeclarations.withOperator(CssCompositeValueNode.Operator.SLASH));
        Iterable plainSizes = StreamSupport.stream(preFamilyCandidates.spliterator(), false).filter(arg_0 -> IS_PLAIN_SIZE.apply(arg_0)).collect(Collectors.toList());
        Iterable lhSizes = StreamSupport.stream(sizeLineHeights.spliterator(), false).map(arg_0 -> EXTRACT_SIZE.apply(arg_0)).collect(Collectors.toList());
        Map<CssNode, Integer> lexicalOrder = EnumeratingVisitor.enumerate(this.tree);
        Iterable sizes = Iterables.concat((Iterable)plainSizes, (Iterable)lhSizes);
        if (!this.validateSplitPoint(FixupFontDeclarations.getSourceCodeLocation(n), lexicalOrder, sizeLineHeights, sizes)) {
            return n.deepCopy();
        }
        CssValueNode splitPoint = (CssValueNode)Iterables.getOnlyElement((Iterable)Iterables.concat((Iterable)sizeLineHeights, (Iterable)plainSizes));
        Iterable<CssValueNode> prefix = this.takeWhile(n.childIterable(), n12 -> ((Integer)lexicalOrder.get(n12)).compareTo((Integer)lexicalOrder.get(splitPoint)) < 0);
        CssPriorityNode priority = this.getPriority(n);
        Iterable<CssValueNode> families = this.dropWhile(this.takeUntil(n.childIterable(), priority), n1 -> ((Integer)lexicalOrder.get(splitPoint)).compareTo((Integer)lexicalOrder.get(n1)) < 0);
        Map<CssValueNode, FontProperty> properties = this.classifyNodes(prefix, sizes, sizeLineHeights);
        this.validatePrefix(prefix);
        this.validateProperties(prefix, properties);
        return this.rebuildFont(prefix, splitPoint, families, priority, properties, n);
    }

    private CssPriorityNode getPriority(CssPropertyValueNode n) {
        if (n.numChildren() < 1) {
            return null;
        }
        Object last = n.getChildAt(n.numChildren() - 1);
        if (last instanceof CssPriorityNode) {
            return (CssPriorityNode)last;
        }
        return null;
    }

    private <T> Iterable<T> takeUntil(Iterable<T> xs, T excludedEndpoint) {
        return this.takeWhile(xs, i -> excludedEndpoint != i);
    }

    private Map<CssValueNode, FontProperty> classifyNodes(Iterable<CssValueNode> prefix, Iterable<CssValueNode> sizes, Iterable<CssCompositeValueNode> sizeLineHeights) {
        HashMap properties = Maps.newHashMap();
        for (CssValueNode i : prefix) {
            if (DEFINITELY_STYLE.contains((Object)i.getValue())) {
                properties.put(i, FontProperty.STYLE);
                continue;
            }
            if (DEFINITELY_VARIANT.contains((Object)i.getValue())) {
                properties.put(i, FontProperty.VARIANT);
                continue;
            }
            if (!this.isWeight(i)) continue;
            properties.put(i, FontProperty.WEIGHT);
        }
        properties.put((CssValueNode)Iterables.getOnlyElement(sizes), FontProperty.SIZE);
        if (!Iterables.isEmpty(sizeLineHeights)) {
            properties.put(((CssCompositeValueNode)Iterables.getOnlyElement(sizeLineHeights)).getValues().get(1), FontProperty.LINE_HEIGHT);
        }
        return properties;
    }

    private boolean isWeight(CssValueNode n) {
        if (DEFINITELY_WEIGHT.contains((Object)n.getValue())) {
            return true;
        }
        if (!(n instanceof CssNumericNode)) {
            return false;
        }
        CssNumericNode numeric = (CssNumericNode)n;
        if (!"".equals(numeric.getUnit())) {
            return false;
        }
        return NUMERIC_WEIGHTS.contains((Object)numeric.getNumericPart());
    }

    private void validateSizeLineHeight(CssCompositeValueNode composite) {
        if (composite.getValues().size() != 2) {
            this.reportError((String)TOO_MANY.get((Object)FontProperty.LINE_HEIGHT), FixupFontDeclarations.getSourceCodeLocation(composite));
        }
    }

    private void reportError(String message, SourceCodeLocation location) {
        this.errorManager.report(new GssError(message, location));
    }

    private boolean validateSplitPoint(SourceCodeLocation loc, Map<CssNode, Integer> lexicalOrder, Iterable<CssCompositeValueNode> sizeLineHeights, Iterable<CssValueNode> sizes) {
        CssCompositeValueNode secondSLH = (CssCompositeValueNode)Iterables.get(sizeLineHeights, (int)1, null);
        if (secondSLH != null) {
            this.reportError((String)TOO_MANY.get((Object)FontProperty.LINE_HEIGHT), FixupFontDeclarations.getSourceCodeLocation(secondSLH));
            return false;
        }
        StreamSupport.stream(sizeLineHeights.spliterator(), false).filter(n -> n.getValues().size() != 2).findFirst().ifPresent(slashy -> this.reportError((String)TOO_MANY.get((Object)FontProperty.LINE_HEIGHT), FixupFontDeclarations.getSourceCodeLocation(slashy)));
        if (Iterables.isEmpty(sizes)) {
            if (this.mode == InputMode.CSS) {
                this.reportError(SIZE_AND_FAMILY_REQUIRED, loc);
            }
            return false;
        }
        if (Iterables.get(sizes, (int)1, null) != null) {
            this.reportError((String)TOO_MANY.get((Object)FontProperty.SIZE), FixupFontDeclarations.getSourceCodeLocation(this.max(sizes, Functions.forMap(lexicalOrder))));
            return false;
        }
        return true;
    }

    private void validatePrefix(Iterable<CssValueNode> prefix) {
        CssValueNode tooMuch = (CssValueNode)Iterables.get(prefix, (int)3, null);
        if (tooMuch != null) {
            this.reportError(TOO_MANY_PRE_SIZE, FixupFontDeclarations.getSourceCodeLocation(tooMuch));
        }
    }

    private void validateProperties(Iterable<CssValueNode> prefix, Map<CssValueNode, FontProperty> classified) {
        LinkedList normals = Lists.newLinkedList();
        for (CssValueNode i : prefix) {
            if (classified.containsKey(i) || !NORMAL.equals(i.getValue())) continue;
            normals.add(i);
        }
        if (normals.size() > 3) {
            this.errorManager.report(new GssError(TOO_MANY_NORMALS, FixupFontDeclarations.getSourceCodeLocation((CssNode)normals.get(normals.size() - 1))));
        }
        HashSet properties = Sets.newHashSet();
        for (Map.Entry<CssValueNode, FontProperty> p : classified.entrySet()) {
            if (properties.add(p.getValue())) continue;
            this.reportError((String)TOO_MANY.get((Object)p.getValue()), FixupFontDeclarations.getSourceCodeLocation(p.getKey()));
        }
        if (this.mode == InputMode.CSS) {
            StreamSupport.stream(prefix.spliterator(), false).filter(n -> !classified.containsKey(n) && !normals.contains(n)).findFirst().ifPresent(interloper -> this.reportError(PRE_SIZE_INTERLOPER_SIZE, FixupFontDeclarations.getSourceCodeLocation(interloper)));
        }
    }

    private CssPropertyValueNode rebuildFont(Iterable<CssValueNode> prefix, CssValueNode splitPoint, Iterable<CssValueNode> families, CssPriorityNode priority, Map<CssValueNode, FontProperty> properties, CssPropertyValueNode n) {
        TreeMap parts = Maps.newTreeMap();
        for (Map.Entry<CssValueNode, FontProperty> p : properties.entrySet()) {
            parts.put(p.getValue(), p.getKey());
        }
        ArrayList preFamily = Lists.newArrayList();
        Iterables.addAll((Collection)preFamily, prefix);
        if (parts.containsKey((Object)FontProperty.SIZE)) {
            preFamily.add((CssValueNode)parts.get((Object)FontProperty.SIZE));
        }
        if (parts.containsKey((Object)FontProperty.LINE_HEIGHT)) {
            CssValueNode lineHeight = (CssValueNode)parts.get((Object)FontProperty.LINE_HEIGHT);
            preFamily.add(new CssLiteralNode("/", FixupFontDeclarations.getSourceCodeLocation(lineHeight)));
            preFamily.add(lineHeight);
        }
        ImmutableList tail = Iterables.isEmpty(families) ? ImmutableList.of() : ImmutableList.of((Object)this.reparseFamilies(families, SourceCodeLocation.merge(families)));
        ImmutableList.Builder resultNodes = ImmutableList.builder();
        resultNodes.addAll(Iterables.concat((Iterable)preFamily, (Iterable)tail));
        if (priority != null) {
            resultNodes.add((Object)priority);
        }
        CssPropertyValueNode result = new CssPropertyValueNode((List<CssValueNode>)resultNodes.build());
        return result.deepCopy();
    }

    private CssCompositeValueNode reparseFamilies(Iterable<CssValueNode> families, SourceCodeLocation loc) {
        ArrayList alternatives = Lists.newArrayList();
        ArrayList commentsOnAlternatives = Lists.newArrayList();
        for (CssValueNode i : families) {
            if (i instanceof CssCompositeValueNode) {
                CssCompositeValueNode segment = (CssCompositeValueNode)i;
                if (segment.getValues().size() == 0) continue;
                CssValueNode first = (CssValueNode)Iterables.getFirst(segment.getValues(), null);
                this.collect(alternatives, first);
                Iterable rest = Iterables.skip(segment.getValues(), (int)1);
                Iterables.addAll((Collection)alternatives, (Iterable)rest);
                for (CssNode j : rest) {
                    commentsOnAlternatives.addAll(j.getComments());
                }
                continue;
            }
            this.collect(alternatives, i);
        }
        CssCompositeValueNode result = new CssCompositeValueNode(alternatives, CssCompositeValueNode.Operator.COMMA, loc);
        for (CssCommentNode c : commentsOnAlternatives) {
            result.appendComment(c);
        }
        return result;
    }

    private CssPropertyValueNode reparseFontFamily(CssPropertyValueNode n) {
        if (n.numChildren() == 0) {
            return n.deepCopy();
        }
        if (n.numChildren() == 1 && INHERIT.equals(((CssValueNode)n.getChildAt(0)).getValue())) {
            return n.deepCopy();
        }
        CssPriorityNode priority = this.getPriority(n);
        CssCompositeValueNode altNode = this.reparseFamilies(this.takeUntil(n.childIterable(), priority), FixupFontDeclarations.getSourceCodeLocation(n));
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)altNode);
        if (priority != null) {
            result.add((Object)priority);
        }
        return new CssPropertyValueNode((List<CssValueNode>)result.build());
    }

    private void collect(List<CssValueNode> alternatives, CssValueNode item) {
        if (this.isString(item)) {
            alternatives.add(item);
        } else {
            CssValueNode stump;
            if (!alternatives.isEmpty() && !this.isString(alternatives.get(alternatives.size() - 1))) {
                stump = alternatives.get(alternatives.size() - 1);
                stump.setValue(stump.getValue() + " ");
            } else {
                stump = new CssLiteralNode("", FixupFontDeclarations.getSourceCodeLocation(item));
                alternatives.add(stump);
            }
            stump.setValue(stump.getValue() + item.getValue());
            stump.setSourceCodeLocation(SourceCodeLocation.merge(stump.getSourceCodeLocation(), item.getSourceCodeLocation()));
            for (CssCommentNode c : item.getComments()) {
                stump.appendComment(c);
            }
        }
    }

    private boolean isString(CssValueNode n) {
        return n instanceof CssStringNode;
    }

    private static SourceCodeLocation getSourceCodeLocation(CssNode n) {
        return (n = (CssNode)StreamSupport.stream(n.ancestors().spliterator(), false).filter(n1 -> n1.getSourceCodeLocation() != null).findFirst().orElse(null)) != null ? n.getSourceCodeLocation() : new SourceCodeLocation(new SourceCode(null, "x"), 1, 1, 1, 1, 1, 1);
    }

    private <T> Iterable<T> takeWhile(final Iterable<T> xs, final Predicate<? super T> p) {
        return () -> new UnmodifiableIterator<T>(){
            boolean validT;
            final Iterator xsi;
            Object t;
            {
                this.xsi = xs.iterator();
                this.validT = false;
                this.next();
            }

            public boolean hasNext() {
                return this.validT;
            }

            public T next() {
                Object result = this.t;
                if (this.xsi.hasNext()) {
                    this.t = this.xsi.next();
                    this.validT = p.apply(this.t);
                } else {
                    this.validT = false;
                }
                return result;
            }
        };
    }

    private <T> Iterable<T> dropWhile(Iterable<T> xs, Predicate<? super T> p) {
        return () -> {
            PeekingIterator xsi = Iterators.peekingIterator(xs.iterator());
            while (xsi.hasNext() && !p.apply(xsi.peek())) {
                xsi.next();
            }
            return xsi;
        };
    }

    private <T, U extends Comparable<U>> T max(Iterable<T> xs, Function<? super T, U> f) {
        Object result = Iterables.getFirst(xs, null);
        Comparable extreme = (Comparable)f.apply(result);
        for (T x : xs) {
            Comparable u = (Comparable)f.apply(x);
            if (extreme.compareTo(u) >= 0) continue;
            result = x;
            extreme = u;
        }
        return (T)result;
    }

    private <T> Iterable<T> extractByType(Class<T> ct, Iterable<? super T> xs) {
        return Iterables.transform((Iterable)StreamSupport.stream(xs.spliterator(), false).filter(arg_0 -> ((Predicate)Predicates.instanceOf(ct)).apply(arg_0)).collect(Collectors.toList()), ct::cast);
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private static class WithOperator
    implements Predicate<CssCompositeValueNode> {
        private final CssCompositeValueNode.Operator op;

        public WithOperator(CssCompositeValueNode.Operator op) {
            this.op = op;
        }

        public boolean apply(CssCompositeValueNode n) {
            return n.getOperator() == this.op;
        }
    }

    public static enum FontProperty {
        STYLE,
        VARIANT,
        WEIGHT,
        SIZE,
        LINE_HEIGHT,
        FAMILY;

    }

    public static enum InputMode {
        CSS,
        GSS;

    }
}

