/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Set;

public class HandleUnknownAtRuleNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    static final String UNKNOWN_AT_RULE_ERROR_MESSAGE = "unknown @ rule";
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Set<String> additionalAtRules;
    private final boolean report;
    private final boolean remove;

    public HandleUnknownAtRuleNodes(MutatingVisitController visitController, ErrorManager errorManager, boolean report, boolean remove) {
        this(visitController, errorManager, (Set<String>)ImmutableSet.of(), report, remove);
    }

    public HandleUnknownAtRuleNodes(MutatingVisitController visitController, ErrorManager errorManager, Set<String> additionalAtRules, boolean report, boolean remove) {
        Preconditions.checkArgument((!report || errorManager != null ? 1 : 0) != 0);
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.additionalAtRules = additionalAtRules;
        this.report = report;
        this.remove = remove;
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.isOkWithoutProcessing() || this.additionalAtRules.contains(node.getName().getValue())) {
            return true;
        }
        if (this.report) {
            this.errorManager.report(new GssError(UNKNOWN_AT_RULE_ERROR_MESSAGE, node.getSourceCodeLocation()));
        }
        if (this.remove) {
            this.visitController.removeCurrentNode();
            return false;
        }
        return true;
    }

    @Override
    public void runPass() {
        if (this.report || this.remove) {
            this.visitController.startVisit(this);
        }
    }
}

