/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssForLoopRuleNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssLoopVariableNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class LoopVariableReplacementPass
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final String variable;
    private final int value;
    private final Set<String> loopDefinitions;
    private final MutatingVisitController visitController;
    private final int loopId;
    private final Pattern variableInNthArgumentPattern;

    public LoopVariableReplacementPass(String variable, int value, Set<String> loopDefinitions, MutatingVisitController visitController, int loopId) {
        this.variable = variable;
        this.value = value;
        this.loopDefinitions = loopDefinitions;
        this.visitController = visitController;
        this.loopId = loopId;
        this.variableInNthArgumentPattern = Pattern.compile("\\s*[-+]?" + Pattern.quote(variable) + "n?\\s*");
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        CssNumericNode newNode = this.updateValueNode(node);
        if (newNode != null) {
            this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), true);
        }
        return true;
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode classSelector) {
        Object[] parts = classSelector.getRefinerName().split("-");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.replaceVariable((String)parts[i]);
        }
        String refinerName = Joiner.on((String)"-").join(parts);
        if (!refinerName.equals(classSelector.getRefinerName())) {
            this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)new CssClassSelectorNode(refinerName, classSelector.getScoping(), classSelector.getSourceCodeLocation())), true);
        }
        return true;
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        CssNumericNode newNode = this.updateValueNode(node);
        if (newNode != null) {
            this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), true);
        }
        return true;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        CssLiteralNode definitionName = node.getName();
        definitionName.setValue(this.replaceDefinition(definitionName.getValue()));
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode refiner) {
        if (refiner.getFunctionType().equals((Object)CssPseudoClassNode.FunctionType.NTH)) {
            Object[] parts = refiner.getArgument().split("\\+");
            for (int i = 0; i < parts.length; ++i) {
                if (!this.variableInNthArgumentPattern.matcher(parts[i]).matches()) continue;
                parts[i] = ((String)parts[i]).replaceFirst(Pattern.quote(this.variable), String.valueOf(this.value));
            }
            refiner.setArgument(Joiner.on((String)"+").join(parts));
        }
        return true;
    }

    @Override
    public boolean enterForLoop(CssForLoopRuleNode node) {
        CssNumericNode step;
        CssNumericNode to;
        CssNumericNode from = this.updateValueNode(node.getFrom());
        if (from != null) {
            node.setFrom(from);
        }
        if ((to = this.updateValueNode(node.getTo())) != null) {
            node.setTo(to);
        }
        if ((step = this.updateValueNode(node.getStep())) != null) {
            node.setStep(step);
        }
        return true;
    }

    @Nullable
    private CssNumericNode updateValueNode(CssValueNode node) {
        CssLoopVariableNode variableNode;
        if (node instanceof CssConstantReferenceNode) {
            if (this.loopDefinitions.contains(node.getValue())) {
                node.setValue(this.replaceDefinition(node.getValue()));
            }
        } else if (node instanceof CssLoopVariableNode && this.needsReplacement((variableNode = (CssLoopVariableNode)node).getValue())) {
            return new CssNumericNode(String.valueOf(this.value), "", node.getSourceCodeLocation());
        }
        return null;
    }

    private boolean needsReplacement(String identifier) {
        return identifier.equals(this.variable);
    }

    private String replaceVariable(String identifier) {
        return this.needsReplacement(identifier) ? String.valueOf(this.value) : identifier;
    }

    private String replaceDefinition(String definiton) {
        return definiton + "__LOOP" + this.loopId + "__" + this.value;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

