/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.ChunkAware;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import java.util.Map;

public class MapChunkAwareNodesToChunk<T>
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final CssTree tree;
    private final Map<String, T> fileToChunk;

    public MapChunkAwareNodesToChunk(CssTree tree, Map<String, T> fileToChunk) {
        this.tree = tree;
        this.fileToChunk = fileToChunk;
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode definition) {
        definition.setChunk(this.getChunk(definition));
        return true;
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        selector.setChunk(this.getChunk(selector));
        return true;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode function) {
        function.setChunk(this.getChunk(function));
        return true;
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode media) {
        media.setChunk(this.getChunk(media));
        return true;
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode keyframes) {
        keyframes.setChunk(this.getChunk(keyframes));
        return true;
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode fontFaceNode) {
        fontFaceNode.setChunk(this.getChunk(fontFaceNode));
        return true;
    }

    private <N extends CssNode> T getChunk(N node) {
        Object chunk = ((ChunkAware)((Object)node)).getChunk();
        if (chunk == null) {
            chunk = MapChunkAwareNodesToChunk.getChunk(node, this.fileToChunk);
        }
        return (T)chunk;
    }

    @Override
    public void runPass() {
        this.tree.getVisitController().startVisit(this);
    }

    static <T> T getChunk(CssNode node, Map<String, T> fileToChunk) {
        String file = node.getSourceCodeLocation().getSourceCode().getFileName();
        T chunk = fileToChunk.get(file);
        Preconditions.checkNotNull(chunk, (String)"File '%s' does not have chunk mapping", (Object)file);
        return chunk;
    }
}

