/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssPriorityNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.SkippingTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.PassUtil;
import java.util.Set;
import java.util.stream.StreamSupport;

public class MarkRemovableRulesetNodes
extends SkippingTreeVisitor
implements CssCompilerPass {
    private final CssTree tree;
    private final VisitController visitController;
    static final ImmutableSet<String> PROPERTIES_NOT_TO_BE_CHECKED = ImmutableSet.of((Object)"display", (Object)"cursor");
    private Set<String> referencedRules = null;
    private String prefixOfReferencedRules = "";

    public MarkRemovableRulesetNodes(CssTree tree) {
        this(tree, false);
    }

    public MarkRemovableRulesetNodes(CssTree tree, boolean skipping) {
        super(skipping);
        this.tree = tree;
        this.visitController = tree.getVisitController();
    }

    public void setReferencedRules(Set<String> referencedRules, String prefixOfReferencedRules) {
        this.referencedRules = referencedRules;
        this.prefixOfReferencedRules = prefixOfReferencedRules;
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        HashBasedTable rules = HashBasedTable.create();
        for (int i = block.numChildren() - 1; i >= 0; --i) {
            if (!(block.getChildAt(i) instanceof CssRulesetNode)) continue;
            CssRulesetNode ruleset = (CssRulesetNode)block.getChildAt(i);
            if (this.referencedRules != null && !this.referencedRules.isEmpty() && this.isSelectorUnreferenced((CssSelectorNode)ruleset.getSelectors().getChildAt(0))) {
                this.tree.getRulesetNodesToRemove().addRulesetNode(ruleset);
                continue;
            }
            if (!this.canModifyRuleset(ruleset)) continue;
            Preconditions.checkArgument((this.isSkipping() || ruleset.getSelectors().numChildren() == 1 ? 1 : 0) != 0);
            this.processRuleset((Table<String, String, CssRulesetNode>)rules, ruleset);
        }
        return false;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private void processRuleset(Table<String, String, CssRulesetNode> rules, CssRulesetNode ruleset) {
        String selector;
        CssRulesetNode previousRuleset;
        if (this.referencedRules != null && !this.referencedRules.isEmpty() && this.isSelectorUnreferenced((CssSelectorNode)ruleset.getSelectors().getChildAt(0))) {
            this.tree.getRulesetNodesToRemove().addRulesetNode(ruleset);
            return;
        }
        Preconditions.checkArgument((ruleset.getDeclarations().numChildren() == 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(ruleset.getDeclarations().getChildAt(0) instanceof CssDeclarationNode));
        CssDeclarationNode declaration = (CssDeclarationNode)ruleset.getDeclarations().getChildAt(0);
        CssPropertyNode propertyNode = declaration.getPropertyName();
        String propertyName = propertyNode.getPropertyName();
        if (PROPERTIES_NOT_TO_BE_CHECKED.contains((Object)propertyName)) {
            return;
        }
        if (declaration.hasStarHack()) {
            propertyName = "*" + propertyName;
        }
        if ((previousRuleset = (CssRulesetNode)rules.get((Object)(selector = PassUtil.printSelector((CssSelectorNode)ruleset.getSelectors().getChildAt(0))), (Object)propertyName)) != null) {
            if (this.isImportantRule(ruleset) && !this.isImportantRule(previousRuleset)) {
                this.tree.getRulesetNodesToRemove().addRulesetNode(previousRuleset);
                rules.put((Object)selector, (Object)propertyName, (Object)ruleset);
            } else {
                this.tree.getRulesetNodesToRemove().addRulesetNode(ruleset);
            }
        } else if (this.hasOverridingShorthand(propertyNode, selector, rules, ruleset)) {
            this.tree.getRulesetNodesToRemove().addRulesetNode(ruleset);
        } else if (!PassUtil.hasAlternateAnnotation(declaration)) {
            rules.put((Object)selector, (Object)propertyName, (Object)ruleset);
        }
    }

    private boolean isSelectorUnreferenced(CssSelectorNode selector) {
        return this.okToRemoveSelector(selector) && (this.atLeastOneUnreferencedRefiner(selector) || this.unreferencedSelectorCombinator(selector));
    }

    private boolean okToRemoveSelector(CssSelectorNode selector) {
        return selector.getSelectorName() == null || !selector.getRefiners().isEmpty() || selector.getCombinator() != null;
    }

    private boolean atLeastOneUnreferencedRefiner(CssSelectorNode selector) {
        for (CssRefinerNode ref : selector.getRefiners().childIterable()) {
            String refiner;
            if (!(ref instanceof CssClassSelectorNode) || !(refiner = ref.getRefinerName()).startsWith(this.prefixOfReferencedRules) || !this.isRefinerUnreferenced(refiner)) continue;
            return true;
        }
        return false;
    }

    private boolean unreferencedSelectorCombinator(CssSelectorNode selector) {
        return selector.getCombinator() != null && this.isSelectorUnreferenced(selector.getCombinator().getSelector());
    }

    private boolean isRefinerUnreferenced(String refiner) {
        String[] splits;
        for (String s : splits = refiner.split("-")) {
            if (this.referencedRules.contains(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isImportantRule(CssRulesetNode ruleset) {
        CssDeclarationNode decl = (CssDeclarationNode)ruleset.getDeclarations().getChildAt(0);
        Iterable propertyValues = decl.getPropertyValue().childIterable();
        return StreamSupport.stream(propertyValues.spliterator(), false).anyMatch(arg_0 -> ((Predicate)Predicates.instanceOf(CssPriorityNode.class)).apply(arg_0));
    }

    private boolean hasOverridingShorthand(CssPropertyNode propertyNode, String selector, Table<String, String, CssRulesetNode> rules, CssRulesetNode ruleset) {
        java.util.function.Supplier<Boolean> rulesetIsImportant = () -> ((Supplier)Suppliers.memoize(() -> this.isImportantRule(ruleset))).get();
        for (String shorthand : propertyNode.getProperty().getShorthands()) {
            CssRulesetNode shorthandRuleset = (CssRulesetNode)rules.get((Object)selector, (Object)shorthand);
            if (shorthandRuleset == null || rulesetIsImportant.get().booleanValue() && !this.isImportantRule(shorthandRuleset)) continue;
            return true;
        }
        return false;
    }
}

