/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.css.JobDescription;
import com.google.common.css.PrefixingSubstitutionMap;
import com.google.common.css.RecordingSubstitutionMap;
import com.google.common.css.SubstitutionMap;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssFunction;
import com.google.common.css.compiler.passes.AbbreviatePositionalValues;
import com.google.common.css.compiler.passes.BiDiFlipper;
import com.google.common.css.compiler.passes.CheckDependencyNodes;
import com.google.common.css.compiler.passes.CollectConstantDefinitions;
import com.google.common.css.compiler.passes.CollectMixinDefinitions;
import com.google.common.css.compiler.passes.ColorValueOptimizer;
import com.google.common.css.compiler.passes.CreateComponentNodes;
import com.google.common.css.compiler.passes.CreateConditionalNodes;
import com.google.common.css.compiler.passes.CreateConstantReferences;
import com.google.common.css.compiler.passes.CreateDefinitionNodes;
import com.google.common.css.compiler.passes.CreateForLoopNodes;
import com.google.common.css.compiler.passes.CreateMixins;
import com.google.common.css.compiler.passes.CreateStandardAtRuleNodes;
import com.google.common.css.compiler.passes.CreateVendorPrefixedKeyframes;
import com.google.common.css.compiler.passes.CssClassRenaming;
import com.google.common.css.compiler.passes.DisallowDuplicateDeclarations;
import com.google.common.css.compiler.passes.EliminateConditionalNodes;
import com.google.common.css.compiler.passes.EliminateEmptyRulesetNodes;
import com.google.common.css.compiler.passes.EliminateUnitsFromZeroNumericValues;
import com.google.common.css.compiler.passes.EliminateUselessRulesetNodes;
import com.google.common.css.compiler.passes.EvaluateCompileConstants;
import com.google.common.css.compiler.passes.HandleUnknownAtRuleNodes;
import com.google.common.css.compiler.passes.MarkNonFlippableNodes;
import com.google.common.css.compiler.passes.MarkRemovableRulesetNodes;
import com.google.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameDeclarations;
import com.google.common.css.compiler.passes.MergeAdjacentRulesetNodesWithSameSelector;
import com.google.common.css.compiler.passes.ProcessComponents;
import com.google.common.css.compiler.passes.ProcessKeyframes;
import com.google.common.css.compiler.passes.ProcessRefiners;
import com.google.common.css.compiler.passes.RemoveVendorSpecificProperties;
import com.google.common.css.compiler.passes.ReplaceConstantReferences;
import com.google.common.css.compiler.passes.ReplaceMixins;
import com.google.common.css.compiler.passes.ResolveCustomFunctionNodes;
import com.google.common.css.compiler.passes.SplitRulesetNodes;
import com.google.common.css.compiler.passes.UnrollLoops;
import com.google.common.css.compiler.passes.ValidatePropertyValues;
import com.google.common.css.compiler.passes.VerifyRecognizedProperties;
import com.google.common.css.compiler.passes.WarnOnCustomProperty;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class PassRunner {
    private static final ImmutableMap<String, GssFunction> EMPTY_GSS_FUNCTION_MAP = ImmutableMap.of();
    private final JobDescription job;
    private final ErrorManager errorManager;
    private final RecordingSubstitutionMap recordingSubstitutionMap;

    public PassRunner(JobDescription job, ErrorManager errorManager) {
        this(job, errorManager, PassRunner.createSubstitutionMap(job));
    }

    public PassRunner(JobDescription job, ErrorManager errorManager, RecordingSubstitutionMap recordingSubstitutionMap) {
        this.job = job;
        this.errorManager = errorManager;
        this.recordingSubstitutionMap = recordingSubstitutionMap;
    }

    public void runPasses(CssTree cssTree) {
        new CheckDependencyNodes(cssTree.getMutatingVisitController(), this.errorManager, this.job.suppressDependencyCheck).runPass();
        new CreateStandardAtRuleNodes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new CreateMixins(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new CreateDefinitionNodes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new CreateConstantReferences(cssTree.getMutatingVisitController()).runPass();
        new CreateConditionalNodes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new CreateForLoopNodes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new CreateComponentNodes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new ValidatePropertyValues(cssTree.getVisitController(), this.errorManager).runPass();
        new WarnOnCustomProperty(cssTree.getVisitController(), this.errorManager).runPass();
        new HandleUnknownAtRuleNodes(cssTree.getMutatingVisitController(), this.errorManager, (Set<String>)this.job.allowedAtRules, true, false).runPass();
        new ProcessKeyframes(cssTree.getMutatingVisitController(), this.errorManager, this.job.allowKeyframes || this.job.allowWebkitKeyframes, this.job.simplifyCss).runPass();
        new CreateVendorPrefixedKeyframes(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new EvaluateCompileConstants(cssTree.getMutatingVisitController(), this.job.compileConstants).runPass();
        new UnrollLoops(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        new ProcessRefiners(cssTree.getMutatingVisitController(), this.errorManager, this.job.simplifyCss).runPass();
        new EliminateConditionalNodes(cssTree.getMutatingVisitController(), (Set<String>)ImmutableSet.copyOf(this.job.trueConditionNames)).runPass();
        CollectMixinDefinitions collectMixinDefinitions = new CollectMixinDefinitions(cssTree.getMutatingVisitController(), this.errorManager);
        collectMixinDefinitions.runPass();
        new ReplaceMixins(cssTree.getMutatingVisitController(), this.errorManager, collectMixinDefinitions.getDefinitions()).runPass();
        new ProcessComponents(cssTree.getMutatingVisitController(), this.errorManager).runPass();
        CollectConstantDefinitions collectConstantDefinitionsPass = new CollectConstantDefinitions(cssTree);
        collectConstantDefinitionsPass.runPass();
        ReplaceConstantReferences replaceConstantReferences = new ReplaceConstantReferences(cssTree, collectConstantDefinitionsPass.getConstantDefinitions(), true, this.errorManager, this.job.allowUndefinedConstants);
        replaceConstantReferences.runPass();
        Map<String, GssFunction> gssFunctionMap = this.getGssFunctionMap();
        new ResolveCustomFunctionNodes(cssTree.getMutatingVisitController(), this.errorManager, gssFunctionMap, this.job.allowUnrecognizedFunctions, this.job.allowedNonStandardFunctions).runPass();
        if (this.job.simplifyCss) {
            new EliminateEmptyRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new EliminateUnitsFromZeroNumericValues(cssTree.getMutatingVisitController()).runPass();
            new ColorValueOptimizer(cssTree.getMutatingVisitController()).runPass();
            new AbbreviatePositionalValues(cssTree.getMutatingVisitController()).runPass();
        }
        if (this.job.eliminateDeadStyles) {
            new DisallowDuplicateDeclarations(cssTree.getVisitController(), this.errorManager).runPass();
            new SplitRulesetNodes(cssTree.getMutatingVisitController()).runPass();
            new MarkRemovableRulesetNodes(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameSelector(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
            new MergeAdjacentRulesetNodesWithSameDeclarations(cssTree).runPass();
            new EliminateUselessRulesetNodes(cssTree).runPass();
        }
        if (this.job.needsBiDiFlipping()) {
            new MarkNonFlippableNodes(cssTree.getVisitController(), this.errorManager).runPass();
            new BiDiFlipper(cssTree.getMutatingVisitController(), this.job.swapLtrRtlInUrl, this.job.swapLeftRightInUrl).runPass();
        }
        if (this.job.vendor != null) {
            new RemoveVendorSpecificProperties(this.job.vendor, cssTree.getMutatingVisitController()).runPass();
        }
        if (!this.job.allowUnrecognizedProperties) {
            new VerifyRecognizedProperties(this.job.allowedUnrecognizedProperties, cssTree.getVisitController(), this.errorManager).runPass();
        }
        if (this.recordingSubstitutionMap != null) {
            new CssClassRenaming(cssTree.getMutatingVisitController(), this.recordingSubstitutionMap, null).runPass();
        }
    }

    @Nullable
    public RecordingSubstitutionMap getRecordingSubstitutionMap() {
        return this.recordingSubstitutionMap;
    }

    private static RecordingSubstitutionMap createSubstitutionMap(JobDescription job) {
        SubstitutionMap baseMap;
        if (job.cssSubstitutionMapProvider != null && (baseMap = job.cssSubstitutionMapProvider.get()) != null) {
            SubstitutionMap map = baseMap;
            if (!job.cssRenamingPrefix.isEmpty()) {
                map = new PrefixingSubstitutionMap(baseMap, job.cssRenamingPrefix);
            }
            RecordingSubstitutionMap recording = new RecordingSubstitutionMap.Builder().withSubstitutionMap(map).shouldRecordMappingForCodeGeneration((Predicate<? super String>)Predicates.not((Predicate)Predicates.in(job.excludedClassesFromRenaming))).build();
            recording.initializeWithMappings(job.inputRenamingMap);
            return recording;
        }
        return null;
    }

    private Map<String, GssFunction> getGssFunctionMap() {
        if (this.job.gssFunctionMapProvider == null) {
            return EMPTY_GSS_FUNCTION_MAP;
        }
        Map<String, GssFunction> map = this.job.gssFunctionMapProvider.get(GssFunction.class);
        if (map == null) {
            return EMPTY_GSS_FUNCTION_MAP;
        }
        return map;
    }
}

