/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.css.compiler.ast.CssAtRuleNode;
import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssCharSetNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssCommentNode;
import com.google.common.css.compiler.ast.CssComponentNode;
import com.google.common.css.compiler.ast.CssCompositeValueNode;
import com.google.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.common.css.compiler.ast.CssDeclarationBlockNode;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFontFaceNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssIdSelectorNode;
import com.google.common.css.compiler.ast.CssImportRuleNode;
import com.google.common.css.compiler.ast.CssKeyListNode;
import com.google.common.css.compiler.ast.CssKeyNode;
import com.google.common.css.compiler.ast.CssKeyframeRulesetNode;
import com.google.common.css.compiler.ast.CssKeyframesNode;
import com.google.common.css.compiler.ast.CssMediaRuleNode;
import com.google.common.css.compiler.ast.CssMixinDefinitionNode;
import com.google.common.css.compiler.ast.CssMixinNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssPageRuleNode;
import com.google.common.css.compiler.ast.CssPageSelectorNode;
import com.google.common.css.compiler.ast.CssPropertyValueNode;
import com.google.common.css.compiler.ast.CssProvideNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.CssRequireNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorListNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssStringNode;
import com.google.common.css.compiler.ast.CssUnknownAtRuleNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.passes.CodeBuffer;
import java.util.List;
import javax.annotation.Nullable;

public class PrettyPrintingVisitor
extends DefaultTreeVisitor {
    private final CodeBuffer buffer;
    private final boolean stripQuotes;
    private final boolean preserveComments;
    private String indent = "";

    public PrettyPrintingVisitor(@Nullable CodeBuffer buffer, boolean stripQuotes, boolean preserveComments) {
        this.buffer = (CodeBuffer)Preconditions.checkNotNull((Object)buffer);
        this.stripQuotes = stripQuotes;
        this.preserveComments = preserveComments;
    }

    @Override
    public boolean enterImportRule(CssImportRuleNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            if (param instanceof CssStringNode) {
                CssStringNode n = (CssStringNode)param;
                this.buffer.append(n.toString(CssStringNode.SHORT_ESCAPER));
                continue;
            }
            this.buffer.append(param.getValue());
        }
        return true;
    }

    @Override
    public void leaveImportRule(CssImportRuleNode node) {
        this.buffer.append(';').startNewLine();
    }

    @Override
    public boolean enterMediaRule(CssMediaRuleNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        if (!node.getParameters().isEmpty() || node.getType().hasBlock() && node.getBlock() != null) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterPageRule(CssPageRuleNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        this.buffer.append(' ');
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(param.getValue());
        }
        if (node.getParametersCount() > 0) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterPageSelector(CssPageSelectorNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            this.buffer.append(param.getValue());
        }
        return true;
    }

    @Override
    public boolean enterFontFace(CssFontFaceNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        return true;
    }

    @Override
    public boolean enterCharSet(CssCharSetNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getType().toString());
        this.buffer.append(' ');
        List<CssValueNode> parameters = node.getParameters();
        if (!parameters.isEmpty()) {
            this.buffer.append(parameters.get(0));
        }
        return true;
    }

    @Override
    public void leaveCharSet(CssCharSetNode node) {
        this.buffer.append(';');
    }

    @Override
    public boolean enterDefinition(CssDefinitionNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(this.indent);
        this.buffer.append((Object)node.getType());
        this.buffer.append(' ');
        this.buffer.append(node.getName());
        this.buffer.append(' ');
        return true;
    }

    @Override
    public void leaveDefinition(CssDefinitionNode node) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(';').startNewLine();
    }

    @Override
    public boolean enterRuleset(CssRulesetNode ruleset) {
        this.maybeAppendComments(ruleset);
        this.buffer.append(this.indent);
        return true;
    }

    @Override
    public boolean enterKeyframeRuleset(CssKeyframeRulesetNode ruleset) {
        this.maybeAppendComments(ruleset);
        this.buffer.append(this.indent);
        return true;
    }

    @Override
    public boolean enterDeclarationBlock(CssDeclarationBlockNode block) {
        this.maybeAppendComments(block);
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(" {").startNewLine();
        this.indent = this.indent + "  ";
        return true;
    }

    @Override
    public void leaveDeclarationBlock(CssDeclarationBlockNode block) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.buffer.append(this.indent);
        this.buffer.append('}').startNewLine();
    }

    @Override
    public boolean enterBlock(CssBlockNode block) {
        this.maybeAppendComments(block);
        if (block.getParent() instanceof CssUnknownAtRuleNode || block.getParent() instanceof CssMediaRuleNode) {
            this.buffer.append('{').startNewLine();
            this.indent = this.indent + "  ";
        }
        return true;
    }

    @Override
    public void leaveBlock(CssBlockNode block) {
        if (block.getParent() instanceof CssMediaRuleNode) {
            this.buffer.append('}').startNewLine();
            this.indent = this.indent.substring(0, this.indent.length() - 2);
        }
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        this.maybeAppendComments(declaration);
        this.buffer.append(this.indent);
        if (declaration.hasStarHack()) {
            this.buffer.append('*');
        }
        this.buffer.append(declaration.getPropertyName().getValue());
        this.buffer.append(": ");
        return true;
    }

    @Override
    public void leaveDeclaration(CssDeclarationNode declaration) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(';').startNewLine();
    }

    @Override
    public boolean enterValueNode(CssValueNode node) {
        this.maybeAppendComments(node);
        Preconditions.checkArgument((!(node instanceof CssCompositeValueNode) ? 1 : 0) != 0);
        String v = node.toString();
        if (this.stripQuotes && node.getParent() instanceof CssDefinitionNode) {
            v = this.maybeStripQuotes(v);
        }
        this.buffer.append(v);
        if (!node.inFunArgs()) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterCompositeValueNodeOperator(CssCompositeValueNode parent) {
        this.maybeAppendComments(parent);
        this.buffer.append(parent.getOperator().getOperatorName());
        if (!parent.inFunArgs()) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getFunctionName());
        this.buffer.append('(');
        return true;
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode node) {
        this.buffer.deleteLastCharIfCharIs(' ');
        this.buffer.append(") ");
    }

    @Override
    public boolean enterArgumentNode(CssValueNode node) {
        this.maybeAppendComments(node);
        String v = node.toString();
        if (this.stripQuotes && node.getParent().getParent() instanceof CssFunctionNode && ((CssFunctionNode)node.getParent().getParent()).getFunctionName().equals("url")) {
            v = this.maybeStripQuotes(v);
        }
        this.buffer.append(v);
        return !(node instanceof CssCompositeValueNode);
    }

    @Override
    public boolean enterSelector(CssSelectorNode selector) {
        this.maybeAppendComments(selector);
        String name = selector.getSelectorName();
        if (name != null) {
            this.buffer.append(name);
        }
        return true;
    }

    @Override
    public void leaveSelector(CssSelectorNode selector) {
        this.buffer.append(", ");
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        this.maybeAppendComments(node);
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterIdSelector(CssIdSelectorNode node) {
        this.maybeAppendComments(node);
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getRefinerName());
        switch (node.getFunctionType()) {
            case NTH: {
                this.buffer.append(node.getArgument().replace(" ", ""));
                this.buffer.append(')');
                break;
            }
            case LANG: {
                this.buffer.append(node.getArgument());
                this.buffer.append(')');
            }
        }
        return true;
    }

    @Override
    public void leavePseudoClass(CssPseudoClassNode node) {
        if (node.getFunctionType() == CssPseudoClassNode.FunctionType.NOT) {
            this.buffer.deleteEndingIfEndingIs(", ");
            this.buffer.append(')');
        }
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        this.maybeAppendComments(node);
        this.appendRefiner(node);
        return true;
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getAttributeName());
        this.buffer.append(node.getMatchSymbol());
        this.buffer.append(node.getValue());
        this.buffer.append(node.getSuffix());
        return true;
    }

    private void appendRefiner(CssRefinerNode node) {
        this.buffer.append(node.getPrefix());
        this.buffer.append(node.getRefinerName());
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (combinator != null) {
            this.maybeAppendComments(combinator);
            this.buffer.append(combinator.getCombinatorType().getCanonicalName());
        }
        return true;
    }

    @Override
    public void leaveCombinator(CssCombinatorNode combinator) {
        this.buffer.deleteEndingIfEndingIs(", ");
    }

    @Override
    public void leaveSelectorBlock(CssSelectorListNode node) {
        this.buffer.deleteEndingIfEndingIs(", ");
    }

    @Override
    public void leaveConditionalBlock(CssConditionalBlockNode block) {
        this.buffer.startNewLine();
    }

    @Override
    public boolean enterConditionalRule(CssConditionalRuleNode node) {
        this.maybeAppendComments(node);
        if (node.getType() != CssAtRuleNode.Type.IF) {
            this.buffer.append(' ');
        } else {
            this.buffer.append(this.indent);
        }
        this.buffer.append((Object)node.getType());
        if (node.getParametersCount() > 0) {
            this.buffer.append(' ');
            boolean firstParameter = true;
            for (CssValueNode value : node.getParameters()) {
                if (!firstParameter) {
                    this.buffer.append(' ');
                }
                firstParameter = false;
                this.buffer.append(value.toString());
            }
        }
        this.buffer.append(" {").startNewLine();
        this.indent = this.indent + "  ";
        return true;
    }

    @Override
    public void leaveConditionalRule(CssConditionalRuleNode node) {
        this.indent = this.indent.substring(0, this.indent.length() - 2);
        this.buffer.append(this.indent);
        this.buffer.append('}');
    }

    @Override
    public boolean enterUnknownAtRule(CssUnknownAtRuleNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(this.indent);
        this.buffer.append('@').append(node.getName().toString());
        if (node.getParameters().size() > 0 || node.getType().hasBlock() && node.getBlock() != null) {
            this.buffer.append(' ');
        }
        return true;
    }

    @Override
    public void leaveUnknownAtRule(CssUnknownAtRuleNode node) {
        if (node.getType().hasBlock()) {
            if (!(node.getBlock() instanceof CssDeclarationBlockNode)) {
                this.indent = this.indent.substring(0, this.indent.length() - 2);
                this.buffer.append(this.indent);
                this.buffer.append('}').startNewLine();
            }
        } else {
            this.buffer.deleteLastCharIfCharIs(' ');
            this.buffer.append(';').startNewLine();
        }
    }

    @Override
    public boolean enterKeyframesRule(CssKeyframesNode node) {
        this.maybeAppendComments(node);
        this.buffer.append(this.indent);
        this.buffer.append('@').append(node.getName().toString());
        for (CssValueNode param : node.getParameters()) {
            this.buffer.append(' ');
            this.buffer.append(param.getValue());
        }
        if (node.getType().hasBlock()) {
            this.buffer.append(" {").startNewLine();
            this.indent = this.indent + "  ";
        }
        return true;
    }

    @Override
    public void leaveKeyframesRule(CssKeyframesNode node) {
        if (node.getType().hasBlock()) {
            this.indent = this.indent.substring(0, this.indent.length() - 2);
            this.buffer.append(this.indent);
            this.buffer.append('}').startNewLine();
        } else {
            this.buffer.append(';').startNewLine();
        }
    }

    @Override
    public boolean enterKey(CssKeyNode key) {
        this.maybeAppendComments(key);
        String value = key.getKeyValue();
        if (value != null) {
            this.buffer.append(value);
        }
        return true;
    }

    @Override
    public void leaveKey(CssKeyNode key) {
        this.buffer.append(", ");
    }

    @Override
    public void leaveKeyBlock(CssKeyListNode node) {
        this.buffer.deleteEndingIfEndingIs(", ");
    }

    @Override
    public boolean enterProvideNode(CssProvideNode node) {
        this.maybeAppendComments(node);
        return true;
    }

    @Override
    public boolean enterRequireNode(CssRequireNode node) {
        this.maybeAppendComments(node);
        return true;
    }

    @Override
    public boolean enterComponent(CssComponentNode node) {
        this.maybeAppendComments(node);
        return true;
    }

    @Override
    public boolean enterMixin(CssMixinNode node) {
        this.maybeAppendComments(node);
        return true;
    }

    @Override
    public boolean enterConditionalBlock(CssConditionalBlockNode block) {
        this.maybeAppendComments(block);
        return true;
    }

    @Override
    public boolean enterMixinDefinition(CssMixinDefinitionNode node) {
        this.maybeAppendComments(node);
        return true;
    }

    @Override
    public boolean enterCompositeValueNode(CssCompositeValueNode value) {
        this.maybeAppendComments(value);
        if (value.hasParenthesis()) {
            this.buffer.append('(');
        }
        return true;
    }

    @Override
    public void leaveCompositeValueNode(CssCompositeValueNode value) {
        if (value.hasParenthesis()) {
            this.buffer.append(')');
        }
    }

    @Override
    public boolean enterPropertyValue(CssPropertyValueNode propertyValue) {
        this.maybeAppendComments(propertyValue);
        return true;
    }

    @Override
    public boolean enterTree(CssRootNode root) {
        this.maybeAppendComments(root);
        return true;
    }

    private void maybeAppendComments(CssNode node) {
        if (this.preserveComments && !node.getComments().isEmpty()) {
            for (CssCommentNode c : node.getComments()) {
                this.buffer.append(this.indent);
                this.buffer.append(c.getValue());
                this.buffer.startNewLine();
            }
        }
    }

    private String maybeStripQuotes(String v) {
        if (v.startsWith("'") || v.startsWith("\"")) {
            assert (v.endsWith(v.substring(0, 1)));
            v = v.substring(1, v.length() - 1);
        }
        return v;
    }
}

