/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.css.SourceCode;
import com.google.common.css.SourceCodeLocation;
import com.google.common.css.compiler.ast.CssBlockNode;
import com.google.common.css.compiler.ast.CssClassSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssComponentNode;
import com.google.common.css.compiler.ast.CssConstantReferenceNode;
import com.google.common.css.compiler.ast.CssDefinitionNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssLiteralNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssProvideNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssRootNode;
import com.google.common.css.compiler.ast.CssRulesetNode;
import com.google.common.css.compiler.ast.CssSelectorNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.passes.MapChunkAwareNodesToChunk;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class ProcessComponents<T>
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String CLASS_SEP = "-";
    private static final String DEF_SEP = "__";
    private final Map<String, CssComponentNode> components = Maps.newHashMap();
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final Map<String, T> fileToChunk;
    private final List<CssProvideNode> provideNodes = Lists.newArrayList();
    private SourceCode lastFile = null;

    public ProcessComponents(MutatingVisitController visitController, ErrorManager errorManager) {
        this(visitController, errorManager, null);
    }

    public ProcessComponents(MutatingVisitController visitController, ErrorManager errorManager, @Nullable Map<String, T> fileToChunk) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.fileToChunk = fileToChunk;
    }

    @Override
    public boolean enterProvideNode(CssProvideNode node) {
        SourceCode sourceCode = node.getSourceCodeLocation().getSourceCode();
        if (sourceCode != this.lastFile) {
            this.provideNodes.clear();
            this.lastFile = sourceCode;
        }
        this.provideNodes.add(node);
        return false;
    }

    @Override
    public boolean enterComponent(CssComponentNode node) {
        SourceCode sourceCode = node.getSourceCodeLocation().getSourceCode();
        if (sourceCode != this.lastFile) {
            this.provideNodes.clear();
            this.lastFile = sourceCode;
        }
        String name = node.getName().getValue();
        if (node.isImplicitlyNamed()) {
            if (this.provideNodes.size() < 1) {
                this.reportError("implicitly-named @components require a prior @provide declaration ", node);
                return false;
            }
            name = ((CssProvideNode)Iterables.getLast(this.provideNodes)).getProvide();
        }
        if (this.components.containsKey(name)) {
            this.reportError("cannot redefine component in chunk ", node);
            return false;
        }
        CssLiteralNode parentName = node.getParentName();
        if (parentName != null && !this.components.containsKey(parentName.getValue())) {
            this.reportError("parent component is undefined in chunk ", node);
            return false;
        }
        this.visitController.replaceCurrentBlockChildWith(this.transformAllNodes(node), false);
        this.components.put(name, node);
        return false;
    }

    @Override
    public boolean enterClassSelector(CssClassSelectorNode node) {
        if (node.getScoping() == CssClassSelectorNode.ComponentScoping.FORCE_SCOPED) {
            this.reportError("'%' prefix for class selectors may only be used in the scope of an @component", node);
            return false;
        }
        if (node.getScoping() == CssClassSelectorNode.ComponentScoping.FORCE_UNSCOPED) {
            this.reportError("'^' prefix for class selectors may only be used in the scope of an @component", node);
            return false;
        }
        return true;
    }

    private void reportError(String message, CssNode node) {
        if (this.fileToChunk != null) {
            message = message + String.valueOf(MapChunkAwareNodesToChunk.getChunk(node, this.fileToChunk));
        }
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
        this.visitController.removeCurrentNode();
    }

    private List<CssNode> transformAllNodes(CssComponentNode current) {
        HashSet constants = Sets.newHashSet();
        LinkedList nodes = Lists.newLinkedList();
        this.transformAllParentNodes(nodes, constants, current, current.getParentName());
        nodes.addAll(this.transformNodes(constants, current, current));
        return nodes;
    }

    private void transformAllParentNodes(List<CssNode> nodes, Set<String> constants, CssComponentNode current, @Nullable CssLiteralNode parentLiteralNode) {
        if (parentLiteralNode == null) {
            return;
        }
        String parentName = parentLiteralNode.getValue();
        CssComponentNode parentComponent = this.components.get(parentName);
        this.transformAllParentNodes(nodes, constants, current, parentComponent.getParentName());
        nodes.addAll(this.transformNodes(constants, current, parentComponent));
    }

    private List<CssNode> transformNodes(Set<String> constants, CssComponentNode target, CssComponentNode source) {
        CssBlockNode sourceBlock = source.getBlock();
        CssBlockNode copyBlock = new CssBlockNode(false, sourceBlock.deepCopy().getChildren());
        copyBlock.setSourceCodeLocation(source.getBlock().getSourceCodeLocation());
        CssTree tree = new CssTree(target.getSourceCodeLocation().getSourceCode(), new CssRootNode(copyBlock));
        new TransformNodes(constants, target, target != source, tree.getMutatingVisitController(), this.errorManager, this.provideNodes).runPass();
        if (this.fileToChunk != null) {
            T chunk = MapChunkAwareNodesToChunk.getChunk(target, this.fileToChunk);
            new SetChunk(tree, chunk).runPass();
        }
        return tree.getRoot().getBody().getChildren();
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }

    private static class TransformNodes
    extends DefaultTreeVisitor
    implements CssCompilerPass {
        private final boolean inAncestorBlock;
        private final MutatingVisitController visitController;
        private final ErrorManager errorManager;
        private final Set<CssDefinitionNode> renamedDefinitions = Sets.newHashSet();
        private final Set<String> componentConstants;
        private final boolean isAbstract;
        private final String classPrefix;
        private final String defPrefix;
        private final String parentName;
        private final SourceCodeLocation sourceCodeLocation;
        private boolean firstClassSelector;
        private int nestedSelectorDepth;

        public TransformNodes(Set<String> constants, CssComponentNode current, boolean inAncestorBlock, MutatingVisitController visitController, ErrorManager errorManager, List<CssProvideNode> provideNodes) {
            this.componentConstants = constants;
            this.inAncestorBlock = inAncestorBlock;
            this.visitController = visitController;
            this.errorManager = errorManager;
            String currentName = current.getName().getValue();
            if (current.isImplicitlyNamed()) {
                currentName = ((CssProvideNode)Iterables.getLast(provideNodes)).getProvide();
            }
            this.isAbstract = current.isAbstract();
            if (current.getPrefixStyle() == CssComponentNode.PrefixStyle.CASE_CONVERT) {
                this.classPrefix = this.getClassPrefixFromDottedName(currentName);
                this.defPrefix = this.getDefPrefixFromDottedName(currentName);
            } else {
                this.classPrefix = currentName + ProcessComponents.CLASS_SEP;
                this.defPrefix = currentName + ProcessComponents.DEF_SEP;
            }
            this.parentName = inAncestorBlock ? current.getParentName().getValue() : null;
            this.sourceCodeLocation = current.getSourceCodeLocation();
        }

        @Override
        public boolean enterComponent(CssComponentNode node) {
            if (!this.inAncestorBlock) {
                this.errorManager.report(new GssError("nested components are not allowed", node.getSourceCodeLocation()));
            }
            this.visitController.removeCurrentNode();
            return false;
        }

        @Override
        public boolean enterRuleset(CssRulesetNode node) {
            if (this.isAbstract) {
                this.visitController.removeCurrentNode();
            }
            return !this.isAbstract;
        }

        @Override
        public boolean enterCombinator(CssCombinatorNode combinator) {
            ++this.nestedSelectorDepth;
            return true;
        }

        @Override
        public void leaveCombinator(CssCombinatorNode combinator) {
            --this.nestedSelectorDepth;
        }

        @Override
        public boolean enterSelector(CssSelectorNode selector) {
            if (this.nestedSelectorDepth == 0) {
                this.firstClassSelector = true;
            }
            return true;
        }

        @Override
        public void leaveSelector(CssSelectorNode selector) {
            this.firstClassSelector = false;
        }

        @Override
        public boolean enterPseudoClass(CssPseudoClassNode pseudoClass) {
            ++this.nestedSelectorDepth;
            return true;
        }

        @Override
        public void leavePseudoClass(CssPseudoClassNode pseudoClass) {
            --this.nestedSelectorDepth;
        }

        @Override
        public boolean enterClassSelector(CssClassSelectorNode node) {
            Preconditions.checkState((!this.isAbstract ? 1 : 0) != 0);
            if (!this.firstClassSelector && node.getScoping() == CssClassSelectorNode.ComponentScoping.FORCE_UNSCOPED) {
                this.errorManager.report(new GssError("'^' prefix may only be used on the first classname in a selector.", node.getSourceCodeLocation()));
            }
            if (this.firstClassSelector && node.getScoping() != CssClassSelectorNode.ComponentScoping.FORCE_UNSCOPED || node.getScoping() == CssClassSelectorNode.ComponentScoping.FORCE_SCOPED) {
                CssClassSelectorNode newNode = new CssClassSelectorNode(this.classPrefix + node.getRefinerName(), this.inAncestorBlock ? this.sourceCodeLocation : node.getSourceCodeLocation());
                newNode.setComments(node.getComments());
                this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), false);
            }
            this.firstClassSelector = false;
            return true;
        }

        @Override
        public boolean enterDefinition(CssDefinitionNode node) {
            CssDefinitionNode newNode;
            if (this.renamedDefinitions.contains(node)) {
                return true;
            }
            String defName = node.getName().getValue();
            CssLiteralNode newDefLit = new CssLiteralNode(this.defPrefix + defName, this.inAncestorBlock ? this.sourceCodeLocation : node.getSourceCodeLocation());
            if (this.inAncestorBlock) {
                String parentRefPrefix = this.parentName + ProcessComponents.DEF_SEP;
                String parentRefName = defName.startsWith(parentRefPrefix) ? defName : parentRefPrefix + defName;
                CssConstantReferenceNode parentRefNode = new CssConstantReferenceNode(parentRefName, this.sourceCodeLocation);
                newNode = new CssDefinitionNode((List<CssValueNode>)ImmutableList.of((Object)parentRefNode), newDefLit, this.sourceCodeLocation);
            } else {
                newNode = new CssDefinitionNode(CssNode.deepCopyNodes(node.getParameters()), newDefLit, this.sourceCodeLocation);
            }
            this.componentConstants.add(defName);
            this.renamedDefinitions.add(newNode);
            this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), true);
            return false;
        }

        @Override
        public boolean enterValueNode(CssValueNode node) {
            if (node instanceof CssConstantReferenceNode && this.componentConstants.contains(node.getValue())) {
                CssConstantReferenceNode newNode = new CssConstantReferenceNode(this.defPrefix + node.getValue(), this.inAncestorBlock ? this.sourceCodeLocation : node.getSourceCodeLocation());
                this.visitController.replaceCurrentBlockChildWith(ImmutableList.of((Object)newNode), false);
            }
            return true;
        }

        @Override
        public boolean enterArgumentNode(CssValueNode node) {
            return this.enterValueNode(node);
        }

        @Override
        public void runPass() {
            this.visitController.startVisit(this);
        }

        private String getClassPrefixFromDottedName(String packageName) {
            String packageNameWithDashes = packageName.replace('.', '-');
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
        }

        private String getDefPrefixFromDottedName(String packageName) {
            return packageName.replace('.', '_').toUpperCase() + "_";
        }
    }

    private static class SetChunk
    extends DefaultTreeVisitor
    implements CssCompilerPass {
        private final CssTree tree;
        private final Object chunk;

        public SetChunk(CssTree tree, Object chunk) {
            this.tree = tree;
            this.chunk = chunk;
        }

        @Override
        public boolean enterDefinition(CssDefinitionNode definition) {
            definition.setChunk(this.chunk);
            return false;
        }

        @Override
        public boolean enterSelector(CssSelectorNode selector) {
            selector.setChunk(this.chunk);
            return true;
        }

        @Override
        public boolean enterFunctionNode(CssFunctionNode function) {
            function.setChunk(this.chunk);
            return super.enterFunctionNode(function);
        }

        @Override
        public void runPass() {
            this.tree.getVisitController().startVisit(this);
        }
    }
}

