/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerListNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.MutatingVisitController;

public class ProcessRefiners
extends DefaultTreeVisitor
implements CssCompilerPass {
    @VisibleForTesting
    static final String INVALID_NTH_ERROR_MESSAGE = "the format for NTH is not in the form an+b, 'odd', or 'even' where a and b are (signed) integers that can be omitted";
    @VisibleForTesting
    static final String INVALID_NOT_SELECTOR_ERROR_MESSAGE = "a :not selector and pseudo-elements ('::') are not allowed inside of a :not";
    @VisibleForTesting
    static final String NOT_LANG_ERROR_MESSAGE = "a pseudo-class which takes arguments has to be ':lang()' or has to start with 'nth-'";
    private static final CharMatcher CSS_WHITESPACE = CharMatcher.anyOf((CharSequence)" \t\r\n\f");
    private final MutatingVisitController visitController;
    private final ErrorManager errorManager;
    private final boolean simplifyCss;

    public ProcessRefiners(MutatingVisitController visitController, ErrorManager errorManager, boolean simplifyCss) {
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.simplifyCss = simplifyCss;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode refiner) {
        CssPseudoClassNode.FunctionType functionType = refiner.getFunctionType();
        switch (functionType) {
            case NONE: {
                return true;
            }
            case LANG: {
                return this.handleLang(refiner);
            }
            case NTH: {
                return this.handleNth(refiner);
            }
            case NOT: {
                return this.handleNot(refiner);
            }
        }
        return true;
    }

    private static String trim(String input) {
        return CSS_WHITESPACE.trimFrom((CharSequence)input);
    }

    private boolean handleLang(CssPseudoClassNode refiner) {
        if (!refiner.getRefinerName().equals("lang(")) {
            this.errorManager.report(new GssError(NOT_LANG_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        return true;
    }

    private boolean handleNot(CssPseudoClassNode refiner) {
        CssPseudoClassNode pseudoClass;
        if (refiner.getNotSelector() == null) {
            this.errorManager.report(new GssError(INVALID_NOT_SELECTOR_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        CssRefinerListNode refinerList = refiner.getNotSelector().getRefiners();
        if (refinerList.numChildren() == 0) {
            return true;
        }
        if (refinerList.numChildren() > 1) {
            this.errorManager.report(new GssError(INVALID_NOT_SELECTOR_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        CssRefinerNode nestedRefiner = (CssRefinerNode)refinerList.getChildAt(0);
        if (nestedRefiner instanceof CssPseudoElementNode) {
            this.errorManager.report(new GssError(INVALID_NOT_SELECTOR_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        if (nestedRefiner instanceof CssPseudoClassNode && (pseudoClass = (CssPseudoClassNode)nestedRefiner).getFunctionType() == CssPseudoClassNode.FunctionType.NOT) {
            this.errorManager.report(new GssError(INVALID_NOT_SELECTOR_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        return true;
    }

    private boolean handleNth(CssPseudoClassNode refiner) {
        int b;
        int a;
        String argument = ProcessRefiners.trim(refiner.getArgument());
        if (argument.contains(".")) {
            this.errorManager.report(new GssError(INVALID_NTH_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
            return false;
        }
        if (argument.equals("even")) {
            a = 2;
            b = 0;
        } else if (argument.equals("odd")) {
            a = 2;
            b = 1;
        } else {
            try {
                int indexOfN = argument.indexOf(110);
                a = this.parseA(argument, indexOfN);
                b = this.parseB(argument, indexOfN);
            }
            catch (NumberFormatException e) {
                this.errorManager.report(new GssError(INVALID_NTH_ERROR_MESSAGE, refiner.getSourceCodeLocation()));
                return false;
            }
        }
        if (this.simplifyCss) {
            refiner.setArgument(this.compactRepresentation(a, b));
        }
        return true;
    }

    private String compactRepresentation(int a, int b) {
        if (a == 2 && b == 1) {
            return "odd";
        }
        if (a == 0 && b == 0) {
            return "0";
        }
        StringBuilder compact = new StringBuilder();
        if (a != 0) {
            if (a != 1 || b == 0) {
                compact.append(a);
            }
            compact.append("n");
        }
        if (b > 0 && a != 0) {
            compact.append("+");
        }
        if (b != 0) {
            compact.append(b);
        }
        return compact.toString();
    }

    @VisibleForTesting
    int parseA(String argument, int indexOfN) {
        if (indexOfN == -1) {
            return 0;
        }
        if (indexOfN > 0) {
            String aStr = ProcessRefiners.trim(argument.substring(0, indexOfN));
            if (aStr.equals("+")) {
                return 1;
            }
            if (aStr.equals("-")) {
                return -1;
            }
            aStr = aStr.replace("+", "");
            return Integer.parseInt(aStr);
        }
        return 1;
    }

    @VisibleForTesting
    int parseB(String argument, int indexOfN) {
        if (indexOfN == -1) {
            argument = ProcessRefiners.trim(argument.replace("+", ""));
            return Integer.parseInt(argument);
        }
        if (indexOfN + 1 < argument.length()) {
            String bStr = argument.substring(indexOfN + 1);
            bStr = ProcessRefiners.trim(bStr);
            bStr = bStr.replace("+", "");
            return Integer.parseInt(bStr);
        }
        return 0;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

