/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.css.Vendor;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.ast.Property;
import javax.annotation.Nonnull;

public class RemoveVendorSpecificProperties
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final Vendor vendorToKeep;
    private final MutatingVisitController visitController;

    public RemoveVendorSpecificProperties(@Nonnull Vendor vendorToKeep, MutatingVisitController visitController) {
        Preconditions.checkNotNull((Object)((Object)vendorToKeep));
        this.vendorToKeep = vendorToKeep;
        this.visitController = visitController;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declarationNode) {
        CssPropertyNode propertyNode = declarationNode.getPropertyName();
        Property property = propertyNode.getProperty();
        Vendor vendor = property.getVendor();
        if (vendor != null && !vendor.equals((Object)this.vendorToKeep)) {
            this.visitController.removeCurrentNode();
            return false;
        }
        return true;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

