/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssCustomFunctionNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.GssFunction;
import com.google.common.css.compiler.ast.GssFunctionException;
import com.google.common.css.compiler.ast.MutatingVisitController;
import com.google.common.css.compiler.ast.Proxiable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolveCustomFunctionNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final MutatingVisitController visitController;
    protected final Map<String, GssFunction> functionMap;
    private final ErrorManager errorManager;
    private final boolean allowUnknownFunctions;
    private final Set<String> allowedNonStandardFunctions;

    public ResolveCustomFunctionNodes(MutatingVisitController visitController, ErrorManager errorManager, Map<String, GssFunction> functionMap) {
        this(visitController, errorManager, functionMap, false);
    }

    public ResolveCustomFunctionNodes(MutatingVisitController visitController, ErrorManager errorManager, Map<String, GssFunction> functionMap, boolean allowUnknownFunctions) {
        this(visitController, errorManager, functionMap, allowUnknownFunctions, (Set<String>)ImmutableSet.of());
    }

    public ResolveCustomFunctionNodes(MutatingVisitController visitController, ErrorManager errorManager, Map<String, GssFunction> functionMap, boolean allowUnknownFunctions, Set<String> allowedNonStandardFunctions) {
        Preconditions.checkNotNull(functionMap);
        this.visitController = visitController;
        this.errorManager = errorManager;
        this.functionMap = functionMap;
        this.allowUnknownFunctions = allowUnknownFunctions;
        this.allowedNonStandardFunctions = ImmutableSet.copyOf(allowedNonStandardFunctions);
    }

    @Override
    public void leaveFunctionNode(CssFunctionNode functionNode) {
        if (!(functionNode instanceof Proxiable)) {
            return;
        }
        CssCustomFunctionNode node = (CssCustomFunctionNode)functionNode;
        List<CssValueNode> functionResult = node.getResult();
        if (functionResult == null) {
            String functionName = node.getFunctionName();
            GssFunction function = this.functionMap.get(functionName);
            if (function == null) {
                if (!this.allowUnknownFunctions && !this.allowedNonStandardFunctions.contains(functionName)) {
                    this.errorManager.report(new GssError(String.format("Unknown function \"%s\"", functionName), node.getSourceCodeLocation()));
                    this.visitController.removeCurrentNode();
                }
                return;
            }
            List<CssValueNode> arguments = CssCustomFunctionNode.fixupFunctionArguments(node.getArguments().childIterable());
            Integer expArgNumber = function.getNumExpectedArguments();
            int argNumber = arguments.size();
            if (expArgNumber != null && expArgNumber != argNumber) {
                this.errorManager.report(new GssError("Function expects " + expArgNumber + " arguments but has " + argNumber, node.getSourceCodeLocation()));
                this.visitController.removeCurrentNode();
                return;
            }
            try {
                functionResult = this.evaluateFunction(node, function, arguments, this.errorManager);
            }
            catch (GssFunctionException e) {
                this.visitController.removeCurrentNode();
                return;
            }
            catch (RuntimeException e) {
                this.errorManager.report(new GssError(Throwables.getStackTraceAsString((Throwable)e), node.getSourceCodeLocation()));
                this.visitController.removeCurrentNode();
                return;
            }
        }
        this.visitController.replaceCurrentBlockChildWith(functionResult, false);
    }

    protected List<CssValueNode> evaluateFunction(CssCustomFunctionNode node, GssFunction function, List<CssValueNode> arguments, ErrorManager errorManager) throws GssFunctionException {
        List<CssValueNode> functionResult = function.getCallResultNodes(arguments, errorManager);
        node.setResult(functionResult);
        return functionResult;
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

