/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssTree;
import com.google.common.css.compiler.ast.CssTreeVisitor;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.CodeBuffer;
import com.google.common.css.compiler.passes.CodePrinter;
import com.google.common.css.compiler.passes.SExprPrintingVisitor;
import com.google.common.css.compiler.passes.UniformVisitor;

public class SExprPrinter
extends CodePrinter {
    private final boolean includeHashCodes;
    private final boolean withLocationAnnotation;

    public SExprPrinter(CssNode subtree) {
        this(subtree, false, false);
    }

    public SExprPrinter(CssTree tree) {
        this(tree, false, false);
    }

    public SExprPrinter(CssNode subtree, boolean includeHashCodes, boolean withLocationAnnotation) {
        super(subtree.getVisitController(), null, null);
        this.includeHashCodes = includeHashCodes;
        this.withLocationAnnotation = withLocationAnnotation;
    }

    public SExprPrinter(CssTree tree, boolean includeHashCodes, boolean withLocationAnnotation) {
        super(tree.getVisitController(), null, null);
        this.includeHashCodes = includeHashCodes;
        this.withLocationAnnotation = withLocationAnnotation;
    }

    @Override
    protected CssTreeVisitor createVisitor(VisitController visitController, CodeBuffer codeBuffer) {
        SExprPrintingVisitor sExprPrintingVisitor = new SExprPrintingVisitor(codeBuffer, this.includeHashCodes, this.withLocationAnnotation);
        return UniformVisitor.Adapters.asCombinedVisitor(sExprPrintingVisitor);
    }

    @Override
    public void runPass() {
        this.resetBuffer();
        this.visit();
    }

    public static String print(CssTree t) {
        SExprPrinter printer = new SExprPrinter(t);
        printer.visit();
        return printer.getOutputBuffer();
    }

    public static String print(boolean includeHashCodes, boolean withLocationAnnotation, CssTree t) {
        SExprPrinter printer = new SExprPrinter(t, includeHashCodes, withLocationAnnotation);
        printer.visit();
        return printer.getOutputBuffer();
    }

    public static String print(CssNode n) {
        SExprPrinter printer = new SExprPrinter(n);
        printer.visit();
        return printer.getOutputBuffer();
    }

    public static String print(boolean includeHashCodes, boolean withLocationAnnotation, CssNode n) {
        SExprPrinter printer = new SExprPrinter(n, includeHashCodes, withLocationAnnotation);
        printer.visit();
        return printer.getOutputBuffer();
    }
}

