/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.css.compiler.ast.CssAttributeSelectorNode;
import com.google.common.css.compiler.ast.CssCombinatorNode;
import com.google.common.css.compiler.ast.CssPseudoClassNode;
import com.google.common.css.compiler.ast.CssPseudoElementNode;
import com.google.common.css.compiler.ast.CssRefinerNode;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import com.google.common.css.compiler.passes.StrictCssBase;
import java.util.Set;

public class StrictCss2
extends StrictCssBase {
    private static final ImmutableSet<String> PSEUDO_CLASSES_OR_ELEMENT = ImmutableSet.of((Object)"first-child", (Object)"link", (Object)"visited", (Object)"active", (Object)"hover", (Object)"focus", (Object[])new String[]{"first-line", "first-letter", "before", "after"});
    private static final ImmutableSet<CssCombinatorNode.Combinator> ALLOWED_COMBINATORS = ImmutableSet.of((Object)((Object)CssCombinatorNode.Combinator.DESCENDANT), (Object)((Object)CssCombinatorNode.Combinator.CHILD), (Object)((Object)CssCombinatorNode.Combinator.ADJACENT_SIBLING));
    private static final ImmutableSet<CssAttributeSelectorNode.MatchType> ALLOWED_ATTRIBUTE_SELECTORS = ImmutableSet.of((Object)((Object)CssAttributeSelectorNode.MatchType.ANY), (Object)((Object)CssAttributeSelectorNode.MatchType.EXACT), (Object)((Object)CssAttributeSelectorNode.MatchType.EXACT_OR_DASH), (Object)((Object)CssAttributeSelectorNode.MatchType.ONE_WORD));
    private static final Set<String> UNITS = Sets.newHashSet((Object[])new String[]{"", "em", "ex", "%", "in", "cm", "mm", "pt", "pc", "px"});
    @VisibleForTesting
    static final String UNSUPPORTED_COMBINATOR_ERROR_MESSAGE = "An unsupported combinator is used.";
    @VisibleForTesting
    static final String UNSUPPORTED_PESUDO_CLASS_OR_ELEMENT_ERROR_MESSAGE = "An unsupported pseudo-class or pseudo-element is used.";
    @VisibleForTesting
    static final String NEW_PESUDO_ELEMENTS_NOT_ALLOWED_ERROR_MESSAGE = "Pseudo-elements starting with '::' are not allowed in CSS 2.1.";
    @VisibleForTesting
    static final String FORBIDDEN_ATTRIBUTE_COMPARER_ERROR_MESSAGE = "An operator for matching attributes not allowed in CSS 2.1 is used.";

    public StrictCss2(VisitController visitController, ErrorManager errorManager) {
        super(visitController, errorManager);
    }

    @Override
    Set<String> getValidCssUnits() {
        return UNITS;
    }

    @Override
    public boolean enterCombinator(CssCombinatorNode combinator) {
        if (!ALLOWED_COMBINATORS.contains((Object)combinator.getCombinatorType())) {
            this.errorManager.report(new GssError(UNSUPPORTED_COMBINATOR_ERROR_MESSAGE, combinator.getSourceCodeLocation()));
            return false;
        }
        return true;
    }

    @Override
    public boolean enterPseudoClass(CssPseudoClassNode node) {
        switch (node.getFunctionType()) {
            case NONE: {
                return this.checkNonFunctionPseudoClass(node);
            }
            case NTH: 
            case NOT: {
                this.reportUnsupported(node, UNSUPPORTED_PESUDO_CLASS_OR_ELEMENT_ERROR_MESSAGE, (Set<String>)PSEUDO_CLASSES_OR_ELEMENT);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFunctionPseudoClass(CssRefinerNode refiner) {
        if (!PSEUDO_CLASSES_OR_ELEMENT.contains((Object)refiner.getRefinerName())) {
            this.reportUnsupported(refiner, UNSUPPORTED_PESUDO_CLASS_OR_ELEMENT_ERROR_MESSAGE, (Set<String>)PSEUDO_CLASSES_OR_ELEMENT);
            return false;
        }
        return true;
    }

    @Override
    public boolean enterPseudoElement(CssPseudoElementNode node) {
        this.errorManager.report(new GssError(NEW_PESUDO_ELEMENTS_NOT_ALLOWED_ERROR_MESSAGE, node.getSourceCodeLocation()));
        return false;
    }

    @Override
    public boolean enterAttributeSelector(CssAttributeSelectorNode node) {
        if (!ALLOWED_ATTRIBUTE_SELECTORS.contains((Object)node.getMatchType())) {
            this.errorManager.report(new GssError(FORBIDDEN_ATTRIBUTE_COMPARER_ERROR_MESSAGE, node.getSourceCodeLocation()));
            return false;
        }
        return true;
    }
}

