/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssNumericNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import java.util.Set;

public abstract class StrictCssBase
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String SUPPORTED_LIST_PREFIX = "\nsupported names: ";
    private static final String SUPPORTED_LIST_SUFFIX = "\n";
    static final String INVALID_UNIT_PREFIX = "Invalid unit: ";
    protected final VisitController visitController;
    protected final ErrorManager errorManager;

    public StrictCssBase(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    abstract Set<String> getValidCssUnits();

    @Override
    public boolean enterValueNode(CssValueNode node) {
        if (node instanceof CssNumericNode) {
            String unit = ((CssNumericNode)node).getUnit();
            if (!this.getValidCssUnits().contains(unit)) {
                this.errorManager.report(new GssError(INVALID_UNIT_PREFIX + unit, node.getSourceCodeLocation()));
                return false;
            }
        }
        return true;
    }

    protected void reportUnsupported(CssNode node, String message, Set<String> supportedNames) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append(SUPPORTED_LIST_PREFIX);
        for (String name : supportedNames) {
            sb.append(name);
            sb.append(", ");
        }
        sb.append(SUPPORTED_LIST_SUFFIX);
        this.errorManager.report(new GssError(sb.toString(), node.getSourceCodeLocation()));
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

