/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssUnicodeRangeNode;
import com.google.common.css.compiler.ast.CssValueNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ValidatePropertyValues
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String UNICODE_RANGE_ERROR = "Invalid expression for unicode range. Expected single codepoint (U+25), range (U+0015-00FF), or wildcard range (U+3??)";
    @VisibleForTesting
    static final String UNICODE_ILLEGAL_CODEPOINT_ERROR = "Unicode code point must be within 0-10FFFF";
    private static final String CODE_POINT_PATTERN = "([\\da-zA-Z]+)";
    private static final Pattern UNICODE_RANGE_PATTERN = Pattern.compile(String.format("U\\+%s(?:-%s)?", "([\\da-zA-Z]+)", "([\\da-zA-Z]+)"));
    private static final Pattern UNICODE_WILDCARD_PATTERN = Pattern.compile(String.format("U\\+%s(\\?+)", "([\\da-zA-Z]+)"));
    private final ErrorManager errorManager;
    private final VisitController visitController;

    public ValidatePropertyValues(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterValueNode(CssValueNode value) {
        if (value instanceof CssUnicodeRangeNode) {
            this.validateUnicodeRangeValue((CssUnicodeRangeNode)value);
        }
        return true;
    }

    private void validateUnicodeRangeValue(CssUnicodeRangeNode value) {
        Matcher rangeMatcher = UNICODE_RANGE_PATTERN.matcher(value.getValue());
        Matcher wildcardMatcher = UNICODE_WILDCARD_PATTERN.matcher(value.getValue());
        if (!rangeMatcher.matches() && !wildcardMatcher.matches()) {
            this.reportError(UNICODE_RANGE_ERROR, value);
            return;
        }
        if (rangeMatcher.matches()) {
            for (int i = 1; i <= rangeMatcher.groupCount(); ++i) {
                this.validateSingleCodePoint(rangeMatcher.group(i), value);
            }
        } else {
            String codePoint = wildcardMatcher.group(1) + wildcardMatcher.group(2).replaceAll("\\?", "0");
            this.validateSingleCodePoint(codePoint, value);
        }
    }

    private void validateSingleCodePoint(@Nullable String codePoint, CssUnicodeRangeNode value) {
        if (codePoint == null) {
            return;
        }
        long asLong = Long.parseLong(codePoint, 16);
        if (asLong > 0x10FFFFL) {
            this.reportError(UNICODE_ILLEGAL_CODEPOINT_ERROR, value);
        }
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

