/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.collect.ImmutableSet;
import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssNode;
import com.google.common.css.compiler.ast.CssPropertyNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.Property;
import com.google.common.css.compiler.ast.VisitController;
import java.util.Set;

public class VerifyRecognizedProperties
extends DefaultTreeVisitor
implements CssCompilerPass {
    private final Set<String> allowedUnrecognizedProperties;
    private final VisitController visitController;
    private final ErrorManager errorManager;

    public VerifyRecognizedProperties(Set<String> allowedUnrecognizedProperties, VisitController visitController, ErrorManager errorManager) {
        this.allowedUnrecognizedProperties = ImmutableSet.copyOf(allowedUnrecognizedProperties);
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declarationNode) {
        CssPropertyNode propertyNode = declarationNode.getPropertyName();
        Property property = propertyNode.getProperty();
        String propertyName = property.getName();
        if (property.isCustom()) {
            return true;
        }
        if (propertyName.startsWith("*") || propertyName.startsWith("_")) {
            propertyName = propertyName.substring(1);
            property = Property.byName(propertyName);
        }
        if (!this.allowedUnrecognizedProperties.contains(property.getName())) {
            if (!property.isRecognizedProperty()) {
                this.reportError(String.format("%s is an unrecognized property", property.getName()), propertyNode);
            } else if (property.hasWarning()) {
                this.errorManager.reportWarning(new GssError(String.format("WARNING for use of CSS property %s: %s%n", property.getName(), property.getWarning()), propertyNode.getSourceCodeLocation()));
            }
        }
        return true;
    }

    private void reportError(String message, CssNode node) {
        this.errorManager.report(new GssError(message, node.getSourceCodeLocation()));
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

