/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css.compiler.passes;

import com.google.common.css.compiler.ast.CssCompilerPass;
import com.google.common.css.compiler.ast.CssDeclarationNode;
import com.google.common.css.compiler.ast.CssFunctionNode;
import com.google.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.common.css.compiler.ast.ErrorManager;
import com.google.common.css.compiler.ast.GssError;
import com.google.common.css.compiler.ast.VisitController;

public class WarnOnCustomProperty
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final String VAR_FUNCTION_NAME = "var";
    static final String DECLARATION_WARNING_MSG = "Custom property declaration encountered. Please note that custom properties do not work with all major browsers, and their use is discouraged.";
    static final String REFERENCE_WARNING_MSG = "Custom property reference encountered. Please note that custom properties do not work with all major browsers, and their use is discouraged.";
    private final ErrorManager errorManager;
    private final VisitController visitController;

    public WarnOnCustomProperty(VisitController visitController, ErrorManager errorManager) {
        this.visitController = visitController;
        this.errorManager = errorManager;
    }

    @Override
    public boolean enterDeclaration(CssDeclarationNode declaration) {
        if (declaration.isCustomDeclaration()) {
            this.errorManager.reportWarning(new GssError(DECLARATION_WARNING_MSG, declaration.getSourceCodeLocation()));
        }
        return super.enterDeclaration(declaration);
    }

    @Override
    public boolean enterFunctionNode(CssFunctionNode value) {
        if (value.getFunctionName().equals(VAR_FUNCTION_NAME)) {
            this.errorManager.reportWarning(new GssError(REFERENCE_WARNING_MSG, value.getSourceCodeLocation()));
        }
        return super.enterFunctionNode(value);
    }

    @Override
    public void runPass() {
        this.visitController.startVisit(this);
    }
}

