/* GssParserCC.java */
/* Generated By:JavaCC: Do not edit this line. GssParserCC.java */
package com.google.common.css.compiler.ast;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.css.SourceCode;
import com.google.common.css.SourceCodeLocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

/**
 * A parser that recognizes GSS files and builds the new AST.
 */
@SuppressWarnings({"java:S3776", "java:S1199"})
public class GssParserCC extends GssParserCCConstants {

    /**
     * Pattern for functions that are allowed to be separated by spaces.
     *
     * <p>The non-standard {@code rect(0 0 0 0)} is sometimes used for IE instead
     * of the standard {@code rect(0,0,0,0)}.
     *
     * <p>The legacy {@code -webkit-gradient} function takes its arguments in the
     * form:
     * {@code (linear, left center, right center, from(color1), to(color2))}.
     * As does {@code -khtml-gradient}.
     *
     * <p>The gradient proposals for CSS 3 are:
     * <ul>
     * <li>linear-gradient
     * <li>radial-gradient
     * <li>repeating-linear-gradient
     * <li>repeating-radial-gradient
     * </ul>
     * As CSS 3 is in draft stage they come in current browsers with a vendor
     * prefix but leaving out the vendor prefix already works.
     */
    private static final Pattern FUNCTIONSWITHSPACESEPOK = Pattern.compile(
            "(?:-(?:O|MOZ|WEBKIT|MS)-)?(?:REPEATING-)?(?:LINEAR|RADIAL)-GRADIENT"
                    + "|(?:-(?:O|MOZ|WEBKIT|MS)-)?IMAGE-SET"
                    + "|(?:-(?:O|MOZ|WEBKIT|MS)-)?RGB"
                    + "|(?:-(?:O|MOZ|WEBKIT|MS)-)?RGBA"
                    + "|RECT|INSET|CIRCLE|ELLIPSE|POLYGON|-KHTML-GRADIENT|-WEBKIT-GRADIENT"
                    + "|(?:-WEBKIT-)?DROP-SHADOW|(?:-WEBKIT-)?CUSTOM|LOCAL",
            Pattern.CASE_INSENSITIVE);

    private static final ImmutableSet<String> URLFUNCTIONS = ImmutableSet.of(
            "domain", "url", "url-prefix");

    private static final CharMatcher CSSWHITESPACE =
            CharMatcher.anyOf(" \t\r\n\f");

    private static final Pattern VALIDBLOCKCOMMENTPATTERN =
            Pattern.compile(".*/\\*.*\\*/.*", Pattern.DOTALL);
    public static final String CRAZY_CONTENT = "{[()]}";

    private CssBlockNode globalBlock;
    private SourceCode sourceCode;
    private final CssNodeBuilder nodeBuilder = new CssNodeBuilder();
    private StringCharStream charStream;

    /**
     * CSS Error Handling (http://www.w3.org/TR/css-syntax-3/#error-handling) is implemented by the
     * demand from Play Book. It still may abort throwing GssParserException due to unhandled errors.
     */
    private boolean enableErrorRecovery;


    /**
     * List of handled errors if error handling enabled.
     */
    private final List<GssParserException> handledErrors = Lists.newArrayList();

    private SourceCodeLocation getLocation() {
        return getLocation(token);
    }

    private SourceCodeLocation getLocation(Token t) {
        int lineNumber1 = t.beginLine;
        int indexInLine1 = t.beginColumn;
        int charIndex1 = charStream.convertToCharacterIndex(lineNumber1,
                indexInLine1);
        int lineNumber2 = t.endLine;
        int indexInLine2 = t.endColumn + 1; // Need to advance 1 to be beyond the end of the token.
        int charIndex2 = charStream.convertToCharacterIndex(lineNumber2,
                indexInLine2);
        return new SourceCodeLocation(sourceCode, charIndex1, lineNumber1,
                indexInLine1, charIndex2, lineNumber2, indexInLine2);
    }

    /**
     * Returns a new SourceCodeLocation which covers everything between the
     * beginning of the first location and the end of the second location.
     */
    private SourceCodeLocation mergeLocations(SourceCodeLocation beginLocation,
                                              SourceCodeLocation endLocation) {
        return SourceCodeLocation.merge(beginLocation, endLocation);
    }

    private SourceCodeLocation mergeLocations(
            Iterable<? extends CssNode> locations) {
        return SourceCodeLocation.merge(locations);
    }

    private CssFunctionNode createUrlFunction(Token t) {
        // We tried using finer-grained tokens for URI parsing, but an
        // unquoted URI can look just like an identifier or even a whole
        // declaration. We tried using lexical states to recognize bare
        // URIs only within URLFUNCTIONS, but that had two problems:
        // (1) it means ordinary functions can't take bare URLs, which
        // harms orthogonality of GSS and outlaws some custom functions
        // we've found in the wild
        // (2) it means our special lexical state must either exclude
        // ordinary functions, or we must import many other tokens into this
        // new state, which adds complexity for little benefit.
        // Therefore, we ask the lexer to distinguish only big
        // recognizably-URLish chunks of input and break those down here.
        SourceCodeLocation loc = this.getLocation(t);
        int pi = t.image.indexOf('(');
        String funName = t.image.substring(0, pi);
        Preconditions.checkState(URLFUNCTIONS.contains(funName));
        CssFunctionNode.Function funType = CssFunctionNode.Function.byName(funName);
        CssFunctionNode fun = new CssFunctionNode(funType, loc);
        String parenContents = trim(t.image.substring(pi + 1, t.image.length() - 1));
        CssValueNode arg = new CssLiteralNode(parenContents, loc);
        fun.setArguments(new CssFunctionArgumentsNode(ImmutableList.of(arg)));
        return fun;
    }

    /**
     * Adds the given arguments explicitly separated by the given
     * separator to the given node. If an argument is a composite node
     * separated by commas, this method adds its children explicitly
     * separated by commas instead of the composite node, in order to
     * flatten out the argument list.
     *
     * <p>Separators such as commas in function calls have to be added
     * explicitly, in order to match the output from the old tree
     * converter.
     *
     * @param node    The function arguments node to add to
     * @param args    The real arguments to add
     * @param numArgs The number of real arguments
     * @param sep     The separator to add between real arguments
     */
    private void addArgumentsWithSeparator(
            CssFunctionArgumentsNode node,
            Iterable<CssValueNode> args,
            int numArgs,
            String sep) {
        int current = 0;
        for (CssValueNode arg : args) {
            if (arg instanceof CssCompositeValueNode &&
                    ((CssCompositeValueNode) arg).getOperator()==CssCompositeValueNode.Operator.COMMA) {
                CssCompositeValueNode composite = (CssCompositeValueNode) arg;
                addArgumentsWithSeparator(node, composite.getValues(), composite.getValues().size(), ",");
            } else {
                node.addChildToBack(arg);
            }
            current++;
            if (current < numArgs) {
                // Note that the source location for the separator is not entirely
                // accurate, but adding the separators as values is a hack anyways.
                node.addChildToBack(
                        new CssLiteralNode(sep, arg.getSourceCodeLocation()));
            }
        }
    }

    private static String trim(String input) {
        return CSSWHITESPACE.trimFrom(input);
    }

    public void parse() throws GssParserException {
        try {
            start();
        } catch (ParseException e) {
            // token.next can be null if there is an error after EOF, such as an unterminated block
            // comment.
            Token tokenWithError = token.next==null ? token:token.next;
            throw new GssParserException(this.getLocation(tokenWithError), e);
        }
    }

    /**
     * Wrapper around {@code parse()} that (re-)initializes the parser and
     * clears its state afterwards.
     *
     * @param globalBlock   the place to store parsing result
     * @param sourceCode    the source code to parse
     * @param errorHandling whether error handling is enabled
     * @param parsingErrors the place to store errors occured during parsing
     */
    public void parse(CssBlockNode globalBlock,
                      SourceCode sourceCode,
                      boolean errorHandling,
                      ImmutableList.Builder<GssParserException> parsingErrors)
            throws GssParserException {
        try {
            initialize(globalBlock, sourceCode, errorHandling);
            parse();
        } finally {
            parsingErrors.addAll(handledErrors);
            clearState();
        }
    }

    /**
     * This helper class takes care of the creation of nodes of the AST, and
     * attaching comments to them.
     */
    private class CssNodeBuilder {

        protected CssNode attachComments(List<Token> tokens, CssNode node) {
            for (Token t : tokens) {
                node = attachComment(t, node);
            }
            return node;
        }

        public CssNode attachComment(Token t, CssNode node) {
            if (t.specialToken==null) {
                return node;
            }
            Token special = t.specialToken;
            // Walking back the special token chain until we reach the first special token
            // which is after the previous regular (non-comment) token.
            while (special.specialToken!=null) {
                special = special.specialToken;
            }
            // Visiting comments in their normal appearing order.
            while (special!=null) {
                node.appendComment(new CssCommentNode(trim(special.image), getLocation(special)));
                special = special.next;
            }
            return node;
        }

        public CssStringNode buildStringNode(CssStringNode.Type type,
                                             String image, SourceCodeLocation location, Token token) {
            Preconditions.checkNotNull(image, "image should be non-null");
            Preconditions.checkArgument(
                    image.length() > 1, "the image argument must be quoted", image);
            CssStringNode node = new CssStringNode(type, location);
            attachComments(Lists.newArrayList(token), node);
            return node;
        }

        public CssHexColorNode buildHexColorNode(String image,
                                                 SourceCodeLocation location, List<Token> tokens) {
            CssHexColorNode node = new CssHexColorNode(image, location);
            attachComments(tokens, node);
            return node;
        }

        public CssRulesetNode buildRulesetNode(CssDeclarationBlockNode declarations,
                                               CssSelectorListNode selectors, SourceCodeLocation location,
                                               List<Token> tokens) {
            CssRulesetNode node = new CssRulesetNode(declarations);
            node.setSelectors(selectors);
            node.setSourceCodeLocation(location);
            attachComments(tokens, node);
            return node;
        }

        public CssKeyframeRulesetNode buildKeyframeRulesetNode(CssDeclarationBlockNode declarations,
                                                               CssKeyListNode keys, List<Token> tokens) {
            CssKeyframeRulesetNode node = new CssKeyframeRulesetNode(declarations);
            node.setKeys(keys);
            attachComments(tokens, node);
            return node;
        }

        public CssKeyNode buildKeyNode(Token token, String value, SourceCodeLocation location) {
            CssKeyNode node = new CssKeyNode(value, location);
            if (token!=null) {
                attachComment(token, node);
            }
            return node;
        }

        public CssClassSelectorNode buildClassSelectorNode(String name,
                                                           SourceCodeLocation location, CssClassSelectorNode.ComponentScoping scoping,
                                                           List<Token> tokens) {
            CssClassSelectorNode node = new CssClassSelectorNode(name, scoping, location);
            attachComments(tokens, node);
            return node;
        }

        public CssIdSelectorNode buildIdSelectorNode(String id,
                                                     SourceCodeLocation location, List<Token> tokens) {
            CssIdSelectorNode node = new CssIdSelectorNode(id, location);
            attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(String name,
                                                       SourceCodeLocation location, List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(name, location);
            attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(
                CssPseudoClassNode.FunctionType functionType, String name,
                String argument, SourceCodeLocation location, List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(functionType, name,
                    argument, location);
            attachComments(tokens, node);
            return node;
        }

        public CssPseudoClassNode buildPseudoClassNode(String name,
                                                       CssSelectorNode notSelector, SourceCodeLocation location,
                                                       List<Token> tokens) {
            CssPseudoClassNode node = new CssPseudoClassNode(name, notSelector,
                    location);
            attachComments(tokens, node);
            return node;
        }

        public CssPseudoElementNode buildPseudoElementNode(String name,
                                                           SourceCodeLocation location, List<Token> tokens) {
            CssPseudoElementNode node = new CssPseudoElementNode(name, location);
            attachComments(tokens, node);
            return node;
        }

        public CssAttributeSelectorNode buildAttributeSelectorNode(
                CssAttributeSelectorNode.MatchType matchType, String attribute,
                CssValueNode value, SourceCodeLocation location, List<Token> tokens) {
            CssAttributeSelectorNode node = new CssAttributeSelectorNode(matchType,
                    attribute, value, location);
            attachComments(tokens, node);
            return node;
        }

        public CssSelectorNode buildSelectorNode(Token token, SourceCodeLocation location,
                                                 CssRefinerListNode refiners) {
            String name = "";
            if (token!=null) {
                name = token.image;
            }
            CssSelectorNode node = new CssSelectorNode(name, location);
            if (token!=null) {
                attachComment(token, node);
            }
            node.setRefiners(refiners);
            return node;
        }

        public CssCombinatorNode buildCombinatorNode(CssCombinatorNode.Combinator combinator,
                                                     SourceCodeLocation location, List<Token> tokens) {
            CssCombinatorNode node = new CssCombinatorNode(combinator, location);
            attachComments(tokens, node);
            return node;
        }

        public CssDeclarationNode buildDeclarationNode(CssPropertyNode property,
                                                       CssPropertyValueNode value, List<Token> tokens) {
            try {
                CssDeclarationNode node =
                        new CssDeclarationNode(
                                property,
                                value,
                                mergeLocations(property.getSourceCodeLocation(), value.getSourceCodeLocation()));
                attachComments(tokens, node);
                return node;
            } catch (NullPointerException e) {
                StringBuilder valueValue = new StringBuilder();
                for (CssValueNode n : value.getChildren()) {
                    valueValue.append(n.getValue());
                    valueValue.append("<");
                    valueValue.append(n.getSourceCodeLocation());
                    valueValue.append("> ");
                }
                throw new RuntimeException("property: " + property.toString() + ", " + valueValue, e);
            }
        }

        public CssCompositeValueNode buildCompositeValueNode(List<CssValueNode> list,
                                                             CssCompositeValueNode.Operator op, SourceCodeLocation location, List<Token> tokens) {
            CssCompositeValueNode node = new CssCompositeValueNode(list, op, location);
            attachComments(tokens, node);
            return node;
        }


        public CssBooleanExpressionNode buildBoolExpressionNode(CssBooleanExpressionNode.Type type,
                                                                String value, CssBooleanExpressionNode left, CssBooleanExpressionNode right,
                                                                SourceCodeLocation loc, List<Token> tokens) {
            CssBooleanExpressionNode node = new CssBooleanExpressionNode(type, value, left, right, loc);
            attachComments(tokens, node);
            return node;
        }

        public CssLiteralNode buildLiteralNode(String value, SourceCodeLocation location,
                                               List<Token> tokens) {
            CssLiteralNode node = new CssLiteralNode(value, location);
            attachComments(tokens, node);
            return node;
        }

        public CssUnicodeRangeNode buildUnicodeRangeNode(String value, SourceCodeLocation location,
                                                         List<Token> tokens) {
            CssUnicodeRangeNode node = new CssUnicodeRangeNode(value, location);
            attachComments(tokens, node);
            return node;
        }

        public CssNumericNode buildNumericNode(String num, String unit, SourceCodeLocation location,
                                               List<Token> tokens) {
            CssNumericNode node = new CssNumericNode(num, unit, location);
            attachComments(tokens, node);
            return node;
        }

        public CssLiteralNode buildLoopVariableNode(String value, SourceCodeLocation location,
                                                    List<Token> tokens) {
            CssLoopVariableNode node = new CssLoopVariableNode(value, location);
            attachComments(tokens, node);
            return node;
        }

        public CssFunctionNode buildFunctionNode(String name, SourceCodeLocation location,
                                                 CssFunctionArgumentsNode args, List<Token> tokens) {
            CssFunctionNode.Function functionType = CssFunctionNode.Function.byName(name);
            if (functionType==null) {
                functionType = CssFunctionNode.Function.CUSTOM;
            }
            CssFunctionNode functionNode = (functionType!=CssFunctionNode.Function.CUSTOM) ?
                    new CssFunctionNode(functionType, location):
                    new CssCustomFunctionNode(name, location);
            functionNode.setArguments(args);
            attachComments(tokens, functionNode);
            return functionNode;
        }

        public CssPriorityNode buildPriorityNode(SourceCodeLocation location, List<Token> tokens) {
            CssPriorityNode node = new CssPriorityNode(CssPriorityNode.PriorityType.IMPORTANT, location);
            attachComments(tokens, node);
            return node;
        }

        public CssUnknownAtRuleNode buildUnknownAtRuleNode(CssLiteralNode name,
                                                           CssAbstractBlockNode block, SourceCodeLocation location,
                                                           List<CssValueNode> parameters, List<Token> tokens) {
            boolean hasBlock = (block!=null);
            CssUnknownAtRuleNode at = new CssUnknownAtRuleNode(name, hasBlock);
            at.setSourceCodeLocation(location);
            if (hasBlock) {
                at.setBlock(block);
            }
            at.setParameters(parameters);
            attachComments(tokens, at);
            return at;
        }

        public CssKeyframesNode buildWebkitKeyframesNode(CssLiteralNode name,
                                                         CssBlockNode block, SourceCodeLocation location,
                                                         List<CssValueNode> parameters, List<Token> tokens) {
            CssKeyframesNode at = new CssKeyframesNode(name);
            at.setSourceCodeLocation(location);
            at.setBlock(block);
            at.setParameters(parameters);
            attachComments(tokens, at);
            return at;
        }
    }

    private void initialize(CssBlockNode globalBlock, SourceCode sourceCode,
                            boolean errorHandling) {
        this.enableErrorRecovery = errorHandling;
        this.sourceCode = sourceCode;
        this.globalBlock = globalBlock;
        this.handledErrors.clear();
        StringCharStream charStream =
                new StringCharStream(sourceCode.getFileContents());
        this.charStream = charStream;
        this.reInit(charStream);
    }

    private void clearState() {
        this.sourceCode = null;
        this.globalBlock = null;
        this.handledErrors.clear();
        this.charStream = null;
    }

// The rest of the file contains the production rules of the grammar and to
// increase readability every rule also has a comment with the rule it
// implements in Extended Backus–Naur Form (EBNF) that follows this syntax:
// nameOfRule
//   : X
//   ;
// where X is the actual production consisting of non terminals and terminals.
// Terminals that exactly represent some characters are not written with their
// name but the characters are written instead, e.g. '(' instead of LEFTROUND,
// but IDENTIFIER stays the same.

    public final CssStringNode string() throws ParseException {
        Token t;
        CssStringNode.Type type;
        SourceCodeLocation beginLocation;
        beginLocation = this.getLocation(token.next);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case DOUBLE_QUOTED_STRING: {
                t = jjConsumeToken(DOUBLE_QUOTED_STRING);
                type = CssStringNode.Type.DOUBLE_QUOTED_STRING;
                break;
            }
            case SINGLE_QUOTED_STRING: {
                t = jjConsumeToken(SINGLE_QUOTED_STRING);
                type = CssStringNode.Type.SINGLE_QUOTED_STRING;
                break;
            }
            default:
                jjLa1[0] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        SourceCodeLocation endLocation = this.getLocation();
        {
            return nodeBuilder.buildStringNode(
                    type, t.image, this.mergeLocations(beginLocation, endLocation), t);
        }
    }

    public final CssRulesetNode ruleSet() throws ParseException {
        List<Token> tokens = Lists.newArrayList();
        try {
            return getCssRulesetNode(tokens);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(RIGHTBRACE);
            {
                throw e;
            }
        }
    }

    private CssRulesetNode getCssRulesetNode(List<Token> tokens) throws ParseException {
        CssSelectorListNode selectors;
        CssDeclarationBlockNode declarations;
        Token t;
        try {
            selectors = selectorList();
            t = jjConsumeToken(LEFTBRACE);
            tokens.add(t);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(LEFTBRACE);
            {
                throw e;
            }
        }
        declarations = styleDeclaration();
        t = jjConsumeToken(RIGHTBRACE);
        tokens.add(t);
        CssRulesetNode ruleSet = nodeBuilder.buildRulesetNode(declarations,
                selectors, mergeLocations(selectors.getSourceCodeLocation(), getLocation()), tokens);
        {
            return ruleSet;
        }
    }

    public final CssSelectorListNode selectorList() throws ParseException {
        CssSelectorListNode list = new CssSelectorListNode();
        CssSelectorNode selector;
        Token t;
        selector = selector();
        list.addChildToBack(selector);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=COMMA) {
                jjLa1[1] = jjGen;
                break;
            }
            t = jjConsumeToken(COMMA);
            nodeBuilder.attachComment(t, selector);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[2] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            selector = selector();
            list.addChildToBack(selector);
        }
        {
            return list;
        }
    }

    public final CssSelectorNode selector() throws ParseException {
        CssSelectorNode first;
        CssCombinatorNode c;
        CssSelectorNode next;
        CssSelectorNode prev;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        first = simpleSelector();
        prev = first;
        while (jj21(2)) {
            c = combinator();
            next = simpleSelector();
            c.setSelector(next);
            prev.setCombinator(c);
            prev = next;
        }
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[3] = jjGen;
                break;
            }
            t = jjConsumeToken(S);
            tokens.add(t);
        }
        nodeBuilder.attachComments(tokens, first);
        {
            return first;
        }
    }

    public final CssClassSelectorNode className() throws ParseException {
        Token t;
        List<Token> tokens = Lists.newArrayList();
        CssClassSelectorNode.ComponentScoping scoping = CssClassSelectorNode.ComponentScoping.DEFAULT;
        t = jjConsumeToken(DOT);
        tokens.add(t);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case PERCENT:
            case CARET: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case PERCENT: {
                        jjConsumeToken(PERCENT);
                        scoping = CssClassSelectorNode.ComponentScoping.FORCE_SCOPED;
                        break;
                    }
                    case CARET: {
                        jjConsumeToken(CARET);
                        scoping = CssClassSelectorNode.ComponentScoping.FORCE_UNSCOPED;
                        break;
                    }
                    default:
                        jjLa1[4] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jjLa1[5] = jjGen;
        }
        t = jjConsumeToken(IDENTIFIER);
        tokens.add(t);
        {
            return nodeBuilder.buildClassSelectorNode(t.image, this.getLocation(), scoping, tokens);
        }
    }

    public final CssRefinerNode id() throws ParseException {
        Token t;
        List<Token> tokens = Lists.newArrayList();
        t = jjConsumeToken(HASH_NAME);
        tokens.add(t);
        String name = t.image.substring(1);
        {
            return nodeBuilder.buildIdSelectorNode(name, this.getLocation(), tokens);
        }
    }

    public final CssRefinerNode pseudo() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        SourceCodeLocation endLocation;
        String pseudo = null;
        String argument;
        List<Token> tokens = Lists.newArrayList();
        CssSelectorNode notSelector;
        t = jjConsumeToken(COLON);
        beginLocation = this.getLocation();
        tokens.add(t);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case COLON:
            case IDENTIFIER:
            case NOTFUNCTION:
            case LANGFUNCTION:
            case FUNCTION: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case IDENTIFIER: {
                        t = jjConsumeToken(IDENTIFIER);
                        pseudo = t.image;
                        tokens.add(t);
                        break;
                    }
                    case COLON: {
                        // ::identifier (pseudo-element)
                        t = jjConsumeToken(COLON);
                        tokens.add(t);
                        t = jjConsumeToken(IDENTIFIER);
                        pseudo = t.image;
                        tokens.add(t);
                        endLocation = this.getLocation();
                        {
                            return nodeBuilder.buildPseudoElementNode(pseudo,
                                    this.mergeLocations(beginLocation, endLocation), tokens);
                        }
                    }
                    case NOTFUNCTION: {
                        // :not( simpleSelector )
                        t = jjConsumeToken(NOTFUNCTION);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[6] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        notSelector = simpleSelector();
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[7] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        t = jjConsumeToken(RIGHTROUND);
                        tokens.add(t);
                        endLocation = this.getLocation();
                        {
                            return nodeBuilder.buildPseudoClassNode(pseudo, notSelector,
                                    this.mergeLocations(beginLocation, endLocation), tokens);
                        }
                    }
                    case LANGFUNCTION: {
                        // :lang( <IDENTIFIER> )
                        t = jjConsumeToken(LANGFUNCTION);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[8] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        t = jjConsumeToken(IDENTIFIER);
                        argument = t.image;
                        tokens.add(t);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[9] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        t = jjConsumeToken(RIGHTROUND);
                        tokens.add(t);
                        endLocation = this.getLocation();
                        {
                            return nodeBuilder.buildPseudoClassNode(
                                    CssPseudoClassNode.FunctionType.LANG, pseudo, argument,
                                    this.mergeLocations(beginLocation, endLocation), tokens);
                        }
                    }
                    case FUNCTION: {
                        // :nth-function( nth )
                        t = jjConsumeToken(FUNCTION);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[10] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        beginLocation = this.getLocation();
                        pseudo = t.image;
                        tokens.add(t);
                        argument = nth();
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[11] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        t = jjConsumeToken(RIGHTROUND);
                        tokens.add(t);
                        endLocation = this.getLocation();
                        {
                            return nodeBuilder.buildPseudoClassNode(
                                    CssPseudoClassNode.FunctionType.NTH, pseudo, argument,
                                    this.mergeLocations(beginLocation, endLocation), tokens);
                        }
                    }
                    default:
                        jjLa1[12] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jjLa1[13] = jjGen;
        }
// non-function pseudo-class
        endLocation = this.getLocation();
        {
            return nodeBuilder.buildPseudoClassNode(pseudo,
                    this.mergeLocations(beginLocation, endLocation), tokens);
        }
    }

    public final String nth() throws ParseException {
        Token t;
        StringBuilder argument = new StringBuilder();
        while (true) {
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case WPLUS: {
                    t = jjConsumeToken(WPLUS);
                    argument.append(t.image);
                    break;
                }
                case MINUS: {
                    t = jjConsumeToken(MINUS);
                    argument.append(t.image);
                    break;
                }
                case WMINUSW: {
                    t = jjConsumeToken(WMINUSW);
                    argument.append(trim(t.image));
                    break;
                }
                case NUMBER: {
                    t = jjConsumeToken(NUMBER);
                    argument.append(t.image);
                    break;
                }
                case IDENTIFIER: {
                    t = jjConsumeToken(IDENTIFIER);
                    argument.append(t.image);
                    break;
                }
                case FOR_VARIABLE: {
                    t = jjConsumeToken(FOR_VARIABLE);
                    argument.append(t.image);
                    break;
                }
                default:
                    jjLa1[14] = jjGen;
                    jjConsumeToken(-1);
                    throw new ParseException();
            }
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[15] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=MINUS && i!=WMINUSW && i!=WPLUS && i!=NUMBER && i!=FOR_VARIABLE && i!=IDENTIFIER) {
                jjLa1[16] = jjGen;
                break;
            }
        }
        {
            return argument.toString();
        }
    }

    public final CssAttributeSelectorNode attribute() throws ParseException {
        Token t;
        CssStringNode stringNode = null;
        CssLiteralNode idNode = null;
        String attribute;
        List<Token> tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        CssAttributeSelectorNode.MatchType matchType =
                CssAttributeSelectorNode.MatchType.ANY;
        t = jjConsumeToken(LEFTSQUARE);
        beginLocation = this.getLocation();
        tokens.add(t);
        try {
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[17] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            t = jjConsumeToken(IDENTIFIER);
            attribute = t.image;
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[18] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case EQUALS:
                case TILDE_EQUALS:
                case CARET_EQUALS:
                case DOLLAR_EQUALS:
                case ASTERISK_EQUALS:
                case PIPE_EQUALS: {
                    switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                        case EQUALS: {
                            t = jjConsumeToken(EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.EXACT;
                            break;
                        }
                        case TILDE_EQUALS: {
                            t = jjConsumeToken(TILDE_EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.ONE_WORD;
                            break;
                        }
                        case CARET_EQUALS: {
                            t = jjConsumeToken(CARET_EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.PREFIX;
                            break;
                        }
                        case DOLLAR_EQUALS: {
                            t = jjConsumeToken(DOLLAR_EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.SUFFIX;
                            break;
                        }
                        case ASTERISK_EQUALS: {
                            t = jjConsumeToken(ASTERISK_EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.CONTAINS;
                            break;
                        }
                        case PIPE_EQUALS: {
                            t = jjConsumeToken(PIPE_EQUALS);
                            tokens.add(t);
                            matchType = CssAttributeSelectorNode.MatchType.EXACT_OR_DASH;
                            break;
                        }
                        default:
                            jjLa1[19] = jjGen;
                            jjConsumeToken(-1);
                            throw new ParseException();
                    }
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[20] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                        case IDENTIFIER: {
                            t = jjConsumeToken(IDENTIFIER);
                            idNode = new CssLiteralNode(t.image, this.getLocation());
                            tokens.add(t);
                            break;
                        }
                        case DOUBLE_QUOTED_STRING:
                        case SINGLE_QUOTED_STRING: {
                            stringNode = string();
                            break;
                        }
                        default:
                            jjLa1[21] = jjGen;
                            jjConsumeToken(-1);
                            throw new ParseException();
                    }
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[22] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    break;
                }
                default:
                    jjLa1[23] = jjGen;
            }
            t = jjConsumeToken(RIGHTSQUARE);
            tokens.add(t);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(RIGHTSQUARE);
            {
                throw e;
            }
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssValueNode v;
        if (stringNode!=null) {
            v = stringNode;
        } else if (idNode!=null) {
            v = idNode;
        } else {
            v = new CssLiteralNode("");
        }
        {
            return nodeBuilder.buildAttributeSelectorNode(
                    matchType, attribute, v,
                    this.mergeLocations(beginLocation, endLocation), tokens);
        }
    }

    public final CssSelectorNode simpleSelector() throws ParseException {
        CssRefinerNode n;
        Token selectorName = null;
        CssRefinerListNode refiners = new CssRefinerListNode();
        SourceCodeLocation beginLocation;
        beginLocation = this.getLocation(token.next);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case ASTERISK:
            case IDENTIFIER: {
                selectorName = elementName();
                while (true) {
                    int i = (jjNtk==-1) ? jjNtkF():jjNtk;
                    if (i!=COLON && i!=DOT && i!=LEFTSQUARE && i!=HASH_NAME) {
                        jjLa1[24] = jjGen;
                        break;
                    }
                    switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                        case HASH_NAME: {
                            n = id();
                            break;
                        }
                        case DOT: {
                            n = className();
                            break;
                        }
                        case LEFTSQUARE: {
                            n = attribute();
                            break;
                        }
                        case COLON: {
                            n = pseudo();
                            break;
                        }
                        default:
                            jjLa1[25] = jjGen;
                            jjConsumeToken(-1);
                            throw new ParseException();
                    }
                    refiners.addChildToBack(n);
                }
                break;
            }
            case COLON:
            case DOT:
            case LEFTSQUARE:
            case HASH_NAME: {
                while (true) {
                    switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                        case HASH_NAME: {
                            n = id();
                            break;
                        }
                        case DOT: {
                            n = className();
                            break;
                        }
                        case LEFTSQUARE: {
                            n = attribute();
                            break;
                        }
                        case COLON: {
                            n = pseudo();
                            break;
                        }
                        default:
                            jjLa1[26] = jjGen;
                            jjConsumeToken(-1);
                            throw new ParseException();
                    }
                    refiners.addChildToBack(n);
                    int i = (jjNtk==-1) ? jjNtkF():jjNtk;
                    if (i!=COLON && i!=DOT && i!=LEFTSQUARE && i!=HASH_NAME) {
                        jjLa1[27] = jjGen;
                        break;
                    }
                }
                break;
            }
            default:
                jjLa1[28] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssSelectorNode selectorNode = nodeBuilder.buildSelectorNode(selectorName,
                this.mergeLocations(beginLocation, endLocation), refiners);
        {
            return selectorNode;
        }
    }

    public final Token elementName() throws ParseException {
        Token t;
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case IDENTIFIER: {
                t = jjConsumeToken(IDENTIFIER);
                break;
            }
            case ASTERISK: {
                t = jjConsumeToken(ASTERISK);
                break;
            }
            default:
                jjLa1[29] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        {
            return t;
        }
    }

    public final CssCombinatorNode combinator() throws ParseException {
        Token t;
        List<Token> tokens = Lists.newArrayList();
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case WPLUS: {
                t = jjConsumeToken(WPLUS);
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[30] = jjGen;
                        break;
                    }
                    jjConsumeToken(S);
                }
                tokens.add(t);
                {
                    return nodeBuilder.buildCombinatorNode(
                            CssCombinatorNode.Combinator.ADJACENT_SIBLING, this.getLocation(),
                            tokens);
                }
            }
            case WGREATER: {
                t = jjConsumeToken(WGREATER);
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[31] = jjGen;
                        break;
                    }
                    jjConsumeToken(S);
                }
                tokens.add(t);
                {
                    return nodeBuilder.buildCombinatorNode(
                            CssCombinatorNode.Combinator.CHILD, this.getLocation(), tokens);
                }
            }
            case WTILDE: {
                t = jjConsumeToken(WTILDE);
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[32] = jjGen;
                        break;
                    }
                    jjConsumeToken(S);
                }
                tokens.add(t);
                {
                    return nodeBuilder.buildCombinatorNode(
                            CssCombinatorNode.Combinator.GENERAL_SIBLING, this.getLocation(),
                            tokens);
                }
            }
            case WDEEP: {
                t = jjConsumeToken(WDEEP);
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[33] = jjGen;
                        break;
                    }
                    jjConsumeToken(S);
                }
                tokens.add(t);
                {
                    return nodeBuilder.buildCombinatorNode(
                            CssCombinatorNode.Combinator.DEEP, this.getLocation(), tokens);
                }
            }
            case S: {
                while (true) {
                    t = jjConsumeToken(S);
                    tokens.add(t);
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[34] = jjGen;
                        break;
                    }
                }
                {
                    return nodeBuilder.buildCombinatorNode(
                            CssCombinatorNode.Combinator.DESCENDANT, this.getLocation(), tokens);
                }
            }
            default:
                jjLa1[35] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
    }

    public final CssDeclarationBlockNode styleDeclaration() throws ParseException {
        CssDeclarationBlockNode block = new CssDeclarationBlockNode();
        CssNode decl;
        try {
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[36] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case ASTERISK:
                case IDENTIFIER:
                case CUSTOM_PROPERTY_NAME: {
                    decl = declaration();
                    block.addChildToBack(decl);
                    break;
                }
                default:
                    jjLa1[37] = jjGen;
            }
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[38] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            handledErrors.add(new GssParserException(getLocation(e.currentToken.next), e));
        }
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=SEMICOLON && i!=ATKEYWORD) {
                jjLa1[39] = jjGen;
                break;
            }
            try {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case ATKEYWORD: {
                        try {
                            decl = innerAtRule();
                            block.addChildToBack(decl);
                        } catch (ParseException e) {
                            if (!enableErrorRecovery || e.currentToken==null) {
                                throw e;
                            }
                            handledErrors.add(new GssParserException(getLocation(e.currentToken.next), e));
                        }
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[40] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                            case ASTERISK:
                            case IDENTIFIER:
                            case CUSTOM_PROPERTY_NAME: {
                                decl = declaration();
                                block.addChildToBack(decl);
                                break;
                            }
                            default:
                                jjLa1[41] = jjGen;
                        }
                        break;
                    }
                    case SEMICOLON: {
                        jjConsumeToken(SEMICOLON);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[42] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                            case ASTERISK:
                            case IDENTIFIER:
                            case CUSTOM_PROPERTY_NAME: {
                                decl = declaration();
                                block.addChildToBack(decl);
                                break;
                            }
                            default:
                                jjLa1[43] = jjGen;
                        }
                        break;
                    }
                    default:
                        jjLa1[44] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
            } catch (ParseException e) {
                if (!enableErrorRecovery || e.currentToken==null) {
                    throw e;
                }
                handledErrors.add(new GssParserException(getLocation(e.currentToken.next), e));
            }
        }
        {
            return block;
        }
    }

    public final CssNode declaration() throws ParseException {
        CssNode decl;
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case ASTERISK:
            case IDENTIFIER: {
                decl = standardDeclaration();
                break;
            }
            case CUSTOM_PROPERTY_NAME: {
                decl = customDeclaration();
                break;
            }
            default:
                jjLa1[45] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        {
            return decl;
        }
    }

    public final CssDeclarationNode customDeclaration() throws ParseException {
        Token t;
        CssPropertyNode property;
        CssPropertyValueNode valueNode;
        List<Token> tokens = Lists.newArrayList();
        try {
            t = jjConsumeToken(CUSTOM_PROPERTY_NAME);
            property = new CssPropertyNode(t.image, this.getLocation());
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[46] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            t = jjConsumeToken(COLON);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[47] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            valueNode = customDeclarationValue();
            {
                return nodeBuilder.buildDeclarationNode(property, valueNode, tokens);
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToBefore(RIGHTBRACE, SEMICOLON);
            {
                throw e;
            }
        }
    }

    public final CssPropertyValueNode customDeclarationValue() throws ParseException {
        CssPropertyValueNode value;
        value = expr();
        {
            return value;
        }
    }

    public final CssDeclarationNode standardDeclaration() throws ParseException {
        Token t;
        CssPropertyNode property;
        CssPropertyValueNode valueNode;
        CssPriorityNode priority = null;
        List<Token> tokens = Lists.newArrayList();
        String propertyName = "";
        try {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==ASTERISK) {
                t = jjConsumeToken(ASTERISK);
                tokens.add(t);
                propertyName = "*";
            } else {
                jjLa1[48] = jjGen;
            }
            // allows "star hack"
            t = jjConsumeToken(IDENTIFIER);
            propertyName = propertyName + t.image;
            property = new CssPropertyNode(propertyName, this.getLocation());
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[49] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            t = jjConsumeToken(COLON);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[50] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            valueNode = expr();
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[51] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==IMPORTANT_SYM) {
                priority = important();
            } else {
                jjLa1[52] = jjGen;
            }
            if (priority!=null) {
                valueNode.addChildToBack(priority);
            }
            CssDeclarationNode node = nodeBuilder.buildDeclarationNode(property, valueNode, tokens);
            {
                return node;
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToBefore(RIGHTBRACE, SEMICOLON);
            {
                throw e;
            }
        }
    }

    public final CssPropertyValueNode expr() throws ParseException {
        List<CssValueNode> lst = Lists.newArrayList();
        CssValueNode value;
        value = compositeTerm();
        lst.add(value);
        while (jj22(1)) {
            value = compositeTerm();
            lst.add(value);
        }
        CssPropertyValueNode result = new CssPropertyValueNode(lst);
        result.setSourceCodeLocation(mergeLocations(lst));
        {
            return result;
        }
    }

    public final CssValueNode compositeTerm() throws ParseException {
        CssValueNode value;
        List<CssValueNode> lst = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        value = assignTerm();
        lst.add(value);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=COMMA) {
                jjLa1[53] = jjGen;
                break;
            }
            t = jjConsumeToken(COMMA);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[54] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            value = assignTerm();
            lst.add(value);
        }
        if (lst.size()==1) {
            {
                return lst.get(0);
            }
        } else {
            {
                return nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.COMMA,
                        this.mergeLocations(beginLocation, this.getLocation()), tokens);
            }
        }
    }

    public final CssValueNode assignTerm() throws ParseException {
        CssValueNode value;
        List<CssValueNode> lst = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        value = slashTerm();
        lst.add(value);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=EQUALS) {
                jjLa1[55] = jjGen;
                break;
            }
            t = jjConsumeToken(EQUALS);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[56] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            value = slashTerm();
            lst.add(value);
        }
        if (lst.size()==1) {
            {
                return lst.get(0);
            }
        }
        {
            return nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.EQUALS,
                    this.mergeLocations(beginLocation, this.getLocation()), tokens);
        }
    }

    public final CssValueNode slashTerm() throws ParseException {
        CssValueNode value;
        List<CssValueNode> lst = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        value = term();
        lst.add(value);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=SLASH) {
                jjLa1[57] = jjGen;
                break;
            }
            t = jjConsumeToken(SLASH);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[58] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            value = term();
            lst.add(value);
        }
        if (lst.size()==1) {
            {
                return lst.get(0);
            }
        } else {
            {
                return nodeBuilder.buildCompositeValueNode(lst, CssCompositeValueNode.Operator.SLASH,
                        this.mergeLocations(beginLocation, this.getLocation()), tokens);
            }
        }
    }

    public final CssValueNode term() throws ParseException {
        Token t = null;
        Token dim = null;
        String unit = null;
        String unop = "";
        CssFunctionNode function = null;
        CssStringNode stringNode = null;
        List<Token> tokens = Lists.newArrayList();
        boolean hexcolor = false;
        boolean loopVariable = false;
        boolean unicodeRange = false;
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case MINUS:
            case WPLUS:
            case NUMBER: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case MINUS:
                    case WPLUS: {
                        t = unaryOperator();
                        unop = trim(t.image);
                        tokens.add(t);
                        break;
                    }
                    default:
                        jjLa1[59] = jjGen;
                }
                // Number with optional arbitrary dimension or percent.
                t = jjConsumeToken(NUMBER);
                unit = CssNumericNode.NO_UNITS;
                tokens.add(t);
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case PERCENT:
                    case IDENTIFIER: {
                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                            case PERCENT: {
                                dim = jjConsumeToken(PERCENT);
                                break;
                            }
                            case IDENTIFIER: {
                                dim = jjConsumeToken(IDENTIFIER);
                                break;
                            }
                            default:
                                jjLa1[60] = jjGen;
                                jjConsumeToken(-1);
                                throw new ParseException();
                        }
                        unit = dim.image.toLowerCase();
                        tokens.add(dim);
                        break;
                    }
                    default:
                        jjLa1[61] = jjGen;
                }
                break;
            }
            case UNICODE_RANGE: {
                t = jjConsumeToken(UNICODE_RANGE);
                unicodeRange = true;
                tokens.add(t);
                break;
            }
            case DOUBLE_QUOTED_STRING:
            case SINGLE_QUOTED_STRING: {
                stringNode = string();
                break;
            }
            default:
                jjLa1[70] = jjGen;
                if (jj23(1)) {
                    if (getToken(2).kind==DOT || getToken(2).kind==COLON) {
                        jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    t = jjConsumeToken(IDENTIFIER);
                    tokens.add(t);
                } else {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)==FOR_VARIABLE) {// For variables will be evaluated to a number eventually.
                        t = jjConsumeToken(FOR_VARIABLE);
                        loopVariable = true;
                        tokens.add(t);
                    } else {
                        jjLa1[71] = jjGen;
                        if (jj24(1)) {
                            if (getToken(1).kind==LEFTROUND
                                    && (getToken(3).kind==COLON || getToken(4).kind==COLON)) {

                            } else {
                                jjConsumeToken(-1);
                                throw new ParseException();
                            }
                            t = jjConsumeToken(LEFTROUND);
                            tokens.add(t);
                            try {
                                if (((jjNtk==-1) ? jjNtkF():jjNtk)==S) {
                                    jjConsumeToken(S);
                                } else {
                                    jjLa1[62] = jjGen;
                                }
                                t = jjConsumeToken(IDENTIFIER);
                                tokens.add(t);
                                t = jjConsumeToken(COLON);
                                tokens.add(t);
                                while (true) {
                                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                        jjLa1[63] = jjGen;
                                        break;
                                    }
                                    jjConsumeToken(S);
                                }
                                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                                    case NUMBER: {
                                        t = jjConsumeToken(NUMBER);
                                        tokens.add(t);
                                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                                            case SLASH:
                                            case S: {
                                                while (true) {
                                                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                                        jjLa1[64] = jjGen;
                                                        break;
                                                    }
                                                    jjConsumeToken(S);
                                                }
                                                t = jjConsumeToken(SLASH);
                                                tokens.add(t);
                                                while (true) {
                                                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                                        jjLa1[65] = jjGen;
                                                        break;
                                                    }
                                                    jjConsumeToken(S);
                                                }
                                                t = jjConsumeToken(NUMBER);
                                                tokens.add(t);
                                                break;
                                            }
                                            default:
                                                jjLa1[66] = jjGen;
                                        }
                                        if (((jjNtk==-1) ? jjNtkF():jjNtk)==IDENTIFIER) {
                                            dim = jjConsumeToken(IDENTIFIER);
                                            tokens.add(dim);
                                        } else {
                                            jjLa1[67] = jjGen;
                                        }
                                        break;
                                    }
                                    case IDENTIFIER: {
                                        t = jjConsumeToken(IDENTIFIER);
                                        tokens.add(t);
                                        break;
                                    }
                                    default:
                                        jjLa1[68] = jjGen;
                                        jjConsumeToken(-1);
                                        throw new ParseException();
                                }
                                while (true) {
                                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                        jjLa1[69] = jjGen;
                                        break;
                                    }
                                    jjConsumeToken(S);
                                }
                                t = jjConsumeToken(RIGHTROUND);
                                tokens.add(t);
                            } catch (ParseException e) {
                                if (!enableErrorRecovery || e.currentToken==null) {
                                    throw e;
                                }
                                skipComponentValuesToAfter(RIGHTROUND);
                                {
                                    throw e;
                                }
                            }
                        } else if (getToken(1).kind==URI) {
                            function = uri();
                        } else {
                            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                                case HASH_NAME: {
                                    t = hexcolor();
                                    tokens.add(t);
                                    hexcolor = true;
                                    break;
                                }
                                case CALC: {
                                    function = calc();
                                    break;
                                }
                                case VARFUNCTION: {
                                    function = varNode();
                                    break;
                                }
                                case IDENTIFIER:
                                case FUNCTION: {
                                    function = function();
                                    break;
                                }
                                default:
                                    jjLa1[72] = jjGen;
                                    jjConsumeToken(-1);
                                    throw new ParseException();
                            }
                        }
                    }
                }
        }
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[73] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        if (unit!=null) {
            SourceCodeLocation location;
            if (dim!=null) {
                location = this.mergeLocations(this.getLocation(t), this.getLocation(dim));
            } else {
                location = this.getLocation(t);
            }
            {
                return nodeBuilder.buildNumericNode(unop + t.image, unit, location, tokens);
            }
        } else if (function!=null) {
            {
                return function;
            }
        } else if (hexcolor) {
            {
                return nodeBuilder.buildHexColorNode(t.image, this.getLocation(t), tokens);
            }
        } else if (stringNode!=null) {
            {
                return stringNode;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (Token token : tokens) {
                sb.append(token.image);
            }
            if (loopVariable) {
                {

                    return nodeBuilder.buildLoopVariableNode(sb.toString(), this.getLocation(t), tokens);
                }
            } else if (unicodeRange) {
                {

                    return nodeBuilder.buildUnicodeRangeNode(sb.toString(), this.getLocation(t), tokens);
                }
            } else {
                {
                    return nodeBuilder.buildLiteralNode(sb.toString(), this.getLocation(t), tokens);
                }
            }
        }
    }

    public final CssBooleanExpressionNode extendedTerm() throws ParseException {
        SourceCodeLocation beginLocation;
        SourceCodeLocation endLocation;
        CssBooleanExpressionNode newNode;
        CssBooleanExpressionNode left;
        CssBooleanExpressionNode right;
        StringBuilder value = new StringBuilder();
        Token t;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        left = booleanAndTerm();
        value.append(left.toString());
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=OR) {
                jjLa1[74] = jjGen;
                break;
            }
            t = jjConsumeToken(OR);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[75] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            right = booleanAndTerm();
            value.append(right.toString());
            endLocation = this.getLocation();
            newNode = nodeBuilder.buildBoolExpressionNode(
                    CssBooleanExpressionNode.Type.OR, value.toString(), left, right,
                    this.mergeLocations(beginLocation, endLocation), tokens);
            left = newNode;
        }
        {
            return left;
        }
    }

    public final CssBooleanExpressionNode booleanAndTerm() throws ParseException {
        SourceCodeLocation beginLocation;
        SourceCodeLocation endLocation;
        CssBooleanExpressionNode newNode;
        CssBooleanExpressionNode left;
        CssBooleanExpressionNode right;
        StringBuilder value = new StringBuilder();
        Token t;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        if (((jjNtk==-1) ? jjNtkF():jjNtk)==EXCL_MARK) {
            left = booleanNegatedTerm();
        } else {
            jjLa1[76] = jjGen;
            if (jj25(1)) {
                left = basicTerm();
            } else {
                jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        value.append(left);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=AND) {
                jjLa1[77] = jjGen;
                break;
            }
            t = jjConsumeToken(AND);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[78] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==EXCL_MARK) {
                right = booleanNegatedTerm();
            } else {
                jjLa1[79] = jjGen;
                if (jj26(1)) {
                    right = basicTerm();
                } else {
                    jjConsumeToken(-1);
                    throw new ParseException();
                }
            }
            value.append(right);
            endLocation = this.getLocation();
            newNode = nodeBuilder.buildBoolExpressionNode(
                    CssBooleanExpressionNode.Type.AND, value.toString(), left, right,
                    this.mergeLocations(beginLocation, endLocation), tokens);
            left = newNode;
        }
        {
            return left;
        }
    }

    public final CssBooleanExpressionNode booleanNegatedTerm() throws ParseException {
        SourceCodeLocation beginLocation;
        String value;
        CssBooleanExpressionNode boolNode;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        t = jjConsumeToken(EXCL_MARK);
        value = "!";
        beginLocation = this.getLocation();
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[80] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        boolNode = basicTerm();
        SourceCodeLocation endLocation = this.getLocation();
        {
            return nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.NOT,
                    value, boolNode, null, this.mergeLocations(beginLocation, endLocation), tokens);
        }
    }

    public final CssBooleanExpressionNode basicTerm() throws ParseException {
        SourceCodeLocation beginLocation;
        String value;
        CssBooleanExpressionNode node = null;
        CssValueNode termNode;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        if (jj27(1)) {
            termNode = term();
            value = termNode.toString();
        } else {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==LEFTROUND) {
                node = parenthesizedTerm();
                value = node.toString();
            } else {
                jjLa1[81] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
            }
        }
        SourceCodeLocation endLocation = this.getLocation();
        if (node==null) {
            {
                return nodeBuilder.buildBoolExpressionNode(CssBooleanExpressionNode.Type.CONSTANT,
                        value, null, null, this.mergeLocations(beginLocation, endLocation), tokens);
            }
        } else {
            {
                return node;
            }
        }
    }

    public final CssBooleanExpressionNode parenthesizedTerm() throws ParseException {
        Token t;
        List<Token> tokens = Lists.newArrayList();
        CssBooleanExpressionNode node;
        t = jjConsumeToken(LEFTROUND);
        tokens.add(t);
        try {
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[82] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            node = extendedTerm();
            t = jjConsumeToken(RIGHTROUND);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[83] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(RIGHTROUND);
            {
                throw e;
            }
        }
        nodeBuilder.attachComments(tokens, node);
        {
            return node;
        }
    }

    public final Token unaryOperator() throws ParseException {
        Token t;
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case MINUS: {
                t = jjConsumeToken(MINUS);
                break;
            }
            case WPLUS: {
                t = jjConsumeToken(WPLUS);
                break;
            }
            default:
                jjLa1[84] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        {
            return t;
        }
    }

    /*
     * There is a constraint on the color that it must
     * have either 3 or 6 hex-digits (i.e., [0-9a-fA-F])
     * after the "#"; e.g., "#000" is OK, but "#abcd" is not.
     */
    public final Token hexcolor() throws ParseException {
        Token t;
        t = jjConsumeToken(HASH_NAME);
        {
            return t;
        }
    }

    public final CssFunctionNode varNode() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        StringBuilder functionName = new StringBuilder();
        CssPropertyValueNode defaultValueNode;
        List<Token> tokens = Lists.newArrayList();
        List<CssValueNode> arguments = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        t = jjConsumeToken(VARFUNCTION);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[85] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        t = jjConsumeToken(CUSTOM_PROPERTY_NAME);
        arguments.add(new CssPropertyNode(t.image, this.getLocation()));
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[86] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        if (((jjNtk==-1) ? jjNtkF():jjNtk)==COMMA) {
            t = jjConsumeToken(COMMA);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[87] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            defaultValueNode = customDeclarationValue();
            arguments.add(defaultValueNode.getChildAt(0));
        } else {
            jjLa1[88] = jjGen;
        }
        t = jjConsumeToken(RIGHTROUND);
        tokens.add(t);
        SourceCodeLocation endLocation = this.getLocation(t);
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        addArgumentsWithSeparator(args, arguments, arguments.size(), ",");
        {
            return nodeBuilder.buildFunctionNode(
                    functionName.toString(),
                    this.mergeLocations(beginLocation, endLocation), args, tokens);
        }
    }

    public final CssFunctionNode uri() throws ParseException {
        Token t;
        this.getLocation(token.next);
        t = jjConsumeToken(URI);
        {
            return createUrlFunction(t);
        }
    }

    /**
     * Note: We allow the function name to have : and . to support non-standard IE functions
     *
     * @return function node
     * @throws ParseException
     */
    public final CssFunctionNode function() throws ParseException {
        Token t;
        CssPropertyValueNode expr;
        SourceCodeLocation beginLocation;
        StringBuilder functionName = new StringBuilder();
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case FUNCTION: {
                t = jjConsumeToken(FUNCTION);
                functionName.append(t.image);
                functionName.setLength(functionName.length() - 1);
                tokens.add(t);
                break;
            }
            case IDENTIFIER: {
                t = jjConsumeToken(IDENTIFIER);
                functionName.append(t.image);
                tokens.add(t);
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case DOT: {
                        jjConsumeToken(DOT);
                        functionName.append(".");
                        break;
                    }
                    case COLON: {
                        jjConsumeToken(COLON);
                        functionName.append(":");
                        break;
                    }
                    default:
                        jjLa1[89] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=IDENTIFIER) {
                        jjLa1[90] = jjGen;
                        break;
                    }
                    t = jjConsumeToken(IDENTIFIER);
                    functionName.append(t.image);
                    switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                        case DOT: {
                            jjConsumeToken(DOT);
                            functionName.append(".");
                            break;
                        }
                        case COLON: {
                            jjConsumeToken(COLON);
                            functionName.append(":");
                            break;
                        }
                        default:
                            jjLa1[91] = jjGen;
                            jjConsumeToken(-1);
                            throw new ParseException();
                    }
                }
                t = jjConsumeToken(FUNCTION);
                functionName.append(t.image);
                functionName.setLength(functionName.length() - 1);
                break;
            }
            default:
                jjLa1[92] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[93] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        expr = expr();
        t = jjConsumeToken(RIGHTROUND);
        tokens.add(t);
        SourceCodeLocation endLocation = this.getLocation();
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        if (expr.numChildren()==1) {
            CssValueNode child = expr.getChildAt(0);
            addArgumentsWithSeparator(args, ImmutableList.of(child), 1, " ");
        } else if (FUNCTIONSWITHSPACESEPOK.matcher(functionName).matches()) {
            addArgumentsWithSeparator(args, expr.childIterable(), expr.numChildren(), " ");
        } else {
            {
                throw generateParseException();
            }
        }
        CssFunctionNode functionNode = nodeBuilder.buildFunctionNode(
                functionName.toString(),
                this.mergeLocations(beginLocation, endLocation), args, tokens);
        {
            return functionNode;
        }
    }

    // TODO(user): this production disallows nested calc() expressions like calc(1 + calc(2*3)).
// (This is equivalent to calc(1 + (2*3)), which is allowed by this production.)
    public final CssFunctionNode calc() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        StringBuilder functionName = new StringBuilder();
        CssValueNode math;
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        t = jjConsumeToken(CALC);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[94] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        math = sum(/* hasParenthesis */ false);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[95] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        t = jjConsumeToken(RIGHTROUND);
        tokens.add(t);
        SourceCodeLocation endLocation = this.getLocation(t);
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        addArgumentsWithSeparator(args, ImmutableList.of(math), 1, "");
        {
            return nodeBuilder.buildFunctionNode(
                    functionName.toString(),
                    this.mergeLocations(beginLocation, endLocation), args, tokens);
        }
    }

    public final CssValueNode sum(boolean hasParenthesis) throws ParseException {
        CssValueNode operand;
        List<CssValueNode> operands = new ArrayList<>();
        List<CssCompositeValueNode.Operator> operators = new ArrayList<>();
        operand = product(hasParenthesis);
        operands.add(operand);
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=WMINUSW && i!=WPLUS) {
                jjLa1[96] = jjGen;
                break;
            }
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case WPLUS: {
                    jjConsumeToken(WPLUS);
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[97] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    operators.add(CssCompositeValueNode.Operator.ADD);
                    break;
                }
                case WMINUSW: {
                    jjConsumeToken(WMINUSW);
                    operators.add(CssCompositeValueNode.Operator.SUB);
                    break;
                }
                default:
                    jjLa1[98] = jjGen;
                    jjConsumeToken(-1);
                    throw new ParseException();
            }
            operand = product(/* hasParenthesis */ false);
            operands.add(operand);
        }
        {
            return CssMathNode.createFromOperandsAndOperators(operands, operators, hasParenthesis);
        }
    }

    public final CssValueNode product(boolean hasParenthesis) throws ParseException {
        Token t;
        CssValueNode operand;
        List<CssValueNode> operands = new ArrayList<>();
        List<CssCompositeValueNode.Operator> operators = new ArrayList<>();
        operand = unit();
        operands.add(operand);
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=ASTERISK && i!=SLASH && i!=S) {
                jjLa1[99] = jjGen;
                break;
            }
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[100] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case ASTERISK: {
                    jjConsumeToken(ASTERISK);
                    operators.add(CssCompositeValueNode.Operator.MULT);
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[101] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    operand = unit();
                    operands.add(operand);
                    break;
                }
                case SLASH: {
                    jjConsumeToken(SLASH);
                    operators.add(CssCompositeValueNode.Operator.DIV);
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[102] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    t = jjConsumeToken(NUMBER);
                    operands.add(new CssNumericNode(t.image, ""));
                    break;
                }
                default:
                    jjLa1[103] = jjGen;
                    jjConsumeToken(-1);
                    throw new ParseException();
            }
        }
        {
            return CssMathNode.createFromOperandsAndOperators(operands, operators, hasParenthesis);
        }
    }

    public final CssValueNode unit() throws ParseException {
        Token t;
        String sign = "";
        Token dim = null;
        CssValueNode node;
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case MINUS:
            case WPLUS:
            case NUMBER:
            case IDENTIFIER:
            case VARFUNCTION: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case VARFUNCTION: {
                        node = varNode();
                        {
                            return node;
                        }
                    }
                    case IDENTIFIER: {
                        t = jjConsumeToken(IDENTIFIER);
                        {
                            return new CssLiteralNode(t.image, this.getLocation(t));
                        }
                    }
                    case MINUS:
                    case WPLUS:
                    case NUMBER: {
                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                            case MINUS:
                            case WPLUS: {
                                t = unaryOperator();
                                sign = t.image;
                                break;
                            }
                            default:
                                jjLa1[104] = jjGen;
                        }
                        t = jjConsumeToken(NUMBER);

                        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                            case PERCENT:
                            case IDENTIFIER: {
                                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                                    case PERCENT: {
                                        dim = jjConsumeToken(PERCENT);
                                        break;
                                    }
                                    case IDENTIFIER: {
                                        dim = jjConsumeToken(IDENTIFIER);
                                        break;
                                    }
                                    default:
                                        jjLa1[105] = jjGen;
                                        jjConsumeToken(-1);
                                        throw new ParseException();
                                }

                                break;
                            }
                            default:
                                jjLa1[106] = jjGen;
                        }
                        {
                            return new CssNumericNode(sign + t.image, dim!=null ? dim.image.toLowerCase():"", this.getLocation(t));
                        }
                    }
                    default:
                        jjLa1[107] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
            }
            case LEFTROUND: {
                jjConsumeToken(LEFTROUND);

                try {
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[108] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    node = sum(/* hasParenthesis */ true);

                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[109] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    jjConsumeToken(RIGHTROUND);
                    {
                        return node;
                    }
                } catch (ParseException e) {
                    if (!enableErrorRecovery || e.currentToken==null) {
                        throw e;
                    }
                    skipComponentValuesToAfter(RIGHTROUND);
                    {
                        throw e;
                    }
                }
            }
            default:
                jjLa1[110] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
    }

    public final CssFunctionNode atFunction() throws ParseException {
        Token t;
        CssPropertyValueNode expr = null;
        SourceCodeLocation beginLocation;
        StringBuilder functionName = new StringBuilder();
        List<Token> tokens = Lists.newArrayList();
        beginLocation = this.getLocation(token.next);
        t = jjConsumeToken(FUNCTION);
        functionName.append(t.image);
        functionName.setLength(functionName.length() - 1);
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[111] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        if (jj28(1)) {
            expr = expr();
        }
        t = jjConsumeToken(RIGHTROUND);
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[112] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssFunctionArgumentsNode args = new CssFunctionArgumentsNode();
        if (expr!=null && expr.numChildren()==1) {
            CssValueNode child = expr.getChildAt(0);
            addArgumentsWithSeparator(args, ImmutableList.of(child), 1, " ");
        } else if (expr!=null) {
            addArgumentsWithSeparator(args, expr.childIterable(), expr.numChildren(),
                    " ");
        }
        CssFunctionNode functionNode = nodeBuilder.buildFunctionNode(
                functionName.toString(),
                this.mergeLocations(beginLocation, endLocation), args, tokens);
        {
            return functionNode;
        }
    }

    public final CssPriorityNode important() throws ParseException {
        Token t;
        List<Token> tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        SourceCodeLocation endLocation;
        t = jjConsumeToken(IMPORTANT_SYM);
        beginLocation = this.getLocation();
        endLocation = this.getLocation();
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[113] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        {
            return nodeBuilder.buildPriorityNode(this.mergeLocations(beginLocation, endLocation), tokens);
        }
    }

    public final CssAtRuleNode atRule() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        CssLiteralNode name;
        CssValueNode v;
        CssBlockNode block = null;
        List<CssValueNode> parameters = Lists.newArrayList();
        List<Token> tokens = Lists.newArrayList();
        try {
            t = jjConsumeToken(ATKEYWORD);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[114] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            while (jj29(1)) {
                if (jj210(1)) {
                    v = compositeTerm();
                } else if (jj211(1)) {
                    v = extendedTerm();
                } else {
                    jjConsumeToken(-1);
                    throw new ParseException();
                }
                parameters.add(v);
                while (true) {
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                        jjLa1[115] = jjGen;
                        break;
                    }
                    jjConsumeToken(S);
                }
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            if (skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                skipComponentValuesToAfter(RIGHTBRACE);
            }
            {
                throw e;
            }
        }
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTBRACE: {
                t = jjConsumeToken(LEFTBRACE);
                tokens.add(t);
                try {
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[116] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    block = block(true);
                    t = jjConsumeToken(RIGHTBRACE);
                    tokens.add(t);
                } catch (ParseException e) {
                    if (!enableErrorRecovery || e.currentToken==null) {
                        throw e;
                    }
                    skipComponentValuesToAfter(RIGHTBRACE);
                    {
                        throw e;
                    }
                }
                break;
            }
            case SEMICOLON: {
                t = jjConsumeToken(SEMICOLON);
                tokens.add(t);
                break;
            }
            default:
                jjLa1[117] = jjGen;
                ParseException e = generateParseException();
                if (enableErrorRecovery && e.currentToken!=null && skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                    skipComponentValuesToAfter(RIGHTBRACE);
                }
            {
                throw e;
            }
        }
        SourceCodeLocation endLocation = getLocation(t);
        CssAtRuleNode at = nodeBuilder.buildUnknownAtRuleNode(name, block,
                this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        {
            return at;
        }
    }

    // TODO(fbenz): Try to reuse selctor parsing instead of [ IDENT? ':' IDENT S* ].
// The problem is that @-rules take a list of value nodes and selectors are not
// value nodes.
    public final CssAtRuleNode atRuleWithDeclBlock() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        CssLiteralNode name;
        CssValueNode v;
        CssAbstractBlockNode block = null;
        List<CssValueNode> parameters = Lists.newArrayList();
        List<Token> tokens = Lists.newArrayList();
        List<Token> pseudoPageTokens = Lists.newArrayList();
        try {
            t = jjConsumeToken(ATRULESWITHDECLBLOCK);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[118] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==FUNCTION) {
                v = atFunction();
                parameters.add(v);
            } else {
                jjLa1[122] = jjGen;
                if (jj215(1)) {
                    if (getToken(1).kind!=COLON && getToken(2).kind!=COLON) {
                        jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)==IDENTIFIER) {
                        t = jjConsumeToken(IDENTIFIER);
                        pseudoPageTokens.add(t);
                        v = nodeBuilder.buildLiteralNode(t.image, getLocation(t), pseudoPageTokens);
                        parameters.add(v);
                        pseudoPageTokens.clear();
                    } else {
                        jjLa1[119] = jjGen;
                    }
                    t = jjConsumeToken(COLON);
                    pseudoPageTokens.add(t);
                    t = jjConsumeToken(IDENTIFIER);
                    pseudoPageTokens.add(t);
                    v = nodeBuilder.buildLiteralNode(":" + t.image, getLocation(t), pseudoPageTokens);
                    parameters.add(v);
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[120] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                } else {
                    while (jj212(1)) {
                        if (jj213(1)) {
                            v = compositeTerm();
                        } else if (jj214(1)) {
                            v = extendedTerm();
                        } else {
                            jjConsumeToken(-1);
                            throw new ParseException();
                        }
                        parameters.add(v);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[121] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                    }
                }
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            if (skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                skipComponentValuesToAfter(RIGHTBRACE);
            }
            {
                throw e;
            }
        }
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTBRACE: {
                t = jjConsumeToken(LEFTBRACE);
                tokens.add(t);
                try {
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[123] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    block = styleDeclaration();
                    t = jjConsumeToken(RIGHTBRACE);
                    tokens.add(t);
                } catch (ParseException e) {
                    if (!enableErrorRecovery || e.currentToken==null) {
                        throw e;
                    }
                    skipComponentValuesToAfter(RIGHTBRACE);
                    {
                        throw e;
                    }
                }
                break;
            }
            case SEMICOLON: {
                t = jjConsumeToken(SEMICOLON);
                tokens.add(t);
                break;
            }
            default:
                jjLa1[124] = jjGen;
                ParseException e = generateParseException();
                if (enableErrorRecovery && e.currentToken!=null && skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                    skipComponentValuesToAfter(RIGHTBRACE);
                }
            {
                throw e;
            }
        }
        SourceCodeLocation endLocation = getLocation(t);
        CssAtRuleNode at = nodeBuilder.buildUnknownAtRuleNode(name, block,
                this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        {
            return at;
        }
    }

    public final CssAtRuleNode innerAtRule() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        CssLiteralNode name;
        CssValueNode v;
        CssAbstractBlockNode block = null;
        List<CssValueNode> parameters = Lists.newArrayList();
        List<Token> tokens = Lists.newArrayList();
        List<Token> pseudoPageTokens = Lists.newArrayList();
        try {
            t = jjConsumeToken(ATKEYWORD);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[125] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            if (((jjNtk==-1) ? jjNtkF():jjNtk)==FUNCTION) {
                v = atFunction();
                parameters.add(v);
            } else {
                jjLa1[129] = jjGen;
                if (jj219(1)) {
                    if (getToken(1).kind!=COLON && getToken(2).kind!=COLON) {
                        jjConsumeToken(-1);
                        throw new ParseException();
                    }
                    if (((jjNtk==-1) ? jjNtkF():jjNtk)==IDENTIFIER) {
                        t = jjConsumeToken(IDENTIFIER);
                        pseudoPageTokens.add(t);
                        v = nodeBuilder.buildLiteralNode(t.image, getLocation(t), pseudoPageTokens);
                        parameters.add(v);
                        pseudoPageTokens.clear();
                    } else {
                        jjLa1[126] = jjGen;
                    }
                    t = jjConsumeToken(COLON);
                    pseudoPageTokens.add(t);
                    t = jjConsumeToken(IDENTIFIER);
                    pseudoPageTokens.add(t);
                    v = nodeBuilder.buildLiteralNode(":" + t.image, getLocation(t), pseudoPageTokens);
                    parameters.add(v);
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[127] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                } else {
                    while (jj216(1)) {
                        if (jj217(1)) {
                            v = compositeTerm();
                        } else if (jj218(1)) {
                            v = extendedTerm();
                        } else {
                            jjConsumeToken(-1);
                            throw new ParseException();
                        }
                        parameters.add(v);
                        while (true) {
                            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                                jjLa1[128] = jjGen;
                                break;
                            }
                            jjConsumeToken(S);
                        }
                    }
                }
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            if (skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                skipComponentValuesToAfter(RIGHTBRACE);
            }
            {
                throw e;
            }
        }
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTBRACE: {
                t = jjConsumeToken(LEFTBRACE);
                tokens.add(t);
                try {
                    while (true) {
                        if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                            jjLa1[130] = jjGen;
                            break;
                        }
                        jjConsumeToken(S);
                    }
                    block = styleDeclaration();
                    t = jjConsumeToken(RIGHTBRACE);
                    tokens.add(t);
                } catch (ParseException e) {
                    if (!enableErrorRecovery || e.currentToken==null) {
                        throw e;
                    }
                    skipComponentValuesToAfter(RIGHTBRACE);
                    {
                        throw e;
                    }
                }
                break;
            }
            case SEMICOLON: {
                t = jjConsumeToken(SEMICOLON);
                tokens.add(t);
                break;
            }
            default:
                jjLa1[131] = jjGen;
                ParseException e = generateParseException();
                if (enableErrorRecovery && e.currentToken!=null && skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                    skipComponentValuesToAfter(RIGHTBRACE);
                }
            {
                throw e;
            }
        }
        SourceCodeLocation endLocation = getLocation(t);
        CssAtRuleNode at = nodeBuilder.buildUnknownAtRuleNode(name, block,
                this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        {
            return at;
        }
    }

    public final CssAtRuleNode webkitKeyframesRule() throws ParseException {
        Token t;
        SourceCodeLocation beginLocation;
        CssLiteralNode name;
        CssBlockNode block;
        List<CssValueNode> parameters = Lists.newArrayList();
        List<Token> tokens = Lists.newArrayList();
        try {
            t = jjConsumeToken(WEBKITKEYFRAMES);
            beginLocation = this.getLocation(t);
            name = new CssLiteralNode(t.image.substring(1), beginLocation);
            tokens.add(t);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[132] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            t = jjConsumeToken(IDENTIFIER);
            List<Token> identifierTokens = Lists.newArrayList();
            identifierTokens.add(t);
            CssLiteralNode l =
                    nodeBuilder.buildLiteralNode(t.image, getLocation(t), identifierTokens);
            parameters.add(l);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[133] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            if (skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                skipComponentValuesToAfter(RIGHTBRACE);
            }
            {
                throw e;
            }
        }
        t = jjConsumeToken(LEFTBRACE);
        tokens.add(t);
        try {
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[134] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            block = webkitKeyframesBlock();
            t = jjConsumeToken(RIGHTBRACE);
            tokens.add(t);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(RIGHTBRACE);
            {
                throw e;
            }
        }
        SourceCodeLocation endLocation = getLocation(t);
        CssAtRuleNode at = nodeBuilder.buildWebkitKeyframesNode(name, block,
                this.mergeLocations(beginLocation, endLocation), parameters, tokens);
        {
            return at;
        }
    }

    public final CssBlockNode webkitKeyframesBlock() throws ParseException {
        CssBlockNode block;
        CssNode n;
        block = new CssBlockNode(true);
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=NUMBER && i!=IDENTIFIER) {
                jjLa1[135] = jjGen;
                break;
            }
            n = webkitKeyframeRuleSet();
            block.addChildToBack(n);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[136] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
        }
        {
            return block;
        }
    }

    public final CssKeyframeRulesetNode webkitKeyframeRuleSet() throws ParseException {
        CssKeyListNode keys;
        CssDeclarationBlockNode declarations;
        Token t;
        List<Token> tokens = Lists.newArrayList();
        try {
            keys = keyList();
            t = jjConsumeToken(LEFTBRACE);
            tokens.add(t);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            if (skipComponentValuesToAfter(SEMICOLON, LEFTBRACE)==LEFTBRACE) {
                skipComponentValuesToAfter(RIGHTBRACE);
            }
            {
                throw e;
            }
        }
        try {
            declarations = styleDeclaration();
            t = jjConsumeToken(RIGHTBRACE);
            tokens.add(t);
        } catch (ParseException e) {
            if (!enableErrorRecovery || e.currentToken==null) {
                throw e;
            }
            skipComponentValuesToAfter(RIGHTBRACE);
            {
                throw e;
            }
        }
        CssKeyframeRulesetNode ruleSet =
                nodeBuilder.buildKeyframeRulesetNode(declarations, keys, tokens);
        {
            return ruleSet;
        }
    }

    public final CssKeyListNode keyList() throws ParseException {
        CssKeyListNode list = new CssKeyListNode();
        CssKeyNode key;
        Token t;
        key = key();
        list.addChildToBack(key);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=COMMA) {
                jjLa1[137] = jjGen;
                break;
            }
            t = jjConsumeToken(COMMA);
            nodeBuilder.attachComment(t, key);
            while (true) {
                if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                    jjLa1[138] = jjGen;
                    break;
                }
                jjConsumeToken(S);
            }
            key = key();
            list.addChildToBack(key);
        }
        {
            return list;
        }
    }

    public final CssKeyNode key() throws ParseException {
        Token key;
        Token t;
        Token dim;
        String value;
        List<Token> tokens = Lists.newArrayList();
        SourceCodeLocation beginLocation;
        beginLocation = this.getLocation(token.next);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case NUMBER: {
                key = jjConsumeToken(NUMBER);
                tokens.add(key);
                dim = jjConsumeToken(PERCENT);
                tokens.add(dim);
                value = key.image + dim.image;
                break;
            }
            case IDENTIFIER: {
                key = jjConsumeToken(IDENTIFIER);
                tokens.add(key);
                value = key.image;
                break;
            }
            default:
                jjLa1[139] = jjGen;
                jjConsumeToken(-1);
                throw new ParseException();
        }
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[140] = jjGen;
                break;
            }
            t = jjConsumeToken(S);
            tokens.add(t);
        }
        SourceCodeLocation endLocation = this.getLocation();
        CssKeyNode keyNode = nodeBuilder.buildKeyNode(key, value,
                this.mergeLocations(beginLocation, endLocation));
        nodeBuilder.attachComments(tokens, keyNode);
        {
            return keyNode;
        }
    }

    public final CssBlockNode block(boolean isEnclosedWithBraces) throws ParseException {
        CssBlockNode block;
        CssNode n;
        if (isEnclosedWithBraces) {
            block = new CssBlockNode(isEnclosedWithBraces);
        } else {
            block = globalBlock;
        }
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=COLON && i!=DOT && i!=ASTERISK && i!=LEFTSQUARE && i!=HASH_NAME && i!=IDENTIFIER && i!=ATLIST && i!=WEBKITKEYFRAMES && i!=ATRULESWITHDECLBLOCK && i!=ATKEYWORD) {
                jjLa1[141] = jjGen;
                break;
            }
            try {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case COLON:
                    case DOT:
                    case ASTERISK:
                    case LEFTSQUARE:
                    case HASH_NAME:
                    case IDENTIFIER: {
                        n = ruleSet();
                        break;
                    }
                    default:
                        jjLa1[142] = jjGen;
                        if (jj220(2147483647)) {
                            n = atRuleWithCrazySyntax();
                        } else {
                            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                                case ATKEYWORD: {
                                    n = atRule();
                                    break;
                                }
                                case WEBKITKEYFRAMES: {
                                    n = webkitKeyframesRule();
                                    break;
                                }
                                case ATRULESWITHDECLBLOCK: {
                                    n = atRuleWithDeclBlock();
                                    break;
                                }
                                default:
                                    jjLa1[143] = jjGen;
                                    jjConsumeToken(-1);
                                    throw new ParseException();
                            }
                        }
                }
                block.addChildToBack(n);
            } catch (ParseException e) {
                if (!enableErrorRecovery || e.currentToken==null) {
                    throw e;
                }
                handledErrors.add(new GssParserException(getLocation(e.currentToken.next), e));
            }
            while (true) {
                int j = (jjNtk==-1) ? jjNtkF():jjNtk;
                if (j!=CDO && j!=CDC && j!=S) {
                    jjLa1[144] = jjGen;
                    break;
                }
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case S: {
                        jjConsumeToken(S);
                        break;
                    }
                    case CDO: {
                        jjConsumeToken(CDO);
                        break;
                    }
                    case CDC: {
                        jjConsumeToken(CDC);
                        break;
                    }
                    default:
                        jjLa1[145] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
            }
        }
        {
            return block;
        }
    }

    public final void start() throws ParseException {
        while (true) {
            int i = (jjNtk==-1) ? jjNtkF():jjNtk;
            if (i!=CDO && i!=CDC && i!=S) {
                jjLa1[146] = jjGen;
                break;
            }
            switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                case S: {
                    jjConsumeToken(S);
                    break;
                }
                case CDO: {
                    jjConsumeToken(CDO);
                    break;
                }
                case CDC: {
                    jjConsumeToken(CDC);
                    break;
                }
                default:
                    jjLa1[147] = jjGen;
                    jjConsumeToken(-1);
                    throw new ParseException();
            }
        }
        block(false);
        jjConsumeToken(0);
        try {
            validateFinalBlockCommentIfPresent();
        } catch (ParseException e) {
            if (!enableErrorRecovery) {
                throw e;
            }
            handledErrors.add(new GssParserException(getLocation(), e));
        }
    }

    public final CssAtRuleNode atRuleWithCrazySyntax() throws ParseException {
        Token t;
        String s;
        SourceCodeLocation beginLocation;
        CssLiteralNode name;
        CssLiteralNode nonBlockContent;
        CssLiteralNode blockishContent = null;
        List<Token> tokens = Lists.newArrayList();
        SourceCodeLocation endLocation;
        // Don't add more special cases like this one and the webkit keyframes
        // one. If you want to support a new block type that follows the CSS 2.1
        // and 3 grammars and doesn't quite fit into the traditional GssParser
        // expectations, just change ATLIST below to ATKEYWORD, move the
        // use site in the block() to the bottom of its disjunction, and use
        // syntactic LOOKAHEAD(foo()) as needed for each foo() in the other choices
        // at that disjunction to ensure that the parser eventually falls back to
        // this rule. It will cost about 1.5% cpu time, but it will keep us from
        // adding any more code complexity here.
        t = jjConsumeToken(ATLIST);
        beginLocation = this.getLocation(t);
        name = new CssLiteralNode(t.image.substring(1), beginLocation);
        tokens.add(t);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[148] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        s = scanCrazyContent(";{");
        nonBlockContent = new CssLiteralNode(s);
        tokens.add(t);
        if (((jjNtk==-1) ? jjNtkF():jjNtk)==LEFTBRACE) {
            blockishContent = crazyBlockBrace();
        } else {
            jjLa1[149] = jjGen;
        }
        if (((jjNtk==-1) ? jjNtkF():jjNtk)==SEMICOLON) {
            t = jjConsumeToken(SEMICOLON);
            tokens.add(t);
        } else {
            jjLa1[150] = jjGen;
        }
        endLocation = this.getLocation(tokens.get(tokens.size() - 1));
        List<CssValueNode> parameters = Lists.newArrayList();
        parameters.add(nonBlockContent);
        if (blockishContent!=null) {
            parameters.add(blockishContent);
        }
        {
            return nodeBuilder.buildUnknownAtRuleNode(
                    name, null, this.mergeLocations(beginLocation, endLocation),
                    parameters,
                    tokens);
        }
    }

    /**
     * A last-resort, minimally-restrictive brace-delimited production.
     *
     * @return literal node
     * @throws ParseException
     */
    public final CssLiteralNode crazyBlockBrace() throws ParseException {
        Token t;
        String s;
        CssLiteralNode childContent;
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        jjConsumeToken(LEFTBRACE);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[151] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        s = scanCrazyContent(CRAZY_CONTENT);
        childContent = new CssLiteralNode(s);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTSQUARE:
            case LEFTROUND:
            case LEFTBRACE: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case LEFTBRACE: {
                        childCrazy = crazyBlockBrace();
                        break;
                    }
                    case LEFTSQUARE: {
                        childCrazy = crazyBlockBracket();
                        break;
                    }
                    case LEFTROUND: {
                        childCrazy = crazyBlockParen();
                        break;
                    }
                    default:
                        jjLa1[152] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jjLa1[153] = jjGen;
        }
        t = jjConsumeToken(RIGHTBRACE);
        this.getLocation(t);
        result.append("{");
        result.append(childContent.getValue());
        if (childCrazy!=null) result.append(" ");
        if (childCrazy!=null) result.append(childCrazy.getValue());
        result.append("}");
        {
            return new CssLiteralNode(result.toString());
        }
    }

    /**
     * Inside blocks, brackets, parens, and braces must be balanced.
     *
     * @return literal node
     * @throws ParseException
     */
    public final CssLiteralNode crazyBlockBracket() throws ParseException {
        Token t;
        String s;
        CssLiteralNode childContent;
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        jjConsumeToken(LEFTSQUARE);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[154] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        s = scanCrazyContent(CRAZY_CONTENT);
        childContent = new CssLiteralNode(s);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTSQUARE:
            case LEFTROUND:
            case LEFTBRACE: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case LEFTBRACE: {
                        childCrazy = crazyBlockBrace();
                        break;
                    }
                    case LEFTSQUARE: {
                        childCrazy = crazyBlockBracket();
                        break;
                    }
                    case LEFTROUND: {
                        childCrazy = crazyBlockParen();
                        break;
                    }
                    default:
                        jjLa1[155] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jjLa1[156] = jjGen;
        }
        t = jjConsumeToken(RIGHTSQUARE);
        this.getLocation(t);
        result.append("[");
        result.append(childContent.getValue());
        if (childCrazy!=null) result.append(" ");
        if (childCrazy!=null) result.append(childCrazy.getValue());
        result.append("]");
        {
            return new CssLiteralNode(result.toString());
        }
    }

    /**
     * Inside blocks, brackets, parens, and braces must be balanced.
     *
     * @return literal node
     * @throws ParseException
     */
    public final CssLiteralNode crazyBlockParen() throws ParseException {
        Token t;
        String s;
        CssLiteralNode childContent;
        CssLiteralNode childCrazy = null;
        StringBuilder result = new StringBuilder();
        jjConsumeToken(LEFTROUND);
        while (true) {
            if (((jjNtk==-1) ? jjNtkF():jjNtk)!=S) {
                jjLa1[157] = jjGen;
                break;
            }
            jjConsumeToken(S);
        }
        s = scanCrazyContent(CRAZY_CONTENT);
        childContent = new CssLiteralNode(s);
        switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
            case LEFTSQUARE:
            case LEFTROUND:
            case LEFTBRACE: {
                switch ((jjNtk==-1) ? jjNtkF():jjNtk) {
                    case LEFTBRACE: {
                        childCrazy = crazyBlockBrace();
                        break;
                    }
                    case LEFTSQUARE: {
                        childCrazy = crazyBlockBracket();
                        break;
                    }
                    case LEFTROUND: {
                        childCrazy = crazyBlockParen();
                        break;
                    }
                    default:
                        jjLa1[158] = jjGen;
                        jjConsumeToken(-1);
                        throw new ParseException();
                }
                break;
            }
            default:
                jjLa1[159] = jjGen;
        }
        t = jjConsumeToken(RIGHTROUND);
        this.getLocation(t);
        result.append("(");
        result.append(childContent.getValue());
        if (childCrazy!=null) result.append(" ");
        if (childCrazy!=null) result.append(childCrazy.getValue());
        result.append(")");
        {
            return new CssLiteralNode(result.toString());
        }
    }

    String scanCrazyContent(String endChars) throws ParseException {
        StringBuilder sb = new StringBuilder();
        Token t;
        while (true) {
            t = getToken(1);
            if (t.kind==EOF || (t.image.length()==1 && endChars.contains(t.image))) {
                break;
            }
            sb.append(t.image);
            getNextToken();
        }
        if (sb.length() < 1) {
            throw generateParseException();
        }
        return sb.toString();
    }

    int skipComponentValuesToBefore(Integer... kinds) throws ParseException {
        Set<Integer> kindset = ImmutableSet.<Integer>builder().add(EOF).add(kinds).build();
        Token t;
        do {
            t = getToken(1);
            if (kindset.contains(t.kind)) {
                return t.kind;
            }
            getNextToken();
        } while ((t.kind!=LEFTBRACE || skipComponentValuesToAfter(RIGHTBRACE)!=EOF)
                && (t.kind!=LEFTROUND || skipComponentValuesToAfter(RIGHTROUND)!=EOF)
                && (t.kind!=LEFTSQUARE || skipComponentValuesToAfter(RIGHTSQUARE)!=EOF));
        return EOF;
    }

    int skipComponentValuesToAfter(Integer... kinds) throws ParseException {
        int kind = skipComponentValuesToBefore(kinds);
        if (kind!=EOF) {
            getNextToken();
        }
        return kind;
    }

    void validateFinalBlockCommentIfPresent() throws ParseException {
        if (token.specialToken!=null
                && !VALIDBLOCKCOMMENTPATTERN.matcher(token.specialToken.image).matches()) {
            // Manually construct a ParseException since this syntax error occurs after the last token,
            // and we don't want the ParseException to reference a non-existent token.
            throw new ParseException("unterminated block comment at EOF");
        }
    }

    private boolean jj21(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj31();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(0, xla);
        }
    }

    private boolean jj22(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj32();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(1, xla);
        }
    }

    private boolean jj23(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj33();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(2, xla);
        }
    }

    private boolean jj24(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj34();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(3, xla);
        }
    }

    private boolean jj25(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj35();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(4, xla);
        }
    }

    private boolean jj26(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj36();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(5, xla);
        }
    }

    private boolean jj27(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj37();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(6, xla);
        }
    }

    private boolean jj28(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj38();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(7, xla);
        }
    }

    private boolean jj29(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj39();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(8, xla);
        }
    }

    private boolean jj210(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj310();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(9, xla);
        }
    }

    private boolean jj211(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj311();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(10, xla);
        }
    }

    private boolean jj212(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj312();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(11, xla);
        }
    }

    private boolean jj213(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj313();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(12, xla);
        }
    }

    private boolean jj214(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj314();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(13, xla);
        }
    }

    private boolean jj215(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj315();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(14, xla);
        }
    }

    private boolean jj216(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj316();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(15, xla);
        }
    }

    private boolean jj217(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj317();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(16, xla);
        }
    }

    private boolean jj218(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj318();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(17, xla);
        }
    }

    private boolean jj219(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj319();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(18, xla);
        }
    }

    private boolean jj220(int xla) {
        jjLa = xla;
        jjLastpos = jjScanpos = token;
        try {
            return !jj320();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jjSave(19, xla);
        }
    }

    private boolean jj3R130() {
        return jj3R143();
    }

    private boolean jj3R129() {
        return jj3R142();
    }

    private boolean jj3R128() {
        return jj3R141();
    }

    private boolean jj3R127() {
        return jj3R140();
    }

    private boolean jj311() {
        return jj3R108();
    }

    private boolean jj3R126() {
        return jj3R139();
    }

    private boolean jj318() {
        return jj3R108();
    }

    private boolean jj3R113() {
        if (jjScanToken(WPLUS)) return true;
        Token xsp;
        while (true) {
            xsp = jjScanpos;
            if (jjScanToken(45)) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj3R100() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R113()) {
            jjScanpos = xsp;
            if (jj3R114()) {
                jjScanpos = xsp;
                if (jj3R115()) {
                    jjScanpos = xsp;
                    if (jj3R116()) {
                        jjScanpos = xsp;
                        return jj3R117();
                    }
                }
            }
        }
        return false;
    }

    private boolean jj3R136() {
        return jjScanToken(LEFTROUND);
    }

    private boolean jj3R133() {
        Token xsp;
        xsp = jjScanpos;
        if (jjScanToken(66)) {
            jjScanpos = xsp;
            return jjScanToken(5);
        }
        return false;
    }

    private boolean jj310() {
        return jj3R102();
    }

    private boolean jj39() {
        Token xsp;
        xsp = jjScanpos;
        if (jj310()) {
            jjScanpos = xsp;
            return jj311();
        }
        return false;
    }

    private boolean jj317() {
        return jj3R102();
    }

    private boolean jj3R158() {
        return jjScanToken(COLON);
    }


    private boolean jj316() {
        Token xsp;
        xsp = jjScanpos;
        if (jj317()) {
            jjScanpos = xsp;
            return jj318();
        }
        return false;
    }

    private boolean jj34() {
        jjLookingAhead = true;
        jjSemLA = getToken(1).kind==LEFTROUND
                && (getToken(3).kind==COLON || getToken(4).kind==COLON);
        jjLookingAhead = false;
        if (!jjSemLA) return true;
        return jjScanToken(LEFTROUND);
    }

    private boolean jj3R148() {
        return jj3R158();
    }

    private boolean jj3R147() {
        return jj3R157();
    }

    private boolean jj3R121() {
        return jj3R136();
    }

    private boolean jj3R146() {
        return jj3R156();
    }

    private boolean jj37() {
        return jj3R106();
    }


    private boolean jj3R145() {
        return jj3R155();
    }

    private boolean jj3R125() {
        return jjScanToken(FOR_VARIABLE);
    }

    private boolean jj3R134() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R145()) {
            jjScanpos = xsp;
            if (jj3R146()) {
                jjScanpos = xsp;
                if (jj3R147()) {
                    jjScanpos = xsp;
                    return jj3R148();
                }
            }
        }
        return false;
    }

    private boolean jj3R141() {
        return jjScanToken(CALC);
    }

    private boolean jj3R119() {
        Token xsp;
        if (jj3R134()) return true;
        while (true) {
            xsp = jjScanpos;
            if (jj3R134()) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj33() {
        jjLookingAhead = true;
        jjSemLA = getToken(2).kind!=DOT && getToken(2).kind!=COLON;
        jjLookingAhead = false;
        if (!jjSemLA) return true;
        return jjScanToken(IDENTIFIER);
    }

    private boolean jj3R105() {
        Token xsp;
        xsp = jjScanpos;
        if (jj37()) {
            jjScanpos = xsp;
            return jj3R121();
        }
        return false;
    }

    private boolean jj3R124() {
        return jj3R138();
    }

    private boolean jj3R112() {
        return jjScanToken(IDENTIFIER);
    }

    private boolean jj3R123() {
        return jjScanToken(UNICODE_RANGE);
    }

    private boolean jj3R118() {
        return jj3R133();
    }

    private boolean jj3R137() {
        return jj3R149();
    }

    private boolean jj319() {
        jjLookingAhead = true;
        jjSemLA = getToken(1).kind==COLON || getToken(2).kind==COLON;
        jjLookingAhead = false;
        if (!jjSemLA) return true;
        Token xsp;
        xsp = jjScanpos;
        if (jj3R112()) jjScanpos = xsp;
        return jjScanToken(COLON);
    }

    private boolean jj3R155() {
        return jjScanToken(HASH_NAME);
    }

    private boolean jj3R122() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R137()) jjScanpos = xsp;
        return jjScanToken(NUMBER);
    }

    private boolean jj3R101() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R118()) {
            jjScanpos = xsp;
            return jj3R119();
        }
        return false;
    }

    private boolean jj3R106() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R122()) {
            jjScanpos = xsp;
            if (jj3R123()) {
                jjScanpos = xsp;
                if (jj3R124()) {
                    jjScanpos = xsp;
                    if (jj33()) {
                        jjScanpos = xsp;
                        if (jj3R125()) {
                            jjScanpos = xsp;
                            if (jj34()) {
                                jjScanpos = xsp;
                                jjLookingAhead = true;
                                jjSemLA = getToken(1).kind==URI;
                                jjLookingAhead = false;
                                if (!jjSemLA || jj3R126()) {
                                    jjScanpos = xsp;
                                    if (jj3R127()) {
                                        jjScanpos = xsp;
                                        if (jj3R128()) {
                                            jjScanpos = xsp;
                                            if (jj3R129()) {
                                                jjScanpos = xsp;
                                                return jj3R130();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj3R154() {
        return jjScanToken(EXCL_MARK);
    }

    private boolean jj3R156() {
        return jjScanToken(DOT);
    }

    private boolean jj3R153() {
        return jjScanToken(IDENTIFIER);
    }

    private boolean jj3R152() {
        return jjScanToken(FUNCTION);
    }

    private boolean jj3R143() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R152()) {
            jjScanpos = xsp;
            return jj3R153();
        }
        return false;
    }

    private boolean jj3R135() {
        return jj3R106();
    }

    private boolean jj36() {
        return jj3R105();
    }

    private boolean jj38() {
        return jj3R107();
    }

    private boolean jj314() {
        return jj3R108();
    }

    private boolean jj31() {
        if (jj3R100()) return true;
        return jj3R101();
    }

    private boolean jj35() {
        return jj3R105();
    }

    private boolean jj3R144() {
        return jj3R154();
    }

    private boolean jj3R139() {
        return jjScanToken(URI);
    }

    private boolean jj3R131() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R144()) {
            jjScanpos = xsp;
            return jj35();
        }
        return false;
    }

    private boolean jj3R120() {
        return jj3R135();
    }

    private boolean jj3R157() {
        return jjScanToken(LEFTSQUARE);
    }

    private boolean jj313() {
        return jj3R102();
    }

    private boolean jj312() {
        Token xsp;
        xsp = jjScanpos;
        if (jj313()) {
            jjScanpos = xsp;
            return jj314();
        }
        return false;
    }

    private boolean jj3R110() {
        return jjScanToken(IDENTIFIER);
    }

    private boolean jj3R102() {
        return jj3R120();
    }

    private boolean jj315() {
        jjLookingAhead = true;
        jjSemLA = getToken(1).kind==COLON || getToken(2).kind==COLON;
        jjLookingAhead = false;
        if (!jjSemLA) return true;
        Token xsp;
        xsp = jjScanpos;
        if (jj3R110()) jjScanpos = xsp;
        return jjScanToken(COLON);
    }

    private boolean jj3R108() {
        return jj3R131();
    }

    private boolean jj3R142() {
        return jjScanToken(VARFUNCTION);
    }

    private boolean jj3R132() {
        return jjScanToken(S);
    }

    private boolean jj32() {
        return jj3R102();
    }

    private boolean jj3R107() {
        return jj3R102();
    }

    private boolean jj3R117() {
        Token xsp;
        if (jj3R132()) return true;
        while (true) {
            xsp = jjScanpos;
            if (jj3R132()) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj3R140() {
        return jjScanToken(HASH_NAME);
    }

    private boolean jj3R116() {
        if (jjScanToken(WDEEP)) return true;
        Token xsp;
        while (true) {
            xsp = jjScanpos;
            if (jjScanToken(45)) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj3R151() {
        return jjScanToken(SINGLE_QUOTED_STRING);
    }

    private boolean jj3R150() {
        return jjScanToken(DOUBLE_QUOTED_STRING);
    }

    private boolean jj320() {
        return jjScanToken(ATLIST);
    }

    private boolean jj3R138() {
        Token xsp;
        xsp = jjScanpos;
        if (jj3R150()) {
            jjScanpos = xsp;
            return jj3R151();
        }
        return false;
    }

    private boolean jj3R115() {
        if (jjScanToken(WTILDE)) return true;
        Token xsp;
        while (true) {
            xsp = jjScanpos;
            if (jjScanToken(45)) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    private boolean jj3R149() {
        Token xsp;
        xsp = jjScanpos;
        if (jjScanToken(7)) {
            jjScanpos = xsp;
            return jjScanToken(49);
        }
        return false;
    }

    private boolean jj3R114() {
        if (jjScanToken(WGREATER)) return true;
        Token xsp;
        while (true) {
            xsp = jjScanpos;
            if (jjScanToken(45)) {
                jjScanpos = xsp;
                break;
            }
        }
        return false;
    }

    /**
     * Generated Token Manager.
     */
    private final GssParserCCTokenManager tokenSource;
    /**
     * Current token.
     */
    private Token token;
    private int jjNtk;
    private Token jjScanpos;
    private Token jjLastpos;
    private int jjLa;
    /**
     * Whether we are looking ahead.
     */
    private boolean jjLookingAhead = false;
    private boolean jjSemLA;
    private int jjGen;
    private final int[] jjLa1 = new int[160];
    private static int[] jjLa10;
    private static int[] jjLa11;
    private static int[] jjLa12;

    static {
        jjLa1Init0();
        jjLa1Init1();
        jjLa1Init2();
    }

    private static void jjLa1Init0() {
        jjLa10 = new int[]{0x0, 0x8000, 0x0, 0x0, 0x8020000, 0x8020000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x8, 0x80, 0x0, 0x80, 0x0, 0x0, 0x100, 0x0, 0x0, 0x0, 0x100, 0x218, 0x218, 0x218, 0x218, 0x238, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x4, 0x0, 0x20, 0x0, 0x20, 0x4, 0x20, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x0, 0x100, 0x0, 0x40, 0x0, 0x80, 0x20000, 0x20000, 0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x0, 0x80000000, 0x0, 0x10000, 0x40000000, 0x0, 0x10000, 0x0, 0x800, 0x0, 0x0, 0x80, 0x0, 0x0, 0x0, 0x8000, 0x18, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0, 0x0, 0x60, 0x80, 0x20000, 0x20000, 0x80, 0x0, 0x0, 0x880, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2004, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8000, 0x0, 0x0, 0x0, 0x238, 0x238, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2000, 0x4, 0x0, 0x2a00, 0x2a00, 0x0, 0x2a00, 0x2a00, 0x0, 0x2a00, 0x2a00,};
    }

    private static void jjLa1Init1() {
        jjLa11 = new int[]{0x60000000, 0x0, 0x2000, 0x2000, 0x0, 0x0, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x0, 0x4030000, 0x2000, 0x4030000, 0x2000, 0x2000, 0x1f, 0x2000, 0x60000000, 0x2000, 0x1f, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0x8000000, 0x0, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x1e2000, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x0, 0x0, 0x0, 0x2000, 0x2000, 0x0, 0x2000, 0x2000, 0x2000, 0x10000000, 0x0, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x20000, 0x0, 0x0, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x4000000, 0x2000, 0x64020000, 0x0, 0x8000000, 0x2000, 0x0, 0x2000, 0x0, 0x0, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x2000, 0x20000, 0x2000, 0x2000, 0x2000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2000, 0x2000, 0x2000, 0x30000, 0x2000, 0x30000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x20000, 0x0, 0x0, 0x4020000, 0x2000, 0x2000, 0x4020000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x2000, 0x0, 0x2000, 0x0, 0x2000, 0x2000, 0x2000, 0x4000000, 0x2000, 0x0, 0x2000, 0x4000000, 0x2000, 0x8000000, 0x8000000, 0x0, 0x2060, 0x2060, 0x2060, 0x2060, 0x2000, 0x0, 0x0, 0x2000, 0x0, 0x0, 0x2000, 0x0, 0x0, 0x2000, 0x0, 0x0,};
    }

    private static void jjLa1Init2() {
        jjLa12 = new int[]{0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x434, 0x434, 0x6, 0x0, 0x6, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x4000, 0x0, 0xc, 0x0, 0xc, 0x4000, 0xc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x0, 0x200, 0x2, 0x4c4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x404, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x4, 0x84, 0x0, 0x0, 0x84, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x400, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x400, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x7804, 0x4, 0x7000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,};
    }

    private final JJCalls[] jj2Rtns = new JJCalls[20];
    private boolean jjRescan = false;
    private int jjGc = 0;

    /**
     * Constructor with user supplied CharStream.
     */
    public GssParserCC(CharStream stream) {
        tokenSource = new GssParserCCTokenManager(stream);
        token = new Token();
        jjNtk = -1;
        jjGen = 0;
        for (int i = 0; i < 160; i++) jjLa1[i] = -1;
        for (int i = 0; i < jj2Rtns.length; i++) jj2Rtns[i] = new JJCalls();
    }

    /**
     * Reinitialise.
     */
    public void reInit(CharStream stream) {
        tokenSource.reInit(stream);
        token = new Token();
        jjNtk = -1;
        jjLookingAhead = false;
        jjGen = 0;
        for (int i = 0; i < 160; i++) jjLa1[i] = -1;
        for (int i = 0; i < jj2Rtns.length; i++) jj2Rtns[i] = new JJCalls();
    }

    private Token jjConsumeToken(int kind) throws ParseException {
        Token oldToken;
        oldToken = token;
        if (oldToken.next!=null) {
            token = token.next;
        } else {
            token = token.next = tokenSource.getNextToken();
        }
        jjNtk = -1;
        if (token.kind==kind) {
            jjGen++;
            if (++jjGc > 100) {
                jjGc = 0;
                for (JJCalls jj2Rtn : jj2Rtns) {
                    JJCalls c = jj2Rtn;
                    while (c!=null) {
                        if (c.gen < jjGen) c.first = null;
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token = oldToken;
        jjKind = kind;
        throw generateParseException();
    }

    @SuppressWarnings("serial")
    private static final class LookaheadSuccess extends Error {
    }

    private final LookaheadSuccess jjLs = new LookaheadSuccess();

    private boolean jjScanToken(int kind) {
        if (jjScanpos==jjLastpos) {
            jjLa--;
            if (jjScanpos.next==null) {
                jjLastpos = jjScanpos = jjScanpos.next = tokenSource.getNextToken();
            } else {
                jjLastpos = jjScanpos = jjScanpos.next;
            }
        } else {
            jjScanpos = jjScanpos.next;
        }
        if (jjRescan) {
            int i = 0;
            Token tok = token;
            while (tok!=null && tok!=jjScanpos) {
                i++;
                tok = tok.next;
            }
            if (tok!=null) jjAddErrorToken(kind, i);
        }
        if (jjScanpos.kind!=kind) return true;
        if (jjLa==0 && jjScanpos==jjLastpos) throw jjLs;
        return false;
    }


    /**
     * Get the next Token.
     */
    public final Token getNextToken() {
        if (token.next!=null) token = token.next;
        else token = token.next = tokenSource.getNextToken();
        jjNtk = -1;
        jjGen++;
        return token;
    }

    /**
     * Get the specific Token.
     */
    public final Token getToken(int index) {
        Token t = jjLookingAhead ? jjScanpos:token;
        for (int i = 0; i < index; i++) {
            if (t.next!=null) t = t.next;
            else t = t.next = tokenSource.getNextToken();
        }
        return t;
    }

    private int jjNtkF() {
        /*
         * Next token.
         */
        Token jjNt;
        if ((jjNt = token.next)==null) {
            token.next = tokenSource.getNextToken();
            jjNtk = (token.next).kind;
        } else {
            jjNtk = jjNt.kind;
        }
        return jjNtk;
    }

    private final List<int[]> jjExpentries = new ArrayList<>();
    private int[] jjExpentry;
    private int jjKind = -1;
    private final int[] jjLasttokens = new int[100];
    private int jjEndpos;

    private void jjAddErrorToken(int kind, int pos) {
        if (pos >= 100) {
            return;
        }

        if (pos==jjEndpos + 1) {
            jjLasttokens[jjEndpos++] = kind;
        } else if (jjEndpos!=0) {
            jjExpentry = new int[jjEndpos];

            System.arraycopy(jjLasttokens, 0, jjExpentry, 0, jjEndpos);

            for (int[] oldentry : jjExpentries) {
                if (oldentry.length==jjExpentry.length) {
                    boolean isMatched = true;

                    for (int i = 0; i < jjExpentry.length; i++) {
                        if (oldentry[i]!=jjExpentry[i]) {
                            isMatched = false;
                            break;
                        }

                    }
                    if (isMatched) {
                        jjExpentries.add(jjExpentry);
                        break;
                    }
                }
            }

            if (pos!=0) {
                jjEndpos = pos;
                jjLasttokens[jjEndpos - 1] = kind;
            }
        }
    }

    /**
     * Generate ParseException.
     */
    public ParseException generateParseException() {
        jjExpentries.clear();
        boolean[] la1tokens = new boolean[80];
        if (jjKind >= 0) {
            la1tokens[jjKind] = true;
            jjKind = -1;
        }
        for (int i = 0; i < 160; i++) {
            if (jjLa1[i]==jjGen) {
                for (int j = 0; j < 32; j++) {
                    if ((jjLa10[i] & (1 << j))!=0) {
                        la1tokens[j] = true;
                    }
                    if ((jjLa11[i] & (1 << j))!=0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jjLa12[i] & (1 << j))!=0) {
                        la1tokens[64 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 80; i++) {
            if (la1tokens[i]) {
                jjExpentry = new int[1];
                jjExpentry[0] = i;
                jjExpentries.add(jjExpentry);
            }
        }
        jjEndpos = 0;
        jjRescanToken();
        jjAddErrorToken(0, 0);
        int[][] exptokseq = new int[jjExpentries.size()][];
        for (int i = 0; i < jjExpentries.size(); i++) {
            exptokseq[i] = jjExpentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    private void jjRescanToken() {
        jjRescan = true;
        for (int i = 0; i < 20; i++) {
            try {
                JJCalls p = jj2Rtns[i];

                do {
                    if (p.gen > jjGen) {
                        jjLa = p.arg;
                        jjLastpos = jjScanpos = p.first;
                        switch (i) {
                            case 0:
                                jj31();
                                break;
                            case 1:
                                jj32();
                                break;
                            case 2:
                                jj33();
                                break;
                            case 3:
                                jj34();
                                break;
                            case 4:
                                jj35();
                                break;
                            case 5:
                                jj36();
                                break;
                            case 6:
                                jj37();
                                break;
                            case 7:
                                jj38();
                                break;
                            case 8:
                                jj39();
                                break;
                            case 9:
                                jj310();
                                break;
                            case 10:
                                jj311();
                                break;
                            case 11:
                                jj312();
                                break;
                            case 12:
                                jj313();
                                break;
                            case 13:
                                jj314();
                                break;
                            case 14:
                                jj315();
                                break;
                            case 15:
                                jj316();
                                break;
                            case 16:
                                jj317();
                                break;
                            case 17:
                                jj318();
                                break;
                            case 18:
                                jj319();
                                break;
                            case 19:
                                jj320();
                                break;
                            default:
                                throw new IllegalStateException("Unexpected value: " + i);
                        }
                    }
                    p = p.next;
                } while (p!=null);

            } catch (LookaheadSuccess ls) {
            }
        }
        jjRescan = false;
    }

    private void jjSave(int index, int xla) {
        JJCalls p = jj2Rtns[index];
        while (p.gen > jjGen) {
            if (p.next==null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }

        p.gen = jjGen + xla - jjLa;
        p.first = token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;
    }

}
