/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.css.ExitCodeHandler;
import com.google.common.css.JobDescription;
import java.util.logging.Logger;

public class AbstractCommandLineCompiler<T extends JobDescription> {
    private static final Logger logger = Logger.getLogger(AbstractCommandLineCompiler.class.getName());
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int ERROR_MESSAGE_EXIT_CODE = 1;
    public static final int UNHANDLED_EXCEPTION_EXIT_CODE = 2;
    public static final int INTERNAL_ERROR_EXIT_CODE = 3;
    protected final T job;
    protected boolean compilerWasUsed = false;
    protected final ExitCodeHandler exitCodeHandler;

    public AbstractCommandLineCompiler(T job, ExitCodeHandler exitCodeHandler) {
        Preconditions.checkNotNull(job);
        Preconditions.checkNotNull((Object)exitCodeHandler);
        this.job = job;
        this.exitCodeHandler = exitCodeHandler;
    }

    protected static void exitOnUnhandledException(Exception e, ExitCodeHandler exitCodeHandler) {
        logger.severe(() -> "The compiler encountered an unhandled error condition. " + e);
        e.printStackTrace();
        exitCodeHandler.processExitCode(2);
    }
}

