/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.css;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.css.SubstitutionMap;
import java.util.Map;

public interface MultipleMappingSubstitutionMap
extends SubstitutionMap {
    public ValueWithMappings getValueWithMappings(String var1);

    public static class ValueWithMappings {
        public final String value;
        public final Map<String, String> mappings;

        private ValueWithMappings(String value, Map<String, String> mappings) {
            Preconditions.checkNotNull((Object)value);
            Preconditions.checkNotNull(mappings);
            this.value = value;
            this.mappings = ImmutableMap.copyOf(mappings);
        }

        public static ValueWithMappings createWithValueAndMappings(String value, Map<String, String> mappings) {
            return new ValueWithMappings(value, mappings);
        }

        public static ValueWithMappings createForSingleMapping(String key, String value) {
            return new ValueWithMappings(value, (Map<String, String>)ImmutableMap.of((Object)key, (Object)value));
        }
    }
}

